/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.specflow;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.reports.adaptors.specflow.ScenarioStep;

public class ScenarioStepReader {
    private static final Set<String> STEP_KEYWORDS = ImmutableSet.of((Object)"given", (Object)"when", (Object)"then", (Object)"and");
    private static final String RESULT_LEAD = "-> ";

    public static boolean isResult(String line) {
        return line.trim().startsWith(RESULT_LEAD);
    }

    public TestStep consumeNextStepFrom(List<String> lines) {
        ScenarioStep scenarioStep = new ScenarioStep(this.consumeLinesFromNextStep(lines));
        TestStep step = TestStep.forStepCalled(scenarioStep.getTitle()).withResult(scenarioStep.getResult());
        if (scenarioStep.getDuration().isPresent()) {
            step.setDuration(((BigDecimal)scenarioStep.getDuration().get()).longValue());
        }
        if (scenarioStep.getException().isPresent()) {
            step.failedWith((Throwable)scenarioStep.getException().get());
        }
        return step;
    }

    private List<String> consumeLinesFromNextStep(List<String> lines) {
        ArrayList stepLines = Lists.newArrayList();
        String title = lines.remove(0);
        stepLines.add(title);
        while (!lines.isEmpty() && !this.isStepTitle(lines.get(0))) {
            stepLines.add(lines.remove(0));
        }
        return stepLines;
    }

    private boolean isStepTitle(String line) {
        String trimmedLowerCaseLine = line.trim().toLowerCase();
        for (String keyword : STEP_KEYWORDS) {
            if (!trimmedLowerCaseLine.startsWith(keyword)) continue;
            return true;
        }
        return false;
    }
}

