/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.OutcomeCounter;
import net.thucydides.core.model.TestDuration;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.TestType;
import net.thucydides.core.model.formatters.TestCoverageFormatter;
import net.thucydides.core.reports.TestOutcomeCounter;
import net.thucydides.core.reports.matchers.TestOutcomeMatchers;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;

public class TestOutcomes {
    private final List<? extends TestOutcome> outcomes;
    private final Optional<TestOutcomes> rootOutcomes;
    private final double estimatedAverageStepCount;
    private final EnvironmentVariables environmentVariables;
    private final RequirementsService requirementsService;
    private final String label;
    private static final Integer DEFAULT_ESTIMATED_TOTAL_STEPS = 3;
    private static List<TestOutcome> NO_OUTCOMES = ImmutableList.of();

    @Inject
    protected TestOutcomes(List<? extends TestOutcome> outcomes, double estimatedAverageStepCount, String label, TestOutcomes rootOutcomes, EnvironmentVariables environmentVariables) {
        this.outcomes = ImmutableList.copyOf(outcomes);
        this.estimatedAverageStepCount = estimatedAverageStepCount;
        this.label = label;
        this.rootOutcomes = Optional.fromNullable((Object)rootOutcomes);
        this.environmentVariables = environmentVariables;
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
    }

    protected TestOutcomes(List<? extends TestOutcome> outcomes, double estimatedAverageStepCount, String label) {
        this(outcomes, estimatedAverageStepCount, label, null, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    protected TestOutcomes(List<? extends TestOutcome> outcomes, double estimatedAverageStepCount) {
        this(outcomes, estimatedAverageStepCount, "");
    }

    public TestOutcomes withLabel(String label) {
        return new TestOutcomes(this.outcomes, this.estimatedAverageStepCount, label);
    }

    public TestOutcomes havingResult(String result) {
        return this.havingResult(TestResult.valueOf(result.toUpperCase()));
    }

    public TestOutcomes havingResult(TestResult result) {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.withResult(result), this.outcomes)).withLabel(this.labelForTestsWithStatus(result.name())).withRootOutcomes(this.getRootOutcomes());
    }

    public static TestOutcomes of(List<? extends TestOutcome> outcomes) {
        return new TestOutcomes(outcomes, ((Configuration)Injectors.getInjector().getInstance(Configuration.class)).getEstimatedAverageStepCount());
    }

    public static TestOutcomes withNoResults() {
        return new TestOutcomes(NO_OUTCOMES, ((Configuration)Injectors.getInjector().getInstance(Configuration.class)).getEstimatedAverageStepCount());
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getTagTypes() {
        HashSet tagTypes = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            this.addTagTypesFrom(testOutcome, tagTypes);
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tagTypes), (Object)Lambda.on(String.class));
    }

    public List<String> getFirstClassTagTypes() {
        HashSet tagTypes = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            this.addTagTypesFrom(testOutcome, tagTypes);
        }
        tagTypes.remove("version");
        tagTypes.removeAll(this.getRequirementTagTypes());
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tagTypes), (Object)Lambda.on(String.class));
    }

    public List<String> getRequirementTagTypes() {
        ArrayList tagTypes = Lists.newArrayList();
        List<String> candidateTagTypes = this.requirementsService.getRequirementTypes();
        for (String tagType : candidateTagTypes) {
            if (!this.getTagTypes().contains(tagType)) continue;
            tagTypes.add(tagType);
        }
        return ImmutableList.copyOf((Collection)tagTypes);
    }

    public List<String> getTagNames() {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            this.addTagNamesFrom(testOutcome, tags);
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tags), (Object)Lambda.on(String.class));
    }

    private void addTagNamesFrom(TestOutcome outcome, Set<String> tags) {
        for (TestTag tag : outcome.getTags()) {
            String normalizedForm = tag.getName().toLowerCase();
            if (tags.contains(normalizedForm)) continue;
            tags.add(normalizedForm);
        }
    }

    private void addTagTypesFrom(TestOutcome outcome, Set<String> tags) {
        for (TestTag tag : outcome.getTags()) {
            String normalizedForm = tag.getType().toLowerCase();
            if (tags.contains(normalizedForm)) continue;
            tags.add(normalizedForm);
        }
    }

    public List<TestTag> getTags() {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            tags.addAll(testOutcome.getTags());
        }
        return ImmutableList.copyOf((Collection)tags);
    }

    public List<TestTag> getTagsOfType(String tagType) {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            tags.addAll(this.tagsOfType(tagType).in(testOutcome));
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tags), (Object)Lambda.on(String.class));
    }

    public List<TestTag> getMostSpecificTagsOfType(String tagType) {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            List<TestTag> mostSpecificOutcomeTags = this.removeGeneralTagsFrom(this.tagsOfType(tagType).in(testOutcome));
            tags.addAll(mostSpecificOutcomeTags);
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tags), (Object)Lambda.on(String.class));
    }

    private List<TestTag> removeGeneralTagsFrom(List<TestTag> tags) {
        ArrayList specificTags = Lists.newArrayList();
        for (TestTag tag : tags) {
            if (this.moreSpecificTagExists(tag, tags)) continue;
            specificTags.add(tag);
        }
        return specificTags;
    }

    private boolean moreSpecificTagExists(TestTag generalTag, List<TestTag> tags) {
        for (TestTag tag : tags) {
            if (!tag.getName().endsWith("/" + generalTag.getName())) continue;
            return true;
        }
        return false;
    }

    public List<TestTag> getTagsOfTypeExcluding(String tagType, String excludedTag) {
        HashSet tags = Sets.newHashSet();
        for (TestOutcome testOutcome : this.outcomes) {
            List<TestTag> allTagsOfType = this.removeGeneralTagsFrom(this.tagsOfType(tagType).in(testOutcome));
            allTagsOfType = this.removeExcluded(allTagsOfType, excludedTag);
            tags.addAll(allTagsOfType);
        }
        return Lambda.sort((Object)ImmutableList.copyOf((Collection)tags), (Object)Lambda.on(String.class));
    }

    private List<TestTag> removeExcluded(List<TestTag> allTagsOfType, String excludedTag) {
        ArrayList tags = Lists.newArrayList();
        for (TestTag tag : allTagsOfType) {
            if (tag.getName().equalsIgnoreCase(excludedTag)) continue;
            tags.add(tag);
        }
        return tags;
    }

    private TagFinder tagsOfType(String tagType) {
        return new TagFinder(tagType);
    }

    public TestOutcomes getRootOutcomes() {
        return (TestOutcomes)this.rootOutcomes.or((Object)this);
    }

    public TestOutcomes forRequirement(Requirement requirement) {
        return this.withTag(requirement.asTag());
    }

    public boolean containsTag(TestTag testTag) {
        return this.getTags().contains(testTag);
    }

    public DateTime getStartTime() {
        return (DateTime)Lambda.min(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getStartTime());
    }

    public TestOutcomes ofType(TestType testType) {
        ArrayList filteredOutcomes = Lists.newArrayList();
        for (TestOutcome testOutcome : this.outcomes) {
            if (!testOutcome.typeCompatibleWith(testType)) continue;
            filteredOutcomes.add(testOutcome);
        }
        return TestOutcomes.of(filteredOutcomes);
    }

    public TestOutcomes withRequirementsTags() {
        ArrayList testOutcomesWithRequirements = Lists.newArrayList();
        for (TestOutcome testOutcome : this.outcomes) {
            HashSet outcomeTags = Sets.newHashSet(testOutcome.getTags());
            List<Requirement> parentRequirements = this.requirementsService.getAncestorRequirementsFor(testOutcome);
            for (Requirement requirement : parentRequirements) {
                outcomeTags.add(requirement.asTag());
            }
            testOutcomesWithRequirements.add(testOutcome.withTags(outcomeTags));
        }
        return new TestOutcomes(testOutcomesWithRequirements, this.estimatedAverageStepCount, this.label, (TestOutcomes)this.rootOutcomes.orNull(), this.environmentVariables);
    }

    public TestOutcomes withTagType(String tagType) {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.havingTagType(tagType), this.outcomes)).withLabel(tagType).withRootOutcomes(this.getRootOutcomes());
    }

    private TestOutcomes withRootOutcomes(TestOutcomes rootOutcomes) {
        return new TestOutcomes(this.outcomes, this.estimatedAverageStepCount, this.label, rootOutcomes, this.environmentVariables);
    }

    public TestOutcomes withTag(String tagName) {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.havingTagName(tagName), this.outcomes)).withLabel(tagName).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes withTag(TestTag tag) {
        List<? extends TestOutcome> matchingTags = this.matchingOutcomes(this.outcomes, tag);
        return TestOutcomes.of(matchingTags).withLabel(tag.getName()).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes withTags(List<TestTag> tags) {
        ArrayList filteredOutcomes = Lists.newArrayList();
        for (TestTag tag : tags) {
            filteredOutcomes.addAll(this.matchingOutcomes(this.outcomes, tag));
        }
        return TestOutcomes.of(filteredOutcomes);
    }

    private List<? extends TestOutcome> matchingOutcomes(List<? extends TestOutcome> outcomes, TestTag tag) {
        ArrayList matchingOutcomes = Lists.newArrayList();
        for (TestOutcome testOutcome : outcomes) {
            if (this.isAnIssue(tag) && testOutcome.hasIssue(tag.getName())) {
                matchingOutcomes.add(testOutcome);
            }
            if (!testOutcome.hasTag(tag)) continue;
            matchingOutcomes.add(testOutcome);
        }
        return matchingOutcomes;
    }

    private boolean isAnIssue(TestTag tag) {
        return tag.getType().equalsIgnoreCase("issue");
    }

    public TestOutcomes withHistory() {
        return TestOutcomes.of(Lambda.convert(this.outcomes, this.toOutcomesWithHistory()));
    }

    private Converter<TestOutcome, TestOutcome> toOutcomesWithHistory() {
        return new Converter<TestOutcome, TestOutcome>(){

            public TestOutcome convert(TestOutcome testOutcome) {
                return testOutcome;
            }
        };
    }

    public TestOutcomes getFailingTests() {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.withResult(TestResult.FAILURE), this.outcomes)).withLabel(this.labelForTestsWithStatus("failing tests")).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes getErrorTests() {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.withResult(TestResult.ERROR), this.outcomes)).withLabel(this.labelForTestsWithStatus("failing tests")).withRootOutcomes(this.getRootOutcomes());
    }

    private String labelForTestsWithStatus(String status) {
        if (StringUtils.isEmpty((CharSequence)this.label)) {
            return status;
        }
        return String.valueOf(this.label) + " (" + status + ")";
    }

    public TestOutcomes getPassingTests() {
        return TestOutcomes.of(Lambda.filter(TestOutcomeMatchers.withResult(TestResult.SUCCESS), this.outcomes)).withLabel(this.labelForTestsWithStatus("passing tests")).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes getPendingTests() {
        List<TestOutcome> pendingOrSkippedOutcomes = this.outcomesWithResults(this.outcomes, TestResult.PENDING, TestResult.SKIPPED);
        return TestOutcomes.of(pendingOrSkippedOutcomes).withLabel(this.labelForTestsWithStatus("pending tests")).withRootOutcomes(this.getRootOutcomes());
    }

    private List<TestOutcome> outcomesWithResults(List<? extends TestOutcome> outcomes, TestResult ... possibleResults) {
        ArrayList validOutcomes = Lists.newArrayList();
        List<TestResult> possibleResultsList = Arrays.asList(possibleResults);
        for (TestOutcome testOutcome : outcomes) {
            if (!possibleResultsList.contains((Object)testOutcome.getResult())) continue;
            validOutcomes.add(testOutcome);
        }
        return validOutcomes;
    }

    public List<? extends TestOutcome> getTests() {
        return Lambda.sort(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getTitle());
    }

    public Long getDuration() {
        Long total = 0L;
        for (TestOutcome testOutcome : this.outcomes) {
            total = total + testOutcome.getDuration();
        }
        return total;
    }

    public double getDurationInSeconds() {
        return TestDuration.of(this.getDuration()).inSeconds();
    }

    public int getTotal() {
        return (Integer)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getTestCount());
    }

    public int getTotalTestScenarios() {
        return this.outcomes.size();
    }

    public List<? extends TestOutcome> getOutcomes() {
        return ImmutableList.copyOf(this.outcomes);
    }

    public TestResult getResult() {
        TestResultList testResults = TestResultList.of(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.outcomes, this.toTestResults());
    }

    private Converter<? extends TestOutcome, TestResult> toTestResults() {
        return new Converter<TestOutcome, TestResult>(){

            public TestResult convert(TestOutcome step) {
                return step.getResult();
            }
        };
    }

    public int getStepCount() {
        return Lambda.sum((Object)Lambda.extract(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount())).intValue();
    }

    public int successCount(String testType) {
        return (Integer)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).countResults(TestResult.SUCCESS, TestType.valueOf(testType.toUpperCase())));
    }

    public OutcomeCounter getTotalTests() {
        return this.count(TestType.ANY);
    }

    public OutcomeCounter count(String testType) {
        return this.count(TestType.valueOf(testType.toUpperCase()));
    }

    public OutcomeCounter count(TestType testType) {
        return new OutcomeCounter(testType, this);
    }

    public OutcomeProportionCounter getProportion() {
        return this.proportionOf(TestType.ANY);
    }

    public OutcomeProportionCounter proportionOf(String testType) {
        return this.proportionOf(TestType.valueOf(testType.toUpperCase()));
    }

    public OutcomeProportionCounter proportionOf(TestType testType) {
        return new OutcomeProportionCounter(testType);
    }

    public OutcomeProportionStepCounter getPercentSteps() {
        return this.proportionalStepsOf(TestType.ANY);
    }

    public OutcomeProportionStepCounter proportionalStepsOf(String testType) {
        return this.proportionalStepsOf(TestType.valueOf(testType.toUpperCase()));
    }

    public OutcomeProportionStepCounter proportionalStepsOf(TestType testType) {
        return new OutcomeProportionStepCounter(testType);
    }

    public OutcomeProportionStepCounter decimalPercentageSteps(String testType) {
        return new OutcomeProportionStepCounter(TestType.valueOf(testType.toUpperCase()));
    }

    public TestCoverageFormatter.FormattedPercentageStepCoverage getFormattedPercentageSteps() {
        return new TestCoverageFormatter(this).getPercentSteps();
    }

    public TestCoverageFormatter.FormattedPercentageCoverage getFormattedPercentage() {
        return new TestCoverageFormatter(this).getPercentTests();
    }

    public TestCoverageFormatter.FormattedPercentageCoverage getFormattedPercentage(String testType) {
        this.getFormattedPercentage().withIndeterminateResult();
        return new TestCoverageFormatter(this).percentTests(testType);
    }

    public TestCoverageFormatter.FormattedPercentageCoverage getFormattedPercentage(TestType testType) {
        return new TestCoverageFormatter(this).percentTests(testType);
    }

    public TestCoverageFormatter getFormatted() {
        return new TestCoverageFormatter(this);
    }

    private int countStepsWithResult(TestResult expectedResult, TestType testType) {
        int stepCount = (Integer)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).countNestedStepsWithResult(expectedResult, testType));
        if (stepCount == 0 && this.aMatchingTestExists(expectedResult, testType)) {
            return (int)Math.round(this.getAverageTestSize());
        }
        return stepCount;
    }

    private boolean aMatchingTestExists(TestResult expectedResult, TestType testType) {
        return this.countTestsWithResult(expectedResult, testType) > 0;
    }

    protected int countTestsWithResult(TestResult expectedResult, TestType testType) {
        return (Integer)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).countResults(expectedResult, testType));
    }

    private Integer getEstimatedTotalStepCount() {
        int estimatedTotalSteps = this.getStepCount() + this.estimatedUnimplementedStepCount();
        return estimatedTotalSteps == 0 ? DEFAULT_ESTIMATED_TOTAL_STEPS : estimatedTotalSteps;
    }

    private Integer estimatedUnimplementedStepCount() {
        return (int)Math.round(this.getAverageTestSize() * (double)this.totalUnimplementedTests());
    }

    public double getAverageTestSize() {
        if (this.totalImplementedTests() > 0) {
            return (double)this.getStepCount() / (double)this.totalImplementedTests();
        }
        return this.estimatedAverageStepCount;
    }

    public double getRecentStability() {
        if (this.outcomes.isEmpty()) {
            return 0.0;
        }
        return (Double)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getRecentStability()) / (double)this.getTestCount();
    }

    public double getOverallStability() {
        if (this.outcomes.isEmpty()) {
            return 0.0;
        }
        return (Double)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getOverallStability()) / (double)this.getTestCount();
    }

    private int totalUnimplementedTests() {
        return this.getTotal() - this.totalImplementedTests();
    }

    public int getTestCount() {
        return (Integer)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getTestCount());
    }

    private int totalImplementedTests() {
        return (Integer)Lambda.sum(this.outcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getImplementedTestCount());
    }

    public boolean hasDataDrivenTests() {
        return !Lambda.filter((Matcher)Lambda.having((Object)((TestOutcome)Lambda.on(TestOutcome.class)).isDataDriven(), (Matcher)Matchers.is((Object)true)), this.outcomes).isEmpty();
    }

    public int getTotalDataRows() {
        List datadrivenTestOutcomes = Lambda.filter((Matcher)Lambda.having((Object)((TestOutcome)Lambda.on(TestOutcome.class)).isDataDriven(), (Matcher)Matchers.is((Object)true)), this.outcomes);
        return (Integer)Lambda.sum((Object)datadrivenTestOutcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getDataTable().getSize());
    }

    public TestOutcomeMatcher findMatchingTags() {
        return new TestOutcomeMatcher(this);
    }

    public class OutcomeProportionCounter
    extends TestOutcomeCounter {
        public OutcomeProportionCounter(TestType testType) {
            super(testType);
        }

        public Double withResult(String expectedResult) {
            return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
        }

        public Double withResult(TestResult testResult) {
            int matchingTestCount = TestOutcomes.this.countTestsWithResult(testResult, this.testType);
            return TestOutcomes.this.getTotal() == 0 ? 0.0 : (double)matchingTestCount / (double)TestOutcomes.this.getTotal();
        }

        public Double withIndeterminateResult() {
            int pendingCount = TestOutcomes.this.countTestsWithResult(TestResult.PENDING, this.testType);
            int ignoredCount = TestOutcomes.this.countTestsWithResult(TestResult.IGNORED, this.testType);
            int skippedCount = TestOutcomes.this.countTestsWithResult(TestResult.SKIPPED, this.testType);
            return TestOutcomes.this.getTotal() == 0 ? 0.0 : (double)(pendingCount + skippedCount + ignoredCount) / (double)TestOutcomes.this.getTotal();
        }

        public Double withFailureOrError() {
            return this.withResult(TestResult.FAILURE) + this.withResult(TestResult.ERROR);
        }
    }

    public class OutcomeProportionStepCounter
    extends TestOutcomeCounter {
        public OutcomeProportionStepCounter(TestType testType) {
            super(testType);
        }

        public Double withResult(String expectedResult) {
            return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
        }

        public Double withResult(TestResult expectedResult) {
            int matchingStepCount = TestOutcomes.this.countStepsWithResult(expectedResult, this.testType);
            return (double)matchingStepCount / (double)TestOutcomes.this.getEstimatedTotalStepCount().intValue();
        }

        public Double withIndeterminateResult() {
            int pendingCount = TestOutcomes.this.countStepsWithResult(TestResult.PENDING, this.testType);
            int ignoredCount = TestOutcomes.this.countStepsWithResult(TestResult.IGNORED, this.testType);
            int skippedCount = TestOutcomes.this.countStepsWithResult(TestResult.SKIPPED, this.testType);
            return (double)(pendingCount + skippedCount + ignoredCount) / (double)TestOutcomes.this.getEstimatedTotalStepCount().intValue();
        }
    }

    private class TagFinder {
        private final String tagType;

        private TagFinder(String tagType) {
            this.tagType = tagType;
        }

        List<TestTag> in(TestOutcome testOutcome) {
            ArrayList matchingTags = Lists.newArrayList();
            for (TestTag tag : testOutcome.getTags()) {
                if (tag.getType().compareToIgnoreCase(this.tagType) != 0) continue;
                matchingTags.add(tag);
            }
            return matchingTags;
        }
    }

    public final class TestOutcomeMatcher {
        private final TestOutcomes outcomes;
        private Optional<List<Matcher<String>>> nameMatcher = Optional.absent();
        private Optional<Matcher<String>> typeMatcher = Optional.absent();

        public TestOutcomeMatcher(TestOutcomes outcomes) {
            this.outcomes = outcomes;
        }

        public TestOutcomeMatcher withName(Matcher<String> nameMatcher) {
            ArrayList matchers = Lists.newArrayList((Object[])new Matcher[]{nameMatcher});
            this.nameMatcher = Optional.of((Object)matchers);
            return this;
        }

        public TestOutcomeMatcher withNameIn(List<Matcher<String>> nameMatchers) {
            ArrayList matchers = Lists.newArrayList(nameMatchers);
            this.nameMatcher = Optional.of((Object)matchers);
            return this;
        }

        public TestOutcomeMatcher withName(String name) {
            return this.withName((Matcher<String>)Matchers.is((Object)name));
        }

        public TestOutcomeMatcher withType(Matcher<String> typeMatcher) {
            this.typeMatcher = Optional.of(typeMatcher);
            return this;
        }

        public TestOutcomeMatcher withType(String type) {
            return this.withType((Matcher<String>)Matchers.is((Object)type));
        }

        public List<TestTag> list() {
            ArrayList matches = Lists.newArrayList();
            for (TestTag tag : this.outcomes.getTags()) {
                if (!this.compatibleTag(tag)) continue;
                matches.add(tag);
            }
            Collections.sort(matches);
            return matches;
        }

        private boolean compatibleTag(TestTag tag) {
            if (this.nameMatcher.isPresent() && !this.matches(tag.getName(), (List)this.nameMatcher.get())) {
                return false;
            }
            return !this.typeMatcher.isPresent() || ((Matcher)this.typeMatcher.get()).matches((Object)tag.getType());
        }

        private boolean matches(String name, List<Matcher<String>> matchers) {
            for (Matcher<String> match : matchers) {
                if (!match.matches((Object)name)) continue;
                return true;
            }
            return false;
        }
    }
}

