/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reflection;

import com.google.common.base.Optional;
import java.lang.reflect.Field;

public class FieldFinder {
    private final Class targetClass;

    private FieldFinder(Class targetClass) {
        this.targetClass = targetClass;
    }

    public static FieldFinder inClass(Class targetClass) {
        return new FieldFinder(targetClass);
    }

    public Optional<Field> findFieldCalled(String fieldName) {
        return this.findFieldCalled(fieldName, this.targetClass);
    }

    private Optional<Field> findFieldCalled(String fieldName, Class targetClass) {
        Field[] fields;
        Field[] fieldArray = fields = targetClass.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals(fieldName)) {
                return Optional.of((Object)field);
            }
            ++n2;
        }
        if (targetClass.getSuperclass() != null) {
            return this.findFieldCalled(fieldName, targetClass.getSuperclass());
        }
        return Optional.absent();
    }
}

