/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import com.google.common.base.Function;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.thucydides.core.pages.WebElementFacadeImpl;
import net.thucydides.core.scheduling.NormalFluentWait;
import net.thucydides.core.scheduling.ThucydidesFluentWait;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RenderedPageObjectView {
    private final transient WebDriver driver;
    private transient long waitForTimeoutInMilliseconds;
    private final Clock webdriverClock;
    private final Sleeper sleeper;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderedPageObjectView.class);

    public RenderedPageObjectView(WebDriver driver, long waitForTimeout) {
        this.driver = driver;
        this.waitForTimeoutInMilliseconds = waitForTimeout;
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
    }

    public ThucydidesFluentWait<WebDriver> waitForCondition() {
        return new NormalFluentWait<WebDriver>(this.driver, this.webdriverClock, this.sleeper).withTimeout(this.waitForTimeoutInMilliseconds, TimeUnit.MILLISECONDS).pollingEvery(50L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    public FluentWait<WebDriver> doWait() {
        return new FluentWait((Object)this.driver).withTimeout(this.waitForTimeoutInMilliseconds, TimeUnit.MILLISECONDS).pollingEvery(50L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    private ExpectedCondition<Boolean> elementDisplayed(final By byElementCriteria) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.elementIsDisplayed(byElementCriteria);
            }
        };
    }

    private ExpectedCondition<Boolean> elementPresent(final By byElementCriteria) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.elementIsDisplayed(byElementCriteria);
            }
        };
    }

    public void waitFor(By byElementCriteria) {
        this.waitForCondition().until(this.elementDisplayed(byElementCriteria));
    }

    public void waitFor(ExpectedCondition expectedCondition) {
        this.doWait().until((Function)expectedCondition);
    }

    public void waitForPresenceOf(By byElementCriteria) {
        WebDriverWait wait = new WebDriverWait(this.driver, this.waitForTimeoutInMilliseconds / 1000L);
        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)byElementCriteria));
    }

    public boolean elementIsPresent(By byElementCriteria) {
        boolean isDisplayed = true;
        try {
            List matchingElements = this.driver.findElements(byElementCriteria);
            if (matchingElements.isEmpty()) {
                isDisplayed = false;
            }
        }
        catch (NoSuchElementException noSuchElement) {
            LOGGER.trace("No such element " + (Object)((Object)noSuchElement));
            isDisplayed = false;
        }
        return isDisplayed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean elementIsDisplayed(By byElementCriteria) {
        try {
            WebElement webElement;
            WebElementFacadeImpl element;
            List matchingElements = this.driver.findElements(byElementCriteria);
            Iterator iterator = matchingElements.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(element = WebElementFacadeImpl.wrapWebElement(this.driver, webElement = (WebElement)iterator.next(), 100L)).isCurrentlyVisible());
            return true;
        }
        catch (NoSuchElementException noSuchElement) {
            LOGGER.trace("No such element " + (Object)((Object)noSuchElement));
            return false;
        }
        catch (StaleElementReferenceException se) {
            LOGGER.trace("Element no longer attached to the DOM " + (Object)((Object)se));
            return false;
        }
    }

    private boolean matchingElementsArePresent(List<WebElement> matchingElements) {
        return matchingElements != null && !matchingElements.isEmpty();
    }

    private ExpectedCondition<Boolean> textPresent(final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.containsText(expectedText);
            }
        };
    }

    public void waitForText(String expectedText) {
        this.waitForCondition().until(this.textPresent(expectedText));
    }

    private ExpectedCondition<Boolean> textPresentInElement(final WebElement element, final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.containsText(element, expectedText);
            }
        };
    }

    public void waitForText(WebElement element, String expectedText) {
        this.waitForCondition().until(this.textPresentInElement(element, expectedText));
    }

    private ExpectedCondition<Boolean> titlePresent(final String expectedTitle) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.titleIs(expectedTitle);
            }
        };
    }

    public void waitForTitle(String expectedTitle) {
        this.waitForCondition().until(this.titlePresent(expectedTitle));
    }

    private boolean titleIs(String expectedTitle) {
        return this.driver.getTitle() != null && this.driver.getTitle().equals(expectedTitle);
    }

    public boolean containsText(String textValue) {
        return this.driver.findElement(By.tagName((String)"body")).getText().contains(textValue);
    }

    private boolean foundNo(List<WebElement> elements) {
        return elements == null || elements.isEmpty();
    }

    public boolean containsText(WebElement element, String textValue) {
        return element.getText().contains(textValue);
    }

    private ExpectedCondition<Boolean> textNotPresent(final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !RenderedPageObjectView.this.containsText(expectedText);
            }
        };
    }

    public void waitForTextToDisappear(String expectedText, long timeout) {
        this.waitForCondition().withTimeout(timeout, TimeUnit.MILLISECONDS).until(this.textNotPresent(expectedText));
    }

    public void waitForTextToAppear(String expectedText, long timeout) {
        this.waitForCondition().withTimeout(timeout, TimeUnit.MILLISECONDS).until(this.textPresent(expectedText));
    }

    private ExpectedCondition<Boolean> titleNotPresent(final String expectedTitle) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !RenderedPageObjectView.this.titleIs(expectedTitle);
            }
        };
    }

    public void waitForTitleToDisappear(String expectedTitle) {
        this.waitForCondition().until(this.titleNotPresent(expectedTitle));
    }

    private ExpectedCondition<Boolean> anyTextPresent(final String ... expectedTexts) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.pageContainsAny(expectedTexts);
            }
        };
    }

    public void waitForAnyTextToAppear(String ... expectedTexts) {
        this.waitForCondition().until(this.anyTextPresent(expectedTexts));
    }

    private ExpectedCondition<Boolean> anyTextPresentInElement(final WebElement element, final String ... expectedTexts) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.elementContains(element, expectedTexts);
            }
        };
    }

    public void waitForAnyTextToAppear(WebElement element, String ... expectedTexts) {
        this.waitForCondition().until(this.anyTextPresentInElement(element, expectedTexts));
    }

    private boolean elementContains(WebElement element, String ... expectedTexts) {
        String[] stringArray = expectedTexts;
        int n = expectedTexts.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedText = stringArray[n2];
            if (this.containsText(element, expectedText)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean pageContainsAny(String ... expectedTexts) {
        String[] stringArray = expectedTexts;
        int n = expectedTexts.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedText = stringArray[n2];
            if (this.containsText(expectedText)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ExpectedCondition<Boolean> allTextPresent(final String ... expectedTexts) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String[] stringArray = expectedTexts;
                int n = expectedTexts.length;
                int n2 = 0;
                while (n2 < n) {
                    String expectedText = stringArray[n2];
                    if (!RenderedPageObjectView.this.containsText(expectedText)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    public void waitForAllTextToAppear(String ... expectedTexts) {
        this.waitForCondition().until(this.allTextPresent(expectedTexts));
    }

    private ExpectedCondition<Boolean> elementNotDisplayed(final By byElementCriteria) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !RenderedPageObjectView.this.elementIsDisplayed(byElementCriteria);
            }
        };
    }

    public void waitForElementsToDisappear(By byElementCriteria) {
        this.waitForCondition().until(this.elementNotDisplayed(byElementCriteria));
    }

    private ExpectedCondition<Boolean> anyElementPresent(final By ... expectedElements) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                By[] byArray = expectedElements;
                int n = expectedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    By expectedElement = byArray[n2];
                    if (RenderedPageObjectView.this.elementIsDisplayed(expectedElement)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    public void waitForAnyRenderedElementOf(By[] expectedElements) {
        this.waitForCondition().until(this.anyElementPresent(expectedElements));
    }

    public void setWaitForTimeoutInMilliseconds(long waitForTimeoutInMilliseconds) {
        this.waitForTimeoutInMilliseconds = waitForTimeoutInMilliseconds;
    }
}

