/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.model.ErrorMessageFormatter;
import org.apache.commons.lang3.StringEscapeUtils;

public class Screenshot {
    private final String filename;
    private final String description;
    private final int width;
    private final Throwable error;

    public Screenshot(String filename, String description, int width, Throwable error) {
        this.filename = filename;
        this.description = description;
        this.width = width;
        this.error = error;
    }

    public Screenshot(String filename, String description, int width) {
        this(filename, description, width, null);
    }

    public Throwable getError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.error != null ? this.errorMessageFrom(this.error) : "";
    }

    private String errorMessageFrom(Throwable error) {
        return error.getCause() != null ? error.getCause().getMessage() : error.getMessage();
    }

    public String getShortErrorMessage() {
        return new ErrorMessageFormatter(this.getErrorMessage()).getShortErrorMessage();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDescription() {
        return this.description;
    }

    public int getWidth() {
        return this.width;
    }

    public HtmlFormattedInfo getHtml() {
        return new HtmlFormattedInfo(this.description);
    }

    public class HtmlFormattedInfo {
        private final String description;

        public HtmlFormattedInfo(String description) {
            this.description = description;
        }

        public String getDescription() {
            return StringEscapeUtils.escapeHtml4((String)this.description);
        }
    }
}

