/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Optional;
import java.lang.reflect.Method;
import net.thucydides.core.annotations.Screenshots;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.reflection.StackTraceAnalyser;
import net.thucydides.core.webdriver.Configuration;

public class ScreenshotPermission {
    private final Configuration configuration;

    public ScreenshotPermission(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean areAllowed(TakeScreenshots takeScreenshots) {
        Optional<TakeScreenshots> overrideLevel = this.methodOverride();
        if (overrideLevel.isPresent()) {
            return this.takeScreenshotLevel(takeScreenshots).isAtLeast((TakeScreenshots)((Object)overrideLevel.get()));
        }
        Optional<TakeScreenshots> configuredLevel = this.configuration.getScreenshotLevel();
        if (configuredLevel.isPresent()) {
            return this.takeScreenshotLevel(takeScreenshots).isAtLeast((TakeScreenshots)((Object)configuredLevel.get()));
        }
        return this.legacyScreenshotConfiguration(takeScreenshots);
    }

    private boolean legacyScreenshotConfiguration(TakeScreenshots takeScreenshots) {
        if (this.configuration.onlySaveFailingScreenshots()) {
            return this.takeScreenshotLevel(takeScreenshots).isAtLeast(TakeScreenshots.FOR_FAILURES);
        }
        if (this.configuration.takeVerboseScreenshots()) {
            return this.takeScreenshotLevel(takeScreenshots).isAtLeast(TakeScreenshots.FOR_EACH_ACTION);
        }
        return this.takeScreenshotLevel(takeScreenshots).isAtLeast(TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP);
    }

    private Optional<TakeScreenshots> methodOverride() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new Throwable().getStackTrace()) {
            Method callingMethod = StackTraceAnalyser.forStackTraceElement(stackTraceElement).getMethod();
            if (callingMethod == null || callingMethod.getAnnotation(Screenshots.class) == null) continue;
            return Optional.of((Object)((Object)this.screenshotLevelFrom(callingMethod.getAnnotation(Screenshots.class))));
        }
        return Optional.absent();
    }

    private TakeScreenshots screenshotLevelFrom(Screenshots screenshots) {
        if (screenshots.onlyOnFailures()) {
            return TakeScreenshots.FOR_FAILURES;
        }
        if (screenshots.forEachAction()) {
            return TakeScreenshots.FOR_EACH_ACTION;
        }
        if (screenshots.afterEachStep()) {
            return TakeScreenshots.AFTER_EACH_STEP;
        }
        if (screenshots.beforeAndAfterEachStep()) {
            return TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP;
        }
        return TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP;
    }

    private TakeScreenshotsComparer takeScreenshotLevel(TakeScreenshots takeScreenshots) {
        return new TakeScreenshotsComparer(takeScreenshots);
    }

    private static class TakeScreenshotsComparer {
        private final TakeScreenshots takeScreenshots;

        private TakeScreenshotsComparer(TakeScreenshots takeScreenshots) {
            this.takeScreenshots = takeScreenshots;
        }

        public boolean isAtLeast(TakeScreenshots requiredLevel) {
            return this.takeScreenshots.compareTo(requiredLevel) >= 0;
        }
    }
}

