/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.maven.plugins;

import java.io.File;
import java.io.IOException;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.TestOutcomeAdaptorReporter;
import net.thucydides.core.reports.adaptors.AdaptorService;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ThucydidesAdaptorMojo
extends AbstractMojo {
    public File outputDirectory;
    public String format;
    public File source;
    private final EnvironmentVariables environmentVariables;
    private final AdaptorService adaptorService;
    private final TestOutcomeAdaptorReporter reporter = new TestOutcomeAdaptorReporter();

    public ThucydidesAdaptorMojo(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.adaptorService = new AdaptorService(environmentVariables);
    }

    public ThucydidesAdaptorMojo() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Importing external test reports");
        this.getLog().info((CharSequence)("Source directory: " + this.source));
        this.getLog().info((CharSequence)("Output directory: " + this.getOutputDirectory()));
        try {
            this.getLog().info((CharSequence)("Adaptor: " + this.adaptorService.getAdaptor(this.format)));
            this.reporter.registerAdaptor(this.adaptorService.getAdaptor(this.format));
            this.reporter.setOutputDirectory(this.outputDirectory);
            this.reporter.generateReportsFrom(this.source);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

