/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.CoreResolvers;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.NameResolver;
import net.sourceforge.pmd.lang.java.symbols.table.internal.JavaResolvers;
import net.sourceforge.pmd.lang.java.types.CaptureMatcher;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JIntersectionType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.JTypeVisitor;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.lang.java.types.internal.infer.OverloadSet;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TypeOps {
    private static final JTypeMirror NO_DOWN_PROJECTION = null;
    private static final ProjectionVisitor UPWARDS_PROJECTOR = new ProjectionVisitor(true){

        @Override
        public JTypeMirror visitTypeVar(JTypeVar t, RecursionStop recursionStop) {
            if (t.isCaptured()) {
                return t.getUpperBound().acceptVisitor(UPWARDS_PROJECTOR, recursionStop);
            }
            return t;
        }

        @Override
        public JTypeMirror visitWildcard(JWildcardType t, RecursionStop recursionStop) {
            JTypeMirror u = t.getBound().acceptVisitor(UPWARDS_PROJECTOR, recursionStop);
            TypeSystem ts = t.getTypeSystem();
            if (u == t.getBound()) {
                return t;
            }
            if (t.isUpperBound()) {
                return ts.wildcard(true, u);
            }
            JTypeMirror down = t.getBound().acceptVisitor(DOWNWARDS_PROJECTOR, recursionStop);
            return down == NO_DOWN_PROJECTION ? ts.UNBOUNDED_WILD : ts.wildcard(false, down);
        }

        @Override
        public JTypeMirror visitNullType(JTypeMirror t, RecursionStop recursionStop) {
            return t;
        }
    };
    private static final ProjectionVisitor DOWNWARDS_PROJECTOR = new ProjectionVisitor(false){

        @Override
        public JTypeMirror visitWildcard(JWildcardType t, RecursionStop recursionStop) {
            JTypeMirror u = t.getBound().acceptVisitor(UPWARDS_PROJECTOR, recursionStop);
            if (u == t.getBound()) {
                return t;
            }
            TypeSystem ts = t.getTypeSystem();
            if (t.isUpperBound()) {
                JTypeMirror down = t.getBound().acceptVisitor(DOWNWARDS_PROJECTOR, recursionStop);
                return down == NO_DOWN_PROJECTION ? NO_DOWN_PROJECTION : ts.wildcard(true, down);
            }
            return ts.wildcard(false, u);
        }

        @Override
        public JTypeMirror visitTypeVar(JTypeVar t, RecursionStop recursionStop) {
            if (t.isCaptured()) {
                return t.getLowerBound().acceptVisitor(DOWNWARDS_PROJECTOR, recursionStop);
            }
            return t;
        }

        @Override
        public JTypeMirror visitNullType(JTypeMirror t, RecursionStop recursionStop) {
            return NO_DOWN_PROJECTION;
        }
    };

    private TypeOps() {
    }

    public static boolean isSameType(JMethodSig t, JMethodSig s) {
        return t.getDeclaringType().equals(s.getDeclaringType()) && TypeOps.haveSameSignature(t, s);
    }

    public static boolean isSameType(JTypeMirror t, JTypeMirror s) {
        return TypeOps.isSameType(t, s, false, false);
    }

    public static boolean isSameTypeWithSameAnnotations(JTypeMirror t, JTypeMirror s) {
        return TypeOps.isSameType(t, s, false, true);
    }

    @InternalApi
    public static boolean isSameTypeInInference(JTypeMirror t, JTypeMirror s) {
        return TypeOps.isSameType(t, s, true, false);
    }

    private static boolean isSameType(JTypeMirror t, JTypeMirror s, boolean inInference, boolean considerAnnotations) {
        if (t == s) {
            return true;
        }
        if (t == null || s == null) {
            return false;
        }
        if (!inInference) {
            if (considerAnnotations) {
                if (t instanceof CaptureMatcher || s instanceof CaptureMatcher) {
                    return t.equals(s);
                }
                return t.getTypeAnnotations().equals(s.getTypeAnnotations()) && t.acceptVisitor(SameTypeVisitor.PURE_WITH_ANNOTATIONS, s) != false;
            }
            return t.acceptVisitor(SameTypeVisitor.PURE, s);
        }
        if (t instanceof InferenceVar) {
            return t.acceptVisitor(SameTypeVisitor.INFERENCE, s);
        }
        return s.acceptVisitor(SameTypeVisitor.INFERENCE, t);
    }

    public static boolean areSameTypes(List<JTypeMirror> ts, List<JTypeMirror> ss) {
        return TypeOps.areSameTypes(ts, ss, Substitution.EMPTY, false, false);
    }

    public static boolean areSameTypesInInference(List<JTypeMirror> ts, List<JTypeMirror> ss) {
        return TypeOps.areSameTypes(ts, ss, Substitution.EMPTY, true, false);
    }

    private static boolean areSameTypes(List<JTypeMirror> ts, List<JTypeMirror> ss, boolean inInference, boolean considerAnnotations) {
        return TypeOps.areSameTypes(ts, ss, Substitution.EMPTY, inInference, considerAnnotations);
    }

    private static boolean areSameTypes(List<JTypeMirror> ts, List<JTypeMirror> ss, Substitution subst) {
        return TypeOps.areSameTypes(ts, ss, subst, false, false);
    }

    private static boolean areSameTypes(List<JTypeMirror> ts, List<JTypeMirror> ss, Substitution subst, boolean inInference, boolean considerAnnotations) {
        if (ts.size() != ss.size()) {
            return false;
        }
        for (int i = 0; i < ts.size(); ++i) {
            if (TypeOps.isSameType(ts.get(i), (JTypeMirror)ss.get(i).subst((Function)subst), inInference, considerAnnotations)) continue;
            return false;
        }
        return true;
    }

    public static Set<JTypeMirror> getSuperTypeSet(@NonNull JTypeMirror t) {
        LinkedHashSet<JTypeMirror> result = new LinkedHashSet<JTypeMirror>();
        t.acceptVisitor(SuperTypesVisitor.INSTANCE, result);
        assert (!result.isEmpty()) : "Empty supertype set for " + t;
        return result;
    }

    public static Convertibility isConvertible(@NonNull JTypeMirror t, @NonNull JTypeMirror s) {
        return TypeOps.isConvertible(t, s, true);
    }

    public static Convertibility isConvertibleNoCapture(@NonNull JTypeMirror t, @NonNull JTypeMirror s) {
        return TypeOps.isConvertible(t, s, false);
    }

    public static Convertibility isConvertible(@NonNull JTypeMirror t, @NonNull JTypeMirror s, boolean capture) {
        if (t == s) {
            Objects.requireNonNull(t);
            return Convertibility.SUBTYPING;
        }
        if (s.isTop()) {
            return Convertibility.subtypeIf(!t.isPrimitive());
        }
        if (s.isVoid() || t.isVoid()) {
            return Convertibility.NEVER;
        }
        if (s instanceof InferenceVar) {
            ((InferenceVar)s).addBound(InferenceVar.BoundKind.LOWER, t);
            return Convertibility.SUBTYPING;
        }
        if (TypeOps.isTypeRange(s)) {
            JTypeMirror lower = TypeOps.lowerBoundRec(s);
            if (!lower.isBottom()) {
                return TypeOps.isConvertible(t, lower, capture);
            }
        } else {
            if (TypeOps.isSpecialUnresolved(t)) {
                return Convertibility.SUBTYPING;
            }
            if (TypeOps.hasUnresolvedSymbol(t) && t instanceof JClassType) {
                if (Objects.equals(t.getSymbol(), s.getSymbol())) {
                    return TypeOps.typeArgsAreContained((JClassType)t, (JClassType)s);
                }
                return Convertibility.subtypeIf(s instanceof JClassType);
            }
            if (s instanceof JIntersectionType) {
                return Convertibility.subtypesAll(t, TypeOps.asList(s));
            }
        }
        if (capture) {
            t = TypeConversion.capture(t);
        }
        return t.acceptVisitor(SubtypeVisitor.INSTANCE, s);
    }

    private static Convertibility isSubtypePure(JTypeMirror t, JTypeMirror s) {
        if (t instanceof InferenceVar) {
            return Convertibility.subtypeIf(((InferenceVar)t).isSubtypeNoSideEffect(s));
        }
        if (s instanceof InferenceVar) {
            return Convertibility.subtypeIf(((InferenceVar)s).isSupertypeNoSideEffect(t));
        }
        return TypeOps.isConvertible(t, s);
    }

    public static boolean allArgsAreUnboundedWildcards(List<JTypeMirror> sargs) {
        for (JTypeMirror sarg : sargs) {
            if (sarg instanceof JWildcardType && ((JWildcardType)sarg).isUnbounded()) continue;
            return false;
        }
        return true;
    }

    private static JTypeMirror wildUpperBound(JTypeMirror type) {
        if (type instanceof JWildcardType) {
            JWildcardType wild = (JWildcardType)type;
            if (wild.isUpperBound()) {
                return TypeOps.wildUpperBound(wild.asUpperBound());
            }
            if (wild.asLowerBound() instanceof JTypeVar) {
                return ((JTypeVar)wild.asLowerBound()).getUpperBound();
            }
        } else if (type instanceof JTypeVar && ((JTypeVar)type).isCaptured()) {
            return TypeOps.wildUpperBound(((JTypeVar)type).getUpperBound());
        }
        return type;
    }

    private static JTypeMirror wildLowerBound(JTypeMirror type) {
        if (type instanceof JWildcardType) {
            return TypeOps.wildLowerBound(((JWildcardType)type).asLowerBound());
        }
        return type;
    }

    private static JTypeMirror lowerBoundRec(JTypeMirror type) {
        if (type instanceof JWildcardType) {
            return TypeOps.lowerBoundRec(((JWildcardType)type).asLowerBound());
        }
        if (type instanceof JTypeVar && ((JTypeVar)type).isCaptured()) {
            return TypeOps.lowerBoundRec(((JTypeVar)type).getLowerBound());
        }
        return type;
    }

    private static boolean isTypeRange(JTypeMirror s) {
        return s instanceof JWildcardType || TypeOps.isCvar(s);
    }

    private static boolean isCvar(JTypeMirror s) {
        return s instanceof JTypeVar && ((JTypeVar)s).isCaptured();
    }

    static Convertibility typeArgContains(JTypeMirror s, JTypeMirror t) {
        if (TypeOps.isSameTypeInInference(s, t)) {
            return Convertibility.SUBTYPING;
        }
        if (s instanceof JWildcardType) {
            JWildcardType sw = (JWildcardType)s;
            if (t instanceof JTypeVar && ((JTypeVar)t).isCaptureOf(sw)) {
                return Convertibility.SUBTYPING;
            }
            if (sw.isUpperBound()) {
                return TypeOps.isConvertible(TypeOps.wildUpperBound(t), sw.asUpperBound());
            }
            return TypeOps.isConvertible(sw.asLowerBound(), TypeOps.wildLowerBound(t));
        }
        return Convertibility.NEVER;
    }

    static Convertibility typeArgsAreContained(JClassType t, JClassType s) {
        List<JTypeMirror> targs = t.getTypeArgs();
        List<JTypeMirror> sargs = s.getTypeArgs();
        if (targs.isEmpty()) {
            if (sargs.isEmpty()) {
                boolean tRaw = t.hasErasedSuperTypes();
                boolean sRaw = s.hasErasedSuperTypes();
                if (tRaw && !sRaw) {
                    return Convertibility.UNCHECKED_NO_WARNING;
                }
                return Convertibility.SUBTYPING;
            }
            return TypeOps.allArgsAreUnboundedWildcards(sargs) ? Convertibility.UNCHECKED_NO_WARNING : Convertibility.UNCHECKED_WARNING;
        }
        if (targs.size() != sargs.size()) {
            return Convertibility.NEVER;
        }
        Convertibility result = Convertibility.SUBTYPING;
        for (int i = 0; i < targs.size(); ++i) {
            Convertibility sub = TypeOps.typeArgContains(sargs.get(i), targs.get(i));
            if (sub == Convertibility.NEVER) {
                return Convertibility.NEVER;
            }
            result = result.and(sub);
        }
        return result;
    }

    public static boolean isStrictSubtype(@NonNull JTypeMirror t, @NonNull JTypeMirror s) {
        return !t.equals(s) && t.isSubtypeOf(s);
    }

    public static JTypeMirror subst(@Nullable JTypeMirror type, Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
        if (type == null || Substitution.isEmptySubst(subst)) {
            return type;
        }
        return type.subst((Function)subst);
    }

    public static List<JTypeMirror> subst(List<? extends JTypeMirror> ts, Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
        if (Substitution.isEmptySubst(subst)) {
            return CollectionUtil.makeUnmodifiableAndNonNull(ts);
        }
        return TypeOps.mapPreservingSelf(ts, t -> t.subst((Function)subst));
    }

    public static List<JClassType> substClasses(List<JClassType> ts, Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
        if (Substitution.isEmptySubst(subst)) {
            return ts;
        }
        return TypeOps.mapPreservingSelf(ts, t -> t.subst((Function)subst));
    }

    public static List<JTypeVar> substInBoundsOnly(List<JTypeVar> ts, Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
        if (Substitution.isEmptySubst(subst)) {
            return ts;
        }
        return TypeOps.mapPreservingSelf(ts, t -> t.substInBounds(subst));
    }

    private static <T> @NonNull List<T> mapPreservingSelf(List<? extends T> ts, Function<? super T, ? extends @NonNull T> subst) {
        List<Object> list = null;
        int size = ts.size();
        for (int i = 0; i < size; ++i) {
            T it = ts.get(i);
            T substed = subst.apply(it);
            if (substed == it) continue;
            if (list == null) {
                list = Arrays.asList(ts.toArray());
            }
            list.set(i, substed);
        }
        return list != null ? list : ts;
    }

    public static JTypeMirror projectUpwards(JTypeMirror t) {
        return t.acceptVisitor(UPWARDS_PROJECTOR, new RecursionStop());
    }

    public static boolean isReturnTypeSubstitutable(JMethodSig m1, JMethodSig m2) {
        JTypeMirror r1 = m1.getReturnType();
        JTypeMirror r2 = m2.getReturnType();
        if (r1 == r1.getTypeSystem().NO_TYPE) {
            return r1 == r2;
        }
        if (r1.isPrimitive()) {
            return r1 == r2;
        }
        JMethodSig m1Prime = TypeOps.adaptForTypeParameters(m1, m2);
        return m1Prime != null && TypeOps.isConvertible(m1Prime.getReturnType(), r2) != Convertibility.NEVER || !TypeOps.haveSameSignature(m1, m2) && TypeOps.isSameType(r1, r2.getErasure());
    }

    static @Nullable JMethodSig adaptForTypeParameters(JMethodSig m1, JMethodSig m2) {
        if (TypeOps.haveSameTypeParams(m1, m2)) {
            return m1.subst((Function)Substitution.mapping(m1.getTypeParameters(), m2.getTypeParameters()));
        }
        return null;
    }

    public static boolean haveSameTypeParams(JMethodSig m1, JMethodSig m2) {
        List<JTypeVar> tp1 = m1.getTypeParameters();
        List<JTypeVar> tp2 = m2.getTypeParameters();
        if (tp1.size() != tp2.size()) {
            return false;
        }
        if (tp1.isEmpty()) {
            return true;
        }
        Substitution mapping = Substitution.mapping(tp2, tp1);
        for (int i = 0; i < tp1.size(); ++i) {
            JTypeVar p1 = tp1.get(i);
            JTypeVar p2 = tp2.get(i);
            if (TypeOps.isSameType(p1.getUpperBound(), TypeOps.subst(p2.getUpperBound(), (Function<? super SubstVar, ? extends JTypeMirror>)mapping))) continue;
            return false;
        }
        return true;
    }

    public static boolean areOverrideEquivalent(JMethodSig m1, JMethodSig m2) {
        if (m1.getArity() != m2.getArity()) {
            return false;
        }
        if (m1 == m2) {
            return true;
        }
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        List<JTypeMirror> formals1 = m1.getFormalParameters();
        List<JTypeMirror> formals2 = m2.getFormalParameters();
        for (int i = 0; i < formals1.size(); ++i) {
            JTypeMirror fi1 = formals1.get(i);
            JTypeMirror fi2 = formals2.get(i);
            if (TypeOps.isSameType(fi1.getErasure(), fi2.getErasure())) continue;
            return false;
        }
        return !m1.isGeneric() || !m2.isGeneric() || TypeOps.haveSameTypeParams(m1, m2);
    }

    public static boolean isSubSignature(JMethodSig m1, JMethodSig m2) {
        boolean m2Gen;
        if (m1.getArity() != m2.getArity() || !m1.getName().equals(m2.getName())) {
            return false;
        }
        boolean m1Gen = m1.isGeneric();
        if (m1Gen ^ (m2Gen = m2.isGeneric())) {
            if (m1Gen) {
                return false;
            }
            m2 = m2.getErasure();
        }
        return TypeOps.haveSameSignature(m1, m2);
    }

    private static boolean haveSameSignature(JMethodSig m1, JMethodSig m2) {
        return m1.getName().equals(m2.getName()) && m1.getArity() == m2.getArity() && TypeOps.haveSameTypeParams(m1, m2) && TypeOps.areSameTypes(m1.getFormalParameters(), m2.getFormalParameters(), Substitution.mapping(m2.getTypeParameters(), m1.getTypeParameters()));
    }

    public static boolean overrides(JMethodSig m1, JMethodSig m2, JTypeMirror origin) {
        JClassType m2AsM1Supertype;
        if (m1.isConstructor() || m2.isConstructor()) {
            return m1.equals(m2);
        }
        JTypeMirror m1Owner = m1.getDeclaringType();
        JClassType m2Owner = (JClassType)m2.getDeclaringType();
        if (TypeOps.isOverridableIn(m2, m1Owner.getSymbol()) && (m2AsM1Supertype = (JClassType)m1Owner.getAsSuper(m2Owner.getSymbol())) != null) {
            JMethodSig m2Prime = m2AsM1Supertype.getDeclaredMethod(m2.getSymbol());
            assert (m2Prime != null);
            if (TypeOps.isSubSignature(m1, m2Prime)) {
                return true;
            }
        }
        if (m1.isAbstract() || !m2.isAbstract() && !m2.getSymbol().isDefaultMethod() || !TypeOps.isOverridableIn(m2, origin.getSymbol()) || !(m1Owner instanceof JClassType)) {
            return false;
        }
        JTypeMirror m1AsSuper = origin.getAsSuper(((JClassType)m1Owner).getSymbol());
        JTypeMirror m2AsSuper = origin.getAsSuper(m2Owner.getSymbol());
        if (m1AsSuper instanceof JClassType && m2AsSuper instanceof JClassType) {
            m1 = ((JClassType)m1AsSuper).getDeclaredMethod(m1.getSymbol());
            m2 = ((JClassType)m2AsSuper).getDeclaredMethod(m2.getSymbol());
            assert (m1 != null && m2 != null);
            return TypeOps.isSubSignature(m1, m2);
        }
        return false;
    }

    private static boolean isOverridableIn(JMethodSig m, JTypeDeclSymbol origin) {
        return TypeOps.isOverridableIn(m.getSymbol(), origin);
    }

    public static boolean isOverridableIn(JExecutableSymbol m, JTypeDeclSymbol origin) {
        if (m instanceof JConstructorSymbol) {
            return false;
        }
        int accessFlags = 7;
        switch (m.getModifiers() & 7) {
            case 1: {
                return true;
            }
            case 4: {
                return !origin.isInterface();
            }
            case 0: {
                return m.getPackageName().equals(origin.getPackageName()) && !origin.isInterface();
            }
        }
        return false;
    }

    public static @Nullable JClassType nonWildcardParameterization(@NonNull JClassType type) {
        TypeSystem ts = type.getTypeSystem();
        List<JTypeMirror> targs = type.getTypeArgs();
        if (targs.stream().noneMatch(it -> it instanceof JWildcardType)) {
            return type;
        }
        List<JTypeVar> tparams = type.getFormalTypeParams();
        ArrayList<JTypeMirror> newArgs = new ArrayList<JTypeMirror>();
        for (int i = 0; i < tparams.size(); ++i) {
            JTypeMirror ai = targs.get(i);
            if (ai instanceof JWildcardType) {
                JTypeVar pi = tparams.get(i);
                JTypeMirror bi = pi.getUpperBound();
                if (TypeOps.mentionsAny(bi, new HashSet<JTypeVar>(tparams))) {
                    return null;
                }
                JWildcardType ai2 = (JWildcardType)ai;
                if (ai2.isUnbounded()) {
                    newArgs.add(bi);
                    continue;
                }
                if (ai2.isUpperBound()) {
                    newArgs.add(ts.glb(Arrays.asList(ai2.asUpperBound(), bi)));
                    continue;
                }
                newArgs.add(ai2.asLowerBound());
                continue;
            }
            newArgs.add(ai);
        }
        return type.withTypeArguments(newArgs);
    }

    public static @Nullable JMethodSig findFunctionalInterfaceMethod(@Nullable JTypeMirror type) {
        JClassType candidateSam = TypeOps.asClassType(type);
        if (candidateSam == null) {
            return null;
        }
        if (candidateSam.isParameterizedType()) {
            return TypeOps.findFunctionTypeImpl(TypeOps.nonWildcardParameterization(candidateSam));
        }
        if (candidateSam.isRaw()) {
            JMethodSig fun = TypeOps.findFunctionTypeImpl(candidateSam.getGenericTypeDeclaration());
            return fun == null ? null : fun.getErasure();
        }
        return TypeOps.findFunctionTypeImpl(candidateSam);
    }

    public static @Nullable JClassType asClassType(@Nullable JTypeMirror t) {
        if (t instanceof JClassType) {
            return (JClassType)t;
        }
        if (t instanceof JIntersectionType) {
            return ((JIntersectionType)t).getInducedClassType();
        }
        return null;
    }

    private static @Nullable JMethodSig findFunctionTypeImpl(@Nullable JClassType candidateSam) {
        if (candidateSam == null || !candidateSam.isInterface() || candidateSam.getSymbol().isAnnotation()) {
            return null;
        }
        Map<String, List<JMethodSig>> relevantMethods = candidateSam.streamMethods(it -> !Modifier.isStatic(it.getModifiers())).filter(TypeOps::isNotDeclaredInClassObject).collect(Collectors.groupingBy(JMethodSig::getName, OverloadSet.collectMostSpecific(candidateSam)));
        ArrayList<JMethodSig> candidates = new ArrayList<JMethodSig>();
        for (Map.Entry<String, List<JMethodSig>> entry : relevantMethods.entrySet()) {
            for (JMethodSig sig : entry.getValue()) {
                if (!sig.isAbstract()) continue;
                candidates.add(sig);
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (JMethodSig)candidates.get(0);
        }
        JMethodSig currentBest = null;
        block2: for (int i = 0; i < candidates.size(); ++i) {
            JMethodSig cand = (JMethodSig)candidates.get(i);
            for (JMethodSig other : candidates) {
                if (TypeOps.isSubSignature(cand, other) && TypeOps.isReturnTypeSubstitutable(cand, other)) continue;
                continue block2;
            }
            if (currentBest == null) {
                currentBest = cand;
                continue;
            }
            if (!cand.getReturnType().isSubtypeOf(currentBest.getReturnType())) continue;
            currentBest = cand;
        }
        return currentBest;
    }

    private static boolean isNotDeclaredInClassObject(JMethodSig it) {
        TypeSystem ts = it.getDeclaringType().getTypeSystem();
        return ts.OBJECT.streamDeclaredMethods(om -> Modifier.isPublic(om.getModifiers()) && om.nameEquals(it.getName())).noneMatch(om -> TypeOps.haveSameSignature(it, om));
    }

    public static @Nullable JTypeMirror asSuper(@NonNull JTypeMirror t, @NonNull JClassSymbol s) {
        if (!t.isPrimitive() && s.equals(t.getTypeSystem().OBJECT.getSymbol())) {
            return t.getTypeSystem().OBJECT;
        }
        return t.acceptVisitor(AsSuperVisitor.INSTANCE, s);
    }

    public static JClassType asOuterSuper(JTypeMirror t, JClassSymbol sym) {
        if (t instanceof JClassType) {
            JClassType ct = (JClassType)t;
            do {
                JClassType sup;
                if ((sup = ct.getAsSuper(sym)) == null) continue;
                return sup;
            } while ((ct = ct.getEnclosingType()) != null);
        } else if (t instanceof JTypeVar || t instanceof JArrayType) {
            return (JClassType)t.getAsSuper(sym);
        }
        return null;
    }

    public static Set<JTypeMirror> mostSpecific(Collection<? extends JTypeMirror> set) {
        LinkedHashSet<JTypeMirror> result = new LinkedHashSet<JTypeMirror>(set.size());
        block0: for (JTypeMirror jTypeMirror : set) {
            for (JTypeMirror jTypeMirror2 : set) {
                if (jTypeMirror2.equals(jTypeMirror) || TypeOps.hasUnresolvedSymbol(jTypeMirror2) || !TypeOps.isSubtypePure(jTypeMirror2, jTypeMirror).bySubtyping()) continue;
                continue block0;
            }
            result.add(jTypeMirror);
        }
        return result;
    }

    public static List<JTypeMirror> asList(JTypeMirror t) {
        if (t instanceof JIntersectionType) {
            return ((JIntersectionType)t).getComponents();
        }
        return Collections.singletonList(t);
    }

    public static List<JTypeMirror> erase(Collection<? extends JTypeMirror> ts) {
        return CollectionUtil.map(ts, JTypeMirror::getErasure);
    }

    public static boolean mentions(@NonNull JTypeVisitable type, @NonNull InferenceVar parent) {
        return type.acceptVisitor(MentionsVisitor.INSTANCE, Collections.singleton(parent));
    }

    public static boolean mentionsAny(JTypeVisitable t, Collection<? extends SubstVar> vars) {
        return !vars.isEmpty() && t.acceptVisitor(MentionsVisitor.INSTANCE, vars) != false;
    }

    public static Predicate<JMethodSymbol> accessibleMethodFilter(String name, @NonNull JClassSymbol symbol) {
        return it -> it.nameEquals(name) && TypeOps.isAccessible(it, symbol);
    }

    public static Iterable<JMethodSig> lazyFilterAccessible(List<JMethodSig> visible, @NonNull JClassSymbol accessSite) {
        return () -> IteratorUtil.filter(visible.iterator(), it -> TypeOps.isAccessible(it.getSymbol(), accessSite));
    }

    public static List<JMethodSig> filterAccessible(List<JMethodSig> visible, @NonNull JClassSymbol accessSite) {
        return CollectionUtil.mapNotNull(visible, m -> TypeOps.isAccessible(m.getSymbol(), accessSite) ? m : null);
    }

    public static List<JMethodSig> getMethodsOf(JTypeMirror type, String name, boolean staticOnly, @NonNull JClassSymbol enclosing) {
        if (staticOnly && type.isInterface()) {
            return type.streamDeclaredMethods(TypeOps.staticMethodFilter(name, true, enclosing)).collect(Collectors.toList());
        }
        if (staticOnly) {
            return type.streamMethods(TypeOps.staticMethodFilter(name, false, enclosing)).collect(OverloadSet.collectMostSpecific(type));
        }
        return type.streamMethods(TypeOps.methodFilter(name, enclosing)).collect(OverloadSet.collectMostSpecific(type));
    }

    private static @NonNull Predicate<JMethodSymbol> methodFilter(String name, @NonNull JClassSymbol enclosing) {
        return it -> TypeOps.isAccessibleWithName(name, enclosing, it);
    }

    private static @NonNull Predicate<JMethodSymbol> staticMethodFilter(String name, boolean acceptItfs, @NonNull JClassSymbol enclosing) {
        return it -> Modifier.isStatic(it.getModifiers()) && (acceptItfs || !it.getEnclosingClass().isInterface()) && TypeOps.isAccessibleWithName(name, enclosing, it);
    }

    private static boolean isAccessibleWithName(String name, @NonNull JClassSymbol enclosing, JMethodSymbol m) {
        return m.nameEquals(name) && TypeOps.isAccessible(m, enclosing);
    }

    private static boolean isAccessible(JExecutableSymbol method, JClassSymbol ctx) {
        Objects.requireNonNull(ctx, "Cannot check a null symbol");
        int mods = method.getModifiers();
        if (Modifier.isPublic(mods)) {
            return true;
        }
        JClassSymbol owner = method.getEnclosingClass();
        if (Modifier.isPrivate(mods)) {
            return ctx.getNestRoot().equals(owner.getNestRoot());
        }
        return ctx.getPackageName().equals(owner.getPackageName()) || Modifier.isProtected(mods) && TypeOps.isSubClassOfNoInterface(ctx, owner);
    }

    private static boolean isSubClassOfNoInterface(JClassSymbol sub, JClassSymbol symbol) {
        if (symbol.equals(sub)) {
            return true;
        }
        JClassSymbol superclass = sub.getSuperclass();
        return superclass != null && TypeOps.isSubClassOfNoInterface(superclass, symbol);
    }

    public static NameResolver<JVariableSig.FieldSig> getMemberFieldResolver(JTypeMirror c, @NonNull String accessPackageName, @Nullable JClassSymbol access, String name) {
        if (c instanceof JClassType) {
            return JavaResolvers.getMemberFieldResolver((JClassType)c, accessPackageName, access, name);
        }
        return c.acceptVisitor(GetFieldVisitor.INSTANCE, new FieldSearchParams(accessPackageName, access, name));
    }

    public static boolean areRelated(@NonNull JTypeMirror t, JTypeMirror s) {
        if (t.isPrimitive() || s.isPrimitive()) {
            return s.equals(t);
        }
        if (t.equals(s)) {
            return true;
        }
        HashSet<JTypeMirror> tSupertypes = new HashSet<JTypeMirror>(t.getSuperTypeSet());
        tSupertypes.retainAll(s.getSuperTypeSet());
        return !tSupertypes.equals(Collections.singleton(t.getTypeSystem().OBJECT));
    }

    public static boolean isUnresolved(@NonNull JTypeMirror t) {
        return TypeOps.isSpecialUnresolved(t) || TypeOps.hasUnresolvedSymbol(t);
    }

    public static boolean isSpecialUnresolved(@NonNull JTypeMirror t) {
        TypeSystem ts = t.getTypeSystem();
        return t == ts.UNKNOWN || t == ts.ERROR;
    }

    public static boolean hasUnresolvedSymbol(@Nullable JTypeMirror t) {
        if (!(t instanceof JClassType)) {
            return t instanceof JArrayType && TypeOps.hasUnresolvedSymbol(((JArrayType)t).getElementType());
        }
        return t.getSymbol() != null && t.getSymbol().isUnresolved();
    }

    public static boolean isUnresolvedOrNull(@Nullable JTypeMirror t) {
        return t == null || TypeOps.isUnresolved(t);
    }

    public static @Nullable JTypeMirror getArrayComponent(@Nullable JTypeMirror t) {
        return t instanceof JArrayType ? ((JArrayType)t).getComponentType() : null;
    }

    private static final class GetFieldVisitor
    implements JTypeVisitor<NameResolver<JVariableSig.FieldSig>, FieldSearchParams> {
        static final GetFieldVisitor INSTANCE = new GetFieldVisitor();

        private GetFieldVisitor() {
        }

        @Override
        public NameResolver<JVariableSig.FieldSig> visit(JTypeMirror t, FieldSearchParams fieldSearchParams) {
            return CoreResolvers.emptyResolver();
        }

        @Override
        public NameResolver<JVariableSig.FieldSig> visitClass(JClassType t, FieldSearchParams fieldSearchParams) {
            return JavaResolvers.getMemberFieldResolver(t, fieldSearchParams.accessPackageName, fieldSearchParams.access, fieldSearchParams.name);
        }

        @Override
        public NameResolver<JVariableSig.FieldSig> visitTypeVar(JTypeVar t, FieldSearchParams fieldSearchParams) {
            return t.getUpperBound().acceptVisitor(this, fieldSearchParams);
        }

        @Override
        public NameResolver<JVariableSig.FieldSig> visitIntersection(JIntersectionType t, FieldSearchParams fieldSearchParams) {
            return NameResolver.composite(CollectionUtil.map(t.getComponents(), c -> c.acceptVisitor(this, fieldSearchParams)));
        }

        @Override
        public NameResolver<JVariableSig.FieldSig> visitArray(JArrayType t, FieldSearchParams fieldSearchParams) {
            if ("length".equals(fieldSearchParams.name)) {
                return CoreResolvers.singleton("length", t.getTypeSystem().sigOf(t, t.getSymbol().getDeclaredField("length")));
            }
            return CoreResolvers.emptyResolver();
        }
    }

    private static final class FieldSearchParams {
        private final @NonNull String accessPackageName;
        private final @Nullable JClassSymbol access;
        private final String name;

        FieldSearchParams(@NonNull String accessPackageName, @Nullable JClassSymbol access, String name) {
            this.accessPackageName = accessPackageName;
            this.access = access;
            this.name = name;
        }
    }

    private static final class MentionsVisitor
    implements JTypeVisitor<Boolean, Collection<? extends JTypeMirror>> {
        static final MentionsVisitor INSTANCE = new MentionsVisitor();

        private MentionsVisitor() {
        }

        @Override
        public Boolean visit(JTypeMirror t, Collection<? extends JTypeMirror> targets) {
            return false;
        }

        @Override
        public Boolean visitTypeVar(JTypeVar t, Collection<? extends JTypeMirror> targets) {
            return targets.contains(t);
        }

        @Override
        public Boolean visitInferenceVar(InferenceVar t, Collection<? extends JTypeMirror> targets) {
            return targets.contains(t);
        }

        @Override
        public Boolean visitWildcard(JWildcardType t, Collection<? extends JTypeMirror> targets) {
            return t.getBound().acceptVisitor(this, targets);
        }

        @Override
        public Boolean visitMethodType(JMethodSig t, Collection<? extends JTypeMirror> targets) {
            if (t.getReturnType().acceptVisitor(this, targets).booleanValue()) {
                return true;
            }
            for (JTypeMirror fi : t.getFormalParameters()) {
                if (!fi.acceptVisitor(this, targets).booleanValue()) continue;
                return true;
            }
            for (JTypeMirror ti : t.getThrownExceptions()) {
                if (!ti.acceptVisitor(this, targets).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitClass(JClassType t, Collection<? extends JTypeMirror> targets) {
            JClassType encl = t.getEnclosingType();
            if (encl != null && encl.acceptVisitor(this, targets).booleanValue()) {
                return true;
            }
            for (JTypeMirror typeArg : t.getTypeArgs()) {
                if (!typeArg.acceptVisitor(this, targets).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitIntersection(JIntersectionType t, Collection<? extends JTypeMirror> targets) {
            for (JTypeMirror comp : t.getComponents()) {
                if (!comp.acceptVisitor(this, targets).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitArray(JArrayType t, Collection<? extends JTypeMirror> targets) {
            return t.getComponentType().acceptVisitor(this, targets);
        }
    }

    private static final class AsSuperVisitor
    implements JTypeVisitor<JTypeMirror, JClassSymbol> {
        static final AsSuperVisitor INSTANCE = new AsSuperVisitor();

        private AsSuperVisitor() {
        }

        @Override
        public JTypeMirror visit(JTypeMirror t, JClassSymbol target) {
            return null;
        }

        @Override
        public JTypeMirror visitClass(JClassType t, JClassSymbol target) {
            JClassType res;
            if (target.equals(t.getSymbol())) {
                return t;
            }
            JClassType sup = t.getSuperClass();
            JClassType jClassType = res = sup == null ? null : (JClassType)sup.acceptVisitor(this, target);
            if (res != null) {
                return res;
            }
            if (target.isInterface() || target.isUnresolved()) {
                return this.firstResult(target, t.getSuperInterfaces());
            }
            return null;
        }

        @Override
        public JTypeMirror visitIntersection(JIntersectionType t, JClassSymbol target) {
            return this.firstResult(target, t.getComponents());
        }

        public @Nullable JTypeMirror firstResult(JClassSymbol target, Iterable<? extends JTypeMirror> components) {
            for (JTypeMirror jTypeMirror : components) {
                @Nullable JTypeMirror sup = jTypeMirror.acceptVisitor(this, target);
                if (sup == null) continue;
                return sup;
            }
            return null;
        }

        @Override
        public JTypeMirror visitTypeVar(JTypeVar t, JClassSymbol target) {
            return t.getUpperBound().acceptVisitor(this, target);
        }

        @Override
        public JTypeMirror visitArray(JArrayType t, JClassSymbol target) {
            JTypeMirror decl = t.getTypeSystem().declaration(target);
            return t.isSubtypeOf(decl) ? decl : null;
        }
    }

    private static abstract class ProjectionVisitor
    implements JTypeVisitor<JTypeMirror, RecursionStop> {
        private final boolean upwards;

        private ProjectionVisitor(boolean upwards) {
            this.upwards = upwards;
        }

        @Override
        public abstract JTypeMirror visitNullType(JTypeMirror var1, RecursionStop var2);

        @Override
        public abstract JTypeMirror visitWildcard(JWildcardType var1, RecursionStop var2);

        @Override
        public abstract JTypeMirror visitTypeVar(JTypeVar var1, RecursionStop var2);

        @Override
        public JTypeMirror visit(JTypeMirror t, RecursionStop recursionStop) {
            return t;
        }

        @Override
        public JTypeMirror visitClass(JClassType t, RecursionStop recursionStop) {
            if (t.isParameterizedType()) {
                TypeSystem ts = t.getTypeSystem();
                List<JTypeMirror> targs = t.getTypeArgs();
                ArrayList<JTypeMirror> newTargs = new ArrayList<JTypeMirror>(targs.size());
                List<JTypeVar> formals = t.getFormalTypeParams();
                boolean change = false;
                for (int i = 0; i < targs.size(); ++i) {
                    JTypeMirror ai = targs.get(i);
                    JTypeMirror u = recursionStop.recurseIfNotDone(ai, (s, stop) -> s.acceptVisitor(this, stop));
                    if (u == ai) {
                        if (TypeOps.isCvar(ai)) {
                            u = ts.UNBOUNDED_WILD;
                            change = true;
                        }
                        newTargs.add(u);
                        continue;
                    }
                    if (!this.upwards) {
                        return NO_DOWN_PROJECTION;
                    }
                    change = true;
                    JTypeMirror bi = formals.get(i).getUpperBound();
                    if (u != ts.OBJECT && (TypeOps.mentionsAny(bi, formals) || !bi.isSubtypeOf(u))) {
                        newTargs.add(ts.wildcard(true, u));
                        continue;
                    }
                    JTypeMirror down = ai.acceptVisitor(DOWNWARDS_PROJECTOR, recursionStop);
                    if (down == NO_DOWN_PROJECTION) {
                        newTargs.add(ts.UNBOUNDED_WILD);
                        continue;
                    }
                    newTargs.add(ts.wildcard(false, down));
                }
                return change ? t.withTypeArguments(newTargs) : t;
            }
            return t;
        }

        @Override
        public JTypeMirror visitIntersection(JIntersectionType t, RecursionStop recursionStop) {
            ArrayList<JTypeMirror> comps = new ArrayList<JTypeMirror>(t.getComponents());
            boolean change = false;
            for (int i = 0; i < comps.size(); ++i) {
                JTypeMirror ci = (JTypeMirror)comps.get(i);
                JTypeMirror proj = ci.acceptVisitor(this, recursionStop);
                if (proj == NO_DOWN_PROJECTION) {
                    return NO_DOWN_PROJECTION;
                }
                comps.set(i, proj);
                if (ci == proj) continue;
                change = true;
            }
            return change ? t.getTypeSystem().glb(comps) : t;
        }

        @Override
        public JTypeMirror visitArray(JArrayType t, RecursionStop recursionStop) {
            JTypeMirror comp2 = t.getComponentType().acceptVisitor(this, recursionStop);
            return comp2 == NO_DOWN_PROJECTION ? NO_DOWN_PROJECTION : (comp2 == t.getComponentType() ? t : t.getTypeSystem().arrayType(comp2));
        }

        @Override
        public JTypeMirror visitSentinel(JTypeMirror t, RecursionStop recursionStop) {
            return t;
        }
    }

    static final class RecursionStop {
        private Set<JTypeVar> set;

        RecursionStop() {
        }

        boolean isAbsent(JTypeVar tvar) {
            if (this.set == null) {
                this.set = new LinkedHashSet<JTypeVar>(1);
            }
            return this.set.add(tvar);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T extends JTypeMirror> JTypeMirror recurseIfNotDone(T t, BiFunction<T, RecursionStop, JTypeMirror> body) {
            if (t instanceof JTypeVar) {
                JTypeVar var = (JTypeVar)t;
                try {
                    if (this.isAbsent(var)) {
                        JTypeMirror jTypeMirror = body.apply(t, this);
                        return jTypeMirror;
                    }
                    T t2 = t;
                    return t2;
                }
                finally {
                    this.set.remove(var);
                }
            }
            return body.apply(t, this);
        }
    }

    private static final class SubtypeVisitor
    implements JTypeVisitor<Convertibility, JTypeMirror> {
        static final SubtypeVisitor INSTANCE = new SubtypeVisitor();

        private SubtypeVisitor() {
        }

        @Override
        public Convertibility visit(JTypeMirror t, JTypeMirror s) {
            throw new IllegalStateException("Should not be called");
        }

        @Override
        public Convertibility visitTypeVar(JTypeVar t, JTypeMirror s) {
            if (s instanceof JTypeVar && t.getSymbol() != null && Objects.equals(t.getSymbol(), s.getSymbol())) {
                return Convertibility.SUBTYPING;
            }
            if (TypeOps.isTypeRange(s)) {
                return TypeOps.isConvertible(t, TypeOps.lowerBoundRec(s));
            }
            return TypeOps.isConvertible(t.getUpperBound(), s);
        }

        @Override
        public Convertibility visitNullType(JTypeMirror t, JTypeMirror s) {
            return Convertibility.subtypeIf(!s.isPrimitive());
        }

        @Override
        public Convertibility visitSentinel(JTypeMirror t, JTypeMirror s) {
            return t.isVoid() ? Convertibility.NEVER : Convertibility.SUBTYPING;
        }

        @Override
        public Convertibility visitInferenceVar(InferenceVar t, JTypeMirror s) {
            if (s == t.getTypeSystem().NULL_TYPE || s instanceof JPrimitiveType) {
                return Convertibility.NEVER;
            }
            t.addBound(InferenceVar.BoundKind.UPPER, s);
            return Convertibility.SUBTYPING;
        }

        @Override
        public Convertibility visitWildcard(JWildcardType t, JTypeMirror s) {
            return Convertibility.NEVER;
        }

        @Override
        public Convertibility visitClass(JClassType t, JTypeMirror s) {
            if (!(s instanceof JClassType)) {
                return Convertibility.NEVER;
            }
            JClassType cs = (JClassType)s;
            JClassType superDecl = t.getAsSuper(cs.getSymbol());
            if (superDecl == null) {
                return Convertibility.NEVER;
            }
            if (cs.isRaw()) {
                return Convertibility.SUBTYPING;
            }
            return TypeOps.typeArgsAreContained(superDecl, cs);
        }

        @Override
        public Convertibility visitIntersection(JIntersectionType t, JTypeMirror s) {
            return Convertibility.anySubTypesAny(t.getComponents(), TypeOps.asList(s));
        }

        @Override
        public Convertibility visitArray(JArrayType t, JTypeMirror s) {
            TypeSystem ts = t.getTypeSystem();
            if (s == ts.OBJECT || s.equals(ts.CLONEABLE) || s.equals(ts.SERIALIZABLE)) {
                return Convertibility.SUBTYPING;
            }
            if (!(s instanceof JArrayType)) {
                return Convertibility.NEVER;
            }
            JArrayType cs = (JArrayType)s;
            if (t.getComponentType().isPrimitive() || cs.getComponentType().isPrimitive()) {
                return Convertibility.subtypeIf(cs.getComponentType() == t.getComponentType());
            }
            return TypeOps.isConvertible(t.getComponentType(), cs.getComponentType());
        }

        @Override
        public Convertibility visitPrimitive(JPrimitiveType t, JTypeMirror s) {
            if (s instanceof JPrimitiveType) {
                return t.superTypes.contains(s) ? Convertibility.SUBTYPING : Convertibility.NEVER;
            }
            return Convertibility.NEVER;
        }
    }

    public static enum Convertibility {
        NEVER,
        UNCHECKED_WARNING,
        UNCHECKED_NO_WARNING,
        SUBTYPING;


        public boolean never() {
            return this == NEVER;
        }

        public boolean somehow() {
            return this != NEVER;
        }

        public boolean bySubtyping() {
            return this == SUBTYPING;
        }

        public boolean withUncheckedWarning() {
            return this == UNCHECKED_WARNING;
        }

        Convertibility and(Convertibility b) {
            return Convertibility.min(this, b);
        }

        static Convertibility min(Convertibility c1, Convertibility c2) {
            return c1.ordinal() < c2.ordinal() ? c1 : c2;
        }

        static Convertibility subtypeIf(boolean b) {
            return b ? SUBTYPING : NEVER;
        }

        static Convertibility subtypesAll(JTypeMirror t, Iterable<? extends JTypeMirror> supers) {
            Convertibility result = SUBTYPING;
            for (JTypeMirror jTypeMirror : supers) {
                Convertibility sub = TypeOps.isConvertible(t, jTypeMirror);
                if (sub == NEVER) {
                    return NEVER;
                }
                result = result.and(sub);
            }
            return result;
        }

        static Convertibility anySubTypesAny(Iterable<? extends JTypeMirror> us, Iterable<? extends JTypeMirror> vs) {
            for (JTypeMirror jTypeMirror : us) {
                for (JTypeMirror jTypeMirror2 : vs) {
                    Convertibility sub = TypeOps.isConvertible(jTypeMirror, jTypeMirror2);
                    if (sub == NEVER) continue;
                    return sub.and(SUBTYPING);
                }
            }
            return NEVER;
        }
    }

    private static final class SuperTypesVisitor
    implements JTypeVisitor<Void, Set<JTypeMirror>> {
        static final SuperTypesVisitor INSTANCE = new SuperTypesVisitor();

        private SuperTypesVisitor() {
        }

        @Override
        public Void visit(JTypeMirror t, Set<JTypeMirror> result) {
            throw new IllegalStateException("Should not be called");
        }

        @Override
        public Void visitTypeVar(JTypeVar t, Set<JTypeMirror> result) {
            if (result.add(t)) {
                t.getUpperBound().acceptVisitor(this, result);
            }
            return null;
        }

        @Override
        public Void visitNullType(JTypeMirror t, Set<JTypeMirror> result) {
            throw new UnsupportedOperationException("The null type has all reference types as supertype");
        }

        @Override
        public Void visitSentinel(JTypeMirror t, Set<JTypeMirror> result) {
            result.add(t);
            return null;
        }

        @Override
        public Void visitInferenceVar(InferenceVar t, Set<JTypeMirror> result) {
            result.add(t);
            return null;
        }

        @Override
        public Void visitWildcard(JWildcardType t, Set<JTypeMirror> result) {
            t.asUpperBound().acceptVisitor(this, result);
            return null;
        }

        @Override
        public Void visitClass(JClassType t, Set<JTypeMirror> result) {
            result.add(t);
            JClassType sup = t.getSuperClass();
            if (sup != null) {
                sup.acceptVisitor(this, result);
            }
            for (JClassType i : t.getSuperInterfaces()) {
                this.visitClass(i, result);
            }
            if (t.isInterface() && t.getSuperInterfaces().isEmpty()) {
                result.add(t.getTypeSystem().OBJECT);
            }
            return null;
        }

        @Override
        public Void visitIntersection(JIntersectionType t, Set<JTypeMirror> result) {
            for (JTypeMirror it : t.getComponents()) {
                it.acceptVisitor(this, result);
            }
            return null;
        }

        @Override
        public Void visitArray(JArrayType t, Set<JTypeMirror> result) {
            result.add(t);
            TypeSystem ts = t.getTypeSystem();
            for (JTypeMirror componentSuper : t.getComponentType().getSuperTypeSet()) {
                result.add(ts.arrayType(componentSuper));
            }
            result.add(ts.CLONEABLE);
            result.add(ts.SERIALIZABLE);
            result.add(ts.OBJECT);
            return null;
        }

        @Override
        public Void visitPrimitive(JPrimitiveType t, Set<JTypeMirror> result) {
            result.addAll(t.getSuperTypeSet());
            return null;
        }
    }

    private static final class SameTypeVisitor
    implements JTypeVisitor<Boolean, JTypeMirror> {
        static final SameTypeVisitor INFERENCE = new SameTypeVisitor(true, false);
        static final SameTypeVisitor PURE = new SameTypeVisitor(false, false);
        static final SameTypeVisitor PURE_WITH_ANNOTATIONS = new SameTypeVisitor(false, true);
        private final boolean inInference;
        private final boolean considerAnnotations;

        private SameTypeVisitor(boolean inInference, boolean considerAnnotations) {
            this.inInference = inInference;
            this.considerAnnotations = considerAnnotations;
        }

        @Override
        public Boolean visit(JTypeMirror t, JTypeMirror s) {
            return t == s;
        }

        @Override
        public Boolean visitPrimitive(JPrimitiveType t, JTypeMirror s) {
            return s.isPrimitive(t.getKind());
        }

        @Override
        public Boolean visitClass(JClassType t, JTypeMirror s) {
            if (s instanceof JClassType) {
                JClassType s2 = (JClassType)s;
                return t.getSymbol().equals(s2.getSymbol()) && t.hasErasedSuperTypes() == s2.hasErasedSuperTypes() && TypeOps.isSameType(t.getEnclosingType(), s2.getEnclosingType(), this.inInference, this.considerAnnotations) && TypeOps.areSameTypes(t.getTypeArgs(), s2.getTypeArgs(), this.inInference, this.considerAnnotations);
            }
            return false;
        }

        @Override
        public Boolean visitTypeVar(JTypeVar t, JTypeMirror s) {
            return t.equals(s);
        }

        @Override
        public Boolean visitWildcard(JWildcardType t, JTypeMirror s) {
            if (!(s instanceof JWildcardType)) {
                return false;
            }
            JWildcardType s2 = (JWildcardType)s;
            return s2.isUpperBound() == t.isUpperBound() && TypeOps.isSameType(t.getBound(), s2.getBound(), this.inInference, this.considerAnnotations);
        }

        @Override
        public Boolean visitInferenceVar(InferenceVar t, JTypeMirror s) {
            if (!this.inInference) {
                return t == s;
            }
            if (s instanceof JPrimitiveType) {
                return false;
            }
            if (s instanceof JWildcardType) {
                JWildcardType s2 = (JWildcardType)s;
                if (s2.isUpperBound()) {
                    t.addBound(InferenceVar.BoundKind.UPPER, s2.asUpperBound());
                } else {
                    t.addBound(InferenceVar.BoundKind.LOWER, s2.asLowerBound());
                }
                return true;
            }
            t.addBound(InferenceVar.BoundKind.EQ, s);
            return true;
        }

        @Override
        public Boolean visitIntersection(JIntersectionType t, JTypeMirror s) {
            if (!(s instanceof JIntersectionType)) {
                return false;
            }
            JIntersectionType s2 = (JIntersectionType)s;
            if (s2.getComponents().size() != t.getComponents().size()) {
                return false;
            }
            if (!TypeOps.isSameType(t.getPrimaryBound(), s2.getPrimaryBound(), this.inInference, this.considerAnnotations)) {
                return false;
            }
            List<JTypeMirror> sComps = ((JIntersectionType)s).getComponents();
            for (JTypeMirror ti : t.getComponents()) {
                boolean found = false;
                for (JTypeMirror si : sComps) {
                    if (!TypeOps.isSameType(ti, si, this.inInference, this.considerAnnotations)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitArray(JArrayType t, JTypeMirror s) {
            return s instanceof JArrayType && TypeOps.isSameType(t.getComponentType(), ((JArrayType)s).getComponentType(), this.inInference, this.considerAnnotations);
        }
    }
}

