/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.internal;

import java.util.HashSet;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.internal.JavaAstProcessor;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.JSymbolTable;
import net.sourceforge.pmd.lang.java.symbols.table.internal.JavaResolvers;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ReferenceCtx {
    final JavaAstProcessor processor;
    final String packageName;
    final @Nullable JClassSymbol enclosingClass;

    private ReferenceCtx(JavaAstProcessor processor, String packageName, @Nullable JClassSymbol enclosingClass) {
        this.processor = processor;
        this.packageName = packageName;
        this.enclosingClass = enclosingClass;
    }

    public void reportCannotResolveSymbol(JavaNode location, String simpleName) {
        this.processor.reportCannotResolveSymbol(location, simpleName);
    }

    public static ReferenceCtx root(JavaAstProcessor processor, ASTCompilationUnit root) {
        return new ReferenceCtx(processor, root.getPackageName(), null);
    }

    public ReferenceCtx scopeDownToNested(JClassSymbol newEnclosing) {
        assert (this.enclosingClass == null || this.enclosingClass.equals(newEnclosing.getEnclosingClass())) : "Not a child class of the current context (" + this + "): " + newEnclosing;
        assert (newEnclosing.getPackageName().equals(this.packageName)) : "Mismatched package name";
        return new ReferenceCtx(this.processor, this.packageName, newEnclosing);
    }

    public  @Nullable JVariableSig.FieldSig findStaticField(JTypeDeclSymbol classSym, String name) {
        if (classSym instanceof JClassSymbol) {
            JClassType t = (JClassType)classSym.getTypeSystem().typeOf(classSym, false);
            return JavaResolvers.getMemberFieldResolver(t, this.packageName, this.enclosingClass, name).resolveFirst(name);
        }
        return null;
    }

    public @Nullable JClassSymbol findTypeMember(JTypeDeclSymbol classSym, String name, JavaNode errorLocation) {
        if (classSym instanceof JClassSymbol) {
            JClassType c = (JClassType)classSym.getTypeSystem().typeOf(classSym, false);
            @NonNull List<JClassType> found = JavaResolvers.getMemberClassResolver(c, this.packageName, this.enclosingClass, name).resolveHere(name);
            JClassType result = this.maybeAmbiguityError(name, errorLocation, found);
            return result == null ? null : result.getSymbol();
        }
        return null;
    }

    <T extends JTypeMirror> T maybeAmbiguityError(String name, JavaNode errorLocation, @NonNull List<? extends T> found) {
        if (found.isEmpty()) {
            return null;
        }
        if (found.size() > 1) {
            HashSet<T> distinct = new HashSet<T>(found);
            if (distinct.size() == 1) {
                return (T)((JTypeMirror)distinct.iterator().next());
            }
            this.processor.getLogger().warning((Node)errorLocation, "Reference ''{0}'' is ambiguous, both {1} and {2} match", new Object[]{name, this.canonicalNameOf(((JTypeMirror)found.get(0)).getSymbol()), this.canonicalNameOf(((JTypeMirror)found.get(1)).getSymbol())});
        }
        return (T)((JTypeMirror)found.get(0));
    }

    private String canonicalNameOf(JTypeDeclSymbol sym) {
        if (sym instanceof JClassSymbol) {
            return ((JClassSymbol)sym).getCanonicalName();
        }
        assert (sym instanceof JTypeParameterSymbol);
        return sym.getEnclosingClass().getCanonicalName() + "#" + sym.getSimpleName();
    }

    public JClassSymbol resolveClassFromBinaryName(String binary) {
        return this.processor.getSymResolver().resolveClassFromBinaryName(binary);
    }

    public static ReferenceCtx ctxOf(ASTAnyTypeDeclaration node, JavaAstProcessor processor, boolean outsideContext) {
        assert (node != null);
        if (outsideContext) {
            JClassSymbol enclosing = node.isTopLevel() ? null : node.getEnclosingType().getSymbol();
            return new ReferenceCtx(processor, node.getPackageName(), enclosing);
        }
        return new ReferenceCtx(processor, node.getPackageName(), node.getSymbol());
    }

    public void reportUnresolvedMember(JavaNode location, Fallback fallbackStrategy, String memberName, JTypeDeclSymbol owner) {
        if (owner.isUnresolved()) {
            return;
        }
        String ownerName = owner instanceof JClassSymbol ? ((JClassSymbol)owner).getCanonicalName() : "type variable " + owner.getSimpleName();
        this.processor.getLogger().warning((Node)location, "Cannot resolve ''{0}'' in {1}, treating it as {2}", new Object[]{memberName, ownerName, fallbackStrategy});
    }

    public SemanticErrorReporter getLogger() {
        return this.processor.getLogger();
    }

    public String toString() {
        return "ReferenceCtx{packageName='" + this.packageName + '\'' + ", enclosingClass=" + this.enclosingClass + '}';
    }

    public JTypeMirror resolveSingleTypeName(JSymbolTable symTable, String image, JavaNode errorLoc) {
        return this.maybeAmbiguityError(image, errorLoc, symTable.types().resolve(image));
    }

    public JClassSymbol makeUnresolvedReference(String canonicalName, int typeArity) {
        return this.processor.makeUnresolvedReference(canonicalName, typeArity);
    }

    public JClassSymbol makeUnresolvedReference(JTypeDeclSymbol outer, String simpleName, int typeArity) {
        return this.processor.makeUnresolvedReference(outer, simpleName, typeArity);
    }

    public static enum Fallback {
        AMBIGUOUS("ambiguous"),
        FIELD_ACCESS("a field access"),
        PACKAGE_NAME("a package name"),
        TYPE("an unresolved type");

        private final String displayName;

        private Fallback(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

