/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ParseLock {
    private static final Logger LOG = LoggerFactory.getLogger(ParseLock.class);
    private volatile ParseStatus status = ParseStatus.NOT_PARSED;

    ParseLock() {
    }

    public void ensureParsed() {
        this.getFinalStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseStatus getFinalStatus() {
        ParseStatus status = this.status;
        if (!status.isFinished) {
            ParseLock parseLock = this;
            synchronized (parseLock) {
                status = this.status;
                if (status == ParseStatus.NOT_PARSED) {
                    this.status = ParseStatus.BEING_PARSED;
                    try {
                        boolean success = this.doParse();
                        this.status = status = success ? ParseStatus.FULL : ParseStatus.FAILED;
                        this.finishParse(!success);
                    }
                    catch (Throwable t) {
                        this.status = status = ParseStatus.FAILED;
                        LOG.error(t.toString(), t);
                        this.finishParse(true);
                    }
                    assert (status.isFinished) : "Inconsistent status " + (Object)((Object)status);
                    assert (this.postCondition()) : "Post condition not satisfied after parsing sig " + this;
                } else if (status == ParseStatus.BEING_PARSED && !this.canReenter()) {
                    throw new IllegalStateException("Thread is reentering the parse lock");
                }
            }
        }
        return status;
    }

    protected boolean canReenter() {
        return false;
    }

    public boolean isFailed() {
        return this.getFinalStatus() == ParseStatus.FAILED;
    }

    protected void finishParse(boolean failed) {
    }

    protected abstract boolean doParse() throws Throwable;

    protected boolean postCondition() {
        return true;
    }

    public String toString() {
        return "ParseLock{status=" + (Object)((Object)this.status) + '}';
    }

    private static enum ParseStatus {
        NOT_PARSED(false),
        BEING_PARSED(false),
        FULL(true),
        FAILED(true);

        final boolean isFinished;

        private ParseStatus(boolean finished) {
            this.isFinished = finished;
        }
    }
}

