/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolToStrings;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.LazyTypeSig;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.MemberStubBase;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TypeAnnotationReceiver;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.Substitution;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;

class FieldStub
extends MemberStubBase
implements JFieldSymbol,
TypeAnnotationReceiver {
    private final LazyTypeSig type;
    private final @Nullable Object constValue;

    FieldStub(ClassStub classStub, String name, int accessFlags, String descriptor, String signature, @Nullable Object constValue) {
        super(classStub, name, accessFlags);
        this.type = new LazyTypeSig(classStub, descriptor, signature);
        this.constValue = constValue;
    }

    @Override
    public void acceptTypeAnnotation(int typeRef, @Nullable TypePath path, SymbolicValue.SymAnnot annot) {
        assert (new TypeReference(typeRef).getSort() == 19) : typeRef;
        this.type.addTypeAnnotation(path, annot);
    }

    @Override
    public @Nullable Object getConstValue() {
        return this.constValue;
    }

    @Override
    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public JTypeMirror getTypeMirror(Substitution subst) {
        return this.type.get(subst);
    }

    public String toString() {
        return SymbolToStrings.ASM.toString(this);
    }

    public int hashCode() {
        return SymbolEquality.FIELD.hash(this);
    }

    @Override
    public boolean equals(Object obj) {
        return SymbolEquality.FIELD.equals(this, obj);
    }
}

