/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.xpath.internal;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseJavaXPathFunction;
import net.sourceforge.pmd.lang.metrics.LanguageMetricsProvider;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstElementNode;

public final class MetricFunction
extends BaseJavaXPathFunction {
    public static final MetricFunction INSTANCE = new MetricFunction();

    private MetricFunction() {
        super("metric");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.OPTIONAL_DECIMAL;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                String metricKey;
                Node contextNode = ((AstElementNode)context.getContextItem()).getUnderlyingNode();
                double metric = MetricFunction.getMetric(contextNode, metricKey = arguments[0].head().getStringValue());
                return Double.isFinite(metric) ? new BigDecimalValue(metric) : EmptySequence.getInstance();
            }
        };
    }

    static String badMetricKeyMessage(String constantName) {
        return String.format("'%s' is not the name of a metric", constantName);
    }

    private static double getMetric(Node n, String metricKeyName) throws XPathException {
        LanguageMetricsProvider provider = n.getAstInfo().getLanguageProcessor().services().getLanguageMetricsProvider();
        Metric metric = provider.getMetricWithName(metricKeyName);
        if (metric == null) {
            throw new XPathException(MetricFunction.badMetricKeyMessage(metricKeyName));
        }
        Number computed = Metric.compute((Metric)metric, (Node)n, (MetricOptions)MetricOptions.emptyOptions());
        return computed == null ? Double.NaN : computed.doubleValue();
    }
}

