/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class CloneMethodMustImplementCloneableRule
extends AbstractJavaRulechainRule {
    public CloneMethodMustImplementCloneableRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (!JavaAstUtils.isCloneMethod(node)) {
            return data;
        }
        ASTBlock body = node.getBody();
        if (body != null && CloneMethodMustImplementCloneableRule.justThrowsCloneNotSupported(body)) {
            return data;
        }
        ASTAnyTypeDeclaration type = node.getEnclosingType();
        if (type instanceof ASTClassOrInterfaceDeclaration && !TypeTestUtil.isA(Cloneable.class, (TypeNode)type)) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private static boolean justThrowsCloneNotSupported(ASTBlock body) {
        return body.size() == 1 && ((JavaNode)body.getChild(0)).asStream().filterIs(ASTThrowStatement.class).map(ASTThrowStatement::getExpr).filter(it -> TypeTestUtil.isA(CloneNotSupportedException.class, (TypeNode)it)).nonEmpty();
    }
}

