/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;

public class AssignmentToNonFinalStaticRule
extends AbstractJavaRulechainRule {
    public AssignmentToNonFinalStaticRule() {
        super(ASTFieldAccess.class, ASTVariableAccess.class);
    }

    @Override
    public Object visit(ASTVariableAccess node, Object data) {
        this.checkAccess(node, data);
        return null;
    }

    @Override
    public Object visit(ASTFieldAccess node, Object data) {
        this.checkAccess(node, data);
        return null;
    }

    private void checkAccess(ASTAssignableExpr.ASTNamedReferenceExpr node, Object data) {
        JFieldSymbol field;
        JVariableSymbol symbol;
        if (this.isInsideConstructor(node) && node.getAccessType() == ASTAssignableExpr.AccessType.WRITE && (symbol = node.getReferencedSym()) != null && symbol.isField() && (field = (JFieldSymbol)symbol).isStatic() && !field.isFinal()) {
            this.addViolation(data, (Node)node, field.getSimpleName());
        }
    }

    private boolean isInsideConstructor(ASTAssignableExpr.ASTNamedReferenceExpr node) {
        return node.ancestors(ASTConstructorDeclaration.class).nonEmpty();
    }
}

