/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.rule.internal.StablePathMatcher;

public class SimplifyConditionalRule
extends AbstractJavaRulechainRule {
    public SimplifyConditionalRule() {
        super(ASTInfixExpression.class, new Class[0]);
    }

    @Override
    public Object visit(ASTInfixExpression node, Object data) {
        if (node.getOperator() == BinaryOp.INSTANCEOF) {
            ASTExpression nullCheckExpr;
            boolean negated;
            StablePathMatcher instanceOfSubject = StablePathMatcher.matching(node.getLeftOperand());
            if (instanceOfSubject == null) {
                return null;
            }
            if (JavaAstUtils.isInfixExprWithOperator((JavaNode)node.getParent(), BinaryOp.CONDITIONAL_AND)) {
                negated = false;
                nullCheckExpr = JavaAstUtils.getOtherOperandIfInInfixExpr(node);
            } else if (JavaAstUtils.isBooleanNegation((JavaNode)node.getParent()) && JavaAstUtils.isInfixExprWithOperator((JavaNode)((JavaNode)node.getParent()).getParent(), BinaryOp.CONDITIONAL_OR)) {
                negated = true;
                nullCheckExpr = JavaAstUtils.getOtherOperandIfInInfixExpr((JavaNode)node.getParent());
            } else {
                return null;
            }
            if (!JavaRuleUtil.isNullCheck(nullCheckExpr, instanceOfSubject)) {
                return null;
            }
            if (negated != JavaAstUtils.isInfixExprWithOperator((JavaNode)nullCheckExpr, BinaryOp.NE)) {
                this.addViolation(data, (Node)nullCheckExpr);
            }
        }
        return null;
    }
}

