/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaPropertyUtil;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.apache.commons.lang3.StringUtils;

public class LinguisticNamingRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<List<String>> IGNORED_ANNOTS = JavaPropertyUtil.ignoredAnnotationsDescriptor("java.lang.Override");
    private static final PropertyDescriptor<Boolean> CHECK_BOOLEAN_METHODS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkBooleanMethod").defaultValue((Object)true)).desc("Check method names and types for inconsistent naming.")).build();
    private static final PropertyDescriptor<Boolean> CHECK_GETTERS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkGetters").defaultValue((Object)true)).desc("Check return type of getters.")).build();
    private static final PropertyDescriptor<Boolean> CHECK_SETTERS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkSetters").defaultValue((Object)true)).desc("Check return type of setters.")).build();
    private static final PropertyDescriptor<Boolean> CHECK_PREFIXED_TRANSFORM_METHODS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkPrefixedTransformMethods").desc("Check return type of methods whose names start with the configured prefix (see transformMethodNames property).")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<Boolean> CHECK_TRANSFORM_METHODS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkTransformMethods").desc("Check return type of methods which contain the configured infix in their name (see transformMethodNames property).")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> CHECK_FIELDS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkFields").defaultValue((Object)true)).desc("Check field names and types for inconsistent naming.")).build();
    private static final PropertyDescriptor<Boolean> CHECK_VARIABLES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkVariables").defaultValue((Object)true)).desc("Check local variable names and types for inconsistent naming.")).build();
    private static final PropertyDescriptor<List<String>> BOOLEAN_METHOD_PREFIXES_PROPERTY = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"booleanMethodPrefixes").desc("The prefixes of methods that return boolean.")).defaultValues((Object)"is", (Object[])new String[]{"has", "can", "have", "will", "should"}).build();
    private static final PropertyDescriptor<List<String>> TRANSFORM_METHOD_NAMES_PROPERTY = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"transformMethodNames").desc("The prefixes and infixes that indicate a transform method.")).defaultValues((Object)"to", (Object[])new String[]{"as"}).build();
    private static final PropertyDescriptor<List<String>> BOOLEAN_FIELD_PREFIXES_PROPERTY = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"booleanFieldPrefixes").desc("The prefixes of fields and variables that indicate boolean.")).defaultValues((Object)"is", (Object[])new String[]{"has", "can", "have", "will", "should"}).build();

    public LinguisticNamingRule() {
        super(ASTMethodDeclaration.class, ASTFieldDeclaration.class, ASTLocalVariableDeclaration.class);
        this.definePropertyDescriptor(IGNORED_ANNOTS);
        this.definePropertyDescriptor(CHECK_BOOLEAN_METHODS);
        this.definePropertyDescriptor(CHECK_GETTERS);
        this.definePropertyDescriptor(CHECK_SETTERS);
        this.definePropertyDescriptor(CHECK_PREFIXED_TRANSFORM_METHODS);
        this.definePropertyDescriptor(CHECK_TRANSFORM_METHODS);
        this.definePropertyDescriptor(BOOLEAN_METHOD_PREFIXES_PROPERTY);
        this.definePropertyDescriptor(TRANSFORM_METHOD_NAMES_PROPERTY);
        this.definePropertyDescriptor(CHECK_FIELDS);
        this.definePropertyDescriptor(CHECK_VARIABLES);
        this.definePropertyDescriptor(BOOLEAN_FIELD_PREFIXES_PROPERTY);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (!this.hasIgnoredAnnotation(node)) {
            String nameOfMethod = node.getName();
            if (((Boolean)this.getProperty(CHECK_BOOLEAN_METHODS)).booleanValue()) {
                this.checkBooleanMethods(node, data, nameOfMethod);
            }
            if (((Boolean)this.getProperty(CHECK_SETTERS)).booleanValue()) {
                this.checkSetters(node, data, nameOfMethod);
            }
            if (((Boolean)this.getProperty(CHECK_GETTERS)).booleanValue()) {
                this.checkGetters(node, data, nameOfMethod);
            }
            if (((Boolean)this.getProperty(CHECK_PREFIXED_TRANSFORM_METHODS)).booleanValue()) {
                this.checkPrefixedTransformMethods(node, data, nameOfMethod);
            }
            if (((Boolean)this.getProperty(CHECK_TRANSFORM_METHODS)).booleanValue()) {
                this.checkTransformMethods(node, data, nameOfMethod);
            }
        }
        return data;
    }

    private boolean hasIgnoredAnnotation(Annotatable node) {
        return node.isAnyAnnotationPresent((Collection)this.getProperty(IGNORED_ANNOTS));
    }

    private void checkPrefixedTransformMethods(ASTMethodDeclaration node, Object data, String nameOfMethod) {
        List prefixes = (List)this.getProperty(TRANSFORM_METHOD_NAMES_PROPERTY);
        String[] splitMethodName = StringUtils.splitByCharacterTypeCamelCase((String)nameOfMethod);
        if (node.isVoid() && splitMethodName.length > 0 && prefixes.contains(splitMethodName[0].toLowerCase(Locale.ROOT))) {
            this.addViolationWithMessage(data, (Node)node, "Linguistics Antipattern - The transform method ''{0}'' should not return void linguistically", new Object[]{nameOfMethod});
        }
    }

    private void checkTransformMethods(ASTMethodDeclaration node, Object data, String nameOfMethod) {
        for (String infix : (List)this.getProperty(TRANSFORM_METHOD_NAMES_PROPERTY)) {
            if (!node.isVoid() || !JavaRuleUtil.containsCamelCaseWord(nameOfMethod, StringUtils.capitalize((String)infix))) continue;
            this.addViolationWithMessage(data, (Node)node, "Linguistics Antipattern - The transform method ''{0}'' should not return void linguistically", new Object[]{nameOfMethod});
            break;
        }
    }

    private void checkGetters(ASTMethodDeclaration node, Object data, String nameOfMethod) {
        if (JavaRuleUtil.startsWithCamelCaseWord(nameOfMethod, "get") && node.isVoid()) {
            this.addViolationWithMessage(data, (Node)node, "Linguistics Antipattern - The getter ''{0}'' should not return void linguistically", new Object[]{nameOfMethod});
        }
    }

    private void checkSetters(ASTMethodDeclaration node, Object data, String nameOfMethod) {
        if (JavaRuleUtil.startsWithCamelCaseWord(nameOfMethod, "set") && !node.isVoid()) {
            this.addViolationWithMessage(data, (Node)node, "Linguistics Antipattern - The setter ''{0}'' should not return any type except void linguistically", new Object[]{nameOfMethod});
        }
    }

    private boolean isBooleanType(ASTType node) {
        return node.getTypeMirror().unbox().isPrimitive(JPrimitiveType.PrimitiveTypeKind.BOOLEAN) || TypeTestUtil.isA("java.util.concurrent.atomic.AtomicBoolean", (TypeNode)node) || TypeTestUtil.isA("java.util.function.Predicate", (TypeNode)node);
    }

    private void checkBooleanMethods(ASTMethodDeclaration node, Object data, String nameOfMethod) {
        ASTType t = node.getResultTypeNode();
        if (!t.isVoid()) {
            for (String prefix : (List)this.getProperty(BOOLEAN_METHOD_PREFIXES_PROPERTY)) {
                if (!JavaRuleUtil.startsWithCamelCaseWord(nameOfMethod, prefix) || this.isBooleanType(t)) continue;
                this.addViolationWithMessage(data, (Node)node, "Linguistics Antipattern - The method ''{0}'' indicates linguistically it returns a boolean, but it returns ''{1}''", new Object[]{nameOfMethod, PrettyPrintingUtil.prettyPrintType(t)});
            }
        }
    }

    private void checkField(ASTType typeNode, ASTVariableDeclarator node, Object data) {
        for (String prefix : (List)this.getProperty(BOOLEAN_FIELD_PREFIXES_PROPERTY)) {
            if (!JavaRuleUtil.startsWithCamelCaseWord(node.getName(), prefix) || this.isBooleanType(typeNode)) continue;
            this.addViolationWithMessage(data, (Node)node, "Linguistics Antipattern - The field ''{0}'' indicates linguistically it is a boolean, but it is ''{1}''", new Object[]{node.getName(), PrettyPrintingUtil.prettyPrintType(typeNode)});
        }
    }

    private void checkVariable(ASTType typeNode, ASTVariableDeclarator node, Object data) {
        for (String prefix : (List)this.getProperty(BOOLEAN_FIELD_PREFIXES_PROPERTY)) {
            if (!JavaRuleUtil.startsWithCamelCaseWord(node.getName(), prefix) || this.isBooleanType(typeNode)) continue;
            this.addViolationWithMessage(data, (Node)node, "Linguistics Antipattern - The variable ''{0}'' indicates linguistically it is a boolean, but it is ''{1}''", new Object[]{node.getName(), PrettyPrintingUtil.prettyPrintType(typeNode)});
        }
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        ASTType type = node.getTypeNode();
        if (type != null && ((Boolean)this.getProperty(CHECK_FIELDS)).booleanValue()) {
            for (ASTVariableDeclarator field : node.children(ASTVariableDeclarator.class)) {
                this.checkField(type, field, data);
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        ASTType type = node.getTypeNode();
        if (type != null && ((Boolean)this.getProperty(CHECK_VARIABLES)).booleanValue()) {
            for (ASTVariableDeclarator variable : node.children(ASTVariableDeclarator.class)) {
                this.checkVariable(type, variable, data);
            }
        }
        return data;
    }
}

