/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UnusedLocalVariableRule
extends AbstractJavaRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTLocalVariableDeclaration.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration decl, Object data) {
        for (ASTVariableDeclaratorId varId : decl.getVarIds()) {
            if (!JavaAstUtils.isNeverUsed(varId) || JavaRuleUtil.isExplicitUnusedVarName(varId.getName())) continue;
            this.addViolation(data, (Node)varId, varId.getName());
        }
        return data;
    }
}

