/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.ASTArrayType;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTClassLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTModuleProvidesDirective;
import net.sourceforge.pmd.lang.java.ast.ASTSuperExpression;
import net.sourceforge.pmd.lang.java.ast.ASTThisExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class LooseCouplingRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<List<String>> ALLOWED_TYPES = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"allowedTypes").desc("Exceptions to the rule")).defaultValues((Object)"java.util.Properties", (Object[])new String[0]).build();

    public LooseCouplingRule() {
        super(ASTClassOrInterfaceType.class, new Class[0]);
        this.definePropertyDescriptor(ALLOWED_TYPES);
    }

    @Override
    public Object visit(ASTClassOrInterfaceType node, Object data) {
        if (!(!this.isConcreteCollectionType(node) || LooseCouplingRule.isInOverriddenMethodSignature(node) || this.isInAllowedSyntacticCtx(node) || this.isAllowedType(node) || this.isTypeParameter(node))) {
            this.addViolation(data, (Node)node, node.getSimpleName());
        }
        return null;
    }

    private boolean isInAllowedSyntacticCtx(ASTClassOrInterfaceType node) {
        JavaNode parent = (JavaNode)node.getParent();
        return parent instanceof ASTConstructorCall || parent instanceof ASTTypeExpression || parent instanceof ASTCastExpression || parent instanceof ASTClassLiteral || parent instanceof ASTClassOrInterfaceType || parent instanceof ASTExtendsList || parent instanceof ASTThisExpression || parent instanceof ASTSuperExpression || parent instanceof ASTModuleProvidesDirective || parent instanceof ASTArrayType && parent.getParent() instanceof ASTArrayAllocation;
    }

    private boolean isAllowedType(ASTClassOrInterfaceType node) {
        for (String allowed : (List)this.getProperty(ALLOWED_TYPES)) {
            if (!TypeTestUtil.isA(allowed, (TypeNode)node)) continue;
            return true;
        }
        return false;
    }

    private boolean isConcreteCollectionType(ASTClassOrInterfaceType node) {
        return (TypeTestUtil.isA(Collection.class, (TypeNode)node) || TypeTestUtil.isA(Map.class, (TypeNode)node)) && !node.getTypeMirror().isInterface();
    }

    private static boolean isInOverriddenMethodSignature(JavaNode node) {
        JavaNode ancestor = (JavaNode)node.ancestors().map(NodeStream.asInstanceOf(ASTMethodDeclaration.class, (Class[])new Class[]{ASTBlock.class})).first();
        return ancestor instanceof ASTMethodDeclaration && ((ASTMethodDeclaration)ancestor).isOverridden();
    }

    private boolean isTypeParameter(ASTClassOrInterfaceType node) {
        return node.getTypeMirror().isTypeVariable();
    }
}

