/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.TestFrameworksUtil;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class JUnitTestContainsTooManyAssertsRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Integer> MAX_ASSERTS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maximumAsserts").desc("Maximum number of assert calls in a test method")).require(NumericConstraints.positive())).defaultValue((Object)1)).build();

    public JUnitTestContainsTooManyAssertsRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(MAX_ASSERTS);
    }

    @Override
    public Object visit(ASTMethodDeclaration method, Object data) {
        int assertCount;
        ASTBlock body = method.getBody();
        if (body != null && TestFrameworksUtil.isTestMethod(method) && (assertCount = body.descendants(ASTMethodCall.class).filter(TestFrameworksUtil::isProbableAssertCall).count()) > (Integer)this.getProperty(MAX_ASSERTS)) {
            this.addViolation(data, (Node)method);
        }
        return data;
    }
}

