/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.apache.commons.lang3.StringUtils;

public class AvoidUsingHardCodedIPRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<List<AddressKinds>> CHECK_ADDRESS_TYPES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.enumListProperty((String)"checkAddressTypes", AddressKinds.class, k -> AddressKinds.access$000(k)).desc("Check for IP address types.")).defaultValue(Arrays.asList(AddressKinds.values()))).build();
    private static final String IPV4_REGEXP = "([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})";
    private static final String IPV6_REGEXP = "(?:(?:[0-9a-fA-F]{1,4})?\\:)+(?:[0-9a-fA-F]{1,4}|" + "([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})".replace("(", "(?:") + ")?";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})$");
    private static final Pattern IPV6_PATTERN = Pattern.compile("^" + IPV6_REGEXP + "$");
    private final Set<AddressKinds> kindsToCheck = EnumSet.noneOf(AddressKinds.class);

    public AvoidUsingHardCodedIPRule() {
        super(ASTStringLiteral.class, new Class[0]);
        this.definePropertyDescriptor(CHECK_ADDRESS_TYPES_DESCRIPTOR);
    }

    public void start(RuleContext ctx) {
        this.kindsToCheck.clear();
        this.kindsToCheck.addAll((Collection)this.getProperty(CHECK_ADDRESS_TYPES_DESCRIPTOR));
    }

    @Override
    public Object visit(ASTStringLiteral node, Object data) {
        String image = node.getConstValue();
        if (image.length() > 0) {
            char firstChar = Character.toUpperCase(image.charAt(0));
            boolean checkIPv4 = this.kindsToCheck.contains((Object)AddressKinds.IPV4);
            boolean checkIPv6 = this.kindsToCheck.contains((Object)AddressKinds.IPV6);
            boolean checkIPv4MappedIPv6 = this.kindsToCheck.contains((Object)AddressKinds.IPV4_MAPPED_IPV6);
            if (checkIPv4 && this.isIPv4(firstChar, image) || this.isIPv6(firstChar, image, checkIPv6, checkIPv4MappedIPv6)) {
                this.addViolation(data, (Node)node);
            }
        }
        return data;
    }

    private boolean isLatinDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private boolean isHexCharacter(char c) {
        return this.isLatinDigit(c) || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    private boolean isIPv4(char firstChar, String s) {
        if (s.length() < 7 || !this.isLatinDigit(firstChar) || s.indexOf(46) < 0) {
            return false;
        }
        Matcher matcher = IPV4_PATTERN.matcher(s);
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                int octet = Integer.parseInt(matcher.group(i));
                if (octet >= 0 && octet <= 255) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isIPv6(char firstChar, String s, boolean checkIPv6, boolean checkIPv4MappedIPv6) {
        if (s.length() < 3 || !this.isHexCharacter(firstChar) && firstChar != ':' || StringUtils.countMatches((CharSequence)s, (char)':') < 2) {
            return false;
        }
        Matcher matcher = IPV6_PATTERN.matcher(s);
        if (matcher.matches()) {
            boolean zeroSubstitution = false;
            if (s.startsWith("::")) {
                s = s.substring(2);
                zeroSubstitution = true;
            } else if (s.endsWith("::")) {
                s = s.substring(0, s.length() - 2);
                zeroSubstitution = true;
            }
            if (s.endsWith(":")) {
                return false;
            }
            int count = 0;
            boolean ipv4Mapped = false;
            String[] parts = s.split(":");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (part.length() == 0) {
                    if (zeroSubstitution) {
                        return false;
                    }
                    zeroSubstitution = true;
                    continue;
                }
                ++count;
                try {
                    int value = Integer.parseInt(part, 16);
                    if (value >= 0 && value <= 65535) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    if (i != parts.length - 1 || !this.isIPv4(part.charAt(0), part)) {
                        return false;
                    }
                    ipv4Mapped = true;
                }
            }
            if (zeroSubstitution) {
                if (ipv4Mapped) {
                    return checkIPv4MappedIPv6 && 1 <= count && count <= 6;
                }
                return checkIPv6 && 1 <= count && count <= 7;
            }
            if (ipv4Mapped) {
                return checkIPv4MappedIPv6 && count == 7;
            }
            return checkIPv6 && count == 8;
        }
        return false;
    }

    public String dysfunctionReason() {
        return !((List)this.getProperty(CHECK_ADDRESS_TYPES_DESCRIPTOR)).isEmpty() ? null : "No address types specified";
    }

    private static enum AddressKinds {
        IPV4("IPv4"),
        IPV6("IPv6"),
        IPV4_MAPPED_IPV6("IPv4 mapped IPv6");

        private final String label;

        private AddressKinds(String label) {
            this.label = label;
        }
    }
}

