/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.function.Function;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTLabeledStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.AbstractStatement;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTBreakStatement
extends AbstractStatement {
    private static final Function<Object, ASTStatement> BREAK_TARGET_MAPPER = NodeStream.asInstanceOf(ASTLoopStatement.class, (Class[])new Class[]{ASTSwitchStatement.class});

    ASTBreakStatement(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public @Nullable String getLabel() {
        return this.getImage();
    }

    public ASTStatement getTarget() {
        String myLabel = this.getLabel();
        if (myLabel == null) {
            return (ASTStatement)this.ancestors().map(BREAK_TARGET_MAPPER).first();
        }
        return (ASTStatement)this.ancestors(ASTLabeledStatement.class).filter(it -> it.getLabel().equals(myLabel)).first();
    }
}

