/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.renderer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coode.owlapi.rdf.model.RDFGraph;
import org.coode.owlapi.rdf.model.RDFNode;
import org.coode.owlapi.rdf.model.RDFResourceNode;
import org.coode.owlapi.rdf.model.RDFTranslator;
import org.coode.owlapi.rdf.model.RDFTriple;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.AxiomSubjectProvider;
import org.semanticweb.owlapi.util.SWRLVariableExtractor;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public abstract class RDFRendererBase {
    private static final String ANNOTATION_PROPERTIES_BANNER_TEXT = "Annotation properties";
    private static final String DATATYPES_BANNER_TEXT = "Datatypes";
    private static final String OBJECT_PROPERTIES_BANNER_TEXT = "Object Properties";
    private static final String DATA_PROPERTIES_BANNER_TEXT = "Data properties";
    private static final String CLASSES_BANNER_TEXT = "Classes";
    private static final String INDIVIDUALS_BANNER_TEXT = "Individuals";
    private static final String ANNOTATED_IRIS_BANNER_TEXT = "Annotations";
    public static final String GENERAL_AXIOMS_BANNER_TEXT = "General axioms";
    public static final String RULES_BANNER_TEXT = "Rules";
    protected OWLOntology ontology;
    private RDFGraph graph;
    protected Set<IRI> prettyPrintedTypes;
    private OWLOntologyFormat format;
    private static final OWLEntityIRIComparator OWL_ENTITY_IRI_COMPARATOR = new OWLEntityIRIComparator();

    public RDFRendererBase(OWLOntology ontology) {
        this(ontology, ontology.getOWLOntologyManager().getOntologyFormat(ontology));
    }

    @Deprecated
    public RDFRendererBase(OWLOntology ontology, OWLOntologyManager manager) {
        this(ontology, ontology.getOWLOntologyManager().getOntologyFormat(ontology));
    }

    @Deprecated
    protected RDFRendererBase(OWLOntology ontology, OWLOntologyManager manager, OWLOntologyFormat format) {
        this(ontology, format);
    }

    protected RDFRendererBase(OWLOntology ontology, OWLOntologyFormat format) {
        this.ontology = ontology;
        this.format = format;
    }

    public RDFGraph getGraph() {
        return this.graph;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    protected abstract void beginDocument() throws IOException;

    protected abstract void endDocument() throws IOException;

    protected void beginObject() throws IOException {
    }

    protected void endObject() throws IOException {
    }

    protected abstract void writeAnnotationPropertyComment(OWLAnnotationProperty var1) throws IOException;

    protected abstract void writeDataPropertyComment(OWLDataProperty var1) throws IOException;

    protected abstract void writeObjectPropertyComment(OWLObjectProperty var1) throws IOException;

    protected abstract void writeClassComment(OWLClass var1) throws IOException;

    protected abstract void writeDatatypeComment(OWLDatatype var1) throws IOException;

    protected abstract void writeIndividualComments(OWLNamedIndividual var1) throws IOException;

    public void render() throws IOException {
        this.beginDocument();
        this.renderOntologyHeader();
        this.renderOntologyComponents();
        this.endDocument();
    }

    private void renderOntologyComponents() throws IOException {
        this.renderInOntologySignatureEntities();
        this.renderAnonymousIndividuals();
        this.renderUntypedIRIAnnotationAssertions();
        this.renderGeneralAxioms();
        this.renderSWRLRules();
    }

    private void renderInOntologySignatureEntities() throws IOException {
        this.renderAnnotationProperties();
        this.renderDatatypes();
        this.renderObjectProperties();
        this.renderDataProperties();
        this.renderClasses();
        this.renderNamedIndividuals();
    }

    private void renderAnnotationProperties() throws IOException {
        Set annotationProperties = this.ontology.getAnnotationPropertiesInSignature();
        this.renderEntities(annotationProperties, ANNOTATION_PROPERTIES_BANNER_TEXT);
    }

    private void renderNamedIndividuals() throws IOException {
        Set individuals = this.ontology.getIndividualsInSignature();
        this.renderEntities(individuals, INDIVIDUALS_BANNER_TEXT);
    }

    private void renderClasses() throws IOException {
        Set clses = this.ontology.getClassesInSignature();
        this.renderEntities(clses, CLASSES_BANNER_TEXT);
    }

    private void renderDataProperties() throws IOException {
        Set dataProperties = this.ontology.getDataPropertiesInSignature();
        this.renderEntities(dataProperties, DATA_PROPERTIES_BANNER_TEXT);
    }

    private void renderObjectProperties() throws IOException {
        Set objectProperties = this.ontology.getObjectPropertiesInSignature();
        this.renderEntities(objectProperties, OBJECT_PROPERTIES_BANNER_TEXT);
    }

    private void renderDatatypes() throws IOException {
        Set datatypes = this.ontology.getDatatypesInSignature();
        this.renderEntities(datatypes, DATATYPES_BANNER_TEXT);
    }

    private void renderEntities(Set<? extends OWLEntity> entities, String bannerText) throws IOException {
        boolean firstRendering = true;
        for (OWLEntity entity : RDFRendererBase.toSortedSet(entities)) {
            if (!this.createGraph(entity)) continue;
            if (firstRendering) {
                firstRendering = false;
                if (!bannerText.isEmpty()) {
                    this.writeBanner(bannerText);
                }
            }
            this.renderEntity(entity);
        }
    }

    private void renderEntity(OWLEntity entity) throws IOException {
        this.beginObject();
        this.writeEntityComment(entity);
        this.render(new RDFResourceNode(entity.getIRI()));
        this.renderAnonRoots();
        this.endObject();
    }

    private void writeEntityComment(OWLEntity entity) throws IOException {
        if (entity.isOWLClass()) {
            this.writeClassComment(entity.asOWLClass());
        } else if (entity.isOWLDatatype()) {
            this.writeDatatypeComment(entity.asOWLDatatype());
        } else if (entity.isOWLObjectProperty()) {
            this.writeObjectPropertyComment(entity.asOWLObjectProperty());
        } else if (entity.isOWLDataProperty()) {
            this.writeDataPropertyComment(entity.asOWLDataProperty());
        } else if (entity.isOWLAnnotationProperty()) {
            this.writeAnnotationPropertyComment(entity.asOWLAnnotationProperty());
        } else if (entity.isOWLNamedIndividual()) {
            this.writeIndividualComments(entity.asOWLNamedIndividual());
        }
    }

    private void renderUntypedIRIAnnotationAssertions() throws IOException {
        HashSet<IRI> annotatedIRIs = new HashSet<IRI>();
        for (OWLAnnotationAssertionAxiom ax : this.ontology.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
            IRI iri;
            OWLAnnotationSubject subject = ax.getSubject();
            if (!(subject instanceof IRI) || this.ontology.containsEntityInSignature(iri = (IRI)subject)) continue;
            annotatedIRIs.add(iri);
        }
        if (!annotatedIRIs.isEmpty()) {
            this.writeBanner(ANNOTATED_IRIS_BANNER_TEXT);
            for (IRI iri : annotatedIRIs) {
                this.beginObject();
                this.createGraph(this.ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)iri));
                this.render(new RDFResourceNode(iri));
                this.renderAnonRoots();
                this.endObject();
            }
        }
    }

    private void renderAnonymousIndividuals() throws IOException {
        for (OWLAnonymousIndividual anonInd : this.ontology.getReferencedAnonymousIndividuals()) {
            boolean anonRoot = true;
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            for (OWLAxiom ax : this.ontology.getReferencingAxioms(anonInd)) {
                if (ax instanceof OWLDifferentIndividualsAxiom) continue;
                AxiomSubjectProvider subjectProvider = new AxiomSubjectProvider();
                OWLObject obj = subjectProvider.getSubject(ax);
                if (!obj.equals(anonInd)) {
                    anonRoot = false;
                    break;
                }
                axioms.add(ax);
            }
            if (!anonRoot) continue;
            this.createGraph(axioms);
            this.renderAnonRoots();
        }
    }

    private void renderSWRLRules() throws IOException {
        Set ruleAxioms = this.ontology.getAxioms(AxiomType.SWRL_RULE);
        this.createGraph(ruleAxioms);
        if (!ruleAxioms.isEmpty()) {
            this.writeBanner(RULES_BANNER_TEXT);
            SWRLVariableExtractor variableExtractor = new SWRLVariableExtractor();
            for (SWRLRule rule : ruleAxioms) {
                rule.accept((SWRLObjectVisitor)variableExtractor);
            }
            for (SWRLVariable var : variableExtractor.getVariables()) {
                this.render(new RDFResourceNode(var.getIRI()));
            }
            this.renderAnonRoots();
        }
    }

    private void renderGeneralAxioms() throws IOException {
        Set<OWLAxiom> generalAxioms = this.getGeneralAxioms();
        this.createGraph(generalAxioms);
        Set<RDFResourceNode> rootNodes = this.graph.getRootAnonymousNodes();
        if (!rootNodes.isEmpty()) {
            this.writeBanner(GENERAL_AXIOMS_BANNER_TEXT);
            this.beginObject();
            this.renderAnonRoots();
            this.endObject();
        }
    }

    private Set<OWLAxiom> getGeneralAxioms() {
        HashSet<OWLAxiom> generalAxioms = new HashSet<OWLAxiom>();
        generalAxioms.addAll(this.ontology.getGeneralClassAxioms());
        generalAxioms.addAll(this.ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS));
        for (OWLDisjointClassesAxiom ax : this.ontology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (ax.getClassExpressions().size() <= 2) continue;
            generalAxioms.add((OWLAxiom)ax);
        }
        for (OWLDisjointClassesAxiom ax : this.ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            if (ax.getProperties().size() <= 2) continue;
            generalAxioms.add((OWLAxiom)ax);
        }
        for (OWLDisjointClassesAxiom ax : this.ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            if (ax.getProperties().size() <= 2) continue;
            generalAxioms.add((OWLAxiom)ax);
        }
        for (OWLDisjointClassesAxiom ax : this.ontology.getAxioms(AxiomType.HAS_KEY)) {
            if (!ax.getClassExpression().isAnonymous()) continue;
            generalAxioms.add((OWLAxiom)ax);
        }
        return generalAxioms;
    }

    private void renderOntologyHeader() throws IOException {
        this.graph = new RDFGraph();
        OWLOntologyID ontID = this.ontology.getOntologyID();
        RDFResourceNode ontologyHeaderNode = this.createOntologyHeaderNode();
        this.addVersionIRIToOntologyHeader(ontologyHeaderNode);
        this.addImportsDeclarationsToOntologyHeader(ontologyHeaderNode);
        this.addAnnotationsToOntologyHeader(ontologyHeaderNode);
        if (!ontID.isAnonymous() || !this.graph.isEmpty()) {
            this.graph.addTriple(new RDFTriple(ontologyHeaderNode, new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), new RDFResourceNode(OWLRDFVocabulary.OWL_ONTOLOGY.getIRI())));
        }
        if (!this.graph.isEmpty()) {
            this.render(ontologyHeaderNode);
        }
    }

    private RDFResourceNode createOntologyHeaderNode() {
        OWLOntologyID ontID = this.ontology.getOntologyID();
        if (ontID.isAnonymous()) {
            return new RDFResourceNode(System.identityHashCode(this.ontology));
        }
        return new RDFResourceNode(ontID.getOntologyIRI());
    }

    private void addVersionIRIToOntologyHeader(RDFResourceNode ontologyHeaderNode) {
        OWLOntologyID ontID = this.ontology.getOntologyID();
        if (ontID.getVersionIRI() != null) {
            this.graph.addTriple(new RDFTriple(ontologyHeaderNode, new RDFResourceNode(OWLRDFVocabulary.OWL_VERSION_IRI.getIRI()), new RDFResourceNode(ontID.getVersionIRI())));
        }
    }

    private void addImportsDeclarationsToOntologyHeader(RDFResourceNode ontologyHeaderNode) {
        for (OWLImportsDeclaration decl : this.ontology.getImportsDeclarations()) {
            this.graph.addTriple(new RDFTriple(ontologyHeaderNode, new RDFResourceNode(OWLRDFVocabulary.OWL_IMPORTS.getIRI()), new RDFResourceNode(decl.getIRI())));
        }
    }

    private void addAnnotationsToOntologyHeader(RDFResourceNode ontologyHeaderNode) {
        for (OWLAnnotation anno : this.ontology.getAnnotations()) {
            OWLAnnotationValueVisitorEx<RDFNode> valVisitor = new OWLAnnotationValueVisitorEx<RDFNode>(){

                public RDFNode visit(IRI iri) {
                    return new RDFResourceNode(iri);
                }

                public RDFNode visit(OWLAnonymousIndividual individual) {
                    return new RDFResourceNode(System.identityHashCode(individual));
                }

                public RDFNode visit(OWLLiteral literal) {
                    return RDFTranslator.translateLiteralNode(literal);
                }
            };
            RDFNode node = (RDFNode)anno.getValue().accept((OWLAnnotationValueVisitorEx)valVisitor);
            this.graph.addTriple(new RDFTriple(ontologyHeaderNode, new RDFResourceNode(anno.getProperty().getIRI()), node));
        }
    }

    private boolean createGraph(OWLEntity entity) {
        final HashSet<OWLDeclarationAxiom> axioms = new HashSet<OWLDeclarationAxiom>();
        if (!this.isIndividualAndClass(entity)) {
            axioms.addAll(entity.getAnnotationAssertionAxioms(this.ontology));
        }
        axioms.addAll(this.ontology.getDeclarationAxioms(entity));
        entity.accept(new OWLEntityVisitor(){

            public void visit(OWLClass cls) {
                for (OWLAxiom ax : RDFRendererBase.this.ontology.getAxioms(cls)) {
                    OWLDisjointClassesAxiom disjAx;
                    if (ax instanceof OWLDisjointClassesAxiom && (disjAx = (OWLDisjointClassesAxiom)ax).getClassExpressions().size() > 2) continue;
                    axioms.add(ax);
                }
                for (OWLAxiom ax : RDFRendererBase.this.ontology.getAxioms(AxiomType.HAS_KEY)) {
                    if (!ax.getClassExpression().equals(cls)) continue;
                    axioms.add(ax);
                }
            }

            public void visit(OWLDatatype datatype) {
                axioms.addAll(RDFRendererBase.this.ontology.getDatatypeDefinitions(datatype));
                RDFRendererBase.this.createGraph(axioms);
            }

            public void visit(OWLNamedIndividual individual) {
                for (OWLAxiom ax : RDFRendererBase.this.ontology.getAxioms((OWLIndividual)individual)) {
                    if (ax instanceof OWLDifferentIndividualsAxiom) continue;
                    axioms.add(ax);
                }
            }

            public void visit(OWLDataProperty property) {
                for (OWLAxiom ax : RDFRendererBase.this.ontology.getAxioms(property)) {
                    if (ax instanceof OWLDisjointDataPropertiesAxiom && ((OWLDisjointDataPropertiesAxiom)ax).getProperties().size() > 2) continue;
                    axioms.add(ax);
                }
            }

            public void visit(OWLObjectProperty property) {
                for (OWLAxiom ax : RDFRendererBase.this.ontology.getAxioms((OWLObjectPropertyExpression)property)) {
                    if (ax instanceof OWLDisjointObjectPropertiesAxiom && ((OWLDisjointObjectPropertiesAxiom)ax).getProperties().size() > 2) continue;
                    axioms.add(ax);
                }
                for (OWLAxiom ax : RDFRendererBase.this.ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                    if (!ax.getSuperProperty().equals(property)) continue;
                    axioms.add(ax);
                }
                axioms.addAll(RDFRendererBase.this.ontology.getAxioms((OWLObjectPropertyExpression)RDFRendererBase.this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLObjectInverseOf((OWLObjectPropertyExpression)property)));
            }

            public void visit(OWLAnnotationProperty property) {
                axioms.addAll(RDFRendererBase.this.ontology.getAxioms(property));
            }
        });
        if (axioms.isEmpty() && this.shouldInsertDeclarations() && RDFOntologyFormat.isMissingType((OWLEntity)entity, (OWLOntology)this.ontology)) {
            axioms.add(this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(entity));
        }
        this.createGraph(axioms);
        return !axioms.isEmpty();
    }

    private boolean isIndividualAndClass(OWLEntity entity) {
        return entity.isOWLNamedIndividual() && this.ontology.containsClassInSignature(entity.getIRI());
    }

    protected boolean shouldInsertDeclarations() {
        return !(this.format instanceof RDFOntologyFormat) || ((RDFOntologyFormat)this.format).isAddMissingTypes();
    }

    protected void createGraph(Set<? extends OWLObject> objects) {
        RDFTranslator translator = new RDFTranslator(this.ontology.getOWLOntologyManager(), this.ontology, this.shouldInsertDeclarations());
        for (OWLObject oWLObject : objects) {
            oWLObject.accept((OWLObjectVisitor)translator);
        }
        this.graph = translator.getGraph();
    }

    protected abstract void writeBanner(String var1) throws IOException;

    private static List<OWLEntity> toSortedSet(Set<? extends OWLEntity> entities) {
        ArrayList<OWLEntity> results = new ArrayList<OWLEntity>(entities);
        Collections.sort(results, OWL_ENTITY_IRI_COMPARATOR);
        return results;
    }

    public void renderAnonRoots() throws IOException {
        for (RDFResourceNode node : this.graph.getRootAnonymousNodes()) {
            this.render(node);
        }
    }

    public abstract void render(RDFResourceNode var1) throws IOException;

    protected boolean isObjectList(RDFResourceNode node) {
        for (RDFTriple triple : this.graph.getTriplesForSubject(node, false)) {
            if (!triple.getProperty().getIRI().equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI()) || triple.getObject().isAnonymous() || !triple.getObject().getIRI().equals((Object)OWLRDFVocabulary.RDF_LIST.getIRI())) continue;
            ArrayList<RDFNode> items = new ArrayList<RDFNode>();
            this.toJavaList(node, items);
            for (RDFNode n : items) {
                if (!n.isLiteral()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void toJavaList(RDFNode n, List<RDFNode> list) {
        RDFNode currentNode = n;
        while (currentNode != null) {
            for (RDFTriple triple : this.graph.getTriplesForSubject(currentNode, false)) {
                if (!triple.getProperty().getIRI().equals((Object)OWLRDFVocabulary.RDF_FIRST.getIRI())) continue;
                list.add(triple.getObject());
            }
            for (RDFTriple triple : this.graph.getTriplesForSubject(currentNode, false)) {
                if (!triple.getProperty().getIRI().equals((Object)OWLRDFVocabulary.RDF_REST.getIRI())) continue;
                if (!triple.getObject().isAnonymous()) {
                    if (!triple.getObject().getIRI().equals((Object)OWLRDFVocabulary.RDF_NIL.getIRI())) continue;
                    currentNode = null;
                    continue;
                }
                currentNode = triple.getObject();
            }
        }
    }

    private static final class OWLEntityIRIComparator
    implements Comparator<OWLEntity>,
    Serializable {
        private static final long serialVersionUID = 30406L;

        @Override
        public int compare(OWLEntity o1, OWLEntity o2) {
            return o1.getIRI().compareTo((OWLObject)o2.getIRI());
        }
    }
}

