/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import jdistlib.rng.MersenneTwister;
import jdistlib.rng.RandomEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static final int[] colon(int from, int to) {
        int n = Math.abs(to - from) + 1;
        int[] d = new int[n];
        int inc = to > from ? 1 : -1;
        for (int i = 0; i < n; ++i) {
            d[i] = from + i * inc;
        }
        return d;
    }

    public static final double[] colon(double from, double to) {
        int n = (int)(Math.abs(to - from) + 1.0);
        double[] d = new double[n];
        int inc = to > from ? 1 : -1;
        for (int i = 0; i < n; ++i) {
            d[i] = from + (double)(i * inc);
        }
        return d;
    }

    public static final int[] seq(int from, int to, int by) {
        int n = (to - from) / by + 1;
        int[] d = new int[n];
        for (int i = 0; i < n; ++i) {
            d[i] = from + i * by;
        }
        return d;
    }

    public static final double[] seq_int(double from, double to, int length_out) {
        double[] d = new double[length_out];
        double delta = (to - from) / ((double)length_out - 1.0);
        for (int i = 0; i < length_out; ++i) {
            d[i] = from + (double)i * delta;
        }
        return d;
    }

    public static final double[] seq(double from, double to, double by) {
        int n = (int)Math.ceil((to - from + 1.0E-15) / by);
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = from + (double)i * by;
        }
        return d;
    }

    public static final int[] c(int[] ... x) {
        int n = 0;
        for (int i = 0; i < x.length; ++i) {
            n += x[i].length;
        }
        int[] v = new int[n];
        int w = 0;
        for (int i = 0; i < x.length; ++i) {
            System.arraycopy(x[i], 0, v, w, x[i].length);
            w += x[i].length;
        }
        return v;
    }

    public static final int[] c(int ... x) {
        return x;
    }

    public static final double[] c(double[] ... x) {
        int n = 0;
        for (int i = 0; i < x.length; ++i) {
            n += x[i].length;
        }
        double[] v = new double[n];
        int w = 0;
        for (int i = 0; i < x.length; ++i) {
            System.arraycopy(x[i], 0, v, w, x[i].length);
            w += x[i].length;
        }
        return v;
    }

    public static final double[] c(double ... x) {
        return x;
    }

    public static final double[] rep(double v, int n) {
        double[] r = new double[n];
        Arrays.fill(r, v);
        return r;
    }

    public static final double[] rep(double[] v, int n) {
        double[] r = new double[n * v.length];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(v, 0, r, i * n, v.length);
        }
        return r;
    }

    public static final double[] rep_each(double[] v, int n) {
        int vn = v.length;
        double[] r = new double[vn * n];
        for (int i = 0; i < vn; ++i) {
            double vi = v[i];
            for (int j = 0; j < n; ++j) {
                r[i * n + j] = vi;
            }
        }
        return r;
    }

    public static final int[] rep_each(int[] v, int n) {
        int vn = v.length;
        int[] r = new int[vn * n];
        for (int i = 0; i < vn; ++i) {
            int vi = v[i];
            for (int j = 0; j < n; ++j) {
                r[i * n + j] = vi;
            }
        }
        return r;
    }

    public static final double[] rec(double[] e) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[i] = 1.0 / e[i];
        }
        return v;
    }

    public static final double[] rev(double[] e) {
        double[] v = new double[e.length];
        for (int i = 0; i < e.length; ++i) {
            v[e.length - i - 1] = e[i];
        }
        return v;
    }

    public static final void print(double ... val) {
        Utilities.print(" %g", val);
    }

    public static final void print(String format, double ... val) {
        int n = val.length;
        for (int i = 0; i < n; ++i) {
            System.out.print(String.format(format, val[i]));
            if ((i + 1) % 6 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    public static final void sort(double[] data) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] a = new long[n];
        long[] b = new long[n];
        for (int i2 = 0; i2 < n; ++i2) {
            a[i2] = Double.doubleToLongBits(data[i2]);
        }
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int p;
            int[] cntarray = new int[1 << numBins];
            for (p = 0; p < n; ++p) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
            }
            for (int i3 = 1; i3 < cntarray.length; ++i3) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
            }
            for (p = n - 1; p >= 0; --p) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
            }
            long[] temp = b;
            b = a;
            a = temp;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0L) {
            for (i = n - 1; a[i] < 0L && i > 0; --i) {
                data[numNegs++] = Double.longBitsToDouble(a[i]);
            }
        }
        if (numNegs > 0) {
            for (i = numNegs; i < n; ++i) {
                data[i] = Double.longBitsToDouble(a[i - numNegs]);
            }
        } else {
            for (i = 0; i < n; ++i) {
                data[i] = Double.longBitsToDouble(a[i]);
            }
        }
    }

    public static final void sort(double[] data, int[] idx) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] a = new long[n];
        long[] b = new long[n];
        int[] idx_a = new int[n];
        int[] idx_b = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            a[i2] = Double.doubleToLongBits(data[i2]);
            idx_a[i2] = idx[i2];
        }
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int p;
            int[] cntarray = new int[1 << numBins];
            for (p = 0; p < n; ++p) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
            }
            for (int i3 = 1; i3 < cntarray.length; ++i3) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
            }
            for (p = n - 1; p >= 0; --p) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
            }
            long[] temp = b;
            b = a;
            a = temp;
            int[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0L) {
            for (i = n - 1; a[i] < 0L && i > 0; --i) {
                data[numNegs] = Double.longBitsToDouble(a[i]);
                idx[numNegs++] = idx_a[i];
            }
        }
        if (numNegs > 0) {
            for (i = numNegs; i < n; ++i) {
                data[i] = Double.longBitsToDouble(a[i - numNegs]);
                idx[i] = idx_a[i - numNegs];
            }
        } else {
            for (i = 0; i < n; ++i) {
                data[i] = Double.longBitsToDouble(a[i]);
                idx[i] = idx_a[i];
            }
        }
    }

    public static final <T> void sort(double[] data, T[] obj) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] a = new long[n];
        long[] b = new long[n];
        Object[] idx_a = new Object[n];
        Object[] idx_b = new Object[n];
        for (int i2 = 0; i2 < n; ++i2) {
            a[i2] = Double.doubleToLongBits(data[i2]);
            idx_a[i2] = obj[i2];
        }
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int p;
            int[] cntarray = new int[1 << numBins];
            for (p = 0; p < n; ++p) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
            }
            for (int i3 = 1; i3 < cntarray.length; ++i3) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
            }
            for (p = n - 1; p >= 0; --p) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
            }
            long[] temp = b;
            b = a;
            a = temp;
            Object[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0L) {
            for (i = n - 1; a[i] < 0L && i > 0; --i) {
                data[numNegs] = Double.longBitsToDouble(a[i]);
                obj[numNegs++] = idx_a[i];
            }
        }
        if (numNegs > 0) {
            for (i = numNegs; i < n; ++i) {
                data[i] = Double.longBitsToDouble(a[i - numNegs]);
                obj[i] = idx_a[i - numNegs];
            }
        } else {
            for (i = 0; i < n; ++i) {
                data[i] = Double.longBitsToDouble(a[i]);
                obj[i] = idx_a[i];
            }
        }
    }

    public static final void sort(int[] a) {
        int[] b;
        int n = a.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        int[] b_orig = b = new int[n];
        int mask = ~(-1 << numBins);
        int rshift = 0;
        while (mask != 0) {
            int p;
            int[] cntarray = new int[1 << numBins];
            for (p = 0; p < n; ++p) {
                int n2 = (a[p] & mask) >>> rshift;
                cntarray[n2] = cntarray[n2] + 1;
            }
            for (int i = 1; i < cntarray.length; ++i) {
                int n3 = i;
                cntarray[n3] = cntarray[n3] + cntarray[i - 1];
            }
            for (p = n - 1; p >= 0; --p) {
                int key;
                int n4 = key = (a[p] & mask) >>> rshift;
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
            }
            int[] temp = b;
            b = a;
            a = temp;
            mask <<= numBins;
            rshift += numBins;
        }
        if (a == b_orig) {
            System.arraycopy(a, 0, b, 0, n);
        }
        int numNegs = 0;
        int i = n - 1;
        while (a[i] < 0 && i > 0) {
            --i;
            ++numNegs;
        }
        if (numNegs > 0) {
            System.arraycopy(a, n - numNegs, b, 0, numNegs);
            System.arraycopy(a, 0, a, numNegs, n - numNegs);
            System.arraycopy(b, 0, a, 0, numNegs);
        }
    }

    public static final void sort(int[] data, int[] idx) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        int[] a = new int[n];
        int[] b = new int[n];
        int[] idx_a = new int[n];
        int[] idx_b = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            a[i2] = data[i2];
            idx_a[i2] = idx[i2];
        }
        int mask = ~(-1 << numBins);
        int rshift = 0;
        while (mask != 0) {
            int p;
            int[] cntarray = new int[1 << numBins];
            for (p = 0; p < n; ++p) {
                int n2 = (a[p] & mask) >>> rshift;
                cntarray[n2] = cntarray[n2] + 1;
            }
            for (int i3 = 1; i3 < cntarray.length; ++i3) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
            }
            for (p = n - 1; p >= 0; --p) {
                int key;
                int n4 = key = (a[p] & mask) >>> rshift;
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
            }
            int[] temp = b;
            b = a;
            a = temp;
            int[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0) {
            for (i = n - 1; a[i] < 0 && i > 0; --i) {
                data[numNegs] = a[i];
                idx[numNegs++] = idx_a[i];
            }
        }
        if (numNegs > 0) {
            for (i = numNegs; i < n; ++i) {
                data[i] = a[i - numNegs];
                idx[i] = idx_a[i - numNegs];
            }
        } else {
            for (i = 0; i < n; ++i) {
                data[i] = a[i];
                idx[i] = idx_a[i];
            }
        }
    }

    public static final <T> void sort(int[] data, T[] idx) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        int[] a = new int[n];
        int[] b = new int[n];
        Object[] idx_a = new Object[n];
        Object[] idx_b = new Object[n];
        for (int i2 = 0; i2 < n; ++i2) {
            a[i2] = data[i2];
            idx_a[i2] = idx[i2];
        }
        int mask = ~(-1 << numBins);
        int rshift = 0;
        while (mask != 0) {
            int p;
            int[] cntarray = new int[1 << numBins];
            for (p = 0; p < n; ++p) {
                int n2 = (a[p] & mask) >>> rshift;
                cntarray[n2] = cntarray[n2] + 1;
            }
            for (int i3 = 1; i3 < cntarray.length; ++i3) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
            }
            for (p = n - 1; p >= 0; --p) {
                int key;
                int n4 = key = (a[p] & mask) >>> rshift;
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
            }
            int[] temp = b;
            b = a;
            a = temp;
            Object[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0) {
            for (i = n - 1; a[i] < 0 && i > 0; --i) {
                data[numNegs] = a[i];
                idx[numNegs++] = idx_a[i];
            }
        }
        if (numNegs > 0) {
            for (i = numNegs; i < n; ++i) {
                data[i] = a[i - numNegs];
                idx[i] = idx_a[i - numNegs];
            }
        } else {
            for (i = 0; i < n; ++i) {
                data[i] = a[i];
                idx[i] = idx_a[i];
            }
        }
    }

    public static final void sort(long[] a) {
        long[] b;
        int n = a.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] b_orig = b = new long[n];
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int p;
            int[] cntarray = new int[1 << numBins];
            for (p = 0; p < n; ++p) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
            }
            for (int i = 1; i < cntarray.length; ++i) {
                int n3 = i;
                cntarray[n3] = cntarray[n3] + cntarray[i - 1];
            }
            for (p = n - 1; p >= 0; --p) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
            }
            long[] temp = b;
            b = a;
            a = temp;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        if (a == b_orig) {
            System.arraycopy(a, 0, b, 0, n);
        }
        int numNegs = 0;
        int i = n - 1;
        while (a[i] < 0L && i > 0) {
            --i;
            ++numNegs;
        }
        if (numNegs > 0) {
            System.arraycopy(a, n - numNegs, b, 0, numNegs);
            System.arraycopy(a, 0, a, numNegs, n - numNegs);
            System.arraycopy(b, 0, a, 0, numNegs);
        }
    }

    public static final void sort(long[] data, int[] idx) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] a = new long[n];
        long[] b = new long[n];
        int[] idx_a = new int[n];
        int[] idx_b = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            a[i2] = data[i2];
            idx_a[i2] = idx[i2];
        }
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int p;
            int[] cntarray = new int[1 << numBins];
            for (p = 0; p < n; ++p) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
            }
            for (int i3 = 1; i3 < cntarray.length; ++i3) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
            }
            for (p = n - 1; p >= 0; --p) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
            }
            long[] temp = b;
            b = a;
            a = temp;
            int[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0L) {
            for (i = n - 1; a[i] < 0L && i > 0; --i) {
                data[numNegs] = a[i];
                idx[numNegs++] = idx_a[i];
            }
        }
        if (numNegs > 0) {
            for (i = numNegs; i < n; ++i) {
                data[i] = a[i - numNegs];
                idx[i] = idx_a[i - numNegs];
            }
        } else {
            for (i = 0; i < n; ++i) {
                data[i] = a[i];
                idx[i] = idx_a[i];
            }
        }
    }

    public static final <T> void sort(long[] data, T[] idx) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] a = new long[n];
        long[] b = new long[n];
        Object[] idx_a = new Object[n];
        Object[] idx_b = new Object[n];
        for (int i2 = 0; i2 < n; ++i2) {
            a[i2] = data[i2];
            idx_a[i2] = idx[i2];
        }
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int p;
            int[] cntarray = new int[1 << numBins];
            for (p = 0; p < n; ++p) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
            }
            for (int i3 = 1; i3 < cntarray.length; ++i3) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
            }
            for (p = n - 1; p >= 0; --p) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
            }
            long[] temp = b;
            b = a;
            a = temp;
            Object[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0L) {
            for (i = n - 1; a[i] < 0L && i > 0; --i) {
                data[numNegs] = a[i];
                idx[numNegs++] = idx_a[i];
            }
        }
        if (numNegs > 0) {
            for (i = numNegs; i < n; ++i) {
                data[i] = a[i - numNegs];
                idx[i] = idx_a[i - numNegs];
            }
        } else {
            for (i = 0; i < n; ++i) {
                data[i] = a[i];
                idx[i] = idx_a[i];
            }
        }
    }

    public static final double[] to_double(int[] e) {
        int n = e.length;
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = e[i];
        }
        return r;
    }

    public static final int[] order(double[] e) {
        int n = e.length;
        int[] order = new int[n];
        double[] v = new double[n];
        System.arraycopy(e, 0, v, 0, n);
        for (int i = 0; i < n; ++i) {
            order[i] = i;
        }
        Utilities.sort(v, order);
        return order;
    }

    public static final double[] rank(double[] e) {
        return Utilities.rank(e, RankTies.AVERAGE);
    }

    public static final double[] rank(double[] e, RankTies ties) {
        int n = e.length;
        int[] order = new int[n];
        double[] rank = new double[n];
        double[] v = new double[n];
        System.arraycopy(e, 0, v, 0, n);
        for (int i = 0; i < n; ++i) {
            order[i] = i;
        }
        Utilities.sort(v, order);
        int i = 0;
        while (i < n) {
            int j;
            for (j = i; j < n - 1 && v[j] == v[j + 1]; ++j) {
            }
            switch (ties) {
                case AVERAGE: {
                    int k;
                    double avg = (double)(i + j) / 2.0;
                    for (k = i; k <= j; ++k) {
                        rank[order[k]] = avg + 1.0;
                    }
                    break;
                }
                case MAX: {
                    int k;
                    for (k = i; k <= j; ++k) {
                        rank[order[k]] = j + 1;
                    }
                    break;
                }
                case MIN: {
                    int k;
                    for (k = i; k <= j; ++k) {
                        rank[order[k]] = i + 1;
                    }
                    break;
                }
            }
            i = j + 1;
        }
        return rank;
    }

    public static final void permute(double[] e) {
        Utilities.permute(e, new MersenneTwister());
    }

    public static final void permute(double[] e, RandomEngine random) {
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            int i1 = random.nextInt(n);
            int i2 = random.nextInt(n);
            double t = e[i1];
            e[i1] = e[i2];
            e[i2] = t;
        }
    }

    public static final double[] sample_int(int n, int s) {
        return Utilities.sample_int(n, s, new MersenneTwister());
    }

    public static final double[] sample_int(int n, int s, RandomEngine random) {
        double[] rand = new double[s];
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < s; ++i) {
            int j;
            while (set.contains(j = (int)(Math.floor(random.random() * (double)n) + 1.0))) {
            }
            set.add(j);
            rand[i] = j;
        }
        return rand;
    }

    public static final double[] unique(double[] e) {
        LinkedHashSet<Double> set = new LinkedHashSet<Double>(e.length);
        for (double _e : e) {
            set.add(_e);
        }
        int n = set.size();
        int i = 0;
        double[] r = new double[n];
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            double _e = (Double)iterator.next();
            r[i++] = _e;
        }
        return r;
    }

    public static final <S> S[] unique(S[] e) {
        LinkedHashSet<S> set = new LinkedHashSet<S>(e.length);
        for (S _e : e) {
            set.add(_e);
        }
        return set.toArray();
    }

    public static final boolean[] is_duplicated(double[] e) {
        LinkedHashSet<Double> set = new LinkedHashSet<Double>(e.length);
        int n = e.length;
        int i = 0;
        boolean[] r = new boolean[n];
        for (double _e : e) {
            r[i++] = set.contains(_e);
            set.add(_e);
        }
        return r;
    }

    public static final <S> boolean[] is_duplicated(S[] e) {
        LinkedHashSet<S> set = new LinkedHashSet<S>(e.length);
        int n = e.length;
        int i = 0;
        boolean[] r = new boolean[n];
        for (S _e : e) {
            r[i++] = set.contains(_e);
            set.add(_e);
        }
        return r;
    }

    public static final int[] which(boolean[] e) {
        int n = e.length;
        int n_true = 0;
        int j = 0;
        for (boolean _e : e) {
            if (!_e) continue;
            ++n_true;
        }
        int[] idx = new int[n_true];
        for (int i = 0; i < n; ++i) {
            if (!e[i]) continue;
            idx[j++] = i;
        }
        return idx;
    }

    public static final double[][] rle(double[] e) {
        ArrayList<Double> vals = new ArrayList<Double>();
        ArrayList<Integer> lens = new ArrayList<Integer>();
        double last_val = e[0];
        int last_ct = 1;
        int n = e.length;
        for (int i = 1; i < n; ++i) {
            if (e[i] != last_val) {
                vals.add(last_val);
                lens.add(last_ct);
                last_val = e[i];
                last_ct = 1;
                continue;
            }
            ++last_ct;
        }
        vals.add(last_val);
        lens.add(last_ct);
        n = vals.size();
        double[] uvals = new double[n];
        double[] ulen = new double[n];
        for (int i = 0; i < n; ++i) {
            uvals[i] = (Double)vals.get(i);
            ulen[i] = ((Integer)lens.get(i)).intValue();
        }
        return new double[][]{uvals, ulen};
    }

    public static final int[] match(double[] x, double[] y) {
        int nx = x.length;
        int ny = y.length;
        int[] r = new int[nx];
        block0: for (int i = 0; i < nx; ++i) {
            r[i] = -1;
            for (int j = 0; j < ny; ++j) {
                if (x[i] != y[j]) continue;
                r[i] = j;
                continue block0;
            }
        }
        return r;
    }

    public static final int[] match(int[] x, int[] y) {
        int nx = x.length;
        int ny = y.length;
        int[] r = new int[nx];
        block0: for (int i = 0; i < nx; ++i) {
            r[i] = -1;
            for (int j = 0; j < ny; ++j) {
                if (x[i] != y[j]) continue;
                r[i] = j;
                continue block0;
            }
        }
        return r;
    }

    public static final <S> int[] match(S[] x, S[] y) {
        int nx = x.length;
        int ny = y.length;
        int[] r = new int[nx];
        block0: for (int i = 0; i < nx; ++i) {
            r[i] = -1;
            for (int j = 0; j < ny; ++j) {
                if (!x[i].equals(y[j])) continue;
                r[i] = j;
                continue block0;
            }
        }
        return r;
    }

    public static final int[] tabulate(int[] x, int n) {
        int nx = x.length;
        int[] r = new int[n];
        for (int i = 0; i < nx; ++i) {
            int n2 = x[i];
            r[n2] = r[n2] + 1;
        }
        return r;
    }

    public static final int[] seq_along(double[] z) {
        return Utilities.colon(1, z.length);
    }

    public static final double[] index(double[] x, int[] idx) {
        int n = idx.length;
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = x[idx[i]];
        }
        return r;
    }

    public static final double[] index_min1(double[] x, int[] idx) {
        int n = idx.length;
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = x[idx[i] - 1];
        }
        return r;
    }

    public static final int[] to_int_array(Collection<Integer> s) {
        int n = s.size();
        int[] r = new int[n];
        int i = 0;
        for (int _s : s) {
            r[i++] = _s;
        }
        return r;
    }

    public static final double[] to_double_array(Collection<Double> s) {
        int n = s.size();
        double[] r = new double[n];
        int i = 0;
        for (double _s : s) {
            r[i++] = _s;
        }
        return r;
    }

    public static final boolean any(boolean ... x) {
        for (boolean _x : x) {
            if (!_x) continue;
            return true;
        }
        return false;
    }

    public static final boolean anyNA(double ... x) {
        for (double _x : x) {
            if (!Double.isNaN(_x)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RankTies {
        AVERAGE,
        MAX,
        MIN;

    }
}

