/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Cauchy
extends GenericDistribution {
    protected double location;
    protected double scale;

    public static final double density(double x, double location, double scale, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x + location + scale;
        }
        if (scale <= 0.0) {
            return Double.NaN;
        }
        double y = (x - location) / scale;
        return give_log ? -Math.log(Math.PI * scale * (1.0 + y * y)) : 1.0 / (Math.PI * scale * (1.0 + y * y));
    }

    public static final double cumulative(double x, double location, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x + location + scale;
        }
        if (scale <= 0.0) {
            return Double.NaN;
        }
        if (Double.isNaN(x = (x - location) / scale)) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(x)) {
            if (x < 0.0) {
                return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
            }
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (!lower_tail) {
            x = -x;
        }
        if (Math.abs(x) > 1.0) {
            double y = Math.atan(1.0 / x) / Math.PI;
            return x > 0.0 ? (log_p ? Math.log1p(-y) : 0.5 - y + 0.5) : (log_p ? Math.log(-y) : -y);
        }
        x = 0.5 + Math.atan(x) / Math.PI;
        return log_p ? Math.log(x) : x;
    }

    public static final double quantile(double p, double location, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(location) || Double.isNaN(scale)) {
            return p + location + scale;
        }
        if (log_p && p > 0.0 || !log_p && (p < 0.0 || p > 1.0)) {
            return Double.NaN;
        }
        if (scale <= 0.0 || MathFunctions.isInfinite(scale)) {
            if (scale == 0.0) {
                return location;
            }
            return Double.NaN;
        }
        if (log_p) {
            if (p > -1.0) {
                if (p == 0.0) {
                    return location + (lower_tail ? scale : -scale) * Double.POSITIVE_INFINITY;
                }
                lower_tail = !lower_tail;
                p = -Math.expm1(p);
            } else {
                p = Math.exp(p);
            }
        } else if (p > 0.5) {
            if (p == 1.0) {
                return location + (lower_tail ? scale : -scale) * Double.POSITIVE_INFINITY;
            }
            p = 1.0 - p;
            boolean bl = lower_tail = !lower_tail;
        }
        if (p == 0.5) {
            return location;
        }
        if (p == 0.0) {
            return location + (lower_tail ? scale : -scale) * Double.NEGATIVE_INFINITY;
        }
        return location + (lower_tail ? -scale : scale) / MathFunctions.tanpi(p);
    }

    public static final double random(double location, double scale, RandomEngine random) {
        if (Double.isNaN(location) || MathFunctions.isInfinite(scale) || scale < 0.0) {
            return Double.NaN;
        }
        if (scale == 0.0 || MathFunctions.isInfinite(location)) {
            return location;
        }
        return location + scale * MathFunctions.tanpi(random.nextDouble());
    }

    public static final double[] random(int n, double location, double scale, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Cauchy.random(location, scale, random);
        }
        return rand;
    }

    public Cauchy() {
        this(0.0, 1.0);
    }

    public Cauchy(double location, double scale) {
        this.location = location;
        this.scale = scale;
    }

    public double density(double x, boolean log) {
        return Cauchy.density(x, this.location, this.scale, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Cauchy.cumulative(p, this.location, this.scale, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Cauchy.quantile(q, this.location, this.scale, lower_tail, log_p);
    }

    public double random() {
        return Cauchy.random(this.location, this.scale, this.random);
    }
}

