/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Uniform
extends GenericDistribution {
    protected double a;
    protected double b;

    public static final double density(double x, double a, double b, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return x + a + b;
        }
        if (b <= a) {
            return Double.NaN;
        }
        if (a <= x && x <= b) {
            return give_log ? -Math.log(b - a) : 1.0 / (b - a);
        }
        return give_log ? Double.NEGATIVE_INFINITY : 0.0;
    }

    public static final double cumulative(double x, double a, double b, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return x + a + b;
        }
        if (b < a || MathFunctions.isInfinite(a) || MathFunctions.isInfinite(b)) {
            return Double.NaN;
        }
        if (x >= b) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (x <= a) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (lower_tail) {
            x = (x - a) / (b - a);
            return log_p ? Math.log(x) : x;
        }
        x = (b - x) / (b - a);
        return log_p ? Math.log(x) : x;
    }

    public static final double quantile(double p, double a, double b, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(a) || Double.isNaN(b)) {
            return p + a + b;
        }
        if (log_p && p > 0.0 || !log_p && (p < 0.0 || p > 1.0)) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(a) || MathFunctions.isInfinite(b) || b < a) {
            return Double.NaN;
        }
        if (b == a) {
            return a;
        }
        p = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (lower_tail ? p : 0.5 - p + 0.5);
        return a + p * (b - a);
    }

    public static final double random(double a, double b, RandomEngine random) {
        double u;
        if (MathFunctions.isInfinite(a) || MathFunctions.isInfinite(b) || b < a) {
            return Double.NaN;
        }
        if (a == b) {
            return a;
        }
        while ((u = random.nextDouble()) <= 0.0 || u >= 1.0) {
        }
        return a + (b - a) * u;
    }

    public static final double[] random(int n, double a, double b, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Uniform.random(a, b, random);
        }
        return rand;
    }

    public Uniform(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public double density(double x, boolean log) {
        return Uniform.density(x, this.a, this.b, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Uniform.cumulative(p, this.a, this.b, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Uniform.quantile(q, this.a, this.b, lower_tail, log_p);
    }

    public double random() {
        return Uniform.random(this.a, this.b, this.random);
    }
}

