/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Binomial;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class HyperGeometric
extends GenericDistribution {
    protected double r;
    protected double b;
    protected double n;
    protected RandomState state;

    public static final RandomState create_random_state() {
        return new RandomState();
    }

    public static final double density(double x, double r, double b, double n, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(r) || Double.isNaN(b) || Double.isNaN(n)) {
            return x + r + b + n;
        }
        if (r < 0.0 || MathFunctions.isNonInt(r) || b < 0.0 || MathFunctions.isNonInt(b) || n < 0.0 || MathFunctions.isNonInt(n) || n > r + b) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (MathFunctions.isNonInt(x)) {
            System.err.println("WARNING: Non-integer x in HyperGeometric.density");
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        x = Math.rint(x);
        r = Math.rint(r);
        b = Math.rint(b);
        if ((n = Math.rint(n)) < x || r < x || n - x > b) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (n == 0.0) {
            return x == 0.0 ? (give_log ? 0.0 : 1.0) : (give_log ? Double.NEGATIVE_INFINITY : 0.0);
        }
        double p = n / (r + b);
        double q = (r + b - n) / (r + b);
        double p1 = Binomial.density_raw(x, r, p, q, give_log);
        double p2 = Binomial.density_raw(n - x, b, p, q, give_log);
        double p3 = Binomial.density_raw(n, r + b, p, q, give_log);
        return give_log ? p1 + p2 - p3 : p1 * p2 / p3;
    }

    public static final double pdhyper(double x, double NR, double NB, double n, boolean log_p) {
        double sum = 0.0;
        double term = 1.0;
        while (x > 0.0 && term >= 2.220446049250313E-16 * sum) {
            sum += (term *= x * (NB - n + x) / (n + 1.0 - x) / (NR + 1.0 - x));
            x -= 1.0;
        }
        return log_p ? Math.log1p(sum) : 1.0 + sum;
    }

    public static final double cumulative(double x, double NR, double NB, double n, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(NR) || Double.isNaN(NB) || Double.isNaN(n)) {
            return x + NR + NB + n;
        }
        x = Math.floor(x + 1.0E-7);
        NR = Math.rint(NR);
        NB = Math.rint(NB);
        n = Math.rint(n);
        if (NR < 0.0 || NB < 0.0 || MathFunctions.isInfinite(NR + NB) || n < 0.0 || n > NR + NB) {
            return Double.NaN;
        }
        if (x * (NR + NB) > n * NR) {
            double oldNB = NB;
            NB = NR;
            NR = oldNB;
            x = n - x - 1.0;
            boolean bl = lower_tail = !lower_tail;
        }
        if (x < 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (x >= NR || x >= n) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        double d = HyperGeometric.density(x, NR, NB, n, log_p);
        double pd = HyperGeometric.pdhyper(x, NR, NB, n, log_p);
        return log_p ? (lower_tail ? (log_p ? d + pd : Math.log(d + pd)) : (log_p ? (d + pd > -0.6931471805599453 ? Math.log(-Math.expm1(d + pd)) : Math.log1p(-Math.exp(d + pd))) : Math.log1p(-(d + pd)))) : (lower_tail ? d * pd : 0.5 - d * pd + 0.5);
    }

    static final double lfastchoose(double n, double k) {
        return -Math.log(n + 1.0) - MathFunctions.lbeta(n - k + 1.0, k + 1.0);
    }

    public static final double quantile(double p, double NR, double NB, double n, boolean lower_tail, boolean log_p) {
        double sum;
        if (Double.isNaN(p) || Double.isNaN(NR) || Double.isNaN(NB) || Double.isNaN(n)) {
            return p + NR + NB + n;
        }
        if (MathFunctions.isInfinite(p) || MathFunctions.isInfinite(NR) || MathFunctions.isInfinite(NB) || MathFunctions.isInfinite(n)) {
            return Double.NaN;
        }
        NR = Math.rint(NR);
        NB = Math.rint(NB);
        double N = NR + NB;
        n = Math.rint(n);
        if (NR < 0.0 || NB < 0.0 || n < 0.0 || n > N) {
            return Double.NaN;
        }
        double xstart = Math.max(0.0, n - NB);
        double xend = Math.min(n, NR);
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? xend : xstart;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? xstart : xend;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? xstart : xend;
            }
            if (p == 1.0) {
                return lower_tail ? xend : xstart;
            }
        }
        double xr = xstart;
        double xb = n - xr;
        boolean small_N = N < 1000.0;
        double term = HyperGeometric.lfastchoose(NR, xr) + HyperGeometric.lfastchoose(NB, xb) - HyperGeometric.lfastchoose(N, n);
        if (small_N) {
            term = Math.exp(term);
        }
        NR -= xr;
        NB -= xb;
        if (!lower_tail || log_p) {
            p = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (lower_tail ? p : 0.5 - p + 0.5);
        }
        p *= 0.999999999999778;
        double d = sum = small_N ? term : Math.exp(term);
        while (sum < p && xr < xend) {
            term = small_N ? (term *= NR / xr * (xb / NB)) : (term += Math.log(NR / (xr += 1.0) * (xb / (NB += 1.0))));
            sum += small_N ? term : Math.exp(term);
            xb -= 1.0;
            NR -= 1.0;
        }
        return xr;
    }

    static final double afc(int i) {
        double value;
        double[] al = new double[]{0.0, 0.0, 0.0, 0.6931471805599453, 1.791759469228055, 3.1780538303479458, 4.787491742782046, 6.579251212010101, 8.525161361065415};
        if (i < 0) {
            return -1.0;
        }
        if (i <= 7) {
            value = al[i + 1];
        } else {
            double di = i;
            value = (di + 0.5) * Math.log(di) - di + 0.08333333333333 / di - 0.00277777777777 / di / di / di + 0.9189385332;
        }
        return value;
    }

    public static final double random(double nn1in, double nn2in, double kkin, RandomEngine random) {
        return HyperGeometric.random(nn1in, nn2in, kkin, random, null);
    }

    public static final double random(double nn1in, double nn2in, double kkin, RandomEngine random, RandomState state) {
        int ix;
        int kk;
        int nn2;
        int nn1;
        block44: {
            boolean setup2;
            boolean setup1;
            double deltal = 0.0078;
            double deltau = 0.0034;
            if (state == null) {
                state = new RandomState();
            }
            if (MathFunctions.isInfinite(nn1in) || MathFunctions.isInfinite(nn2in) || MathFunctions.isInfinite(kkin)) {
                return Double.NaN;
            }
            nn1 = (int)Math.rint(nn1in);
            nn2 = (int)Math.rint(nn2in);
            kk = (int)Math.rint(kkin);
            if (nn1 < 0 || nn2 < 0 || kk < 0 || kk > nn1 + nn2) {
                return Double.NaN;
            }
            boolean reject = true;
            if (nn1 != state.n1s || nn2 != state.n2s) {
                setup1 = true;
                setup2 = true;
            } else if (kk != state.ks) {
                setup1 = false;
                setup2 = true;
            } else {
                setup1 = false;
                setup2 = false;
            }
            if (setup1) {
                state.n1s = nn1;
                state.n2s = nn2;
                state.tn = nn1 + nn2;
                if (nn1 <= nn2) {
                    state.n1 = nn1;
                    state.n2 = nn2;
                } else {
                    state.n1 = nn2;
                    state.n2 = nn1;
                }
            }
            if (setup2) {
                state.ks = kk;
                state.k = (double)(kk + kk) >= state.tn ? (int)(state.tn - (double)kk) : kk;
            }
            if (setup1 || setup2) {
                state.m = (int)(((double)state.k + 1.0) * ((double)state.n1 + 1.0) / (state.tn + 2.0));
                state.minjx = Math.max(0, state.k - state.n2);
                state.maxjx = Math.min(state.n1, state.k);
            }
            if (state.minjx == state.maxjx) {
                int ix2 = state.maxjx;
                if ((double)(kk + kk) >= state.tn) {
                    ix2 = nn1 > nn2 ? kk - nn2 + ix2 : nn1 - ix2;
                } else if (nn1 > nn2) {
                    ix2 = kk - ix2;
                }
                return ix2;
            }
            if (state.m - state.minjx < 10) {
                double scale = 1.0E25;
                double con = 57.564627324851145;
                if (setup1 || setup2) {
                    double lw = state.k < state.n2 ? HyperGeometric.afc(state.n2) + HyperGeometric.afc(state.n1 + state.n2 - state.k) - HyperGeometric.afc(state.n2 - state.k) - HyperGeometric.afc(state.n1 + state.n2) : HyperGeometric.afc(state.n1) + HyperGeometric.afc(state.k) - HyperGeometric.afc(state.k - state.n2) - HyperGeometric.afc(state.n1 + state.n2);
                    state.w = Math.exp(lw + 57.564627324851145);
                }
                block0: while (true) {
                    double p = state.w;
                    ix = state.minjx;
                    double u = random.nextDouble() * 1.0E25;
                    while (u > p) {
                        u -= p;
                        p *= (double)((state.n1 - ix) * (state.k - ix));
                        p = p / (double)(++ix) / (double)(state.n2 - state.k + ix);
                        if (ix <= state.maxjx) continue;
                        continue block0;
                    }
                    break block44;
                    break;
                }
            }
            if (setup1 || setup2) {
                state.s = Math.sqrt((state.tn - (double)state.k) * (double)state.k * (double)state.n1 * (double)state.n2 / (state.tn - 1.0) / state.tn / state.tn);
                state.d = (double)((int)(1.5 * state.s)) + 0.5;
                state.xl = (double)state.m - state.d + 0.5;
                state.xr = (double)state.m + state.d + 0.5;
                state.a = HyperGeometric.afc(state.m) + HyperGeometric.afc(state.n1 - state.m) + HyperGeometric.afc(state.k - state.m) + HyperGeometric.afc(state.n2 - state.k + state.m);
                state.kl = Math.exp(state.a - HyperGeometric.afc((int)state.xl) - HyperGeometric.afc((int)((double)state.n1 - state.xl)) - HyperGeometric.afc((int)((double)state.k - state.xl)) - HyperGeometric.afc((int)((double)(state.n2 - state.k) + state.xl)));
                state.kr = Math.exp(state.a - HyperGeometric.afc((int)(state.xr - 1.0)) - HyperGeometric.afc((int)((double)state.n1 - state.xr + 1.0)) - HyperGeometric.afc((int)((double)state.k - state.xr + 1.0)) - HyperGeometric.afc((int)((double)(state.n2 - state.k) + state.xr - 1.0)));
                state.lamdl = -Math.log(state.xl * ((double)(state.n2 - state.k) + state.xl) / ((double)state.n1 - state.xl + 1.0) / ((double)state.k - state.xl + 1.0));
                state.lamdr = -Math.log(((double)state.n1 - state.xr + 1.0) * ((double)state.k - state.xr + 1.0) / state.xr / ((double)(state.n2 - state.k) + state.xr));
                state.p1 = state.d + state.d;
                state.p2 = state.p1 + state.kl / state.lamdl;
                state.p3 = state.p2 + state.kr / state.lamdr;
            }
            while (true) {
                double u = random.nextDouble() * state.p3;
                double v = random.nextDouble();
                if (u < state.p1) {
                    ix = (int)(state.xl + u);
                } else if (u <= state.p2) {
                    ix = (int)(state.xl + Math.log(v) / state.lamdl);
                    if (ix < state.minjx) continue;
                    v = v * (u - state.p1) * state.lamdl;
                } else {
                    ix = (int)(state.xr - Math.log(v) / state.lamdr);
                    if (ix > state.maxjx) continue;
                    v = v * (u - state.p2) * state.lamdr;
                }
                if (state.m < 100 || ix <= 50) {
                    int i;
                    double f = 1.0;
                    if (state.m < ix) {
                        for (i = state.m + 1; i <= ix; ++i) {
                            f = f * (double)(state.n1 - i + 1) * (double)(state.k - i + 1) / (double)(state.n2 - state.k + i) / (double)i;
                        }
                    } else if (state.m > ix) {
                        for (i = ix + 1; i <= state.m; ++i) {
                            f = f * (double)i * (double)(state.n2 - state.k + i) / (double)(state.n1 - i + 1) / (double)(state.k - i + 1);
                        }
                    }
                    if (v <= f) {
                        reject = false;
                    }
                } else {
                    double y = ix;
                    double y1 = y + 1.0;
                    double ym = y - (double)state.m;
                    double yn = (double)state.n1 - y + 1.0;
                    double yk = (double)state.k - y + 1.0;
                    double nk = (double)(state.n2 - state.k) + y1;
                    double r = -ym / y1;
                    state.s = ym / yn;
                    double t = ym / yk;
                    double e = -ym / nk;
                    double g = yn * yk / (y1 * nk) - 1.0;
                    double dg = 1.0;
                    if (g < 0.0) {
                        dg = 1.0 + g;
                    }
                    double gu = g * (1.0 + g * (-0.5 + g / 3.0));
                    double gl = gu - 0.25 * (g * g * g * g) / dg;
                    double xm = (double)state.m + 0.5;
                    double xn = (double)(state.n1 - state.m) + 0.5;
                    double xk = (double)(state.k - state.m) + 0.5;
                    double nm = (double)(state.n2 - state.k) + xm;
                    double ub = y * gu - (double)state.m * gl + 0.0034 + xm * r * (1.0 + r * (-0.5 + r / 3.0)) + xn * state.s * (1.0 + state.s * (-0.5 + state.s / 3.0)) + xk * t * (1.0 + t * (-0.5 + t / 3.0)) + nm * e * (1.0 + e * (-0.5 + e / 3.0));
                    double alv = Math.log(v);
                    if (alv > ub) {
                        reject = true;
                    } else {
                        double dr = xm * (r * r * r * r);
                        if (r < 0.0) {
                            dr /= 1.0 + r;
                        }
                        double ds = xn * (state.s * state.s * state.s * state.s);
                        if (state.s < 0.0) {
                            ds /= 1.0 + state.s;
                        }
                        double dt = xk * (t * t * t * t);
                        if (t < 0.0) {
                            dt /= 1.0 + t;
                        }
                        double de = nm * (e * e * e * e);
                        if (e < 0.0) {
                            de /= 1.0 + e;
                        }
                        reject = alv < ub - 0.25 * (dr + ds + dt + de) + (y + (double)state.m) * (gl - gu) - 0.0078 ? false : !(alv <= state.a - HyperGeometric.afc(ix) - HyperGeometric.afc(state.n1 - ix) - HyperGeometric.afc(state.k - ix) - HyperGeometric.afc(state.n2 - state.k + ix));
                    }
                }
                if (!reject) break;
            }
        }
        if ((double)(kk + kk) >= state.tn) {
            ix = nn1 > nn2 ? kk - nn2 + ix : nn1 - ix;
        } else if (nn1 > nn2) {
            ix = kk - ix;
        }
        return ix;
    }

    public static final double[] random(int n, double nn1in, double nn2in, double kkin, RandomEngine random, RandomState state) {
        if (state == null) {
            state = HyperGeometric.create_random_state();
        }
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = HyperGeometric.random(nn1in, nn2in, kkin, random, state);
        }
        return rand;
    }

    public static final double[] random(int n, double nn1in, double nn2in, double kkin, RandomEngine random) {
        return HyperGeometric.random(n, nn1in, nn2in, kkin, random, HyperGeometric.create_random_state());
    }

    public HyperGeometric(double r, double b, double n) {
        this.r = r;
        this.b = b;
        this.n = n;
        this.state = HyperGeometric.create_random_state();
    }

    public double density(double x, boolean log) {
        return HyperGeometric.density(x, this.r, this.b, this.n, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return HyperGeometric.cumulative(p, this.r, this.b, this.n, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return HyperGeometric.quantile(q, this.r, this.b, this.n, lower_tail, log_p);
    }

    public double random() {
        return HyperGeometric.random(this.r, this.b, this.n, this.random, this.state);
    }

    public double[] random(int ct) {
        return HyperGeometric.random(ct, this.r, this.b, this.n, this.random, this.state);
    }

    public static class RandomState {
        public int ks = -1;
        public int n1s = -1;
        public int n2s = -1;
        public int k;
        public int m;
        public int minjx;
        public int maxjx;
        public int n1;
        public int n2;
        public double tn;
        public double w;
        public double a;
        public double d;
        public double s;
        public double xl;
        public double xr;
        public double kl;
        public double kr;
        public double lamdl;
        public double lamdr;
        public double p1;
        public double p2;
        public double p3;
    }
}

