/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math;

public class MathFunctions {
    protected static final double bigx = 4.294967296E9;
    protected static final double scalefactor = 1.157920892373162E77;

    public static final double lmvgammafn(double a, int p) {
        double sum = 0.0;
        for (int j = 1; j <= p; ++j) {
            sum += MathFunctions.lgammafn(a + (double)(1 - j) / 2.0);
        }
        return sum + (double)(p * (p - 1)) / 4.0 * 1.1447298858494002;
    }

    public static final double trunc(double x) {
        return x >= 0.0 ? Math.floor(x) : Math.ceil(x);
    }

    public static final double round(double val, int places) {
        double factor = Math.pow(10.0, places);
        return (double)Math.round(val * factor) / factor;
    }

    public static final float round(float val, int places) {
        return MathFunctions.round(val, places);
    }

    public static final double signif(double val, int places) {
        if (val != 0.0) {
            places -= (int)Math.ceil(Math.log10(val));
        }
        double factor = Math.pow(10.0, places);
        return (double)Math.round(val * factor) / factor;
    }

    public static final int gcd(int m, int n) {
        do {
            if (0 != (m %= n)) continue;
            return n;
        } while (0 != (n %= m));
        return m;
    }

    public static final double sinc(double x) {
        return x == 0.0 ? 1.0 : Math.sin(x) / x;
    }

    public static final boolean isFinite(double x) {
        return !Double.isNaN(x) && x != Double.POSITIVE_INFINITY && x != Double.NEGATIVE_INFINITY;
    }

    public static final boolean isInfinite(double x) {
        return Double.isNaN(x) || x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY;
    }

    public static final double ldexp(double x, double ex) {
        return Math.exp(Math.log(x) + ex * 0.6931471805599453);
    }

    static final int chebyshev_init(double[] dos, int nos, double eta) {
        if (nos < 1) {
            return 0;
        }
        double err = 0.0;
        int i = 0;
        for (int ii = 1; ii <= nos; ++ii) {
            i = nos - ii;
            if (!((err += Math.abs(dos[i])) > eta)) continue;
            return i;
        }
        return i;
    }

    public static final double chebyshev_eval(double x, double[] a, int n) {
        if (n < 1 || n > 1000 || x < -1.1 || x > 1.1) {
            return Double.NaN;
        }
        double twox = x * 2.0;
        double b2 = 0.0;
        double b1 = 0.0;
        double b0 = 0.0;
        for (int i = 1; i <= n; ++i) {
            b2 = b1;
            b1 = b0;
            b0 = twox * b1 - b2 + a[n - i];
        }
        return (b0 - b2) * 0.5;
    }

    public static final double lgammacor(double x) {
        double[] algmcs = new double[]{0.16663894804518634, -1.384948176067564E-5, 9.81082564692473E-9, -1.809129475572494E-11, 6.221098041892606E-14, -3.399615005417722E-16, 2.683181998482699E-18, -2.868042435334643E-20, 3.9628370610464347E-22, -6.831888753985767E-24, 1.4292273559424982E-25, -3.5475981581010704E-27, 1.025680058010471E-28, -3.401102254316749E-30, 1.276642195630063E-31};
        int nalgm = 5;
        double xbig = 9.490626562425156E7;
        double xmax = 3.745194030963158E306;
        if (x < 10.0) {
            return Double.NaN;
        }
        if (x >= xmax) {
            return 1.0 / (x * 12.0);
        }
        if (x < xbig) {
            double tmp = 10.0 / x;
            return MathFunctions.chebyshev_eval(tmp * tmp * 2.0 - 1.0, algmcs, nalgm) / x;
        }
        return 1.0 / (x * 12.0);
    }

    public static final double lgammafn_sign(double x, int[] sgn) {
        double xmax = 2.5327372760800758E305;
        double dxrel = 1.4901161193847656E-8;
        if (sgn != null) {
            sgn[0] = 1;
        }
        if (sgn != null && x < 0.0 && Math.floor(-x) % 2.0 == 0.0) {
            sgn[0] = -1;
        }
        if (x <= 0.0 && x == MathFunctions.trunc(x)) {
            return Double.POSITIVE_INFINITY;
        }
        double y = Math.abs(x);
        if (y < 1.0E-306) {
            return -Math.log(y);
        }
        if (y <= 10.0) {
            return Math.log(Math.abs(MathFunctions.gammafn(x)));
        }
        if (y > 2.5327372760800758E305) {
            return Double.POSITIVE_INFINITY;
        }
        if (x > 0.0) {
            if (x > 1.0E17) {
                return x * (Math.log(x) - 1.0);
            }
            if (x > 4934720.0) {
                return 0.9189385332046728 + (x - 0.5) * Math.log(x) - x;
            }
            return 0.9189385332046728 + (x - 0.5) * Math.log(x) - x + MathFunctions.lgammacor(x);
        }
        double sinpiy = Math.abs(MathFunctions.sinpi(y));
        if (sinpiy == 0.0) {
            return Double.NaN;
        }
        double ans = 0.22579135264472744 + (x - 0.5) * Math.log(y) - x - Math.log(sinpiy) - MathFunctions.lgammacor(y);
        if (Math.abs((x - MathFunctions.trunc(x - 0.5)) * ans / x) < 1.4901161193847656E-8) {
            System.err.println("lgamma precision error!");
        }
        return ans;
    }

    public static final double lgammafn(double x) {
        return MathFunctions.lgammafn_sign(x, null);
    }

    public static final double[] lgammafn(double[] x) {
        int n = x.length;
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = MathFunctions.lgammafn_sign(x[i], null);
        }
        return r;
    }

    public static final double stirlerr(double n) {
        double S0 = 0.08333333333333333;
        double S1 = 0.002777777777777778;
        double S2 = 7.936507936507937E-4;
        double S3 = 5.952380952380953E-4;
        double S4 = 8.417508417508417E-4;
        double[] sferr_halves = new double[]{0.0, 0.15342640972002736, 0.08106146679532726, 0.05481412105191765, 0.0413406959554093, 0.03316287351993629, 0.02767792568499834, 0.023746163656297496, 0.020790672103765093, 0.018488450532673187, 0.016644691189821193, 0.015134973221917378, 0.013876128823070748, 0.012810465242920227, 0.01189670994589177, 0.011104559758206917, 0.010411265261972096, 0.009799416126158804, 0.009255462182712733, 0.008768700134139386, 0.00833056343336287, 0.00793411456431402, 0.007573675487951841, 0.007244554301320383, 0.00694284010720953, 0.006665247032707682, 0.006408994188004207, 0.006171712263039458, 0.0059513701127588475, 0.0057462165130101155, 0.005554733551962801};
        if (n <= 15.0) {
            double nn = n + n;
            if (nn == (double)((int)nn)) {
                return sferr_halves[(int)nn];
            }
            return MathFunctions.lgammafn(n + 1.0) - (n + 0.5) * Math.log(n) + n - 0.9189385332046728;
        }
        double nn = n * n;
        if (n > 500.0) {
            return (0.08333333333333333 - 0.002777777777777778 / nn) / n;
        }
        if (n > 80.0) {
            return (0.08333333333333333 - (0.002777777777777778 - 7.936507936507937E-4 / nn) / nn) / n;
        }
        if (n > 35.0) {
            return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - 5.952380952380953E-4 / nn) / nn) / nn) / n;
        }
        return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - (5.952380952380953E-4 - 8.417508417508417E-4 / nn) / nn) / nn) / nn) / n;
    }

    public static final double gammafn(double x) {
        double value;
        double[] gamcs = new double[]{0.00857119559098933, 0.004415381324841007, 0.05685043681599363, -0.00421983539641856, 0.0013268081812124603, -1.8930245297988805E-4, 3.606925327441245E-5, -6.056761904460864E-6, 1.0558295463022833E-6, -1.811967365542384E-7, 3.117724964715322E-8, -5.354219639019687E-9, 9.193275519859589E-10, -1.5779412802883398E-10, 2.7079806229349544E-11, -4.64681865382573E-12, 7.97335019200742E-13, -1.368078209830916E-13, 2.3473194865638007E-14, -4.027432614949067E-15, 6.910051747372101E-16, -1.185584500221993E-16, 2.034148542496374E-17, -3.490054341717406E-18, 5.987993856485306E-19, -1.027378057872228E-19, 1.7627028160605298E-20, -3.024320653735306E-21, 5.188914660218398E-22, -8.902770842456576E-23, 1.5274740684933426E-23, -2.620731256187363E-24, 4.496464047830539E-25, -7.714712731336878E-26, 1.323635453126044E-26, -2.2709994129429287E-27, 3.8964189980039913E-28, -6.685198115125953E-29, 1.1469986631400244E-29, -1.9679385863451348E-30, 3.376448816585338E-31, -5.793070335782136E-32};
        int ngam = 22;
        double xmin = -170.5674972726612;
        double xmax = 171.61447887182297;
        double xsml = 2.2474362225598545E-308;
        double dxrel = 1.4901161193847656E-8;
        if (Double.isNaN(x)) {
            return x;
        }
        if (x == 0.0 || x < 0.0 && x == (double)((long)x)) {
            return Double.NaN;
        }
        double y = Math.abs(x);
        if (y <= 10.0) {
            int n = (int)x;
            if (x < 0.0) {
                --n;
            }
            y = x - (double)n;
            double value2 = MathFunctions.chebyshev_eval(y * 2.0 - 1.0, gamcs, 22) + 0.9375;
            if (--n == 0) {
                return value2;
            }
            if (n < 0) {
                if (x < -0.5 && Math.abs(x - (double)((int)(x - 0.5)) / x) < 1.4901161193847656E-8) {
                    throw new ArithmeticException("Math Error: PRECISION");
                }
                if (y < 2.2474362225598545E-308) {
                    return x > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                }
                n = -n;
                for (int i = 0; i < n; ++i) {
                    value2 /= x + (double)i;
                }
                return value2;
            }
            for (int i = 1; i <= n; ++i) {
                value2 *= y + (double)i;
            }
            return value2;
        }
        if (x > 171.61447887182297) {
            return Double.POSITIVE_INFINITY;
        }
        if (x < -170.5674972726612) {
            return 0.0;
        }
        if (y <= 50.0 && y == (double)((int)y)) {
            value = 1.0;
            int i = 2;
            while ((double)i < y) {
                value *= (double)i;
                ++i;
            }
        } else {
            value = Math.exp((y - 0.5) * Math.log(y) - y + 0.9189385332046728 + (2.0 * y == 2.0 * y ? MathFunctions.stirlerr(y) : MathFunctions.lgammacor(y)));
        }
        if (x > 0.0) {
            return value;
        }
        if (Math.abs((x - (double)((int)(x - 0.5))) / x) < 1.4901161193847656E-8) {
            throw new ArithmeticException("Math Error: PRECISION");
        }
        double sinpiy = MathFunctions.sinpi(y);
        if (sinpiy == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return -Math.PI / (y * sinpiy * value);
    }

    public static final double[] gammafn(double[] x) {
        int n = x.length;
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = MathFunctions.gammafn(x[i]);
        }
        return r;
    }

    public static final double bd0(double x, double np) {
        if (MathFunctions.isInfinite(x) || MathFunctions.isInfinite(np) || np == 0.0) {
            return Double.NaN;
        }
        if (Math.abs(x - np) < 0.1 * (x + np)) {
            double v = Math.exp(Math.log(x - np) - Math.log(x + np));
            double s = (x - np) * v;
            double ej = 2.0 * x * v;
            v *= v;
            for (int j = 1; j < 1000; ++j) {
                double s1 = s + (ej *= v) / (double)((j << 1) + 1);
                if (s1 == s) {
                    return s1;
                }
                s = s1;
            }
        }
        return x * (Math.log(x) - Math.log(np)) + np - x;
    }

    public static final double lbeta(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return a + b;
        }
        double q = a;
        double p = q;
        if (b < p) {
            p = b;
        }
        if (b > q) {
            q = b;
        }
        if (p < 0.0) {
            return Double.NaN;
        }
        if (p == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (MathFunctions.isInfinite(q)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p >= 10.0) {
            double corr = MathFunctions.lgammacor(p) + MathFunctions.lgammacor(q) - MathFunctions.lgammacor(p + q);
            return Math.log(q) * -0.5 + 0.9189385332046728 + corr + (p - 0.5) * Math.log(p / (p + q)) + q * Math.log1p(-p / (p + q));
        }
        if (q >= 10.0) {
            double corr = MathFunctions.lgammacor(q) - MathFunctions.lgammacor(p + q);
            return MathFunctions.lgammafn(p) + corr + p - p * Math.log(p + q) + (q - 0.5) * Math.log1p(-p / (p + q));
        }
        if (p < 1.0E-306) {
            return MathFunctions.lgammafn(p) + (MathFunctions.lgammafn(q) - MathFunctions.lgammafn(p + q));
        }
        return Math.log(MathFunctions.gammafn(p) * (MathFunctions.gammafn(q) / MathFunctions.gammafn(p + q)));
    }

    static final double logcf(double x, double i, double d, double eps) {
        double c1 = 2.0 * d;
        double c2 = i + d;
        double c4 = c2 + d;
        double a1 = c2;
        double b1 = i * (c2 - i * x);
        double b2 = d * d * x;
        double a2 = c4 * c2 - b2;
        b2 = c4 * b1 - i * b2;
        while (Math.abs(a2 * b1 - a1 * b2) > Math.abs(eps * b1 * b2)) {
            double c3 = c2 * c2 * x;
            c2 += d;
            a1 = (c4 += d) * a2 - c3 * a1;
            b1 = c4 * b2 - c3 * b1;
            c3 = c1 * c1 * x;
            c1 += d;
            a2 = (c4 += d) * a1 - c3 * a2;
            if (Math.abs(b2 = c4 * b1 - c3 * b2) > 1.157920892373162E77) {
                a1 /= 1.157920892373162E77;
                b1 /= 1.157920892373162E77;
                a2 /= 1.157920892373162E77;
                b2 /= 1.157920892373162E77;
                continue;
            }
            if (!(Math.abs(b2) < 8.636168555094445E-78)) continue;
            a1 *= 1.157920892373162E77;
            b1 *= 1.157920892373162E77;
            a2 *= 1.157920892373162E77;
            b2 *= 1.157920892373162E77;
        }
        return a2 / b2;
    }

    public static final double log1pmx(double x) {
        double minLog1Value = -0.79149064;
        if (x > 1.0 || x < -0.79149064) {
            return Math.log1p(x) - x;
        }
        double r = x / (2.0 + x);
        double y = r * r;
        if (Math.abs(x) < 0.01) {
            double two = 2.0;
            return r * ((((0.2222222222222222 * y + 0.2857142857142857) * y + 0.4) * y + 0.6666666666666666) * y - x);
        }
        double tol_logcf = 1.0E-14;
        return r * (2.0 * y * MathFunctions.logcf(y, 3.0, 2.0, 1.0E-14) - x);
    }

    public static final double log1px(double x) {
        double oans;
        if (!(Math.abs(x) < 1.0)) {
            return Double.NaN;
        }
        double ans = oans = x;
        double term = oans;
        oans = ans + 1.0;
        int n = 1;
        int sn = 1;
        double xn = x;
        while (ans != oans) {
            oans = ans;
            term = (double)(sn *= -1) / (double)(++n) * (xn *= x);
            ans += term;
        }
        return ans;
    }

    public static final double lgamma1p(double a) {
        double eulers_const = 0.5772156649015329;
        int N = 40;
        double[] coeffs = new double[]{0.3224670334241132, 0.0673523010531981, 0.020580808427784546, 0.007385551028673986, 0.0028905103307415234, 0.001192753911703261, 5.096695247430425E-4, 2.2315475845357939E-4, 9.945751278180853E-5, 4.492623673813314E-5, 2.050721277567069E-5, 9.439488275268397E-6, 4.374866789907488E-6, 2.039215753801366E-6, 9.55141213040742E-7, 4.492469198764566E-7, 2.1207184805554665E-7, 1.0043224823968099E-7, 4.7698101693639804E-8, 2.2711094608943164E-8, 1.0838659214896955E-8, 5.183475041970047E-9, 2.4836745438024785E-9, 1.1921401405860912E-9, 5.731367241678862E-10, 2.7595228851242334E-10, 1.330476437424449E-10, 6.4229645638381E-11, 3.1044247747322276E-11, 1.5021384080754142E-11, 7.275974480239079E-12, 3.527742476575915E-12, 1.711991790559618E-12, 8.315385841420285E-13, 4.04220052528944E-13, 1.9664756310966165E-13, 9.573630387838556E-14, 4.6640760264283744E-14, 2.2737369600659724E-14, 1.1091399470834522E-14};
        double c = 2.2737368458246524E-13;
        double tol_logcf = 1.0E-14;
        if (Math.abs(a) >= 0.5) {
            return MathFunctions.lgammafn(a + 1.0);
        }
        double lgam = 2.2737368458246524E-13 * MathFunctions.logcf(-a / 2.0, 42.0, 1.0, 1.0E-14);
        for (int i = 39; i >= 0; --i) {
            lgam = coeffs[i] - a * lgam;
        }
        return (a * lgam - 0.5772156649015329) * a - MathFunctions.log1pmx(a);
    }

    public static final double logspace_add(double logx, double logy) {
        return Math.max(logx, logy) + Math.log1p(Math.exp(-Math.abs(logx - logy)));
    }

    public static final double logspace_sub(double logx, double logy) {
        return logx + ((logy -= logx) > -0.6931471805599453 ? Math.log(-Math.expm1(logy)) : Math.log1p(-Math.exp(logy)));
    }

    public static final double logspace_sum(double[] logx) {
        int i;
        int n = logx.length;
        if (n == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n == 1) {
            return logx[0];
        }
        if (n == 2) {
            return MathFunctions.logspace_add(logx[0], logx[1]);
        }
        double Mx = logx[0];
        for (i = 1; i < n; ++i) {
            if (!(Mx < logx[i])) continue;
            Mx = logx[i];
        }
        double s = 0.0;
        for (i = 0; i < n; ++i) {
            s += Math.exp(logx[i] - Mx);
        }
        return Mx + Math.log(s);
    }

    public static final double[] bratio(double a, double b, double x, double y, boolean log_p) {
        double y0;
        double b0;
        double x0;
        double a0;
        boolean do_swap;
        int n = 0;
        int kase = 0;
        int[] ierr1 = new int[]{0};
        double lambda = 0.0;
        double eps = 4.440892098500626E-16;
        double w1 = log_p ? Double.NEGATIVE_INFINITY : 0.0;
        double w = w1;
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(a) || Double.isNaN(b)) {
            return new double[]{w, w1, 9.0};
        }
        if (a < 0.0 || b < 0.0) {
            return new double[]{w, w1, 1.0};
        }
        if (a == 0.0 && b == 0.0) {
            return new double[]{w, w1, 2.0};
        }
        if (x < 0.0 || x > 1.0) {
            return new double[]{w, w1, 3.0};
        }
        if (y < 0.0 || y > 1.0) {
            return new double[]{w, w1, 4.0};
        }
        double z = x + y - 0.5 - 0.5;
        if (Math.abs(z) > eps * 3.0) {
            return new double[]{w, w1, 5.0};
        }
        if (x == 0.0) {
            if (a == 0.0) {
                return new double[]{w, w1, 6.0};
            }
            w = log_p ? Double.NEGATIVE_INFINITY : 0.0;
            w1 = log_p ? 0.0 : 1.0;
            return new double[]{w, w1, 0.0};
        }
        if (y == 0.0) {
            if (b == 0.0) {
                return new double[]{w, w1, 7.0};
            }
            w = log_p ? 0.0 : 1.0;
            w1 = log_p ? Double.NEGATIVE_INFINITY : 0.0;
            return new double[]{w, w1, 0.0};
        }
        if (a == 0.0) {
            w = log_p ? 0.0 : 1.0;
            w1 = log_p ? Double.NEGATIVE_INFINITY : 0.0;
            return new double[]{w, w1, 0.0};
        }
        if (b == 0.0) {
            w = log_p ? Double.NEGATIVE_INFINITY : 0.0;
            w1 = log_p ? 0.0 : 1.0;
            return new double[]{w, w1, 0.0};
        }
        eps = Math.max(eps, 1.0E-15);
        boolean a_lt_b = a < b;
        double d = a_lt_b ? b : a;
        if (d < eps * 0.001) {
            if (log_p) {
                if (a_lt_b) {
                    w = Math.log1p(-a / (a + b));
                    w1 = Math.log(a / (a + b));
                } else {
                    w = Math.log(b / (a + b));
                    w1 = Math.log1p(-b / (a + b));
                }
            } else {
                w = b / (a + b);
                w1 = a / (a + b);
            }
            return new double[]{w, w1, 0.0};
        }
        if (Math.min(a, b) <= 1.0) {
            boolean bl = do_swap = x > 0.5;
            if (do_swap) {
                a0 = b;
                x0 = y;
                b0 = a;
                y0 = x;
            } else {
                a0 = a;
                x0 = x;
                b0 = b;
                y0 = y;
            }
            if (b0 < Math.min(eps, eps * a0)) {
                w = MathFunctions.fpser(a0, b0, x0, eps, log_p);
                double d2 = log_p ? (w > -0.6931471805599453 ? Math.log(-Math.expm1(w)) : Math.log1p(-Math.exp(w))) : (w1 = 0.5 - w + 0.5);
                if (do_swap) {
                    double t = w;
                    w = w1;
                    w1 = t;
                }
                return new double[]{w, w1, 0.0};
            }
            if (a0 < Math.min(eps, eps * b0) && b0 * x0 <= 1.0) {
                w1 = MathFunctions.apser(a0, b0, x0, eps);
                w = 0.5 - w1 + 0.5;
                if (log_p) {
                    w = Math.log1p(-w1);
                    w1 = Math.log(w1);
                } else {
                    w = 0.5 - w1 + 0.5;
                }
                if (do_swap) {
                    double t = w;
                    w = w1;
                    w1 = t;
                }
                return new double[]{w, w1, 0.0};
            }
            boolean did_bup = false;
            if (Math.max(a0, b0) > 1.0) {
                if (b0 <= 1.0) {
                    kase = 100;
                } else if (x0 >= 0.29) {
                    kase = 110;
                } else if (x0 < 0.1 && Math.pow(x0 * b0, a0) <= 0.7) {
                    kase = 100;
                } else if (b0 > 15.0) {
                    w1 = 0.0;
                    kase = 131;
                }
            } else if (a0 >= Math.min(0.2, b0) || Math.pow(x0, a0) <= 0.9) {
                kase = 100;
            } else if (x0 >= 0.3) {
                kase = 110;
            }
            if (kase == 0) {
                n = 20;
                w1 = MathFunctions.bup(b0, a0, y0, x0, n, eps, false);
                did_bup = true;
                b0 += (double)n;
            }
            if (kase == 0 || kase == 131) {
                if ((w1 = MathFunctions.bgrat(b0, a0, y0, x0, w1, 15.0 * eps, ierr1, false)) == 0.0 || 0.0 < w1 && w1 < 1.0E-310) {
                    w1 = did_bup ? MathFunctions.bup(b0 - (double)n, a0, y0, x0, n, eps, true) : Double.NEGATIVE_INFINITY;
                    w1 = MathFunctions.bgrat(b0, a0, y0, x0, w1, 15.0 * eps, ierr1, true);
                    if (log_p) {
                        w = w1 > -0.6931471805599453 ? Math.log(-Math.expm1(w1)) : Math.log1p(-Math.exp(w1));
                    } else {
                        w = -Math.expm1(w1);
                        w1 = Math.exp(w1);
                    }
                    if (do_swap) {
                        double t = w;
                        w = w1;
                        w1 = t;
                    }
                    return new double[]{w, w1, ierr1[0] > 0 ? (double)(10 + ierr1[0]) : 0.0};
                }
                if (log_p) {
                    w = Math.log1p(-w1);
                    w1 = Math.log(w1);
                } else {
                    w = 0.5 - w1 + 0.5;
                }
                if (do_swap) {
                    double t = w;
                    w = w1;
                    w1 = t;
                }
                return new double[]{w, w1, ierr1[0] > 0 ? (double)(10 + ierr1[0]) : 0.0};
            }
        } else {
            lambda = a > b ? (a + b) * y - b : a - (a + b) * x;
            boolean bl = do_swap = lambda < 0.0;
            if (do_swap) {
                lambda = -lambda;
                a0 = b;
                x0 = y;
                b0 = a;
                y0 = x;
            } else {
                a0 = a;
                x0 = x;
                b0 = b;
                y0 = y;
            }
            if (b0 < 40.0) {
                kase = b0 * x0 <= 0.7 || log_p && lambda > 650.0 ? 100 : 140;
            } else if (a0 > b0) {
                if (b0 <= 100.0 || lambda > b0 * 0.03) {
                    kase = 120;
                }
            } else if (a0 <= 100.0) {
                kase = 120;
            } else if (lambda > a0 * 0.03) {
                kase = 120;
            }
            if (kase == 0) {
                w = MathFunctions.basym(a0, b0, lambda, eps * 100.0, log_p);
                double d3 = log_p ? (w > -0.6931471805599453 ? Math.log(-Math.expm1(w)) : Math.log1p(-Math.exp(w))) : (w1 = 0.5 - w + 0.5);
                if (do_swap) {
                    double t = w;
                    w = w1;
                    w1 = t;
                }
                return new double[]{w, w1, 0.0};
            }
        }
        int ierr = 0;
        switch (kase) {
            case 100: {
                w = MathFunctions.bpser(a0, b0, x0, eps, log_p);
                w1 = log_p ? (w > -0.6931471805599453 ? Math.log(-Math.expm1(w)) : Math.log1p(-Math.exp(w))) : 0.5 - w + 0.5;
                break;
            }
            case 110: {
                w1 = MathFunctions.bpser(b0, a0, y0, eps, log_p);
                w = log_p ? (w1 > -0.6931471805599453 ? Math.log(-Math.expm1(w1)) : Math.log1p(-Math.exp(w1))) : 0.5 - w1 + 0.5;
                break;
            }
            case 120: {
                w = MathFunctions.bfrac(a0, b0, x0, y0, lambda, eps * 15.0, log_p);
                w1 = log_p ? (w > -0.6931471805599453 ? Math.log(-Math.expm1(w)) : Math.log1p(-Math.exp(w))) : 0.5 - w + 0.5;
                break;
            }
            case 140: {
                n = (int)b0;
                if ((b0 -= (double)n) == 0.0) {
                    --n;
                    b0 = 1.0;
                }
                if ((w = MathFunctions.bup(b0, a0, y0, x0, n, eps, false)) < Double.MIN_NORMAL && log_p) {
                    w = MathFunctions.bpser(a0, b0 += (double)n, x0, eps, log_p);
                    w1 = log_p ? (w > -0.6931471805599453 ? Math.log(-Math.expm1(w)) : Math.log1p(-Math.exp(w))) : 0.5 - w + 0.5;
                    break;
                }
                if (x0 <= 0.7) {
                    w += MathFunctions.bpser(a0, b0, x0, eps, false);
                    if (log_p) {
                        w1 = Math.log1p(-w);
                        w = Math.log(w);
                        break;
                    }
                    w1 = 0.5 - w + 0.5;
                    break;
                }
                if (a0 <= 15.0) {
                    n = 20;
                    w += MathFunctions.bup(a0, b0, x0, y0, n, eps, false);
                    a0 += (double)n;
                }
                w = MathFunctions.bgrat(a0, b0, x0, y0, w, 15.0 * eps, ierr1, false);
                if (log_p) {
                    w1 = Math.log1p(-w);
                    w = Math.log(w);
                } else {
                    w1 = 0.5 - w + 0.5;
                }
                if (ierr1[0] <= 0) break;
                ierr = 10 + ierr1[0];
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (do_swap) {
            double t = w;
            w = w1;
            w1 = t;
        }
        return new double[]{w, w1, ierr};
    }

    public static final double fpser(double a, double b, double x, double eps, boolean log_p) {
        double c;
        double t;
        double ans;
        if (log_p) {
            ans = a * Math.log(x);
        } else if (a > eps * 0.001) {
            t = a * Math.log(x);
            if (t < MathFunctions.exparg(1)) {
                return 0.0;
            }
            ans = Math.exp(t);
        } else {
            ans = 1.0;
        }
        ans = log_p ? (ans += Math.log(b) - Math.log(a)) : (ans *= b / a);
        double tol = eps / a;
        double an = a + 1.0;
        t = x;
        double s = t / an;
        do {
            t = x * t;
            c = t / (an += 1.0);
            s += c;
        } while (Math.abs(c) > tol);
        ans = log_p ? (ans += Math.log1p(a * s)) : (ans *= a * s + 1.0);
        return ans;
    }

    public static final double apser(double a, double b, double x, double eps) {
        double aj;
        double g = 0.577215664901533;
        double bx = b * x;
        double t = x - bx;
        double c = b * eps <= 0.02 ? Math.log(x) + MathFunctions.psi(b) + 0.577215664901533 + t : Math.log(bx) + 0.577215664901533 + t;
        double tol = eps * 5.0 * Math.abs(c);
        double j = 1.0;
        double s = 0.0;
        do {
            aj = (t *= x - bx / (j += 1.0)) / j;
            s += aj;
        } while (Math.abs(aj) > tol);
        return -a * (c + s);
    }

    public static final double bpser(double a, double b, double x, double eps, boolean log_p) {
        double w;
        double c;
        double ans;
        double z;
        if (x == 0.0) {
            return log_p ? Double.NEGATIVE_INFINITY : 0.0;
        }
        double a0 = Math.min(a, b);
        if (a0 >= 1.0) {
            z = a * Math.log(x) - MathFunctions.betaln(a, b);
            ans = log_p ? z - Math.log(a) : Math.exp(z) / a;
        } else {
            double u;
            double b0 = Math.max(a, b);
            if (b0 < 8.0) {
                double apb;
                if (b0 <= 1.0) {
                    if (log_p) {
                        ans = a * Math.log(x);
                    } else {
                        ans = Math.pow(x, a);
                        if (ans == 0.0) {
                            return ans;
                        }
                    }
                    apb = a + b;
                    if (apb > 1.0) {
                        u = a + b - 1.0;
                        z = (MathFunctions.gam1(u) + 1.0) / apb;
                    } else {
                        z = MathFunctions.gam1(apb) + 1.0;
                    }
                    c = (MathFunctions.gam1(a) + 1.0) * (MathFunctions.gam1(b) + 1.0) / z;
                    ans = log_p ? (ans += Math.log(c * (b / apb))) : (ans *= c * (b / apb));
                } else {
                    double t;
                    u = MathFunctions.gamln1(a0);
                    int m = (int)(b0 - 1.0);
                    if (m >= 1) {
                        c = 1.0;
                        for (int i = 1; i <= m; ++i) {
                            c *= (b0 += -1.0) / (a0 + b0);
                        }
                        u += Math.log(c);
                    }
                    z = a * Math.log(x) - u;
                    apb = a0 + (b0 += -1.0);
                    if (apb > 1.0) {
                        u = a0 + b0 - 1.0;
                        t = (MathFunctions.gam1(u) + 1.0) / apb;
                    } else {
                        t = MathFunctions.gam1(apb) + 1.0;
                    }
                    ans = log_p ? z + Math.log(a0 / a) + Math.log1p(MathFunctions.gam1(b0)) - Math.log(t) : Math.exp(z) * (a0 / a) * (MathFunctions.gam1(b0) + 1.0) / t;
                }
            } else {
                u = MathFunctions.gamln1(a0) + MathFunctions.algdiv(a0, b0);
                z = a * Math.log(x) - u;
                ans = log_p ? z + Math.log(a0 / a) : a0 / a * Math.exp(z);
            }
        }
        if (ans == (log_p ? Double.NEGATIVE_INFINITY : 0.0) || !log_p && a <= eps * 0.1) {
            return ans;
        }
        double sum = 0.0;
        double n = 0.0;
        c = 1.0;
        double tol = eps / a;
        do {
            w = (c *= (0.5 - b / (n += 1.0) + 0.5) * x) / (a + n);
            sum += w;
        } while (n < 1.0E7 && Math.abs(w) > tol);
        if (Math.abs(w) > tol && (log_p && (!(a * sum > -1.0) || !(Math.abs(Math.log1p(a * sum)) < eps * Math.abs(ans))) || !log_p && Math.abs(a * sum + 1.0) != 1.0)) {
            System.err.println(String.format(" bpser(a=%g, b=%g, x=%g,...) did not converge (n=1e7, |w|/tol=%g > 1; A=%g)", a, b, x, Math.abs(w) / tol, ans));
        }
        ans = log_p ? (a * sum > -1.0 ? (ans += Math.log1p(a * sum)) : Double.NEGATIVE_INFINITY) : (ans *= a * sum + 1.0);
        return ans;
    }

    public static final double bup(double a, double b, double x, double y, int n, double eps, boolean give_log) {
        double l;
        int i;
        double ret_val;
        double d;
        double t;
        int k;
        int mu;
        double apb = a + b;
        double ap1 = a + 1.0;
        if (n > 1 && a >= 1.0 && apb >= ap1 * 1.1) {
            mu = (int)Math.abs(MathFunctions.exparg(1));
            if (mu > (k = (int)MathFunctions.exparg(0))) {
                mu = k;
            }
            t = mu;
            d = Math.exp(-t);
        } else {
            mu = 0;
            d = 1.0;
        }
        double d2 = ret_val = give_log ? MathFunctions.brcmp1(mu, a, b, x, y, true) - Math.log(a) : MathFunctions.brcmp1(mu, a, b, x, y, false) / a;
        if (n == 1 || give_log && ret_val == Double.NEGATIVE_INFINITY || !give_log && ret_val == 0.0) {
            return ret_val;
        }
        int nm1 = n - 1;
        double w = d;
        boolean skipToL40 = false;
        k = 0;
        if (b <= 1.0) {
            skipToL40 = true;
        } else if (y > 1.0E-4) {
            double r = (b - 1.0) * x / y - a;
            if (r >= 1.0) {
                k = nm1;
                t = k;
                if (r < t) {
                    k = (int)r;
                }
            } else {
                skipToL40 = true;
            }
        } else {
            k = nm1;
        }
        if (!skipToL40) {
            for (i = 1; i <= k; ++i) {
                l = i - 1;
                d = (apb + l) / (ap1 + l) * x * d;
                w += d;
            }
            if (k == nm1) {
                return give_log ? ret_val + Math.log(w) : ret_val * w;
            }
        }
        for (i = k + 1; i <= nm1 && !((d = (apb + (l = (double)(i - 1))) / (ap1 + l) * x * d) <= eps * (w += d)); ++i) {
        }
        return give_log ? ret_val + Math.log(w) : ret_val * w;
    }

    public static final double bfrac(double a, double b, double x, double y, double lambda, double eps, boolean log_p) {
        double brc = MathFunctions.brcomp(a, b, x, y, log_p);
        if (!log_p && brc == 0.0) {
            return 0.0;
        }
        double c = lambda + 1.0;
        double c0 = b / a;
        double c1 = 1.0 / a + 1.0;
        double yp1 = y + 1.0;
        double n = 0.0;
        double p = 1.0;
        double s = a + 1.0;
        double an = 0.0;
        double bn = 1.0;
        double anp1 = 1.0;
        double bnp1 = c / c1;
        double r = c1 / c;
        while (true) {
            double t = (n += 1.0) / a;
            double w = n * (b - n) * x;
            double e = a / s;
            double alpha = p * (p + c0) * e * e * (w * x);
            e = (t + 1.0) / (c1 + t + t);
            double beta = n + w / s + e * (c + n * yp1);
            p = t + 1.0;
            s += 2.0;
            t = alpha * an + beta * anp1;
            an = anp1;
            anp1 = t;
            t = alpha * bn + beta * bnp1;
            bn = bnp1;
            bnp1 = t;
            r = anp1 / bnp1;
            double r0 = r;
            if (Math.abs(r - r0) <= eps * r) break;
            an /= bnp1;
            bn /= bnp1;
            anp1 = r;
            bnp1 = 1.0;
        }
        return log_p ? brc + Math.log(r) : brc * r;
    }

    public static final double brcomp(double a, double b, double x, double y, boolean log_p) {
        double lambda;
        double y0;
        double x0;
        if (x == 0.0 || y == 0.0) {
            return log_p ? Double.NEGATIVE_INFINITY : 0.0;
        }
        double a0 = Math.min(a, b);
        if (a0 < 8.0) {
            double t;
            double lny;
            double lnx;
            if (x <= 0.375) {
                lnx = Math.log(x);
                lny = MathFunctions.alnrel(-x);
            } else if (y > 0.375) {
                lnx = Math.log(x);
                lny = Math.log(y);
            } else {
                lnx = MathFunctions.alnrel(-y);
                lny = Math.log(y);
            }
            double z = a * lnx + b * lny;
            if (a0 >= 1.0) {
                return log_p ? z : Math.exp(z -= MathFunctions.betaln(a, b));
            }
            double b0 = Math.max(a, b);
            if (b0 >= 8.0) {
                double u = MathFunctions.gamln1(a0) + MathFunctions.algdiv(a0, b0);
                return log_p ? Math.log(a0) + (z - u) : a0 * Math.exp(z - u);
            }
            if (b0 <= 1.0) {
                double e_z;
                double d = e_z = log_p ? z : Math.exp(z);
                if (!log_p && e_z == 0.0) {
                    return 0.0;
                }
                double apb = a + b;
                if (apb > 1.0) {
                    double u = a + b - 1.0;
                    z = (MathFunctions.gam1(u) + 1.0) / apb;
                } else {
                    z = MathFunctions.gam1(apb) + 1.0;
                }
                double c = (MathFunctions.gam1(a) + 1.0) * (MathFunctions.gam1(b) + 1.0) / z;
                return log_p ? e_z + Math.log(a0 * c) - Math.log1p(a0 / b0) : e_z * (a0 * c) / (a0 / b0 + 1.0);
            }
            double u = MathFunctions.gamln1(a0);
            int n = (int)(b0 - 1.0);
            if (n >= 1) {
                double c = 1.0;
                for (int i = 1; i <= n; ++i) {
                    c *= (b0 += -1.0) / (a0 + b0);
                }
                u = Math.log(c) + u;
            }
            z -= u;
            double apb = a0 + (b0 += -1.0);
            if (apb > 1.0) {
                u = a0 + b0 - 1.0;
                t = (MathFunctions.gam1(u) + 1.0) / apb;
            } else {
                t = MathFunctions.gam1(apb) + 1.0;
            }
            return log_p ? Math.log(a0) + z + Math.log1p(MathFunctions.gam1(b0)) - Math.log(t) : a0 * Math.exp(z) * (MathFunctions.gam1(b0) + 1.0) / t;
        }
        if (a <= b) {
            double h = a / b;
            x0 = h / (h + 1.0);
            y0 = 1.0 / (h + 1.0);
            lambda = a - (a + b) * x;
        } else {
            double h = b / a;
            x0 = 1.0 / (h + 1.0);
            y0 = h / (h + 1.0);
            lambda = (a + b) * y - b;
        }
        double e = -lambda / a;
        double u = Math.abs(e) > 0.6 ? e - Math.log(x / x0) : MathFunctions.rlog1(e);
        e = lambda / b;
        double v = Math.abs(e) <= 0.6 ? MathFunctions.rlog1(e) : e - Math.log(y / y0);
        double z = log_p ? -(a * u + b * v) : Math.exp(-(a * u + b * v));
        return log_p ? -0.9189385332046728 + 0.5 * Math.log(b * x0) + z - MathFunctions.bcorr(a, b) : 0.3989422804014327 * Math.sqrt(b * x0) * z * Math.exp(-MathFunctions.bcorr(a, b));
    }

    public static final double brcmp1(int mu, double a, double b, double x, double y, boolean give_log) {
        double lambda;
        double y0;
        double x0;
        double a0 = Math.min(a, b);
        if (a0 < 8.0) {
            double apb;
            double lny;
            double lnx;
            if (x <= 0.375) {
                lnx = Math.log(x);
                lny = MathFunctions.alnrel(-x);
            } else if (y > 0.375) {
                lnx = Math.log(x);
                lny = Math.log(y);
            } else {
                lnx = MathFunctions.alnrel(-y);
                lny = Math.log(y);
            }
            double z = a * lnx + b * lny;
            if (a0 >= 1.0) {
                return MathFunctions.esum(mu, z -= MathFunctions.betaln(a, b), give_log);
            }
            double b0 = Math.max(a, b);
            if (b0 >= 8.0) {
                double u = MathFunctions.gamln1(a0) + MathFunctions.algdiv(a0, b0);
                return give_log ? Math.log(a0) + MathFunctions.esum(mu, z - u, true) : a0 * MathFunctions.esum(mu, z - u, false);
            }
            if (b0 <= 1.0) {
                double ans = MathFunctions.esum(mu, z, give_log);
                if (ans == (give_log ? Double.NEGATIVE_INFINITY : 0.0)) {
                    return ans;
                }
                double apb2 = a + b;
                if (apb2 > 1.0) {
                    double u = a + b - 1.0;
                    z = (MathFunctions.gam1(u) + 1.0) / apb2;
                } else {
                    z = MathFunctions.gam1(apb2) + 1.0;
                }
                double c = give_log ? Math.log1p(MathFunctions.gam1(a)) + Math.log1p(MathFunctions.gam1(b)) - Math.log(z) : (MathFunctions.gam1(a) + 1.0) * (MathFunctions.gam1(b) + 1.0) / z;
                return give_log ? ans + Math.log(a0) + c - Math.log1p(a0 / b0) : ans * (a0 * c) / (a0 / b0 + 1.0);
            }
            double u = MathFunctions.gamln1(a0);
            int n = (int)(b0 - 1.0);
            if (n >= 1) {
                double c = 1.0;
                for (int i = 1; i <= n; ++i) {
                    c *= (b0 += -1.0) / (a0 + b0);
                }
                u += Math.log(c);
            }
            double t = (apb = a0 + (b0 += -1.0)) > 1.0 ? (MathFunctions.gam1(apb - 1.0) + 1.0) / apb : MathFunctions.gam1(apb) + 1.0;
            return give_log ? Math.log(a0) + MathFunctions.esum(mu, z, true) + Math.log1p(MathFunctions.gam1(b0)) - Math.log(t) : a0 * MathFunctions.esum(mu, z -= u, false) * (MathFunctions.gam1(b0) + 1.0) / t;
        }
        if (a > b) {
            double h = b / a;
            x0 = 1.0 / (h + 1.0);
            y0 = h / (h + 1.0);
            lambda = (a + b) * y - b;
        } else {
            double h = a / b;
            x0 = h / (h + 1.0);
            y0 = 1.0 / (h + 1.0);
            lambda = a - (a + b) * x;
        }
        double lx0 = -Math.log1p(b / a);
        double e = -lambda / a;
        double u = Math.abs(e) > 0.6 ? e - Math.log(x / x0) : MathFunctions.rlog1(e);
        e = lambda / b;
        double v = Math.abs(e) > 0.6 ? e - Math.log(y / y0) : MathFunctions.rlog1(e);
        double z = MathFunctions.esum(mu, -(a * u + b * v), give_log);
        return give_log ? Math.log(0.3989422804014327) + (Math.log(b) + lx0) / 2.0 + z - MathFunctions.bcorr(a, b) : 0.3989422804014327 * Math.sqrt(b * x0) * z * Math.exp(-MathFunctions.bcorr(a, b));
    }

    public static final double bgrat(double a, double b, double x, double y, double w, double eps, int[] ierr, boolean log_w) {
        double j;
        boolean u_0;
        int n_terms_bgrat = 30;
        double[] c = new double[30];
        double[] d = new double[30];
        double bm1 = b - 0.5 - 0.5;
        double nu = a + bm1 * 0.5;
        double lnx = y > 0.375 ? Math.log(x) : MathFunctions.alnrel(-y);
        double z = -nu * lnx;
        if (b * z == 0.0) {
            ierr[0] = 1;
            return w;
        }
        double log_r = Math.log(b) + Math.log1p(MathFunctions.gam1(b)) + b * Math.log(z) + nu * lnx;
        double log_u = log_r - (MathFunctions.algdiv(b, a) + b * Math.log(nu));
        double u = Math.exp(log_u);
        if (log_u == Double.NEGATIVE_INFINITY) {
            ierr[0] = 2;
            return w;
        }
        boolean bl = u_0 = u == 0.0;
        double l = log_w ? (w == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(w - log_u)) : (w == 0.0 ? 0.0 : Math.exp(Math.log(w) - log_u));
        double q_r = MathFunctions.grat_r(b, z, log_r, eps);
        double v = 0.25 / (nu * nu);
        double t2 = lnx * 0.25 * lnx;
        double sum = j = q_r;
        double t = 1.0;
        double cn = 1.0;
        double n2 = 0.0;
        for (int n = 1; n <= 30; ++n) {
            double bp2n = b + n2;
            j = (bp2n * (bp2n + 1.0) * j + (z + bp2n + 1.0) * t) * v;
            t *= t2;
            int nm1 = n - 1;
            c[nm1] = cn /= (n2 += 2.0) * (n2 + 1.0);
            double s = 0.0;
            if (n > 1) {
                double coef = b - (double)n;
                for (int i = 1; i <= nm1; ++i) {
                    s += coef * c[i - 1] * d[nm1 - i];
                    coef += b;
                }
            }
            d[nm1] = bm1 * cn + s / (double)n;
            double dj = d[nm1] * j;
            if ((sum += dj) <= 0.0) {
                ierr[0] = 3;
                return w;
            }
            if (Math.abs(dj) <= eps * (sum + l)) break;
            if (n != 30) continue;
            ierr[0] = 4;
        }
        ierr[0] = 0;
        return log_w ? MathFunctions.logspace_add(w, log_u + Math.log(sum)) : w + (u_0 ? Math.exp(log_u + Math.log(sum)) : u * sum);
    }

    public static final double grat_r(double a, double x, double log_r, double eps) {
        double am0;
        double c_a;
        double an0;
        if (a * x == 0.0) {
            if (x <= a) {
                return Math.exp(-log_r);
            }
            return 0.0;
        }
        if (a == 0.5) {
            if (x < 0.25) {
                double p = MathFunctions.erf__(Math.sqrt(x));
                return (0.5 - p + 0.5) * Math.exp(-log_r);
            }
            double sx = Math.sqrt(x);
            double q_r = MathFunctions.erfc1(1, sx) / sx * 1.772453850905516;
            return q_r;
        }
        if (x < 1.1) {
            double t;
            double an = 3.0;
            double c = x;
            double sum = x / (a + 3.0);
            double tol = eps * 0.1 / (a + 1.0);
            do {
                t = (c *= -(x / (an += 1.0))) / (a + an);
                sum += t;
            } while (Math.abs(t) > tol);
            double j = a * x * ((sum / 6.0 - 0.5 / (a + 2.0)) * x + 1.0 / (a + 1.0));
            double z = a * Math.log(x);
            double h = MathFunctions.gam1(a);
            double g = h + 1.0;
            if (x >= 0.25 && a < x / 2.59 || z > -0.13394) {
                double l = MathFunctions.rexpm1(z);
                double q = ((l + 0.5 + 0.5) * j - l) * g - h;
                if (q <= 0.0) {
                    return 0.0;
                }
                return q * Math.exp(-log_r);
            }
            double p = Math.exp(z) * g * (0.5 - j + 0.5);
            return (0.5 - p + 0.5) * Math.exp(-log_r);
        }
        double a2n_1 = 1.0;
        double a2n = 1.0;
        double b2n_1 = x;
        double b2n = x + (1.0 - a);
        double c = 1.0;
        while (Math.abs((an0 = (a2n = (a2n_1 = x * a2n + c * a2n_1) + (c_a = (c += 1.0) - a) * a2n) / (b2n = (b2n_1 = x * b2n + c * b2n_1) + c_a * b2n)) - (am0 = a2n_1 / b2n_1)) >= eps * an0) {
        }
        return an0;
    }

    public static final double basym(double a, double b, double lambda, double eps, boolean log_p) {
        double w0;
        double r1;
        double r0;
        double h;
        double t;
        int num_IT = 20;
        int nip1 = 21;
        double e0 = 1.12837916709551;
        double e1 = 0.353553390593274;
        double ln_e0 = 0.120782237635245;
        double[] a0 = new double[21];
        double[] b0 = new double[21];
        double[] c = new double[21];
        double[] d = new double[21];
        double f = a * MathFunctions.rlog1(-lambda / a) + b * MathFunctions.rlog1(lambda / b);
        if (log_p) {
            t = -f;
        } else {
            t = Math.exp(-f);
            if (t == 0.0) {
                return 0.0;
            }
        }
        double z0 = Math.sqrt(f);
        double z = z0 / 0.353553390593274 * 0.5;
        double z2 = f + f;
        if (a < b) {
            h = a / b;
            r0 = 1.0 / (h + 1.0);
            r1 = (b - a) / b;
            w0 = 1.0 / Math.sqrt(a * (h + 1.0));
        } else {
            h = b / a;
            r0 = 1.0 / (h + 1.0);
            r1 = (b - a) / a;
            w0 = 1.0 / Math.sqrt(b * (h + 1.0));
        }
        a0[0] = r1 * 0.6666666666666666;
        c[0] = a0[0] * -0.5;
        d[0] = -c[0];
        double j0 = 0.4431134627263801 * MathFunctions.erfc1(1, z0);
        double j1 = 0.353553390593274;
        double sum = j0 + d[0] * w0 * j1;
        double s = 1.0;
        double h2 = h * h;
        double hn = 1.0;
        double w = w0;
        double znm1 = z;
        double zn = z2;
        for (int n = 2; n <= 20; n += 2) {
            a0[n - 1] = r0 * 2.0 * (h * (hn *= h2) + 1.0) / ((double)n + 2.0);
            int np1 = n + 1;
            a0[np1 - 1] = r1 * 2.0 * (s += hn) / ((double)n + 3.0);
            for (int i = n; i <= np1; ++i) {
                int j;
                double r = ((double)i + 1.0) * -0.5;
                b0[0] = r * a0[0];
                for (int m = 2; m <= i; ++m) {
                    double bsum = 0.0;
                    int mm1 = m - 1;
                    for (j = 1; j <= mm1; ++j) {
                        int mmj = m - j;
                        bsum += ((double)j * r - (double)mmj) * a0[j - 1] * b0[mmj - 1];
                    }
                    b0[mm1] = r * a0[mm1] + bsum / (double)m;
                }
                int im1 = i - 1;
                c[im1] = b0[im1] / ((double)i + 1.0);
                double dsum = 0.0;
                for (j = 1; j <= im1; ++j) {
                    dsum += d[im1 - j] * c[j - 1];
                }
                d[im1] = -(dsum + c[im1]);
            }
            j0 = 0.353553390593274 * znm1 + ((double)n - 1.0) * j0;
            j1 = 0.353553390593274 * zn + (double)n * j1;
            znm1 = z2 * znm1;
            zn = z2 * zn;
            double t0 = d[n - 1] * (w *= w0) * j0;
            double t1 = d[np1 - 1] * (w *= w0) * j1;
            if (Math.abs(t0) + Math.abs(t1) <= eps * (sum += t0 + t1)) break;
        }
        if (log_p) {
            return 0.120782237635245 + t - MathFunctions.bcorr(a, b) + Math.log(sum);
        }
        double u = Math.exp(-MathFunctions.bcorr(a, b));
        return 1.12837916709551 * t * u * sum;
    }

    public static final double exparg(int l) {
        double lnb = 0.69314718055995;
        int m = l == 0 ? 1024 : -1022;
        return (double)m * 0.69314718055995 * 0.99999;
    }

    public static final double esum(int mu, double x, boolean give_log) {
        if (give_log) {
            return x + (double)mu;
        }
        double w = (double)mu + x;
        if (x > 0.0 ? mu > 0 || w < 0.0 : mu < 0 || w > 0.0) {
            return Math.exp(mu) * Math.exp(x);
        }
        return Math.exp(w);
    }

    public static final double rexpm1(double x) {
        double p1 = 9.14041914819518E-10;
        double p2 = 0.0238082361044469;
        double q1 = -0.499999999085958;
        double q2 = 0.107141568980644;
        double q3 = -0.0119041179760821;
        double q4 = 5.95130811860248E-4;
        if (Math.abs(x) <= 0.15) {
            return x * (((0.0238082361044469 * x + 9.14041914819518E-10) * x + 1.0) / ((((5.95130811860248E-4 * x + -0.0119041179760821) * x + 0.107141568980644) * x + -0.499999999085958) * x + 1.0));
        }
        double w = Math.exp(x);
        if (x > 0.0) {
            return w * (0.5 - 1.0 / w + 0.5);
        }
        return w - 0.5 - 0.5;
    }

    public static final double alnrel(double a) {
        if (Math.abs(a) > 0.375) {
            return Math.log(1.0 + a);
        }
        double p1 = -1.29418923021993;
        double p2 = 0.405303492862024;
        double p3 = -0.0178874546012214;
        double q1 = -1.62752256355323;
        double q2 = 0.747811014037616;
        double q3 = -0.0845104217945565;
        double t = a / (a + 2.0);
        double t2 = t * t;
        double w = (((-0.0178874546012214 * t2 + 0.405303492862024) * t2 + -1.29418923021993) * t2 + 1.0) / (((-0.0845104217945565 * t2 + 0.747811014037616) * t2 + -1.62752256355323) * t2 + 1.0);
        return t * 2.0 * w;
    }

    public static final double rlog1(double x) {
        double w1;
        double h;
        double a = 0.0566749439387324;
        double b = 0.0456512608815524;
        double p0 = 0.333333333333333;
        double p1 = -0.224696413112536;
        double p2 = 0.00620886815375787;
        double q1 = -1.27408923933623;
        double q2 = 0.354508718369557;
        if (x < -0.39 || x > 0.57) {
            double w = x + 0.5 + 0.5;
            return x - Math.log(w);
        }
        if (x < -0.18) {
            h = x + 0.3;
            w1 = 0.0566749439387324 - (h /= 0.7) * 0.3;
        } else if (x > 0.18) {
            h = x * 0.75 - 0.25;
            w1 = 0.0456512608815524 + h / 3.0;
        } else {
            h = x;
            w1 = 0.0;
        }
        double r = h / (h + 2.0);
        double t = r * r;
        double w = ((0.00620886815375787 * t + -0.224696413112536) * t + 0.333333333333333) / ((0.354508718369557 * t + -1.27408923933623) * t + 1.0);
        return t * 2.0 * (1.0 / (1.0 - r) - r * w) + w1;
    }

    public static final double erf__(double x) {
        double c = 0.564189583547756;
        double[] a = new double[]{7.7105849500132E-5, -0.00133733772997339, 0.0323076579225834, 0.0479137145607681, 0.128379167095513};
        double[] b = new double[]{0.00301048631703895, 0.0538971687740286, 0.375795757275549};
        double[] p = new double[]{-1.36864857382717E-7, 0.564195517478974, 7.21175825088309, 43.1622272220567, 152.98928504694, 339.320816734344, 451.918953711873, 300.459261020162};
        double[] q = new double[]{1.0, 12.7827273196294, 77.0001529352295, 277.585444743988, 638.980264465631, 931.35409485061, 790.950925327898, 300.459260956983};
        double[] r = new double[]{2.10144126479064, 26.2370141675169, 21.3688200555087, 4.6580782871847, 0.282094791773523};
        double[] s = new double[]{94.153775055546, 187.11481179959, 99.0191814623914, 18.0124575948747};
        double ax = Math.abs(x);
        if (ax <= 0.5) {
            double t = x * x;
            double top = (((a[0] * t + a[1]) * t + a[2]) * t + a[3]) * t + a[4] + 1.0;
            double bot = ((b[0] * t + b[1]) * t + b[2]) * t + 1.0;
            return x * (top / bot);
        }
        if (ax <= 4.0) {
            double top = ((((((p[0] * ax + p[1]) * ax + p[2]) * ax + p[3]) * ax + p[4]) * ax + p[5]) * ax + p[6]) * ax + p[7];
            double bot = ((((((q[0] * ax + q[1]) * ax + q[2]) * ax + q[3]) * ax + q[4]) * ax + q[5]) * ax + q[6]) * ax + q[7];
            double ret_val = 0.5 - Math.exp(-x * x) * top / bot + 0.5;
            if (x < 0.0) {
                ret_val = -ret_val;
            }
            return ret_val;
        }
        if (ax >= 5.8) {
            return x > 0.0 ? 1.0 : -1.0;
        }
        double x2 = x * x;
        double t = 1.0 / x2;
        double top = (((r[0] * t + r[1]) * t + r[2]) * t + r[3]) * t + r[4];
        double bot = (((s[0] * t + s[1]) * t + s[2]) * t + s[3]) * t + 1.0;
        t = (0.564189583547756 - top / (x2 * bot)) / ax;
        double ret_val = 0.5 - Math.exp(-x2) * t + 0.5;
        if (x < 0.0) {
            ret_val = -ret_val;
        }
        return ret_val;
    }

    public static final double erfc1(int ind, double x) {
        double t;
        double ret_val;
        double c = 0.564189583547756;
        double[] a = new double[]{7.7105849500132E-5, -0.00133733772997339, 0.0323076579225834, 0.0479137145607681, 0.128379167095513};
        double[] b = new double[]{0.00301048631703895, 0.0538971687740286, 0.375795757275549};
        double[] p = new double[]{-1.36864857382717E-7, 0.564195517478974, 7.21175825088309, 43.1622272220567, 152.98928504694, 339.320816734344, 451.918953711873, 300.459261020162};
        double[] q = new double[]{1.0, 12.7827273196294, 77.0001529352295, 277.585444743988, 638.980264465631, 931.35409485061, 790.950925327898, 300.459260956983};
        double[] r = new double[]{2.10144126479064, 26.2370141675169, 21.3688200555087, 4.6580782871847, 0.282094791773523};
        double[] s = new double[]{94.153775055546, 187.11481179959, 99.0191814623914, 18.0124575948747};
        double ax = Math.abs(x);
        if (ax <= 0.5) {
            double t2 = x * x;
            double top = (((a[0] * t2 + a[1]) * t2 + a[2]) * t2 + a[3]) * t2 + a[4] + 1.0;
            double bot = ((b[0] * t2 + b[1]) * t2 + b[2]) * t2 + 1.0;
            double ret_val2 = 0.5 - x * (top / bot) + 0.5;
            if (ind != 0) {
                ret_val2 = Math.exp(t2) * ret_val2;
            }
            return ret_val2;
        }
        if (ax <= 4.0) {
            double top = ((((((p[0] * ax + p[1]) * ax + p[2]) * ax + p[3]) * ax + p[4]) * ax + p[5]) * ax + p[6]) * ax + p[7];
            double bot = ((((((q[0] * ax + q[1]) * ax + q[2]) * ax + q[3]) * ax + q[4]) * ax + q[5]) * ax + q[6]) * ax + q[7];
            ret_val = top / bot;
        } else {
            if (x <= -5.6) {
                double ret_val3 = 2.0;
                if (ind != 0) {
                    ret_val3 = Math.exp(x * x) * 2.0;
                }
                return ret_val3;
            }
            if (ind == 0 && (x > 100.0 || x * x > -MathFunctions.exparg(1))) {
                return 0.0;
            }
            t = 1.0 / (x * x);
            double top = (((r[0] * t + r[1]) * t + r[2]) * t + r[3]) * t + r[4];
            double bot = (((s[0] * t + s[1]) * t + s[2]) * t + s[3]) * t + 1.0;
            ret_val = (0.564189583547756 - t * top / bot) / ax;
        }
        if (ind != 0) {
            if (x < 0.0) {
                ret_val = Math.exp(x * x) * 2.0 - ret_val;
            }
        } else {
            double w;
            t = w = x * x;
            double e = w - t;
            ret_val = (0.5 - e + 0.5) * Math.exp(-t) * ret_val;
            if (x < 0.0) {
                ret_val = 2.0 - ret_val;
            }
        }
        return ret_val;
    }

    public static final double gam1(double a) {
        double[] p = new double[]{0.577215664901533, -0.409078193005776, -0.230975380857675, 0.0597275330452234, 0.0076696818164949, -0.00514889771323592, 5.89597428611429E-4};
        double[] q = new double[]{1.0, 0.427569613095214, 0.158451672430138, 0.0261132021441447, 0.00423244297896961};
        double[] r = new double[]{-0.422784335098468, -0.771330383816272, -0.244757765222226, 0.118378989872749, 9.30357293360349E-4, -0.0118290993445146, 0.00223047661158249, 2.66505979058923E-4, -1.32674909766242E-4};
        double s1 = 0.273076135303957;
        double s2 = 0.0559398236957378;
        double t = a;
        double d = a - 0.5;
        if (d > 0.0) {
            t = d - 0.5;
        }
        if (t < 0.0) {
            double top = (((((((r[8] * t + r[7]) * t + r[6]) * t + r[5]) * t + r[4]) * t + r[3]) * t + r[2]) * t + r[1]) * t + r[0];
            double bot = (0.0559398236957378 * t + 0.273076135303957) * t + 1.0;
            double w = top / bot;
            if (d > 0.0) {
                return t * w / a;
            }
            return a * (w + 0.5 + 0.5);
        }
        if (t == 0.0) {
            return 0.0;
        }
        double top = (((((p[6] * t + p[5]) * t + p[4]) * t + p[3]) * t + p[2]) * t + p[1]) * t + p[0];
        double bot = (((q[4] * t + q[3]) * t + q[2]) * t + q[1]) * t + 1.0;
        double w = top / bot;
        if (d > 0.0) {
            return t / a * (w - 0.5 - 0.5);
        }
        return a * w;
    }

    public static final double gamln1(double a) {
        double p0 = 0.577215664901533;
        double p1 = 0.844203922187225;
        double p2 = -0.168860593646662;
        double p3 = -0.780427615533591;
        double p4 = -0.402055799310489;
        double p5 = -0.0673562214325671;
        double p6 = -0.00271935708322958;
        double q1 = 2.88743195473681;
        double q2 = 3.12755088914843;
        double q3 = 1.56875193295039;
        double q4 = 0.361951990101499;
        double q5 = 0.0325038868253937;
        double q6 = 6.67465618796164E-4;
        double r0 = 0.422784335098467;
        double r1 = 0.848044614534529;
        double r2 = 0.565221050691933;
        double r3 = 0.156513060486551;
        double r4 = 0.017050248402265;
        double r5 = 4.97958207639485E-4;
        double s1 = 1.24313399877507;
        double s2 = 0.548042109832463;
        double s3 = 0.10155218743983;
        double s4 = 0.00713309612391;
        double s5 = 1.16165475989616E-4;
        if (a < 0.6) {
            double w = ((((((-0.00271935708322958 * a + -0.0673562214325671) * a + -0.402055799310489) * a + -0.780427615533591) * a + -0.168860593646662) * a + 0.844203922187225) * a + 0.577215664901533) / ((((((6.67465618796164E-4 * a + 0.0325038868253937) * a + 0.361951990101499) * a + 1.56875193295039) * a + 3.12755088914843) * a + 2.88743195473681) * a + 1.0);
            return -a * w;
        }
        double x = a - 0.5 - 0.5;
        double w = (((((4.97958207639485E-4 * x + 0.017050248402265) * x + 0.156513060486551) * x + 0.565221050691933) * x + 0.848044614534529) * x + 0.422784335098467) / (((((1.16165475989616E-4 * x + 0.00713309612391) * x + 0.10155218743983) * x + 0.548042109832463) * x + 1.24313399877507) * x + 1.0);
        return x * w;
    }

    public static final double psi(double x) {
        double w;
        double piov4 = 0.785398163397448;
        double dx0 = 1.4616321449683622;
        double[] p1 = new double[]{0.0089538502298197, 4.77762828042627, 142.441585084029, 1186.45200713425, 3633.51846806499, 4138.10161269013, 1305.60269827897};
        double[] q1 = new double[]{44.8452573429826, 520.752771467162, 2210.0079924783, 3641.27349079381, 1908.310765963, 6.91091682714533E-6};
        double[] p2 = new double[]{-2.12940445131011, -7.01677227766759, -4.48616543918019, -0.648157123766197};
        double[] q2 = new double[]{32.2703493791143, 89.2920700481861, 54.6117738103215, 7.77788548522962};
        double xmax1 = 2.147483647E9;
        double d2 = 4.503599627370496E15;
        if (xmax1 > d2) {
            xmax1 = d2;
        }
        double xsmall = 1.0E-9;
        double aug = 0.0;
        if (x < 0.5) {
            if (Math.abs(x) <= xsmall) {
                if (x == 0.0) {
                    return 0.0;
                }
                aug = -1.0 / x;
            } else {
                w = -x;
                double sgn = 0.785398163397448;
                if (w <= 0.0) {
                    w = -w;
                    sgn = -sgn;
                }
                if (w >= xmax1) {
                    return 0.0;
                }
                int nq = (int)w;
                w -= (double)nq;
                nq = (int)(w * 4.0);
                w = (w - (double)nq * 0.25) * 4.0;
                int n = nq / 2;
                if (n + n != nq) {
                    w = 1.0 - w;
                }
                double z = 0.785398163397448 * w;
                int m = n / 2;
                if (m + m != n) {
                    sgn = -sgn;
                }
                n = (nq + 1) / 2;
                m = n / 2;
                if ((m += m) == n) {
                    if (z == 0.0) {
                        return 0.0;
                    }
                    aug = sgn * (Math.cos(z) / Math.sin(z) * 4.0);
                } else {
                    aug = sgn * (Math.sin(z) / Math.cos(z) * 4.0);
                }
            }
            x = 1.0 - x;
        }
        if (x <= 3.0) {
            double den = x;
            double upper = p1[0] * x;
            for (int i = 1; i <= 5; ++i) {
                den = (den + q1[i - 1]) * x;
                upper = (upper + p1[i]) * x;
            }
            den = (upper + p1[6]) / (den + q1[5]);
            double xmx0 = x - 1.4616321449683622;
            return den * xmx0 + aug;
        }
        if (x < xmax1) {
            double den = w = 1.0 / (x * x);
            double upper = p2[0] * w;
            for (int i = 1; i <= 3; ++i) {
                den = (den + q2[i - 1]) * w;
                upper = (upper + p2[i]) * w;
            }
            aug = upper / (den + q2[3]) - 0.5 / x + aug;
        }
        return aug + Math.log(x);
    }

    public static final double betaln(double a0, double b0) {
        double v;
        double a = Math.min(a0, b0);
        double b = Math.max(a0, b0);
        if (a < 8.0) {
            if (a < 1.0) {
                if (b < 8.0) {
                    return MathFunctions.gamln(a) + (MathFunctions.gamln(b) - MathFunctions.gamln(a + b));
                }
                return MathFunctions.gamln(a) + MathFunctions.algdiv(a, b);
            }
            if (a < 2.0) {
                if (b <= 2.0) {
                    return MathFunctions.gamln(a) + MathFunctions.gamln(b) - MathFunctions.gsumln(a, b);
                }
                double w = 0.0;
                if (b < 8.0) {
                    int n = (int)(b - 1.0);
                    double z = 1.0;
                    for (int i = 1; i <= n; ++i) {
                        z *= (b += -1.0) / (a + b);
                    }
                    return w + Math.log(z) + (MathFunctions.gamln(a) + (MathFunctions.gamln(b) - MathFunctions.gsumln(a, b)));
                }
                return MathFunctions.gamln(a) + MathFunctions.algdiv(a, b);
            }
            if (b <= 1000.0) {
                int n = (int)(a - 1.0);
                double w = 1.0;
                for (int i = 1; i <= n; ++i) {
                    double h = (a += -1.0) / b;
                    w *= h / (h + 1.0);
                }
                w = Math.log(w);
                if (b >= 8.0) {
                    return w + MathFunctions.gamln(a) + MathFunctions.algdiv(a, b);
                }
                n = (int)(b - 1.0);
                double z = 1.0;
                for (int i = 1; i <= n; ++i) {
                    z *= (b += -1.0) / (a + b);
                }
                return w + Math.log(z) + (MathFunctions.gamln(a) + (MathFunctions.gamln(b) - MathFunctions.gsumln(a, b)));
            }
            int n = (int)(a - 1.0);
            double w = 1.0;
            for (int i = 1; i <= n; ++i) {
                w *= (a += -1.0) / (a / b + 1.0);
            }
            return Math.log(w) - (double)n * Math.log(b) + (MathFunctions.gamln(a) + MathFunctions.algdiv(a, b));
        }
        double w = MathFunctions.bcorr(a, b);
        double h = a / b;
        double u = -(a - 0.5) * Math.log(h / (h + 1.0));
        if (u > (v = b * MathFunctions.alnrel(h))) {
            return Math.log(b) * -0.5 + 0.9189385332046728 + w - v - u;
        }
        return Math.log(b) * -0.5 + 0.9189385332046728 + w - u - v;
    }

    public static final double gsumln(double a, double b) {
        double x = a + b - 2.0;
        if (x <= 0.25) {
            return MathFunctions.gamln1(x + 1.0);
        }
        if (x <= 1.25) {
            return MathFunctions.gamln1(x) + MathFunctions.alnrel(x);
        }
        return MathFunctions.gamln1(x - 1.0) + Math.log(x * (x + 1.0));
    }

    public static final double bcorr(double a0, double b0) {
        double c0 = 0.0833333333333333;
        double c1 = -0.00277777777760991;
        double c2 = 7.9365066682539E-4;
        double c3 = -5.9520293135187E-4;
        double c4 = 8.37308034031215E-4;
        double c5 = -0.00165322962780713;
        double a = Math.min(a0, b0);
        double b = Math.max(a0, b0);
        double h = a / b;
        double c = h / (h + 1.0);
        double x = 1.0 / (h + 1.0);
        double x2 = x * x;
        double s3 = x + x2 + 1.0;
        double s5 = x + x2 * s3 + 1.0;
        double s7 = x + x2 * s5 + 1.0;
        double s9 = x + x2 * s7 + 1.0;
        double s11 = x + x2 * s9 + 1.0;
        double r1 = 1.0 / b;
        double t = r1 * r1;
        double w = ((((-0.00165322962780713 * s11 * t + 8.37308034031215E-4 * s9) * t + -5.9520293135187E-4 * s7) * t + 7.9365066682539E-4 * s5) * t + -0.00277777777760991 * s3) * t + 0.0833333333333333;
        r1 = 1.0 / a;
        t = r1 * r1;
        return (((((-0.00165322962780713 * t + 8.37308034031215E-4) * t + -5.9520293135187E-4) * t + 7.9365066682539E-4) * t + -0.00277777777760991) * t + 0.0833333333333333) / a + (w *= c / b);
    }

    public static final double algdiv(double a, double b) {
        double d;
        double x;
        double c;
        double c0 = 0.0833333333333333;
        double c1 = -0.00277777777760991;
        double c2 = 7.9365066682539E-4;
        double c3 = -5.9520293135187E-4;
        double c4 = 8.37308034031215E-4;
        double c5 = -0.00165322962780713;
        if (a > b) {
            double h = b / a;
            c = 1.0 / (h + 1.0);
            x = h / (h + 1.0);
            d = a + (b - 0.5);
        } else {
            double h = a / b;
            c = h / (h + 1.0);
            x = 1.0 / (h + 1.0);
            d = b + (a - 0.5);
        }
        double x2 = x * x;
        double s3 = x + x2 + 1.0;
        double s5 = x + x2 * s3 + 1.0;
        double s7 = x + x2 * s5 + 1.0;
        double s9 = x + x2 * s7 + 1.0;
        double s11 = x + x2 * s9 + 1.0;
        double t = 1.0 / (b * b);
        double w = ((((-0.00165322962780713 * s11 * t + 8.37308034031215E-4 * s9) * t + -5.9520293135187E-4 * s7) * t + 7.9365066682539E-4 * s5) * t + -0.00277777777760991 * s3) * t + 0.0833333333333333;
        w *= c / b;
        double u = d * MathFunctions.alnrel(a / b);
        double v = a * (Math.log(b) - 1.0);
        if (u > v) {
            return w - v - u;
        }
        return w - u - v;
    }

    public static final double gamln(double a) {
        double d = 0.418938533204673;
        double c0 = 0.0833333333333333;
        double c1 = -0.00277777777760991;
        double c2 = 7.9365066682539E-4;
        double c3 = -5.9520293135187E-4;
        double c4 = 8.37308034031215E-4;
        double c5 = -0.00165322962780713;
        if (a <= 0.8) {
            return MathFunctions.gamln1(a) - Math.log(a);
        }
        if (a <= 2.25) {
            return MathFunctions.gamln1(a - 0.5 - 0.5);
        }
        if (a < 10.0) {
            int n = (int)(a - 1.25);
            double t = a;
            double w = 1.0;
            for (int i = 1; i <= n; ++i) {
                w *= (t += -1.0);
            }
            return MathFunctions.gamln1(t - 1.0) + Math.log(w);
        }
        double t = 1.0 / (a * a);
        double w = (((((-0.00165322962780713 * t + 8.37308034031215E-4) * t + -5.9520293135187E-4) * t + 7.9365066682539E-4) * t + -0.00277777777760991) * t + 0.0833333333333333) / a;
        return 0.418938533204673 + w + (a - 0.5) * (Math.log(a) - 1.0);
    }

    public static final double beta(double a, double b) {
        double xmax = 171.61447887182297;
        double lnsml = -708.3964185322641;
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return a + b;
        }
        if (a < 0.0 || b < 0.0) {
            return Double.NaN;
        }
        if (a == 0.0 || b == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (MathFunctions.isInfinite(a) || MathFunctions.isInfinite(b)) {
            return 0.0;
        }
        if (a + b < 171.61447887182297) {
            return 1.0 / MathFunctions.gammafn(a + b) * MathFunctions.gammafn(a) * MathFunctions.gammafn(b);
        }
        double val = MathFunctions.lbeta(a, b);
        if (val < -708.3964185322641) {
            return Double.NaN;
        }
        return Math.exp(val);
    }

    private static final double lfastchoose(double n, double k) {
        return -Math.log(n + 1.0) - MathFunctions.lbeta(n - k + 1.0, k + 1.0);
    }

    private static final double lfastchoose2(double n, double k, int[] s_choose) {
        double r = MathFunctions.lgammafn_sign(n - k + 1.0, s_choose);
        return MathFunctions.lgammafn(n + 1.0) - MathFunctions.lgammafn(k + 1.0) - r;
    }

    public static final double lchoose(double n, double k) {
        double k0 = k;
        k = Math.rint(k);
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return n + k;
        }
        if (Math.abs(k - k0) > 1.0E-7) {
            System.err.println(String.format("'k' (%.2f) must be integer, rounded to %.0f", k0, k));
        }
        if (k < 2.0) {
            if (k < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (k == 0.0) {
                return 0.0;
            }
            return Math.log(Math.abs(n));
        }
        if (n < 0.0) {
            return MathFunctions.lchoose(-n + k - 1.0, k);
        }
        if (!MathFunctions.isNonInt(n)) {
            if (n < k) {
                return Double.NEGATIVE_INFINITY;
            }
            if (n - k < 2.0) {
                return MathFunctions.lchoose(n, n - k);
            }
            return MathFunctions.lfastchoose(n, k);
        }
        if (n < k - 1.0) {
            return MathFunctions.lfastchoose2(n, k, null);
        }
        return MathFunctions.lfastchoose(n, k);
    }

    public static final double choose(double n, double k) {
        int k_small_max = 30;
        double k0 = k;
        k = Math.rint(k);
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return n + k;
        }
        if (Math.abs(k - k0) > 1.0E-7) {
            System.err.println(String.format("'k' (%.2f) must be integer, rounded to %.0f", k0, k));
        }
        if (k < 30.0) {
            if (n - k < k && n >= 0.0 && !MathFunctions.isNonInt(n)) {
                k = n - k;
            }
            if (k < 0.0) {
                return 0.0;
            }
            if (k == 0.0) {
                return 1.0;
            }
            double r = n;
            int j = 2;
            while ((double)j <= k) {
                r *= (n - (double)j + 1.0) / (double)j;
                ++j;
            }
            return !MathFunctions.isNonInt(n) ? Math.rint(r) : r;
        }
        if (n < 0.0) {
            double r = MathFunctions.choose(-n + k - 1.0, k);
            if (k != 2.0 * Math.floor(k / 2.0)) {
                r = -r;
            }
            return r;
        }
        if (!MathFunctions.isNonInt(n)) {
            if (n < k) {
                return 0.0;
            }
            if (n - k < 30.0) {
                return MathFunctions.choose(n, n - k);
            }
            return Math.rint(Math.exp(MathFunctions.lfastchoose(n, k)));
        }
        if (n < k - 1.0) {
            int[] s_choose = new int[]{1};
            double r = MathFunctions.lfastchoose2(n, k, s_choose);
            return (double)s_choose[0] * Math.exp(r);
        }
        return Math.exp(MathFunctions.lfastchoose(n, k));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final double gamma_cody(double x) {
        double res;
        double yi;
        double xbig = 171.624;
        double[] p = new double[]{-1.716185138865495, 24.76565080557592, -379.80425647094563, 629.3311553128184, 866.9662027904133, -31451.272968848367, -36144.413418691176, 66456.14382024054};
        double[] q = new double[]{-30.840230011973897, 315.35062697960416, -1015.1563674902192, -3107.771671572311, 22538.11842098015, 4755.846277527881, -134659.9598649693, -115132.25967555349};
        double[] c = new double[]{-0.001910444077728, 8.4171387781295E-4, -5.952379913043012E-4, 7.936507935003503E-4, -0.0027777777777776816, 0.08333333333333333, 0.0057083835261};
        boolean parity = false;
        double fact = 1.0;
        long n = 0L;
        double y = x;
        if (y <= 0.0) {
            y = -x;
            yi = MathFunctions.trunc(y);
            res = y - yi;
            if (res == 0.0) return Double.POSITIVE_INFINITY;
            if (yi != MathFunctions.trunc(yi * 0.5) * 2.0) {
                parity = true;
            }
            fact = -Math.PI / MathFunctions.sinpi(res);
            y += 1.0;
        }
        if (y < 2.220446049250313E-16) {
            if (!(y >= Double.MIN_NORMAL)) return Double.POSITIVE_INFINITY;
            res = 1.0 / y;
        } else if (y < 12.0) {
            int i;
            double z;
            yi = y;
            if (y < 1.0) {
                z = y;
                y += 1.0;
            } else {
                n = (long)y - 1L;
                z = (y -= (double)n) - 1.0;
            }
            double xnum = 0.0;
            double xden = 1.0;
            for (i = 0; i < 8; ++i) {
                xnum = (xnum + p[i]) * z;
                xden = xden * z + q[i];
            }
            res = xnum / xden + 1.0;
            if (yi < y) {
                res /= yi;
            } else if (yi > y) {
                i = 0;
                while ((long)i < n) {
                    res *= y;
                    y += 1.0;
                    ++i;
                }
            }
        } else {
            if (!(y <= 171.624)) return Double.POSITIVE_INFINITY;
            double ysq = y * y;
            double sum = c[6];
            for (int i = 0; i < 6; ++i) {
                sum = sum / ysq + c[i];
            }
            sum = sum / y - y + 0.9189385332046728;
            res = Math.exp(sum += (y - 0.5) * Math.log(y));
        }
        if (parity) {
            res = -res;
        }
        if (fact == 1.0) return res;
        return fact / res;
    }

    public static final double pd_upper_series(double x, double y, boolean log_p) {
        double term;
        double sum = term = x / y;
        while ((term *= x / (y += 1.0)) > (sum += term) * 2.220446049250313E-16) {
        }
        return log_p ? Math.log(sum) : sum;
    }

    public static final double pd_lower_cf(double y, double d) {
        double b2;
        double f = 0.0;
        int max_it = 200000;
        if (y == 0.0) {
            return 0.0;
        }
        double f0 = y / d;
        if (Math.abs(y - 1.0) < Math.abs(d) * 2.220446049250313E-16) {
            return f0;
        }
        if (f0 > 1.0) {
            f0 = 1.0;
        }
        double c2 = y;
        double c4 = d;
        double a1 = 0.0;
        double b1 = 1.0;
        double a2 = y;
        for (b2 = d; b2 > 1.157920892373162E77; b2 /= 1.157920892373162E77) {
            a1 /= 1.157920892373162E77;
            b1 /= 1.157920892373162E77;
            a2 /= 1.157920892373162E77;
        }
        double i = 0.0;
        double of = -1.0;
        while (i < 200000.0) {
            double c3 = (i += 1.0) * (c2 -= 1.0);
            a1 = (c4 += 2.0) * a2 + c3 * a1;
            b1 = c4 * b2 + c3 * b1;
            c3 = (i += 1.0) * (c2 -= 1.0);
            a2 = (c4 += 2.0) * a1 + c3 * a2;
            if ((b2 = c4 * b1 + c3 * b2) > 1.157920892373162E77) {
                a1 /= 1.157920892373162E77;
                b1 /= 1.157920892373162E77;
                a2 /= 1.157920892373162E77;
                b2 /= 1.157920892373162E77;
            }
            if (b2 == 0.0) continue;
            f = a2 / b2;
            if (Math.abs(f - of) <= 2.220446049250313E-16 * Math.max(f0, Math.abs(f))) {
                return f;
            }
            of = f;
        }
        return f;
    }

    public static final double pd_lower_series(double lambda, double y) {
        double term = 1.0;
        double sum = 0.0;
        while (y >= 1.0 && term > sum * 2.220446049250313E-16) {
            sum += (term *= y / lambda);
            y -= 1.0;
        }
        if (y != Math.floor(y)) {
            double f = MathFunctions.pd_lower_cf(y, lambda + 1.0 - y);
            sum += term * f;
        }
        return sum;
    }

    public static final double _expm1(double x) {
        double a = Math.abs(x);
        if (a < 2.220446049250313E-16) {
            return x;
        }
        if (a > 0.697) {
            return Math.exp(x) - 1.0;
        }
        double y = a > 1.0E-8 ? Math.exp(x) - 1.0 : (x / 2.0 + 1.0) * x;
        y -= (1.0 + y) * (Math.log1p(y) - x);
        return y;
    }

    public static final double _log1p(double x) {
        double[] alnrcs = new double[]{1.037869356274377, -0.13364301504908918, 0.019408249135520562, -0.0030107551127535777, 4.869461479715485E-4, -8.105488189317536E-5, 1.3778847799559525E-5, -2.380221089435897E-6, 4.1640416213865184E-7, -7.359582837807599E-8, 1.3117611876241675E-8, -2.3546709317742423E-9, 4.2522773276035E-10, -7.71908941348408E-11, 1.407574648135907E-11, -2.5769072058024682E-12, 4.734240666629442E-13, -8.724901267474264E-14, 1.612461490274055E-14, -2.9875652015665774E-15, 5.548070120908289E-16, -1.0324619158271569E-16, 1.9250239203049852E-17, -3.595507346526515E-18, 6.726454253787686E-19, -1.260262416873522E-19, 2.364488440860621E-20, -4.4419377050807936E-21, 8.354659446403425E-22, -1.5731559416479563E-22, 2.9653128740247425E-23, -5.594958348181595E-24, 1.056635426883568E-24, -1.9972483680670205E-25, 3.778297781883936E-26, -7.153158688908174E-27, 1.3552488463674214E-27, -2.5694673048487566E-28, 4.8747756066216946E-29, -9.254211253084972E-30, 1.757859784176024E-30, -3.341002667773101E-31, 6.353393618023618E-32};
        int nlnrel = 22;
        double xmin = -0.999999985;
        if (x == 0.0) {
            return 0.0;
        }
        if (x == -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x < -1.0) {
            return Double.NaN;
        }
        if (Math.abs(x) <= 0.375) {
            if (Math.abs(x) < (double)1.110223E-16f) {
                return x;
            }
            if (0.0 < x && x < 1.0E-8 || -1.0E-9 < x && x < 0.0) {
                return x * (1.0 - 0.5 * x);
            }
            return x * (1.0 - x * MathFunctions.chebyshev_eval(x / 0.375, alnrcs, 22));
        }
        if (x < -0.999999985) {
            System.err.println("Precision loss warning at log1p");
        }
        return Math.log(1.0 + x);
    }

    public static final double gharmonic(int n) {
        return MathFunctions.gharmonic(n, 1.0, 0.0);
    }

    public static final double gharmonic(int n, double s) {
        return MathFunctions.gharmonic(n, s, 0.0);
    }

    public static final double gharmonic(int n, double s, double logexponent) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        double sum = 0.0;
        if (logexponent != 0.0) {
            for (int i = 2; i <= n; ++i) {
                sum += Math.pow(Math.log(i), logexponent) * Math.pow(i, -s);
            }
        } else {
            for (int i = 1; i <= n; ++i) {
                sum += Math.pow(i, -s);
            }
        }
        return sum;
    }

    public static final double lgharmonic(int n) {
        return MathFunctions.lgharmonic(n, 1.0, 0.0);
    }

    public static final double lgharmonic(int n, double s) {
        return MathFunctions.lgharmonic(n, s, 0.0);
    }

    public static final double lgharmonic(int n, double s, double logexponent) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        double sum = 0.0;
        if (logexponent != 0.0) {
            for (int i = 2; i <= n; ++i) {
                sum = MathFunctions.logspace_add(sum, logexponent * Math.log(Math.log(i)) - s * Math.log(i));
            }
        } else {
            for (int i = 1; i <= n; ++i) {
                sum = MathFunctions.logspace_add(sum, -s * Math.log(i));
            }
        }
        return sum;
    }

    public static final double cospi(double x) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (MathFunctions.isInfinite(x)) {
            return Double.NaN;
        }
        if ((x = Math.abs(x) % 2.0) % 1.0 == 0.5) {
            return 0.0;
        }
        if (x == 1.0) {
            return -1.0;
        }
        if (x == 0.0) {
            return 1.0;
        }
        return Math.cos(Math.PI * x);
    }

    public static final double sinpi(double x) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (MathFunctions.isInfinite(x)) {
            return Double.NaN;
        }
        if ((x %= 2.0) <= -1.0) {
            x += 2.0;
        } else if (x > 1.0) {
            x -= 2.0;
        }
        if (x == 0.0 || x == 1.0) {
            return 0.0;
        }
        if (x == 0.5) {
            return -1.0;
        }
        if (x == -0.5) {
            return 1.0;
        }
        return Math.sin(Math.PI * x);
    }

    public static final double tanpi(double x) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (MathFunctions.isInfinite(x)) {
            return Double.NaN;
        }
        if ((x = Math.abs(x) % 1.0) <= -0.5) {
            x += 1.0;
        } else if (x > 0.5) {
            x -= 1.0;
        }
        return x == 0.0 ? 0.0 : (x == 0.5 ? Double.NaN : Math.tan(Math.PI * x));
    }

    public static final double frexp(double x, int[] i) {
        int j = 0;
        boolean neg = false;
        if (x < 0.0) {
            x = -x;
            neg = true;
        }
        if (x > 1.0) {
            while (x > 1.0) {
                ++j;
                x /= 2.0;
            }
        } else if (x < 0.5) {
            while (x < 0.5) {
                --j;
                x *= 2.0;
            }
        }
        i[0] = j;
        return neg ? -x : x;
    }

    public static final double ldexp(double x, int p) {
        int[] xx = new int[1];
        MathFunctions.frexp(x, xx);
        int MAXSHIFT = 30;
        int old_exp = xx[0];
        if (p > 0) {
            if (p + old_exp > 1023) {
                return x < 0.0 ? -1.7976931348623157E308 : Double.MAX_VALUE;
            }
            while (p > 30) {
                x *= 1.073741824E9;
                p -= 30;
            }
            return x * (double)(1L << p);
        }
        if (p + old_exp < -1023) {
            return 0.0;
        }
        while (p < -30) {
            x *= 9.313225746154785E-10;
            p += 30;
        }
        return x / (double)(1L << -p);
    }

    public static final boolean isNonInt(double x) {
        return Math.abs(x - Math.rint(x)) > 1.0E-7 * Math.max(1.0, Math.abs(x));
    }
}

