/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.disttest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import jdistlib.Ansari;
import jdistlib.Binomial;
import jdistlib.ChiSquare;
import jdistlib.F;
import jdistlib.Normal;
import jdistlib.Poisson;
import jdistlib.SignRank;
import jdistlib.T;
import jdistlib.Wilcoxon;
import jdistlib.disttest.TestKind;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.math.VectorMath;
import jdistlib.math.approx.ApproximationFunction;
import jdistlib.util.Utilities;

public class DistributionTest {
    private static final double[][] qDiptab = new double[][]{{0.125, 0.125, 0.125, 0.125, 0.125, 0.125, 0.125, 0.125, 0.125, 0.125, 0.132559548782689, 0.157497369040235, 0.187401878807559, 0.20726978858736, 0.223755804629222, 0.231796258864192, 0.237263743826779, 0.241992892688593, 0.244369839049632, 0.245966625504691, 0.247439597233262, 0.248230659656638, 0.248754269146416, 0.249302039974259, 0.249459652323225, 0.24974836247845}, {0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.108720593576329, 0.121563798026414, 0.134318918697053, 0.147298798976252, 0.161085025702604, 0.176811998476076, 0.186391796027944, 0.19361253363045, 0.196509139798845, 0.198159967287576, 0.199244279362433, 0.199617527406166, 0.199800941499028, 0.199917081834271, 0.199959029093075, 0.199978395376082, 0.199993151405815, 0.199995525025673, 0.199999835639211}, {0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0924514470941933, 0.103913431059949, 0.113885220640212, 0.123071187137781, 0.13186973390253, 0.140564796497941, 0.14941924112913, 0.159137064572627, 0.164769608513302, 0.179176547392782, 0.191862827995563, 0.202101971042968, 0.213015781111186, 0.219518627282415, 0.224339047394446, 0.229449332154241, 0.232714530449602, 0.236548128358969, 0.2390887911995, 0.240103566436295, 0.244672883617768}, {0.0714285714285714, 0.0714285714285714, 0.0714285714285714, 0.0725717816250742, 0.0817315478539489, 0.0940590181922527, 0.103244490800871, 0.110964599995697, 0.117807846504335, 0.124216086833531, 0.130409013968317, 0.136639642123068, 0.144240669035124, 0.159903395678336, 0.175196553271223, 0.184118659121501, 0.191014396174306, 0.198216795232182, 0.202341010748261, 0.205377566346832, 0.208306562526874, 0.209866047852379, 0.210967576933451, 0.212233348558702, 0.212661038312506, 0.21353618608817}, {0.0625, 0.0625, 0.0656911994503283, 0.0738651136071762, 0.0820045917762512, 0.0922700601131892, 0.0996737189599363, 0.105733531802737, 0.111035129847705, 0.115920055749988, 0.120561479262465, 0.125558759034845, 0.141841067033899, 0.153978303998561, 0.16597856724751, 0.172988528276759, 0.179010413496374, 0.186504388711178, 0.19448404115794, 0.200864297005026, 0.208849997050229, 0.212556040406219, 0.217149174137299, 0.221700076404503, 0.225000835357532, 0.233772919687683}, {0.0555555555555556, 0.0613018090298924, 0.0658615858179315, 0.0732651142535317, 0.0803941629593475, 0.0890432420913848, 0.0950811420297928, 0.0999380897811046, 0.104153560075868, 0.108007802361932, 0.112512617124951, 0.122915033480817, 0.136412639387084, 0.146603784954019, 0.157084065653166, 0.164164643657217, 0.172821674582338, 0.182555283567818, 0.188658833121906, 0.194089120768246, 0.19915700809389, 0.202881598436558, 0.205979795735129, 0.21054115498898, 0.21180033095039, 0.215379914317625}, {0.05, 0.0610132555623269, 0.0651627333214016, 0.0718321619656165, 0.077966212182459, 0.0852835359834564, 0.0903204173707099, 0.0943334983745117, 0.0977817630384725, 0.102180866696628, 0.109960948142951, 0.118844767211587, 0.130462149644819, 0.139611395137099, 0.150961728882481, 0.159684158858235, 0.16719524735674, 0.175419540856082, 0.180611195797351, 0.185286416050396, 0.191203083905044, 0.195805159339184, 0.20029398089673, 0.205651089646219, 0.209682048785853, 0.221530282182963}, {0.0341378172277919, 0.0546284208048975, 0.0572191260231815, 0.0610087367689692, 0.0642657137330444, 0.0692234107989591, 0.0745462114365167, 0.0792030878981762, 0.083621033469191, 0.0881198482202905, 0.093124666680253, 0.0996694393390689, 0.110087496900906, 0.118760769203664, 0.128890475210055, 0.13598356863636, 0.142452483681277, 0.150172816530742, 0.155456133696328, 0.160896499106958, 0.166979407946248, 0.17111793515551, 0.175900505704432, 0.181856676013166, 0.185743454151004, 0.192240563330562}, {0.033718563622065, 0.0474333740698401, 0.0490891387627092, 0.052719998201553, 0.0567795509056742, 0.0620134674468181, 0.0660163872069048, 0.0696506075066401, 0.0733437740592714, 0.0776460662880254, 0.0824558407118372, 0.088344627001737, 0.0972346018122903, 0.105130218270636, 0.114309704281253, 0.120624043335821, 0.126552378036739, 0.13360135382395, 0.138569903791767, 0.14336916123968, 0.148940116394883, 0.152832538183622, 0.156010163618971, 0.161319225839345, 0.165568255916749, 0.175834459522789}, {0.0262674485075642, 0.0395871890405749, 0.0414574606741673, 0.0444462614069956, 0.0473998525042686, 0.0516677370374349, 0.0551037519001622, 0.058265005347493, 0.0614510857304343, 0.0649164408053978, 0.0689178762425442, 0.0739249074078291, 0.0814791379390127, 0.0881689143126666, 0.0960564383013644, 0.101478558893837, 0.10650487144103, 0.112724636524262, 0.117164140184417, 0.121425859908987, 0.126733051889401, 0.131198578897542, 0.133691739483444, 0.137831637950694, 0.141557509624351, 0.163833046059817}, {0.0218544781364545, 0.0314400501999916, 0.0329008160470834, 0.0353023819040016, 0.0377279973102482, 0.0410699984399582, 0.0437704598622665, 0.0462925642671299, 0.048851155289608, 0.0516145897865757, 0.0548121932066019, 0.0588230482851366, 0.0649136324046767, 0.0702737877191269, 0.0767095886079179, 0.0811998415355918, 0.0852854646662134, 0.0904847827490294, 0.0940930106666244, 0.0974904344916743, 0.102284204283997, 0.104680624334611, 0.107496694235039, 0.11140887547015, 0.113536607717411, 0.117886716865312}, {0.0164852597438403, 0.022831985803043, 0.0238917486442849, 0.0256559537977579, 0.0273987414570948, 0.0298109370830153, 0.0317771496530253, 0.0336073821590387, 0.0354621760592113, 0.0374805844550272, 0.0398046179116599, 0.0427283846799166, 0.047152783315718, 0.0511279442868827, 0.0558022052195208, 0.059024132304226, 0.0620425065165146, 0.0658016011466099, 0.0684479731118028, 0.0709169443994193, 0.0741183486081263, 0.0762579402903838, 0.0785735967934979, 0.0813458356889133, 0.0832963013755522, 0.0926780423096737}, {0.0111236388849688, 0.0165017735429825, 0.0172594157992489, 0.0185259426032926, 0.0197917612637521, 0.0215233745778454, 0.0229259769870428, 0.024243848341112, 0.025584358256487, 0.0270252129816288, 0.0286920262150517, 0.0308006766341406, 0.0339967814293504, 0.0368418413878307, 0.0402729850316397, 0.0426864799777448, 0.044958959158761, 0.0477643873749449, 0.0497198001867437, 0.0516114611801451, 0.0540543978864652, 0.0558704526182638, 0.0573877056330228, 0.0593365901653878, 0.0607646310473911, 0.0705309107882395}, {0.00755488597576196, 0.0106403461127515, 0.0111255573208294, 0.0119353655328931, 0.0127411306411808, 0.0138524542751814, 0.0147536004288476, 0.0155963185751048, 0.0164519238025286, 0.017383057902553, 0.0184503949887735, 0.0198162679782071, 0.0218781313182203, 0.0237294742633411, 0.025919578977657, 0.0274518022761997, 0.0288986369564301, 0.0306813505050163, 0.0320170996823189, 0.0332452747332959, 0.0348335698576168, 0.0359832389317461, 0.0369051995840645, 0.0387221159256424, 0.03993025905765, 0.0431448163617178}, {0.00541658127872122, 0.00760286745300187, 0.00794987834644799, 0.0085216518343594, 0.00909775605533253, 0.00988924521014078, 0.0105309297090482, 0.0111322726797384, 0.0117439009052552, 0.012405033293814, 0.0131684179320803, 0.0141377942603047, 0.0156148055023058, 0.0169343970067564, 0.018513067368104, 0.0196080260483234, 0.0206489568587364, 0.0219285176765082, 0.0228689168972669, 0.023738710122235, 0.0248334158891432, 0.0256126573433596, 0.0265491336936829, 0.027578430100536, 0.0284430733108, 0.0313640941982108}, {0.00390439997450557, 0.00541664181796583, 0.00566171386252323, 0.00607120971135229, 0.0064762535755248, 0.00703573098590029, 0.00749421254589299, 0.00792087889601733, 0.00835573724768006, 0.00882439333812351, 0.00936785820717061, 0.01005604603884, 0.0111019116837591, 0.0120380990328341, 0.0131721010552576, 0.0139655122281969, 0.0146889122204488, 0.0156076779647454, 0.0162685615996248, 0.0168874937789415, 0.0176505093388153, 0.0181944265400504, 0.0186226037818523, 0.0193001796565433, 0.0196241518040617, 0.0213081254074584}, {0.00245657785440433, 0.00344809282233326, 0.00360473943713036, 0.00386326548010849, 0.00412089506752692, 0.00447640050137479, 0.00476555693102276, 0.00503704029750072, 0.00531239247408213, 0.00560929919359959, 0.00595352728377949, 0.00639092280563517, 0.00705566126234625, 0.0076506368153935, 0.00836821687047215, 0.00886357892854914, 0.00934162787186159, 0.00993218636324029, 0.0103498795291629, 0.0107780907076862, 0.0113184316868283, 0.0117329446468571, 0.0119995948968375, 0.0124410052027886, 0.0129467396733128, 0.014396063834027}, {0.00174954269199566, 0.00244595133885302, 0.00255710802275612, 0.00273990955227265, 0.0029225480567908, 0.00317374638422465, 0.00338072258533527, 0.00357243876535982, 0.00376734715752209, 0.00397885007249132, 0.00422430013176233, 0.00453437508148542, 0.00500178808402368, 0.00542372242836395, 0.00592656681022859, 0.00628034732880374, 0.00661030641550873, 0.00702254699967648, 0.00731822628156458, 0.0076065423418208, 0.00795640367207482, 0.0082270524584354, 0.00852240989786251, 0.00892863905540303, 0.00913853933000213, 0.00952234579566773}, {0.00119458814106091, 0.00173435346896287, 0.00181194434584681, 0.00194259470485893, 0.00207173719623868, 0.00224993202086955, 0.00239520831473419, 0.00253036792824665, 0.00266863168718114, 0.0028181999035216, 0.00299137548142077, 0.00321024899920135, 0.00354362220314155, 0.00384330190244679, 0.00420258799378253, 0.00445774902155711, 0.00469461513212743, 0.00499416069129168, 0.00520917757743218, 0.00540396235924372, 0.00564540201704594, 0.00580460792299214, 0.00599774739593151, 0.00633099254378114, 0.00656987109386762, 0.00685829448046227}, {8.52415648011777E-4, 0.00122883479310665, 0.00128469304457018, 0.00137617650525553, 0.00146751502006323, 0.00159376453672466, 0.00169668445506151, 0.00179253418337906, 0.00189061261635977, 0.00199645471886179, 0.00211929748381704, 0.00227457698703581, 0.00250999080890397, 0.00272375073486223, 0.00298072958568387, 0.00315942194040388, 0.0033273652798148, 0.00353988965698579, 0.00369400045486625, 0.00383345715372182, 0.00400793469634696, 0.00414892737222885, 0.0042839159079761, 0.00441870104432879, 0.00450818604569179, 0.00513477467565583}, {6.44400053256997E-4, 9.16872204484283E-4, 9.57932946765532E-4, 0.00102641863872347, 0.00109495154218002, 0.00118904090369415, 0.00126575197699874, 0.00133750966361506, 0.00141049709228472, 0.00148936709298802, 0.00158027541945626, 0.00169651643860074, 0.00187306184725826, 0.00203178401610555, 0.00222356097506054, 0.00235782814777627, 0.00248343580127067, 0.00264210826339498, 0.0027524322157581, 0.0028608570740143, 0.00298695044508003, 0.00309340092038059, 0.00319932767198801, 0.00332688234611187, 0.00339316094477355, 0.00376331697005859}};
    private static final double[] qDiptabPr = new double[]{0.0, 0.01, 0.02, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.95, 0.98, 0.99, 0.995, 0.998, 0.999, 0.9995, 0.9998, 0.9999, 0.99995, 0.99998, 0.99999, 1.0};
    private static final int[] qDiptabN = new int[]{4, 5, 6, 7, 8, 9, 10, 15, 20, 30, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 40000, 72000};

    public static final double[] kolmogorov_smirnov_test(double[] X, double[] Y) {
        return DistributionTest.kolmogorov_smirnov_test(X, Y, TestKind.TWO_SIDED, true);
    }

    public static final double[] kolmogorov_smirnov_test(double[] X, double[] Y, boolean isExact) {
        return DistributionTest.kolmogorov_smirnov_test(X, Y, TestKind.TWO_SIDED, isExact);
    }

    public static final double[] kolmogorov_smirnov_test(double[] X, double[] Y, TestKind kind) {
        return DistributionTest.kolmogorov_smirnov_test(X, Y, kind, true);
    }

    public static final double[] kolmogorov_smirnov_test(double[] X, double[] Y, TestKind kind, boolean isExact) {
        double maxDiv;
        int nX = X.length;
        int nY = Y.length;
        int n_total = nX + nY;
        HashSet<Double> set = new HashSet<Double>();
        double[] w = Utilities.c(new double[][]{X, Y});
        int[] ow = Utilities.order(w);
        double[] z = new double[n_total];
        double cs = 0.0;
        for (int i = 0; i < n_total; ++i) {
            z[i] = cs += ow[i] + 1 <= nX ? 1.0 / (double)nX : -1.0 / (double)nY;
            set.add(w[i]);
        }
        int new_n = set.size();
        if (new_n < n_total) {
            double[] dz = new double[n_total];
            double[] new_z = new double[new_n];
            System.arraycopy(w, 0, dz, 0, n_total);
            Utilities.sort(dz);
            dz = VectorMath.diff(dz);
            int j = 0;
            for (int i = 0; i < dz.length; ++i) {
                if (dz[i] == 0.0) continue;
                new_z[j++] = z[i];
            }
            new_z[new_n - 1] = z[n_total - 1];
            z = new_z;
        }
        double pval = maxDiv = Double.NaN;
        switch (kind) {
            case TWO_SIDED: {
                maxDiv = VectorMath.max(VectorMath.vabs(z));
                break;
            }
            case LOWER: {
                maxDiv = -VectorMath.min(z);
                break;
            }
            case GREATER: {
                maxDiv = VectorMath.max(z);
            }
        }
        if (new_n < n_total || !isExact) {
            double n = (double)nX * ((double)nY * 1.0 / (double)(nX + nY));
            if (kind != TestKind.TWO_SIDED) {
                pval = Math.exp(-2.0 * n * maxDiv * maxDiv);
            } else {
                double tol = 1.0E-10;
                double d = Math.sqrt(n) * maxDiv;
                if (d < 1.0) {
                    int k_max = (int)Math.sqrt(2.0 - Math.log(tol));
                    double z_star = -1.2337005501361697 / (d * d);
                    double w_star = Math.log(d);
                    double s = 0.0;
                    for (int k = 1; k < k_max; k += 2) {
                        s += Math.exp((double)(k * k) * z_star - w_star);
                    }
                    pval = 1.0 - s / 0.3989422804014327;
                } else {
                    int k = 1;
                    double z_star = -2.0 * d * d;
                    double s = -1.0;
                    double oldval = 0.0;
                    double newval = 1.0;
                    while (Math.abs(oldval - newval) > tol) {
                        oldval = newval;
                        newval += 2.0 * s * Math.exp(z_star * (double)k * (double)k);
                        s *= -1.0;
                        ++k;
                    }
                    pval = 1.0 - newval;
                }
            }
        } else {
            if (nX > nY) {
                int temp = nY;
                nY = nX;
                nX = temp;
            }
            double q = (0.5 + Math.floor(maxDiv * (double)nX * (double)nY - 1.0E-7)) / (double)(nX * nY);
            double[] u = new double[nY + 1];
            double dx = 1.0 / (double)nX;
            double dy = 1.0 / (double)nY;
            for (int j = 0; j <= nY; ++j) {
                u[j] = (double)j * dy > q ? 0.0 : 1.0;
            }
            for (int i = 1; i <= nX; ++i) {
                double w_star = (double)i / (double)(i + nY);
                u[0] = (double)i * dx > q ? 0.0 : w_star * u[0];
                for (int j = 1; j <= nY; ++j) {
                    u[j] = Math.abs((double)i * dx - (double)j * dy) > q ? 0.0 : w_star * u[j] + u[j - 1];
                }
            }
            pval = 1.0 - u[nY];
        }
        return new double[]{maxDiv, pval};
    }

    public static final double[] kolmogorov_smirnov_test(double[] X, GenericDistribution dist) {
        return DistributionTest.kolmogorov_smirnov_test(X, dist, TestKind.TWO_SIDED, true);
    }

    public static final double[] kolmogorov_smirnov_test(double[] X, GenericDistribution dist, TestKind kind) {
        return DistributionTest.kolmogorov_smirnov_test(X, dist, kind, true);
    }

    public static final double[] kolmogorov_smirnov_test(double[] X, GenericDistribution dist, boolean isExact) {
        return DistributionTest.kolmogorov_smirnov_test(X, dist, TestKind.TWO_SIDED, isExact);
    }

    public static final double[] kolmogorov_smirnov_test(double[] X, GenericDistribution dist, TestKind kind, boolean isExact) {
        int n = X.length;
        double[] sortedX = new double[n];
        System.arraycopy(X, 0, sortedX, 0, n);
        Utilities.sort(sortedX);
        boolean hasTies = false;
        double maxX = -9.223372036854776E18;
        double minX = 9.223372036854776E18;
        for (int i = 0; i < n; ++i) {
            double val;
            if (i > 0 && sortedX[i] == sortedX[i - 1]) {
                hasTies = true;
            }
            if (maxX < (val = dist.cumulative(sortedX[i]) - (double)i * 1.0 / (double)n)) {
                maxX = val;
                continue;
            }
            if (!(minX > val)) continue;
            minX = val;
        }
        double maxDiv = Double.NaN;
        double pval = Double.NaN;
        switch (kind) {
            case TWO_SIDED: {
                maxDiv = Math.max(maxX, 1.0 / (double)n - minX);
                break;
            }
            case LOWER: {
                maxDiv = maxX;
                break;
            }
            case GREATER: {
                maxDiv = 1.0 / (double)n - minX;
            }
        }
        pval = hasTies || !isExact ? DistributionTest.kolmogorov_smirnov_pvalue_inexact(maxDiv, n) : DistributionTest.kolmogorov_smirnov_pvalue_exact(maxDiv, n);
        return new double[]{maxDiv, pval};
    }

    static final double kolmogorov_smirnov_statistic(double[] X, GenericDistribution dist, TestKind kind) {
        int n = X.length;
        double[] sortedX = new double[n];
        System.arraycopy(X, 0, sortedX, 0, n);
        Utilities.sort(sortedX);
        double maxX = -9.223372036854776E18;
        double minX = 9.223372036854776E18;
        for (int i = 0; i < n; ++i) {
            double val = dist.cumulative(sortedX[i]) - (double)i * 1.0 / (double)n;
            if (maxX < val) {
                maxX = val;
                continue;
            }
            if (!(minX > val)) continue;
            minX = val;
        }
        switch (kind) {
            case TWO_SIDED: {
                return Math.max(maxX, 1.0 / (double)n - minX);
            }
            case LOWER: {
                return maxX;
            }
            case GREATER: {
                return 1.0 / (double)n - minX;
            }
        }
        return Double.NaN;
    }

    static final double kolmogorov_smirnov_pvalue_inexact(double d, int n) {
        double pval;
        if (d >= 1.0) {
            pval = 0.0;
        } else if (d <= 0.0) {
            pval = 1.0;
        } else {
            int max_j = (int)Math.floor((double)n * (1.0 - d));
            double s = 0.0;
            double invN = 1.0 / (double)n;
            for (int j = 0; j <= max_j; ++j) {
                s += Math.exp(MathFunctions.lchoose(n, j) + (double)(n - j) * Math.log(1.0 - d - (double)j * invN) + (double)(j - 1) * Math.log(d + (double)j * invN));
            }
            pval = d * s;
        }
        return pval;
    }

    static final double kolmogorov_smirnov_pvalue_exact(double d, int n) {
        int j;
        int i;
        int k = (int)((double)n * d) + 1;
        int m = 2 * k - 1;
        int mm = m * m;
        double h = (double)k - (double)n * d;
        double[] H = new double[mm];
        double[] Q = new double[mm];
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                H[i * m + j] = i - j + 1 < 0 ? 0.0 : 1.0;
            }
        }
        for (i = 0; i < m; ++i) {
            int n2 = i * m;
            H[n2] = H[n2] - Math.pow(h, i + 1);
            int n3 = (m - 1) * m + i;
            H[n3] = H[n3] - Math.pow(h, m - i);
        }
        int n4 = (m - 1) * m;
        H[n4] = H[n4] + (2.0 * h - 1.0 > 0.0 ? Math.pow(2.0 * h - 1.0, m) : 0.0);
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                if (i - j + 1 <= 0) continue;
                for (int g = 1; g <= i - j + 1; ++g) {
                    int n5 = i * m + j;
                    H[n5] = H[n5] / (double)g;
                }
            }
        }
        int eH = 0;
        double eQ = DistributionTest.m_power(H, eH, Q, 0, m, n);
        double s = Q[(k - 1) * m + k - 1];
        for (int i2 = 1; i2 <= n; ++i2) {
            if (!((s = s * (double)i2 / (double)n) < 1.0E-140)) continue;
            s *= 1.0E140;
            eQ -= 140.0;
        }
        return 1.0 - (s *= Math.pow(10.0, eQ));
    }

    private static final int m_power(double[] A, int eA, double[] V, int eV, int m, int n) {
        double[] B = new double[m * m];
        if (n == 1) {
            for (int i = 0; i < m * m; ++i) {
                V[i] = A[i];
            }
            return eA;
        }
        eV = DistributionTest.m_power(A, eA, V, eV, m, n / 2);
        DistributionTest.m_multiply(V, V, B, m);
        int eB = 2 * eV;
        if ((n & 1) == 0) {
            for (int i = 0; i < m * m; ++i) {
                V[i] = B[i];
            }
            eV = eB;
        } else {
            DistributionTest.m_multiply(A, B, V, m);
            eV = eA + eB;
        }
        int mdiv2 = m / 2;
        if (V[mdiv2 * m + mdiv2] > 1.0E140) {
            for (int i = 0; i < m * m; ++i) {
                V[i] = V[i] * 1.0E-140;
            }
            eV += 140;
        }
        return eV;
    }

    private static final void m_multiply(double[] A, double[] B, double[] C, int m) {
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                double s = 0.0;
                for (int k = 0; k < m; ++k) {
                    s += A[i * m + k] * B[k * m + j];
                }
                C[i * m + j] = s;
            }
        }
    }

    public static final double[] ansari_bradley_test(double[] x, double[] y, boolean force_exact) {
        return DistributionTest.ansari_bradley_test(x, y, force_exact, TestKind.TWO_SIDED);
    }

    public static final double[] ansari_bradley_test(double[] x, double[] y, boolean force_exact, TestKind kind) {
        int nx = x.length;
        int ny = y.length;
        double N = nx + ny;
        double[] r = Utilities.rank(Utilities.c(new double[][]{x, y}));
        boolean has_ties = Utilities.unique(r).length != r.length;
        boolean large_xy = nx >= 50 || ny >= 50;
        double h = 0.0;
        r = VectorMath.pmin(r, VectorMath.vmin(N + 1.0, r));
        for (int i = 0; i < nx; ++i) {
            h += r[i];
        }
        if (force_exact || !has_ties && !large_xy) {
            switch (kind) {
                case TWO_SIDED: {
                    double limit = (double)((nx + 1) * (nx + 1) / 4) + (double)(nx * ny / 2) / 2.0;
                    double p = h > limit ? 1.0 - Ansari.cumulative((int)h - 1, nx, ny) : Ansari.cumulative((int)h, nx, ny);
                    p = Math.min(2.0 * p, 1.0);
                    return new double[]{h, p};
                }
                case LOWER: {
                    double p = Ansari.cumulative((int)(h - 1.0), nx, ny, false);
                    return new double[]{h, p};
                }
                case GREATER: {
                    double p = Ansari.cumulative((int)h, nx, ny, true);
                    return new double[]{h, p};
                }
            }
            throw new RuntimeException();
        }
        Utilities.sort(r);
        double[][] rle = Utilities.rle(r);
        double denom = 16.0 * N * (N - 1.0);
        double Np1Sq = N + 1.0;
        double Np2 = N + 2.0;
        Np1Sq *= Np1Sq;
        double sigma = 16.0 * VectorMath.sum(VectorMath.vtimes(VectorMath.vtimes(rle[0], rle[0]), rle[1]));
        sigma = N % 2.0 == 0.0 ? Math.sqrt((double)(nx * ny) * (sigma - N * Np2 * Np2) / denom) : Math.sqrt((double)(nx * ny) * (sigma * N - Np1Sq * Np1Sq) / (denom * N));
        double z = N % 2.0 == 0.0 ? h - (double)nx * Np2 / 4.0 : h - (double)nx * Np1Sq / (4.0 * N);
        double p = Normal.cumulative(z / sigma, 0.0, 1.0, true, false);
        p = 2.0 * Math.min(p, 1.0 - p);
        return new double[]{h, p};
    }

    public static final double[] mood_test(double[] x, double[] y) {
        return DistributionTest.mood_test(x, y, TestKind.TWO_SIDED);
    }

    public static final double[] mood_test(double[] x, double[] y, TestKind kind) {
        int nx = x.length;
        int ny = y.length;
        double N = nx + ny;
        if (N < 3.0) {
            throw new RuntimeException("Not enough observations");
        }
        double E = (double)nx * (N * N - 1.0) / 12.0;
        double v = 0.005555555555555556 * (double)nx * (double)ny * (N + 1.0) * (N + 2.0) * (N - 2.0);
        double[] z = Utilities.c(new double[][]{x, y});
        boolean has_ties = Utilities.unique(z).length != z.length;
        double T2 = 0.0;
        double con = (N + 1.0) / 2.0;
        if (!has_ties) {
            double[] r = Utilities.rank(z);
            for (int i = 0; i < nx; ++i) {
                double val = r[i] - con;
                T2 += val * val;
            }
        } else {
            double[] u = Utilities.unique(z);
            Utilities.sort(u);
            int[] a = Utilities.tabulate(Utilities.match(x, u), u.length);
            int[] t = Utilities.tabulate(Utilities.match(z, u), u.length);
            double[] p = VectorMath.vmin(Utilities.colon(1.0, (double)z.length), con);
            p = VectorMath.cumsum(VectorMath.vsq(p));
            double sum = 0.0;
            for (int i = 0; i < u.length; ++i) {
                double ti = t[i];
                double NmtiSq = N - (double)t[i];
                double tsq = ti * ti;
                NmtiSq *= NmtiSq;
                sum += ti * (tsq - 1.0) * (tsq - 4.0 + 15.0 * NmtiSq);
            }
            v -= (double)(nx * ny) / (180.0 * N * (N - 1.0)) * sum;
            double[] temp = VectorMath.diff(Utilities.c(new double[][]{{0.0}, Utilities.index_min1(p, VectorMath.cumsum(t))}));
            for (int i = 0; i < t.length; ++i) {
                T2 += (double)a[i] * temp[i] / (double)t[i];
            }
        }
        double zz = (T2 - E) / Math.sqrt(v);
        double p = Normal.cumulative(zz, 0.0, 1.0, kind != TestKind.GREATER, false);
        return new double[]{zz, kind == TestKind.TWO_SIDED ? 2.0 * Math.min(p, 1.0 - p) : p};
    }

    public static final double[] var_test(double[] x, double[] y, TestKind kind) {
        return DistributionTest.var_test(x, y, 1.0, kind);
    }

    public static final double[] var_test(double[] x, double[] y, double ratio, TestKind kind) {
        double stat = VectorMath.var(x) / VectorMath.var(y) / ratio;
        double p = Double.NaN;
        switch (kind) {
            case TWO_SIDED: {
                p = F.cumulative(stat, x.length - 1, y.length - 1, true, false);
                p = 2.0 * Math.min(p, 1.0 - p);
                break;
            }
            case GREATER: {
                p = F.cumulative(stat, x.length - 1, y.length - 1, false, false);
                break;
            }
            case LOWER: {
                p = F.cumulative(stat, x.length - 1, y.length - 1, true, false);
            }
        }
        return new double[]{stat, p};
    }

    public static final double[] wilcoxon_test(double[] x, double mu, boolean correction, TestKind kind) {
        boolean has_zeroes = false;
        int n_nonzero = 0;
        HashSet<Double> seen_set = new HashSet<Double>();
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == mu) {
                has_zeroes = true;
                continue;
            }
            ++n_nonzero;
            seen_set.add(x[i]);
        }
        double[] new_x = new double[n_nonzero];
        int j = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == mu) continue;
            new_x[j++] = x[i] - mu;
        }
        x = new_x;
        boolean has_ties = seen_set.size() != x.length;
        double[] r = Utilities.rank(VectorMath.vabs(x));
        int n = r.length;
        double limit = (double)(n * (n + 1)) / 4.0;
        double v = 0.0;
        double p = Double.NaN;
        for (int i = 0; i < n; ++i) {
            v += r[i];
        }
        if (!has_ties && !has_zeroes) {
            SignRank sr = new SignRank(n);
            switch (kind) {
                case TWO_SIDED: {
                    p = v > limit ? sr.cumulative(v - 1.0, false, false) : sr.cumulative(v);
                    p = Math.min(2.0 * p, 1.0);
                    break;
                }
                case GREATER: {
                    p = sr.cumulative(v - 1.0, false, false);
                    break;
                }
                case LOWER: {
                    p = sr.cumulative(v);
                }
            }
        } else {
            double sigma = 0.0;
            for (int nties : VectorMath.table(r).values()) {
                sigma += (double)(nties * nties * nties - nties);
            }
            sigma = Math.sqrt(limit * (double)(2 * n + 1) / 6.0 - sigma / 48.0);
            v -= limit;
            double cor = 0.0;
            if (correction) {
                switch (kind) {
                    case TWO_SIDED: {
                        cor = Math.signum(v) * 0.5;
                        break;
                    }
                    case GREATER: {
                        cor = 0.5;
                        break;
                    }
                    case LOWER: {
                        cor = -0.5;
                    }
                }
            }
            v = (v - cor) / sigma;
            switch (kind) {
                case TWO_SIDED: {
                    p = 2.0 * Math.min(Normal.cumulative_standard(v), Normal.cumulative(v, 0.0, 1.0, false, false));
                    break;
                }
                case GREATER: {
                    p = Normal.cumulative(v, 0.0, 1.0, false, false);
                    break;
                }
                case LOWER: {
                    p = Normal.cumulative_standard(v);
                }
            }
        }
        return new double[]{v, p};
    }

    public static final double[] mann_whitney_u_test(double[] x, double[] y, double mu, boolean correction, boolean paired, TestKind kind) {
        boolean has_ties;
        int nx = x.length;
        int ny = y.length;
        int n = nx + ny;
        if (paired) {
            return DistributionTest.wilcoxon_test(VectorMath.vmin(x, y), mu, correction, kind);
        }
        double[] r = mu == 0.0 ? Utilities.rank(Utilities.c(new double[][]{x, y})) : Utilities.rank(Utilities.c(new double[][]{VectorMath.vmin(x, mu), y}));
        double w = -nx * (nx + 1) / 2;
        double p = Double.NaN;
        double limit = (double)(nx * ny) / 2.0;
        for (int i = 0; i < nx; ++i) {
            w += r[i];
        }
        boolean bl = has_ties = Utilities.unique(r).length != r.length;
        if (!has_ties) {
            Wilcoxon wilcox = new Wilcoxon(nx, ny);
            switch (kind) {
                case TWO_SIDED: {
                    p = w > limit ? wilcox.cumulative(w - 1.0, false, false) : wilcox.cumulative(w);
                    p = Math.min(2.0 * p, 1.0);
                    break;
                }
                case GREATER: {
                    p = wilcox.cumulative(w - 1.0, false, false);
                    break;
                }
                case LOWER: {
                    p = wilcox.cumulative(w);
                }
            }
        } else {
            double sigma = 0.0;
            for (int nties : VectorMath.table(r).values()) {
                sigma += (double)(nties * nties * nties - nties);
            }
            sigma = Math.sqrt(limit / 6.0 * ((double)(n + 1) - sigma / (double)(n * (n + 1))));
            w -= limit;
            double cor = 0.0;
            if (correction) {
                switch (kind) {
                    case TWO_SIDED: {
                        cor = Math.signum(w) * 0.5;
                        break;
                    }
                    case GREATER: {
                        cor = 0.5;
                        break;
                    }
                    case LOWER: {
                        cor = -0.5;
                    }
                }
            }
            w = (w - cor) / sigma;
            switch (kind) {
                case TWO_SIDED: {
                    p = 2.0 * Math.min(Normal.cumulative_standard(w), Normal.cumulative(w, 0.0, 1.0, false, false));
                    break;
                }
                case GREATER: {
                    p = Normal.cumulative(w, 0.0, 1.0, false, false);
                    break;
                }
                case LOWER: {
                    p = Normal.cumulative_standard(w);
                }
            }
        }
        return new double[]{w, p};
    }

    public static final double[] t_test(double[] x, double mu, TestKind kind) {
        int nx = x.length;
        double stderr = Math.sqrt(VectorMath.var(x) / (double)nx);
        --nx;
        double t = (VectorMath.mean(x) - mu) / stderr;
        double p = Double.NaN;
        switch (kind) {
            case TWO_SIDED: {
                p = 2.0 * T.cumulative(-Math.abs(t), nx, true, false);
                break;
            }
            case GREATER: {
                p = T.cumulative(t, nx, false, false);
                break;
            }
            case LOWER: {
                p = T.cumulative(t, nx, true, false);
            }
        }
        return new double[]{t, p};
    }

    public static final double[] t_test_paired(double[] x, double[] y, double mu, TestKind kind) {
        return DistributionTest.t_test(VectorMath.vmin(x, y), mu, kind);
    }

    public static final double[] t_test(double[] x, double[] y, double mu, boolean pool_var, TestKind kind) {
        double stderr;
        double df;
        int nx = x.length;
        int ny = y.length;
        if (pool_var) {
            df = nx + ny - 2;
            stderr = 0.0;
            if (nx > 1) {
                stderr += (double)(nx - 1) * VectorMath.var(x);
            }
            if (ny > 1) {
                stderr += (double)(ny - 1) * VectorMath.var(y);
            }
            stderr = Math.sqrt(stderr / df * (1.0 / (double)nx + 1.0 / (double)ny));
        } else {
            double sx = VectorMath.var(x) / (double)nx;
            double sy = VectorMath.var(y) / (double)ny;
            stderr = sx + sy;
            df = stderr * stderr / (sx * sx / (double)(nx - 1) + sy * sy / (double)(ny - 1));
            stderr = Math.sqrt(stderr);
        }
        double t = (VectorMath.mean(x) - VectorMath.mean(y) - mu) / stderr;
        double p = Double.NaN;
        switch (kind) {
            case TWO_SIDED: {
                p = 2.0 * T.cumulative(-Math.abs(t), df, true, false);
                break;
            }
            case GREATER: {
                p = T.cumulative(t, df, false, false);
                break;
            }
            case LOWER: {
                p = T.cumulative(t, df, true, false);
            }
        }
        return new double[]{t, p};
    }

    public static final double[] binomial_test(int n_success, int n, double p, TestKind kind) {
        switch (kind) {
            case TWO_SIDED: {
                if (p == 0.0) {
                    p = n_success == 0 ? 1.0 : 0.0;
                    break;
                }
                if (p == 1.0) {
                    p = n_success == n ? 1.0 : 0.0;
                    break;
                }
                double d = Binomial.density(n_success, n, p, false) * 1.0000001;
                double m = (double)n * p;
                if ((double)n_success == m) {
                    p = 1.0;
                    break;
                }
                if ((double)n_success < m) {
                    int y = 0;
                    for (int i = (int)Math.ceil(m); i <= n; ++i) {
                        if (!(Binomial.density(i, n, p, false) <= d)) continue;
                        ++y;
                    }
                    p = Binomial.cumulative(n_success, n, p, true, false) + Binomial.cumulative(n - y, n, p, false, false);
                    break;
                }
                int y = 0;
                int mlo = (int)Math.floor(m);
                for (int i = 0; i <= mlo; ++i) {
                    if (!(Binomial.density(i, n, p, false) <= d)) continue;
                    ++y;
                }
                p = Binomial.cumulative(y - 1, n, p, true, false) + Binomial.cumulative(n_success - 1, n, p, false, false);
                break;
            }
            case GREATER: {
                p = Binomial.cumulative(n_success - 1, n, p, false, false);
                break;
            }
            case LOWER: {
                p = Binomial.cumulative(n_success, n, p, true, false);
            }
        }
        return new double[]{n_success, p};
    }

    public static final double[] bartlett_test(double[] x, int[] group) {
        int n = x.length;
        if (n != group.length) {
            throw new RuntimeException();
        }
        HashMap<Integer, ArrayList<Double>> map = new HashMap<Integer, ArrayList<Double>>();
        for (int i = 0; i < n; ++i) {
            ArrayList<Double> ll = (ArrayList<Double>)map.get(group[i]);
            if (ll == null) {
                ll = new ArrayList<Double>();
                map.put(group[i], ll);
            }
            ll.add(x[i]);
        }
        int[] unique_group = Utilities.to_int_array(map.keySet());
        int k = unique_group.length;
        double v_total = 0.0;
        double sum_recip = 0.0;
        double sum_n_vlog = 0.0;
        for (int i = 0; i < k; ++i) {
            double[] dbl = Utilities.to_double_array((Collection)map.get(unique_group[i]));
            double var_group = VectorMath.var(dbl);
            int ni = dbl.length - 1;
            v_total += (double)ni * var_group / (double)(n - k);
            sum_recip += 1.0 / (double)ni;
            sum_n_vlog += (double)ni * Math.log(var_group);
        }
        double stat = ((double)(n - k) * Math.log(v_total) - sum_n_vlog) / (1.0 + (sum_recip - 1.0 / (double)(n - k)) / (double)(3 * (k - 1)));
        double p = ChiSquare.cumulative(stat, k - 1, false, false);
        return new double[]{stat, p};
    }

    public static final double[] fligner_test(double[] x, int[] group) {
        int i;
        int n = x.length;
        if (n != group.length) {
            throw new RuntimeException();
        }
        HashMap<Integer, ArrayList<Double>> map = new HashMap<Integer, ArrayList<Double>>();
        for (int i2 = 0; i2 < n; ++i2) {
            ArrayList<Double> ll = (ArrayList<Double>)map.get(group[i2]);
            if (ll == null) {
                ll = new ArrayList<Double>();
                map.put(group[i2], ll);
            }
            ll.add(x[i2]);
        }
        int[] unique_group = Utilities.to_int_array(map.keySet());
        int k = unique_group.length;
        int[] cumsum_n_group = new int[k];
        int[] n_group = new int[k];
        double[] new_x = new double[n];
        for (i = 0; i < k; ++i) {
            double[] dbl = Utilities.to_double_array((Collection)map.get(unique_group[i]));
            int ni = dbl.length;
            cumsum_n_group[i] = ni + (i > 0 ? cumsum_n_group[i - 1] : 0);
            n_group[i] = ni;
            double med_group = VectorMath.median(dbl);
            int j = 0;
            while (j < ni) {
                int n2 = j++;
                dbl[n2] = dbl[n2] - med_group;
            }
            System.arraycopy(dbl, 0, new_x, i == 0 ? 0 : cumsum_n_group[i - 1], ni);
        }
        new_x = Utilities.rank(VectorMath.vabs(new_x));
        for (i = 0; i < new_x.length; ++i) {
            new_x[i] = Normal.quantile((1.0 + new_x[i] / (double)(n + 1)) / 2.0, 0.0, 1.0, true, false);
        }
        double stat = 0.0;
        for (int i3 = 0; i3 < k; ++i3) {
            int from = i3 == 0 ? 0 : cumsum_n_group[i3 - 1];
            int ni = n_group[i3];
            int to = from + ni;
            double sum = 0.0;
            for (int j = from; j < to; ++j) {
                sum += new_x[j];
            }
            stat += sum * sum / (double)ni;
        }
        double ma = VectorMath.mean(new_x);
        stat = (stat - (double)n * ma * ma) / VectorMath.var(new_x);
        double p = ChiSquare.cumulative(stat, k - 1, false, false);
        return new double[]{stat, p};
    }

    public static final double[] kruskal_wallis_test(double[] x, int[] group) {
        int n = x.length;
        if (n != group.length) {
            throw new RuntimeException();
        }
        HashMap<Integer, ArrayList<Double>> map = new HashMap<Integer, ArrayList<Double>>();
        for (int i = 0; i < n; ++i) {
            ArrayList<Double> ll = (ArrayList<Double>)map.get(group[i]);
            if (ll == null) {
                ll = new ArrayList<Double>();
                map.put(group[i], ll);
            }
            ll.add(x[i]);
        }
        int[] unique_group = Utilities.to_int_array(map.keySet());
        int k = unique_group.length;
        int[] cumsum_n_group = new int[k];
        int[] n_group = new int[k];
        double[] new_x = new double[n];
        for (int i = 0; i < k; ++i) {
            double[] dbl = Utilities.to_double_array((Collection)map.get(unique_group[i]));
            int ni = dbl.length;
            cumsum_n_group[i] = ni + (i > 0 ? cumsum_n_group[i - 1] : 0);
            n_group[i] = ni;
            System.arraycopy(dbl, 0, new_x, i == 0 ? 0 : cumsum_n_group[i - 1], ni);
        }
        double[] r = Utilities.rank(new_x);
        double stat = 0.0;
        for (int i = 0; i < k; ++i) {
            int from = i == 0 ? 0 : cumsum_n_group[i - 1];
            int ni = n_group[i];
            int to = from + ni;
            double sum = 0.0;
            for (int j = from; j < to; ++j) {
                sum += r[j];
            }
            stat += sum * sum / (double)ni;
        }
        double sigma = 0.0;
        for (int nties : VectorMath.table(r).values()) {
            sigma += (double)(nties * nties * nties - nties);
        }
        stat = (12.0 * stat / (double)(n * (n + 1)) - (double)(3 * (n + 1))) / (1.0 - sigma / (double)(n * n * n - n));
        double p = ChiSquare.cumulative(stat, k - 1, false, false);
        return new double[]{stat, p};
    }

    public static final double[] poisson_test(int num_events, double time, double rate, TestKind kind) {
        if (time < 0.0 || rate < 0.0 || num_events < 0) {
            throw new RuntimeException();
        }
        double m = rate * time;
        double p = Double.NaN;
        switch (kind) {
            case TWO_SIDED: {
                if (m == 0.0) {
                    p = num_events == 0 ? 1.0 : 0.0;
                    break;
                }
                if ((double)num_events == m) {
                    p = 1.0;
                    break;
                }
                double d = Poisson.density(num_events, m, false);
                double fuzz = 1.0000001 * d;
                double y = 0.0;
                if ((double)num_events < m) {
                    double N = (int)Math.ceil(2.0 * m - (double)num_events);
                    while (Poisson.density(N, m, false) > d) {
                        N *= 2.0;
                    }
                    int i = (int)Math.ceil(m);
                    while ((double)i <= N) {
                        if (Poisson.density(i, m, false) <= fuzz) {
                            y += 1.0;
                        }
                        ++i;
                    }
                    p = Poisson.cumulative(num_events, m, true, false) + Poisson.cumulative(N - y, m, false, false);
                    break;
                }
                double N = (int)Math.floor(m);
                int i = 0;
                while ((double)i < N) {
                    if (Poisson.density(i, m, false) <= fuzz) {
                        y += 1.0;
                    }
                    ++i;
                }
                p = Poisson.cumulative(y - 1.0, m, true, false) + Poisson.cumulative(num_events - 1, m, false, false);
                break;
            }
            case GREATER: {
                p = Poisson.cumulative(num_events - 1, m, false, false);
                break;
            }
            case LOWER: {
                p = Poisson.cumulative(num_events, m, true, false);
            }
        }
        return new double[]{num_events, p};
    }

    public static final double[] poisson_test(int num_events1, int num_events2, double time1, double time2, double r, TestKind kind) {
        if (time1 < 0.0 || time2 < 0.0 || r < 0.0 || num_events1 < 0 || num_events2 < 0) {
            throw new RuntimeException();
        }
        return DistributionTest.binomial_test(num_events1, num_events1 + num_events2, r * time1 / (r * time1 + time2), kind);
    }

    static final double cramer_vonmises_statistic(double[] X, double[] Y) {
        double val;
        int i;
        int nX = X.length;
        int nY = Y.length;
        int nXY = nX * nY;
        int nXPY = nX + nY;
        double[] rank = Utilities.rank(Utilities.c(new double[][]{X, Y}));
        double[] rankX = Utilities.rank(X);
        double[] rankY = Utilities.rank(Y);
        double sumX = 0.0;
        double sumY = 0.0;
        for (i = 0; i < nX; ++i) {
            val = rank[i] - rankX[i];
            sumX += val * val;
        }
        for (i = nX; i < nXPY; ++i) {
            val = rank[i] - rankY[i - nX];
            sumY += val * val;
        }
        val = ((double)nX * sumX + (double)nY * sumY) / (double)(nXY * nXPY) - (double)((4 * nXY - 1) / (6 * nXPY));
        return val;
    }

    public static final double[] diptest(double[] x) {
        double[] x_ = new double[x.length];
        System.arraycopy(x, 0, x_, 0, x.length);
        Utilities.sort(x_);
        return DistributionTest.diptest_presorted(x_);
    }

    public static final double[] diptest_presorted(double[] x) {
        double dip = 0.0;
        int n = x.length;
        int low = 1;
        int high = n;
        int l_gcm = 0;
        int l_lcm = 0;
        int[] gcm = new int[n + 1];
        int[] lcm = new int[n + 1];
        int[] mn = new int[n + 1];
        int[] mj = new int[n + 1];
        if (n < 2 || x[0] == x[n - 1]) {
            return new double[]{0.0, 1.0, -1.0, -1.0};
        }
        mn[1] = 1;
        block0: for (int j = 2; j <= n; ++j) {
            mn[j] = j - 1;
            while (true) {
                int mnj = mn[j];
                int mnmnj = mn[mnj];
                if (mnj == 1 || (x[j - 1] - x[mnj - 1]) * (double)(mnj - mnmnj) < (x[mnj - 1] - x[mnmnj - 1]) * (double)(j - mnj)) continue block0;
                mn[j] = mnmnj;
            }
        }
        mj[n] = n;
        block2: for (int k = n - 1; k >= 1; --k) {
            mj[k] = k + 1;
            while (true) {
                int mjk = mj[k];
                int mjmjk = mj[mjk];
                if (mjk == n || (x[k - 1] - x[mjk - 1]) * (double)(mjk - mjmjk) < (x[mjk - 1] - x[mjmjk - 1]) * (double)(k - mjk)) continue block2;
                mj[k] = mjmjk;
            }
        }
        while (true) {
            double t;
            int jj;
            double C;
            int jb;
            int je;
            double max_t;
            int j;
            gcm[1] = high;
            int i = 1;
            while (gcm[i] > low) {
                gcm[i + 1] = mn[gcm[i]];
                ++i;
            }
            int ig = l_gcm = i;
            int ix = ig - 1;
            lcm[1] = low;
            i = 1;
            while (lcm[i] < high) {
                lcm[i + 1] = mj[lcm[i]];
                ++i;
            }
            int ih = l_lcm = i;
            int iv = 2;
            double d = 0.0;
            if (l_gcm != 2 || l_lcm != 2) {
                do {
                    double dx;
                    int lcmiv;
                    int gcmix;
                    if ((gcmix = gcm[ix]) > (lcmiv = lcm[iv])) {
                        int gcmi1 = gcm[ix + 1];
                        dx = (double)(lcmiv - gcmi1 + 1) - (x[lcmiv - 1] - x[gcmi1 - 1]) * (double)(gcmix - gcmi1) / (x[gcmix - 1] - x[gcmi1 - 1]);
                        ++iv;
                        if (dx >= d) {
                            d = dx;
                            ig = ix + 1;
                            ih = iv - 1;
                        }
                    } else {
                        int lcmiv1 = lcm[iv - 1];
                        dx = (x[gcmix - 1] - x[lcmiv1 - 1]) * (double)(lcmiv - lcmiv1) / (x[lcmiv - 1] - x[lcmiv1 - 1]) - (double)(gcmix - lcmiv1 - 1);
                        --ix;
                        if (dx >= d) {
                            d = dx;
                            ig = ix + 1;
                            ih = iv;
                        }
                    }
                    if (ix < 1) {
                        ix = 1;
                    }
                    if (iv <= l_lcm) continue;
                    iv = l_lcm;
                } while (gcm[ix] != lcm[iv]);
            } else {
                d = 0.0;
            }
            if (d < dip) break;
            double dip_l = 0.0;
            for (j = ig; j < l_gcm; ++j) {
                max_t = 1.0;
                je = gcm[j];
                jb = gcm[j + 1];
                if (je - jb > 1 && x[je - 1] != x[jb - 1]) {
                    C = (double)(je - jb) / (x[je - 1] - x[jb - 1]);
                    for (jj = jb; jj <= je; ++jj) {
                        t = (double)(jj - jb + 1) - (x[jj - 1] - x[jb - 1]) * C;
                        if (!(max_t < t)) continue;
                        max_t = t;
                    }
                }
                if (!(dip_l < max_t)) continue;
                dip_l = max_t;
            }
            double dip_u = 0.0;
            for (j = ih; j < l_lcm; ++j) {
                max_t = 1.0;
                je = lcm[j + 1];
                jb = lcm[j];
                if (je - jb > 1 && x[je - 1] != x[jb - 1]) {
                    C = (double)(je - jb) / (x[je - 1] - x[jb - 1]);
                    for (jj = jb; jj <= je; ++jj) {
                        t = (x[jj - 1] - x[jb - 1]) * C - (double)(jj - jb - 1);
                        if (!(max_t < t)) continue;
                        max_t = t;
                    }
                }
                if (!(dip_u < max_t)) continue;
                dip_u = max_t;
            }
            double dipnew = dip_u > dip_l ? dip_u : dip_l;
            if (dip < dipnew) {
                dip = dipnew;
            }
            if (low == gcm[ig] && high == lcm[ih]) break;
            low = gcm[ig];
            high = lcm[ih];
        }
        dip /= (double)(2 * n);
        int nn = qDiptabN.length - 1;
        int max_n = qDiptabN[nn];
        int prn = qDiptab[0].length;
        double[] zz = new double[prn];
        if (n > max_n) {
            double sqn0 = Math.sqrt(max_n);
            for (int j = 0; j < prn; ++j) {
                zz[j] = sqn0 * qDiptab[nn][j];
            }
        } else {
            int i_n = nn;
            while (n < qDiptabN[i_n]) {
                --i_n;
            }
            int i2 = i_n + 1;
            int n0 = qDiptabN[i_n];
            int n1 = qDiptabN[i2];
            double f_n = (double)(n - n0) * 1.0 / (double)(n1 - n0);
            double sqn0 = Math.sqrt(n0);
            double sqn1 = Math.sqrt(n1);
            for (int j = 0; j < prn; ++j) {
                double y0 = sqn0 * qDiptab[i_n][j];
                zz[j] = y0 + f_n * (sqn1 * qDiptab[i2][j] - y0);
            }
        }
        double pval = 1.0 - ApproximationFunction.linear(Math.sqrt(n) * dip, zz, qDiptabPr, 0.0, 1.0);
        return new double[]{dip, pval, low - 1, high - 1};
    }

    static final void kstest_example() {
        double[] x = new double[]{1.160041688388212, -1.055476349265595, -1.3207242029566646, 0.23915046399456202, 0.1280372490607462, 0.05569133699728501, -0.8125002687519708, -0.2527056092320565, -0.1806423563283645, -1.688517367112071, 0.4520176594127373, -0.8223951418778523, -1.2843174602054348, -1.11673394115549, 0.3548467430335484, 0.6946971736333469, 0.8081483846581686, -0.2132882145279537, -1.2761468822702142, 0.7070114668756505, 0.507517339877647, 0.03272845258879652, 0.35783108099085625, 0.4420890029750776, -0.5206908244712504, -0.557631587177767, -0.4163315169619347, 0.267696024197844, -0.7498723403587779, -0.41904535934255055, 0.8925790614422582, -0.0719059745357396, 0.7330227975648881, -0.10734082387514077, 0.6940662960503111, -0.15263137425121245, -1.1967489516398724, 0.6675716786037661, -0.814948570182664, 0.8004093100578593, 0.8075496724237657, -1.5691692835222897, -1.3516738613760655, 1.1631878981801262, 0.2893620600005766, 0.5229049108151712, -0.057626055701180276, -0.1417637096612063, -0.37619927990739527, -1.067365580349716};
        double[] y = new double[]{0.40490121906623244, 0.24850796000100672, 0.1022286640945822, 0.6285310559906065, 0.6195512628182769, 0.28701157541945577, 0.9514963554684073, 0.010874098632484674, 0.6370721007697284, 0.6103827697224915, 0.0921065725851804, 0.6475813502911478, 0.4883203764911741, 0.1030736668035388, 0.864651667419821, 0.6877460014075041, 0.7625355611089617, 0.5201810055878013, 0.6166569679044187, 0.7778363111428916, 0.8987720855511725, 0.8358376433607191, 0.9225274042692035, 0.836997929494828, 0.3580999285914004, 0.590041151503101, 0.6085326359607279, 0.1356926434673369, 0.383456161711365, 0.9117110567167401};
        double[] p = DistributionTest.kolmogorov_smirnov_test(x, y);
        System.out.println(p[0]);
        System.out.println(p[1]);
        p = DistributionTest.kolmogorov_smirnov_test(x, new Normal());
        System.out.println(p[0]);
        System.out.println(p[1]);
    }

    public static final void main(String[] args) {
        DistributionTest.kstest_example();
        System.exit(0);
        double[] x = new double[]{-1.2315764307891697, 0.10766660489198622, -0.25076771026116995, 0.1865730243313593, 0.7674721840239808, -0.18746405292415022, 0.13769759969213102, 0.37226584315573147, 1.8257862598243677, -1.4691239378183403};
        double[] y = new double[]{2.633833206002906, -1.0413375749105698, -1.0811218382230727, 2.702460192243479, 1.6265489662012782, 1.3366425380960192, 1.0751450212932796, 1.5430569496700024, -0.08503998732825324, 1.3579302158870394};
        System.out.println(DistributionTest.cramer_vonmises_statistic(x, y));
    }
}

