/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class SignRank
extends GenericDistribution {
    protected double[] w;
    protected int n;

    public SignRank(int n) {
        this.n = n;
        int c = n * (n + 1) / 4;
        this.w = new double[c + 1];
    }

    protected double count(int k, int n) {
        int u = n * (n + 1) / 2;
        int c = u / 2;
        if (k < 0 || k > u) {
            return 0.0;
        }
        if (k > c) {
            k = u - k;
        }
        if (n == 1) {
            return 1.0;
        }
        if (this.w[0] == 1.0) {
            return this.w[k];
        }
        this.w[1] = 1.0;
        this.w[0] = 1.0;
        for (int j = 2; j < n + 1; ++j) {
            int end;
            for (int i = end = Math.min(j * (j + 1) / 2, c); i >= j; --i) {
                int n2 = i;
                this.w[n2] = this.w[n2] + this.w[i - j];
            }
        }
        return this.w[k];
    }

    public double density(int x, boolean give_log) {
        if (Double.isNaN(x)) {
            return x + this.n;
        }
        if (x < 0 || x > this.n * (this.n + 1) / 2) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        double d = Math.log(this.count(x, this.n)) - (double)this.n * 0.6931471805599453;
        return give_log ? d : Math.exp(d);
    }

    public double cumulative(int x, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x)) {
            return x + this.n;
        }
        if ((double)x < 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (x >= this.n * (this.n + 1) / 2) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        double f = Math.exp((double)(-this.n) * 0.6931471805599453);
        double p = 0.0;
        if (x <= this.n * (this.n + 1) / 4) {
            for (int i = 0; i <= x; ++i) {
                p += this.count(i, this.n) * f;
            }
        } else {
            x = this.n * (this.n + 1) / 2 - x;
            for (int i = 0; i < x; ++i) {
                p += this.count(i, this.n) * f;
            }
            boolean bl = lower_tail = !lower_tail;
        }
        return lower_tail ? (log_p ? Math.log(p) : p) : (log_p ? Math.log1p(-p) : 0.5 - p + 0.5);
    }

    public double quantile(double x, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x)) {
            return x + (double)this.n;
        }
        if (MathFunctions.isInfinite(x)) {
            return Double.NaN;
        }
        if (log_p && x > 0.0 || !log_p && (x < 0.0 || x > 1.0)) {
            return Double.NaN;
        }
        if (x == (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0))) {
            return 0.0;
        }
        if (x == (lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0))) {
            return this.n * (this.n + 1) / 2;
        }
        if (log_p || !lower_tail) {
            x = log_p ? (lower_tail ? Math.exp(x) : -Math.expm1(x)) : (lower_tail ? x : 0.5 - x + 0.5);
        }
        double f = Math.exp((double)(-this.n) * 0.6931471805599453);
        double p = 0.0;
        int q = 0;
        if (x <= 0.5) {
            x -= 2.220446049250313E-15;
            while (!((p += this.count(q, this.n) * f) >= x)) {
                ++q;
            }
        } else {
            x = 1.0 - x + 2.220446049250313E-15;
            while (true) {
                if ((p += this.count(q, this.n) * f) > x) {
                    q = this.n * (this.n + 1) / 2 - q;
                    break;
                }
                ++q;
            }
        }
        return q;
    }

    public void setRandomEngine(RandomEngine rand) {
        this.random = rand;
    }

    public RandomEngine getRandomEngine() {
        return this.random;
    }

    public double random() {
        return this.random(this.random);
    }

    public double random(RandomEngine rr) {
        if (this.n == 0) {
            return 0.0;
        }
        double r = 0.0;
        int i = 0;
        while (i < this.n) {
            r += (double)(++i) * Math.rint(rr.nextDouble());
        }
        return r;
    }

    public double[] random(int n, RandomEngine r) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = this.random(r);
        }
        return rand;
    }

    public double density(double x, boolean log) {
        return this.density((int)x, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return this.cumulative((int)p, lower_tail, log_p);
    }
}

