/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Exponential;
import jdistlib.Gamma;
import jdistlib.Normal;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Poisson
extends GenericDistribution {
    protected double lambda;
    protected RandomState state;

    public static final RandomState create_random_state() {
        return new RandomState();
    }

    public static final double density_raw(double x, double lambda, boolean give_log) {
        if (lambda == 0.0) {
            return x == 0.0 ? (give_log ? 0.0 : 1.0) : (give_log ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (MathFunctions.isInfinite(lambda)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x < 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x <= lambda * Double.MIN_NORMAL) {
            return give_log ? -lambda : Math.exp(-lambda);
        }
        if (lambda < x * Double.MIN_NORMAL) {
            x = -lambda + x * Math.log(lambda) - MathFunctions.lgammafn(x + 1.0);
            return give_log ? x : Math.exp(x);
        }
        lambda = -MathFunctions.stirlerr(x) - MathFunctions.bd0(x, lambda);
        x = Math.PI * 2 * x;
        return give_log ? -0.5 * Math.log(x) + lambda : Math.exp(lambda - 0.5 * Math.log(x));
    }

    public static final double density(double x, double lambda, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(lambda)) {
            return x + lambda;
        }
        if (lambda < 0.0) {
            return Double.NaN;
        }
        if (MathFunctions.isNonInt(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x < 0.0 || MathFunctions.isInfinite(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        return Poisson.density_raw(Math.round(x), lambda, give_log);
    }

    public static final double cumulative(double x, double lambda, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(lambda)) {
            return x + lambda;
        }
        if (lambda < 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (lambda == 0.0) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (MathFunctions.isInfinite(x)) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        x = Math.floor(x + 1.0E-7);
        return Gamma.cumulative(lambda, x + 1.0, 1.0, !lower_tail, log_p);
    }

    static final double do_search(double y, double[] z, double p, double lambda, double incr) {
        double d;
        block4: {
            if (!(z[0] >= p)) break block4;
            while (true) {
                block6: {
                    block5: {
                        double d2;
                        if (y == 0.0) break block5;
                        z[0] = Poisson.cumulative(y - incr, lambda, true, false);
                        if (!(d2 < p)) break block6;
                    }
                    return y;
                }
                y = Math.max(0.0, y - incr);
            }
        }
        do {
            z[0] = Poisson.cumulative(y += incr, lambda, true, false);
        } while (!(d >= p));
        return y;
    }

    public static final double quantile(double p, double lambda, boolean lower_tail, boolean log_p) {
        double oldincr;
        double[] z = new double[1];
        if (Double.isNaN(p) || Double.isNaN(lambda)) {
            return p + lambda;
        }
        if (MathFunctions.isInfinite(lambda)) {
            return Double.NaN;
        }
        if (lambda < 0.0) {
            return Double.NaN;
        }
        if (lambda == 0.0) {
            return 0.0;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        double mu = lambda;
        double sigma = Math.sqrt(lambda);
        double gamma = 1.0 / sigma;
        if (!lower_tail || log_p) {
            double d = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (p = lower_tail ? p : 0.5 - p + 0.5);
            if (p == 0.0) {
                return 0.0;
            }
            if (p == 1.0) {
                return Double.POSITIVE_INFINITY;
            }
        }
        if (p + 2.242650509742816E-16 >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        z[0] = Normal.quantile(p, 0.0, 1.0, true, false);
        double y = Math.rint(mu + sigma * (z[0] + gamma * (z[0] * z[0] - 1.0) / 6.0));
        z[0] = Poisson.cumulative(y, lambda, true, false);
        p *= 0.9999999999999858;
        if (lambda < 100000.0) {
            return Poisson.do_search(y, z, p, lambda, 1.0);
        }
        double incr = Math.floor(y * 0.001);
        do {
            oldincr = incr;
            y = Poisson.do_search(y, z, p, lambda, incr);
            incr = Math.max(1.0, Math.floor(incr / 100.0));
        } while (oldincr > 1.0 && incr > lambda * 1.0E-15);
        return y;
    }

    public static final double random(double mu, RandomEngine random) {
        return Poisson.random(mu, random, null);
    }

    public static final double[] random(int n, double mu, RandomEngine random) {
        return Poisson.random(n, mu, random, Poisson.create_random_state());
    }

    public static final double[] random(int n, double mu, RandomEngine random, RandomState state) {
        if (state == null) {
            state = Poisson.create_random_state();
        }
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = Poisson.random(mu, random, state);
        }
        return result;
    }

    public static final double random(double mu, RandomEngine random, RandomState state) {
        double g;
        boolean big_mu;
        double a0 = -0.5;
        double a1 = 0.3333333;
        double a2 = -0.2500068;
        double a3 = 0.2000118;
        double a4 = -0.1661269;
        double a5 = 0.1421878;
        double a6 = -0.1384794;
        double a7 = 0.125006;
        double one_7 = 0.14285714285714285;
        double one_12 = 0.08333333333333333;
        double one_24 = 0.041666666666666664;
        double[] fact = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0};
        double difmuk = 0.0;
        double E = 0.0;
        double fk = 0.0;
        double u = 0.0;
        double pois = -1.0;
        boolean kflag = true;
        boolean new_big_mu = false;
        if (MathFunctions.isInfinite(mu) || mu < 0.0) {
            return Double.NaN;
        }
        if (mu <= 0.0) {
            return 0.0;
        }
        if (state == null) {
            state = new RandomState();
        }
        boolean bl = big_mu = mu >= 10.0;
        if (big_mu) {
            new_big_mu = false;
        }
        if (!big_mu || mu != state.muprev) {
            if (big_mu) {
                new_big_mu = true;
                state.muprev = mu;
                state.s = Math.sqrt(mu);
                state.d = 6.0 * mu * mu;
                state.big_l = Math.floor(mu - 1.1484);
            } else {
                if (mu != state.muprev) {
                    state.muprev = mu;
                    state.m = Math.max(1, (int)mu);
                    state.l = 0;
                    state.p0 = state.p = Math.exp(-mu);
                    state.q = state.p;
                }
                while (true) {
                    int k;
                    if ((u = random.nextDouble()) <= state.p0) {
                        return 0.0;
                    }
                    if (state.l != 0) {
                        int n = k = u <= 0.458 ? 1 : Math.min(state.l, state.m);
                        while (k <= state.l) {
                            if (u <= state.pp[k]) {
                                return k;
                            }
                            ++k;
                        }
                        if (state.l == 35) continue;
                    }
                    for (k = ++state.l; k <= 35; ++k) {
                        state.p *= mu / (double)k;
                        state.q += state.p;
                        state.pp[k] = state.q;
                        if (!(u <= state.q)) continue;
                        state.l = k;
                        return k;
                    }
                    state.l = 35;
                }
            }
        }
        if ((g = mu + state.s * Normal.random_standard(random)) >= 0.0) {
            pois = Math.floor(g);
            if (pois >= state.big_l) {
                return pois;
            }
            fk = pois;
            difmuk = mu - fk;
            u = random.nextDouble();
            if (state.d * u >= difmuk * difmuk * difmuk) {
                return pois;
            }
        }
        if (new_big_mu || mu != state.muprev2) {
            state.muprev2 = mu;
            state.omega = 0.3989422804014327 / state.s;
            state.b1 = 0.041666666666666664 / mu;
            state.b2 = 0.3 * state.b1 * state.b1;
            state.c3 = 0.14285714285714285 * state.b1 * state.b2;
            state.c2 = state.b2 - 15.0 * state.c3;
            state.c1 = state.b1 - 6.0 * state.b2 + 45.0 * state.c3;
            state.c0 = 1.0 - state.b1 + 3.0 * state.b2 - 15.0 * state.c3;
            state.c = 0.1069 / mu;
        }
        boolean skip_to_stepf = false;
        if (g >= 0.0) {
            kflag = false;
            skip_to_stepf = true;
        }
        double t = 0.0;
        while (true) {
            double py;
            double px;
            if (!skip_to_stepf) {
                E = Exponential.random_standard(random);
                u = 2.0 * random.nextDouble() - 1.0;
                t = 1.8 + Math.abs(E) * Math.signum(u);
                if (t <= -0.6744) continue;
                fk = pois = Math.floor(mu + state.s * t);
                difmuk = mu - fk;
                kflag = true;
            }
            skip_to_stepf = false;
            if (pois < 10.0) {
                px = -mu;
                py = Math.pow(mu, pois) / fact[(int)pois];
            } else {
                double del = 0.08333333333333333 / fk;
                del *= 1.0 - 4.8 * del * del;
                double v = difmuk / fk;
                px = Math.abs(v) <= 0.25 ? fk * v * v * (((((((0.125006 * v + -0.1384794) * v + 0.1421878) * v + -0.1661269) * v + 0.2000118) * v + -0.2500068) * v + 0.3333333) * v + -0.5) - del : fk * Math.log(1.0 + v) - difmuk - del;
                py = 0.3989422804014327 / Math.sqrt(fk);
            }
            double x = (0.5 - difmuk) / state.s;
            x *= x;
            double fx = -0.5 * x;
            double fy = state.omega * (((state.c3 * x + state.c2) * x + state.c1) * x + state.c0);
            if (kflag ? state.c * Math.abs(u) <= py * Math.exp(px + E) - fy * Math.exp(fx + E) : fy - u * fy <= py * Math.exp(px - fx)) break;
        }
        return pois;
    }

    public Poisson(double lambda) {
        this.lambda = lambda;
        this.state = Poisson.create_random_state();
    }

    public double density(double x, boolean log) {
        return Poisson.density(x, this.lambda, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Poisson.cumulative(p, this.lambda, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Poisson.quantile(q, this.lambda, lower_tail, log_p);
    }

    public double random() {
        return Poisson.random(this.lambda, this.random, this.state);
    }

    public double[] random(int n) {
        return Poisson.random(n, this.lambda, this.random, this.state);
    }

    public static class RandomState {
        int l;
        int m;
        double b1;
        double b2;
        double c;
        double c0;
        double c1;
        double c2;
        double c3;
        double[] pp = new double[36];
        double p0;
        double p;
        double q;
        double s;
        double d;
        double omega;
        double big_l;
        double muprev = 0.0;
        double muprev2 = 0.0;
    }
}

