/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Beta;
import jdistlib.ChiSquare;
import jdistlib.Normal;
import jdistlib.T;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class NonCentralT
extends GenericDistribution {
    protected double df;
    protected double ncp;

    public static final double density(double x, double df, double ncp, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(df)) {
            return x + df;
        }
        if (df <= 0.0) {
            return Double.NaN;
        }
        if (ncp == 0.0) {
            return T.density(x, df, give_log);
        }
        if (MathFunctions.isInfinite(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (MathFunctions.isInfinite(df) || df > 1.0E8) {
            return Normal.density(x, ncp, 1.0, give_log);
        }
        double u = Math.abs(x) > Math.sqrt(df * 2.220446049250313E-16) ? Math.log(df) - Math.log(Math.abs(x)) + Math.log(Math.abs(NonCentralT.cumulative(x * Math.sqrt((df + 2.0) / df), df + 2.0, ncp, true, false) - NonCentralT.cumulative(x, df, ncp, true, false))) : MathFunctions.lgammafn((df + 1.0) / 2.0) - MathFunctions.lgammafn(df / 2.0) - (0.5723649429247001 + 0.5 * (Math.log(df) + ncp * ncp));
        return give_log ? u : Math.exp(u);
    }

    public static final double cumulative(double t, double df, double ncp, boolean lower_tail, boolean log_p) {
        double tnc;
        double del;
        double tt;
        boolean negdel;
        int itrmax = 1000;
        double errmax = 1.0E-12;
        if (df <= 0.0) {
            return Double.NaN;
        }
        if (ncp == 0.0) {
            return T.cumulative(t, df, lower_tail, log_p);
        }
        if (MathFunctions.isInfinite(t)) {
            return t < 0.0 ? (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0)) : (lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0));
        }
        if (t >= 0.0) {
            negdel = false;
            tt = t;
            del = ncp;
        } else {
            if (!(!(ncp > 40.0) || log_p && lower_tail)) {
                return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
            }
            negdel = true;
            tt = -t;
            del = -ncp;
        }
        if (df > 400000.0 || del * del > 1415.4065427034084) {
            double s = 1.0 / (4.0 * df);
            return Normal.cumulative(tt * (1.0 - s), del, Math.sqrt(1.0 + tt * tt * 2.0 * s), lower_tail != negdel, log_p);
        }
        double x = t * t;
        double rxb = df / (x + df);
        if ((x /= x + df) > 0.0) {
            double lambda = del * del;
            double p = 0.5 * Math.exp(-0.5 * lambda);
            if (p == 0.0) {
                System.err.println("Underflow error in NonCentralT.cumulative");
                return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
            }
            double q = 0.7978845608028654 * p * del;
            double s = 0.5 - p;
            if (s < 1.0E-7) {
                s = -0.5 * Math.expm1(-0.5 * lambda);
            }
            double a = 0.5;
            double b = 0.5 * df;
            rxb = Math.pow(rxb, b);
            double albeta = 0.5723649429247001 + MathFunctions.lgammafn(b) - MathFunctions.lgammafn(0.5 + b);
            double xodd = Beta.cumulative(x, a, b, true, false);
            double godd = 2.0 * rxb * Math.exp(a * Math.log(x) - albeta);
            tnc = b * x;
            double xeven = tnc < 2.220446049250313E-16 ? tnc : 1.0 - rxb;
            double geven = tnc * rxb;
            tnc = p * xodd + q * xeven;
            boolean conv = false;
            for (int it = 1; it <= 1000; ++it) {
                tnc += (p *= lambda / (double)(2 * it)) * (xodd -= (godd *= x * ((a += 1.0) + b - 1.0) / a)) + (q *= lambda / (double)(2 * it + 1)) * (xeven -= (geven *= x * (a + b - 0.5) / (a + 0.5)));
                if ((s -= p) < -1.0E-10) {
                    System.err.println("Precision error in NonCentralT.cumulative");
                    break;
                }
                if (s <= 0.0 && it > 1) {
                    conv = true;
                    break;
                }
                double errbd = 2.0 * s * (xodd - godd);
                if (!(Math.abs(errbd) < 1.0E-12)) continue;
                conv = true;
                break;
            }
            if (!conv) {
                System.err.println("Non-convergence error in NonCentralT.cumulative");
            }
        } else {
            tnc = 0.0;
        }
        tnc += Normal.cumulative(-del, 0.0, 1.0, true, false);
        boolean bl = lower_tail = lower_tail != negdel;
        if (tnc > 0.9999999999 && lower_tail) {
            System.err.println("Precision error in final section of NonCentralT.cumulative");
        }
        tnc = Math.min(tnc, 1.0);
        return lower_tail ? (log_p ? Math.log(tnc) : tnc) : (log_p ? Math.log1p(-tnc) : 0.5 - tnc + 0.5);
    }

    public static final double quantile(double p, double df, double ncp, boolean lower_tail, boolean log_p) {
        double lx;
        double ux;
        double accu = 1.0E-13;
        double Eps = 1.0E-11;
        if (Double.isNaN(p) || Double.isNaN(df) || Double.isNaN(ncp)) {
            return p + df + ncp;
        }
        if (MathFunctions.isInfinite(df)) {
            return Double.NaN;
        }
        if (df <= 0.0) {
            return Double.NaN;
        }
        if (ncp == 0.0 && df >= 1.0) {
            return T.quantile(p, df, lower_tail, log_p);
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
        }
        double d = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (p = lower_tail ? p : 0.5 - p + 0.5);
        if (p > 0.9999999999999998) {
            return Double.POSITIVE_INFINITY;
        }
        double pp = Math.min(0.9999999999999998, p * 1.00000000001);
        for (ux = Math.max(1.0, ncp); ux < Double.MAX_VALUE && NonCentralT.cumulative(ux, df, ncp, true, false) < pp; ux *= 2.0) {
        }
        pp = p * 0.99999999999;
        for (lx = Math.min(-1.0, -ncp); lx > -1.7976931348623157E308 && NonCentralT.cumulative(lx, df, ncp, true, false) > pp; lx *= 2.0) {
        }
        do {
            double nx;
            if (NonCentralT.cumulative(nx = 0.5 * (lx + ux), df, ncp, true, false) > p) {
                ux = nx;
                continue;
            }
            lx = nx;
        } while (ux - lx > 1.0E-13 * Math.max(Math.abs(lx), Math.abs(ux)));
        return 0.5 * (lx + ux);
    }

    public static final double random(double df, double ncp, RandomEngine random) {
        if (ncp == 0.0) {
            return T.random(df, random);
        }
        return Normal.random(ncp, 1.0, random) / Math.sqrt(ChiSquare.random(df, random) / df);
    }

    public static final double[] random(int n, double df, double ncp, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = NonCentralT.random(df, ncp, random);
        }
        return rand;
    }

    public NonCentralT(double df, double ncp) {
        this.df = df;
        this.ncp = ncp;
    }

    public double density(double x, boolean log) {
        return NonCentralT.density(x, this.df, this.ncp, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return NonCentralT.cumulative(p, this.df, this.ncp, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return NonCentralT.quantile(q, this.df, this.ncp, lower_tail, log_p);
    }

    public double random() {
        return NonCentralT.random(this.df, this.ncp, this.random);
    }
}

