/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Normal;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class LogNormal
extends GenericDistribution {
    protected double meanlog;
    protected double sdlog;

    public static final double density(double x, double meanlog, double sdlog, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(meanlog) || Double.isNaN(sdlog)) {
            return x + meanlog + sdlog;
        }
        if (sdlog <= 0.0) {
            if (sdlog < 0.0) {
                return Double.NaN;
            }
            return Math.log(x) == meanlog ? Double.POSITIVE_INFINITY : (give_log ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (x <= 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        double y = (Math.log(x) - meanlog) / sdlog;
        return give_log ? -(0.9189385332046728 + 0.5 * y * y + Math.log(x * sdlog)) : 0.3989422804014327 * Math.exp(-0.5 * y * y) / (x * sdlog);
    }

    public static final double cumulative(double x, double meanlog, double sdlog, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(meanlog) || Double.isNaN(sdlog)) {
            return x + meanlog + sdlog;
        }
        if (sdlog < 0.0) {
            return Double.NaN;
        }
        if (x > 0.0) {
            return Normal.cumulative(Math.log(x), meanlog, sdlog, lower_tail, log_p);
        }
        return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
    }

    public static final double quantile(double p, double meanlog, double sdlog, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(meanlog) || Double.isNaN(sdlog)) {
            return p + meanlog + sdlog;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        return Math.exp(Normal.quantile(p, meanlog, sdlog, lower_tail, log_p));
    }

    public static final double random(double meanlog, double sdlog, RandomEngine random) {
        if (Double.isNaN(meanlog) || MathFunctions.isInfinite(sdlog) || sdlog < 0.0) {
            return Double.NaN;
        }
        return Math.exp(Normal.random(meanlog, sdlog, random));
    }

    public static final double[] random(int n, double meanlog, double sdlog, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = LogNormal.random(meanlog, sdlog, random);
        }
        return rand;
    }

    public LogNormal() {
        this(0.0, 1.0);
    }

    public LogNormal(double meanlog, double sdlog) {
        this.meanlog = meanlog;
        this.sdlog = sdlog;
    }

    public double density(double x, boolean log) {
        return LogNormal.density(x, this.meanlog, this.sdlog, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return LogNormal.cumulative(p, this.meanlog, this.sdlog, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return LogNormal.quantile(q, this.meanlog, this.sdlog, lower_tail, log_p);
    }

    public double random() {
        return LogNormal.random(this.meanlog, this.sdlog, this.random);
    }
}

