/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.disttest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import jdistlib.Ansari;
import jdistlib.Binomial;
import jdistlib.ChiSquare;
import jdistlib.F;
import jdistlib.Normal;
import jdistlib.Poisson;
import jdistlib.SignRank;
import jdistlib.T;
import jdistlib.Wilcoxon;
import jdistlib.disttest.TestKind;
import jdistlib.disttest.Utils;
import jdistlib.math.VectorMath;
import jdistlib.util.Utilities;

public class DistributionTest {
    public static final double kolmogorov_smirnov_statistic(double[] X, double[] Y) {
        int nX = X.length;
        int nY = Y.length;
        int idxX = 0;
        int idxY = 0;
        double[] sortedX = new double[nX];
        double[] sortedY = new double[nY];
        double maxDiv = 0.0;
        System.arraycopy(X, 0, sortedX, 0, nX);
        System.arraycopy(Y, 0, sortedY, 0, nY);
        Utilities.sort(sortedX);
        Utilities.sort(sortedY);
        if (sortedX[nX - 1] < sortedY[0] || sortedY[nY - 1] < sortedX[0]) {
            return 1.0;
        }
        double[] cdfX = Utils.calculate_ecdf(sortedX);
        double[] cdfY = Utils.calculate_ecdf(sortedY);
        double pX = 0.0;
        double pY = 0.0;
        double div = 0.0;
        while (idxX < nX && idxY < nY) {
            double y = sortedY[idxY];
            double x = sortedX[idxX];
            if (y < x) {
                pY = cdfY[idxY];
                ++idxY;
            } else if (y > x) {
                pX = cdfX[idxX];
                ++idxX;
            } else {
                pX = cdfX[idxX];
                pY = cdfY[idxY];
                ++idxX;
                ++idxY;
            }
            if (!((div = Math.abs(pX - pY)) > maxDiv)) continue;
            maxDiv = div;
        }
        return maxDiv;
    }

    public static final double kolmogorov_smirnov_pvalue(double maxDiv, int lengthX, int lengthY) {
        if (lengthX > lengthY) {
            int temp = lengthY;
            lengthY = lengthX;
            lengthX = temp;
        }
        double q = Math.floor(maxDiv * (double)lengthX * (double)lengthY - 1.0E-7) / (double)(lengthX * lengthY);
        double[] u = new double[lengthY + 1];
        double md = lengthX;
        double nd = lengthY;
        for (int j = 0; j <= lengthY; ++j) {
            u[j] = (double)j / nd > q ? 0.0 : 1.0;
        }
        for (int i = 1; i <= lengthX; ++i) {
            double w = (double)i / (double)(i + lengthY);
            u[0] = (double)i / md > q ? 0.0 : w * u[0];
            for (int j = 1; j <= lengthY; ++j) {
                u[j] = Math.abs((double)i / md - (double)j / nd) > q ? 0.0 : w * u[j] + u[j - 1];
            }
        }
        return 1.0 - u[lengthY];
    }

    public static final double[] ansari_bradley_test(double[] x, double[] y, boolean force_exact) {
        return DistributionTest.ansari_bradley_test(x, y, force_exact, TestKind.TWO_SIDED);
    }

    public static final double[] ansari_bradley_test(double[] x, double[] y, boolean force_exact, TestKind kind) {
        int nx = x.length;
        int ny = y.length;
        double N = nx + ny;
        double[] r = Utilities.rank(Utilities.c(new double[][]{x, y}));
        boolean has_ties = Utilities.unique(r).length != r.length;
        boolean large_xy = nx >= 50 || ny >= 50;
        double h = 0.0;
        r = VectorMath.pmin(r, VectorMath.vmin(N + 1.0, r));
        for (int i = 0; i < nx; ++i) {
            h += r[i];
        }
        if (force_exact || !has_ties && !large_xy) {
            switch (kind) {
                case TWO_SIDED: {
                    double limit = (double)((nx + 1) * (nx + 1) / 4) + (double)(nx * ny / 2) / 2.0;
                    double p = h > limit ? 1.0 - Ansari.cumulative((int)h - 1, nx, ny) : Ansari.cumulative((int)h, nx, ny);
                    p = Math.min(2.0 * p, 1.0);
                    return new double[]{h, p};
                }
                case LOWER: {
                    double p = Ansari.cumulative((int)(h - 1.0), nx, ny, false);
                    return new double[]{h, p};
                }
                case GREATER: {
                    double p = Ansari.cumulative((int)h, nx, ny, true);
                    return new double[]{h, p};
                }
            }
            throw new RuntimeException();
        }
        Utilities.sort(r);
        double[][] rle = Utilities.rle(r);
        double denom = 16.0 * N * (N - 1.0);
        double Np1Sq = N + 1.0;
        double Np2 = N + 2.0;
        Np1Sq *= Np1Sq;
        double sigma = 16.0 * VectorMath.sum(VectorMath.vtimes(VectorMath.vtimes(rle[0], rle[0]), rle[1]));
        sigma = N % 2.0 == 0.0 ? Math.sqrt((double)(nx * ny) * (sigma - N * Np2 * Np2) / denom) : Math.sqrt((double)(nx * ny) * (sigma * N - Np1Sq * Np1Sq) / (denom * N));
        double z = N % 2.0 == 0.0 ? h - (double)nx * Np2 / 4.0 : h - (double)nx * Np1Sq / (4.0 * N);
        double p = Normal.cumulative(z / sigma, 0.0, 1.0, true, false);
        p = 2.0 * Math.min(p, 1.0 - p);
        return new double[]{h, p};
    }

    public static final double[] mood_test(double[] x, double[] y) {
        return DistributionTest.mood_test(x, y, TestKind.TWO_SIDED);
    }

    public static final double[] mood_test(double[] x, double[] y, TestKind kind) {
        int nx = x.length;
        int ny = y.length;
        double N = nx + ny;
        if (N < 3.0) {
            throw new RuntimeException("Not enough observations");
        }
        double E = (double)nx * (N * N - 1.0) / 12.0;
        double v = 0.005555555555555556 * (double)nx * (double)ny * (N + 1.0) * (N + 2.0) * (N - 2.0);
        double[] z = Utilities.c(new double[][]{x, y});
        boolean has_ties = Utilities.unique(z).length != z.length;
        double T2 = 0.0;
        double con = (N + 1.0) / 2.0;
        if (!has_ties) {
            double[] r = Utilities.rank(z);
            for (int i = 0; i < nx; ++i) {
                double val = r[i] - con;
                T2 += val * val;
            }
        } else {
            double[] u = Utilities.unique(z);
            Utilities.sort(u);
            int[] a = Utilities.tabulate(Utilities.match(x, u), u.length);
            int[] t = Utilities.tabulate(Utilities.match(z, u), u.length);
            double[] p = VectorMath.vmin(Utilities.colon(1.0, (double)z.length), con);
            p = VectorMath.cumsum(VectorMath.vsq(p));
            double sum = 0.0;
            for (int i = 0; i < u.length; ++i) {
                double ti = t[i];
                double NmtiSq = N - (double)t[i];
                double tsq = ti * ti;
                NmtiSq *= NmtiSq;
                sum += ti * (tsq - 1.0) * (tsq - 4.0 + 15.0 * NmtiSq);
            }
            v -= (double)(nx * ny) / (180.0 * N * (N - 1.0)) * sum;
            double[] temp = VectorMath.diff(Utilities.c(new double[][]{{0.0}, Utilities.index_min1(p, VectorMath.cumsum(t))}));
            for (int i = 0; i < t.length; ++i) {
                T2 += (double)a[i] * temp[i] / (double)t[i];
            }
        }
        double zz = (T2 - E) / Math.sqrt(v);
        double p = Normal.cumulative(zz, 0.0, 1.0, kind != TestKind.GREATER, false);
        return new double[]{zz, kind == TestKind.TWO_SIDED ? 2.0 * Math.min(p, 1.0 - p) : p};
    }

    public static final double[] var_test(double[] x, double[] y, TestKind kind) {
        return DistributionTest.var_test(x, y, 1.0, kind);
    }

    public static final double[] var_test(double[] x, double[] y, double ratio, TestKind kind) {
        double stat = VectorMath.var(x) / VectorMath.var(y) / ratio;
        double p = Double.NaN;
        switch (kind) {
            case TWO_SIDED: {
                p = F.cumulative(stat, x.length - 1, y.length - 1, true, false);
                p = 2.0 * Math.min(p, 1.0 - p);
                break;
            }
            case GREATER: {
                p = F.cumulative(stat, x.length - 1, y.length - 1, false, false);
                break;
            }
            case LOWER: {
                p = F.cumulative(stat, x.length - 1, y.length - 1, true, false);
            }
        }
        return new double[]{stat, p};
    }

    public static final double[] wilcoxon_test(double[] x, double mu, boolean correction, TestKind kind) {
        boolean has_zeroes = false;
        int n_nonzero = 0;
        HashSet<Double> seen_set = new HashSet<Double>();
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == mu) {
                has_zeroes = true;
                continue;
            }
            ++n_nonzero;
            seen_set.add(x[i]);
        }
        double[] new_x = new double[n_nonzero];
        int j = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == mu) continue;
            new_x[j++] = x[i] - mu;
        }
        x = new_x;
        boolean has_ties = seen_set.size() != x.length;
        double[] r = Utilities.rank(VectorMath.vabs(x));
        int n = r.length;
        double limit = (double)(n * (n + 1)) / 4.0;
        double v = 0.0;
        double p = Double.NaN;
        for (int i = 0; i < n; ++i) {
            v += r[i];
        }
        if (!has_ties && !has_zeroes) {
            SignRank sr = new SignRank(n);
            switch (kind) {
                case TWO_SIDED: {
                    p = v > limit ? sr.cumulative(v - 1.0, false, false) : sr.cumulative(v);
                    p = Math.min(2.0 * p, 1.0);
                    break;
                }
                case GREATER: {
                    p = sr.cumulative(v - 1.0, false, false);
                    break;
                }
                case LOWER: {
                    p = sr.cumulative(v);
                }
            }
        } else {
            double sigma = 0.0;
            for (int nties : VectorMath.table(r).values()) {
                sigma += (double)(nties * nties * nties - nties);
            }
            sigma = Math.sqrt(limit * (double)(2 * n + 1) / 6.0 - sigma / 48.0);
            v -= limit;
            double cor = 0.0;
            if (correction) {
                switch (kind) {
                    case TWO_SIDED: {
                        cor = Math.signum(v) * 0.5;
                        break;
                    }
                    case GREATER: {
                        cor = 0.5;
                        break;
                    }
                    case LOWER: {
                        cor = -0.5;
                    }
                }
            }
            v = (v - cor) / sigma;
            switch (kind) {
                case TWO_SIDED: {
                    p = 2.0 * Math.min(Normal.cumulative_standard(v), Normal.cumulative(v, 0.0, 1.0, false, false));
                    break;
                }
                case GREATER: {
                    p = Normal.cumulative(v, 0.0, 1.0, false, false);
                    break;
                }
                case LOWER: {
                    p = Normal.cumulative_standard(v);
                }
            }
        }
        return new double[]{v, p};
    }

    public static final double[] mann_whitney_u_test(double[] x, double[] y, double mu, boolean correction, boolean paired, TestKind kind) {
        boolean has_ties;
        int nx = x.length;
        int ny = y.length;
        int n = nx + ny;
        if (paired) {
            return DistributionTest.wilcoxon_test(VectorMath.vmin(x, y), mu, correction, kind);
        }
        double[] r = Utilities.rank(Utilities.c(new double[][]{VectorMath.vmin(x, mu), y}));
        double w = -nx * (nx + 1) / 2;
        double p = Double.NaN;
        double limit = (double)(nx * ny) / 2.0;
        for (int i = 0; i < nx; ++i) {
            w += r[i];
        }
        boolean bl = has_ties = Utilities.unique(r).length != r.length;
        if (!has_ties) {
            Wilcoxon wilcox = new Wilcoxon(nx, ny);
            switch (kind) {
                case TWO_SIDED: {
                    p = w > limit ? wilcox.cumulative(w - 1.0, false, false) : wilcox.cumulative(w);
                    p = Math.min(2.0 * p, 1.0);
                    break;
                }
                case GREATER: {
                    p = wilcox.cumulative(w - 1.0, false, false);
                    break;
                }
                case LOWER: {
                    p = wilcox.cumulative(w);
                }
            }
        } else {
            double sigma = 0.0;
            for (int nties : VectorMath.table(r).values()) {
                sigma += (double)(nties * nties * nties - nties);
            }
            sigma = Math.sqrt(limit / 6.0 * ((double)(n + 1) - sigma / (double)(n * (n + 1))));
            w -= limit;
            double cor = 0.0;
            if (correction) {
                switch (kind) {
                    case TWO_SIDED: {
                        cor = Math.signum(w) * 0.5;
                        break;
                    }
                    case GREATER: {
                        cor = 0.5;
                        break;
                    }
                    case LOWER: {
                        cor = -0.5;
                    }
                }
            }
            w = (w - cor) / sigma;
            switch (kind) {
                case TWO_SIDED: {
                    p = 2.0 * Math.min(Normal.cumulative_standard(w), Normal.cumulative(w, 0.0, 1.0, false, false));
                    break;
                }
                case GREATER: {
                    p = Normal.cumulative(w, 0.0, 1.0, false, false);
                    break;
                }
                case LOWER: {
                    p = Normal.cumulative_standard(w);
                }
            }
        }
        return new double[]{w, p};
    }

    public static final double[] t_test(double[] x, double mu, TestKind kind) {
        int nx = x.length;
        double stderr = Math.sqrt(VectorMath.var(x) / (double)nx);
        --nx;
        double t = (VectorMath.mean(x) - mu) / stderr;
        double p = Double.NaN;
        switch (kind) {
            case TWO_SIDED: {
                p = 2.0 * T.cumulative(-Math.abs(t), nx, true, false);
                break;
            }
            case GREATER: {
                p = T.cumulative(t, nx, false, false);
                break;
            }
            case LOWER: {
                p = T.cumulative(t, nx, true, false);
            }
        }
        return new double[]{t, p};
    }

    public static final double[] t_test_paired(double[] x, double[] y, double mu, TestKind kind) {
        return DistributionTest.t_test(VectorMath.vmin(x, y), mu, kind);
    }

    public static final double[] t_test(double[] x, double[] y, double mu, boolean pool_var, TestKind kind) {
        double stderr;
        double df;
        int nx = x.length;
        int ny = y.length;
        if (pool_var) {
            df = nx + ny - 2;
            stderr = 0.0;
            if (nx > 1) {
                stderr += (double)(nx - 1) * VectorMath.var(x);
            }
            if (ny > 1) {
                stderr += (double)(ny - 1) * VectorMath.var(y);
            }
            stderr = Math.sqrt(stderr / df * (1.0 / (double)nx + 1.0 / (double)ny));
        } else {
            double sx = VectorMath.var(x) / (double)nx;
            double sy = VectorMath.var(y) / (double)ny;
            stderr = sx + sy;
            df = stderr * stderr / (sx * sx / (double)(nx - 1) + sy * sy / (double)(ny - 1));
            stderr = Math.sqrt(stderr);
        }
        double t = (VectorMath.mean(x) - VectorMath.mean(y) - mu) / stderr;
        double p = Double.NaN;
        switch (kind) {
            case TWO_SIDED: {
                p = 2.0 * T.cumulative(-Math.abs(t), df, true, false);
                break;
            }
            case GREATER: {
                p = T.cumulative(t, df, false, false);
                break;
            }
            case LOWER: {
                p = T.cumulative(t, df, true, false);
            }
        }
        return new double[]{t, p};
    }

    public static final double[] binomial_test(int n_success, int n, double p, TestKind kind) {
        switch (kind) {
            case TWO_SIDED: {
                if (p == 0.0) {
                    p = n_success == 0 ? 1.0 : 0.0;
                    break;
                }
                if (p == 1.0) {
                    p = n_success == n ? 1.0 : 0.0;
                    break;
                }
                double d = Binomial.density(n_success, n, p, false) * 1.0000001;
                double m = (double)n * p;
                if ((double)n_success == m) {
                    p = 1.0;
                    break;
                }
                if ((double)n_success < m) {
                    int y = 0;
                    for (int i = (int)Math.ceil(m); i <= n; ++i) {
                        if (!(Binomial.density(i, n, p, false) <= d)) continue;
                        ++y;
                    }
                    p = Binomial.cumulative(n_success, n, p, true, false) + Binomial.cumulative(n - y, n, p, false, false);
                    break;
                }
                int y = 0;
                int mlo = (int)Math.floor(m);
                for (int i = 0; i <= mlo; ++i) {
                    if (!(Binomial.density(i, n, p, false) <= d)) continue;
                    ++y;
                }
                p = Binomial.cumulative(y - 1, n, p, true, false) + Binomial.cumulative(n_success - 1, n, p, false, false);
                break;
            }
            case GREATER: {
                p = Binomial.cumulative(n_success - 1, n, p, false, false);
                break;
            }
            case LOWER: {
                p = Binomial.cumulative(n_success, n, p, true, false);
            }
        }
        return new double[]{n_success, p};
    }

    public static final double[] bartlett_test(double[] x, int[] group) {
        int n = x.length;
        if (n != group.length) {
            throw new RuntimeException();
        }
        HashMap<Integer, ArrayList<Double>> map = new HashMap<Integer, ArrayList<Double>>();
        for (int i = 0; i < n; ++i) {
            ArrayList<Double> ll = (ArrayList<Double>)map.get(group[i]);
            if (ll == null) {
                ll = new ArrayList<Double>();
                map.put(group[i], ll);
            }
            ll.add(x[i]);
        }
        int[] unique_group = Utilities.to_int_array(map.keySet());
        int k = unique_group.length;
        double v_total = 0.0;
        double sum_recip = 0.0;
        double sum_n_vlog = 0.0;
        for (int i = 0; i < k; ++i) {
            double[] dbl = Utilities.to_double_array((Collection)map.get(unique_group[i]));
            double var_group = VectorMath.var(dbl);
            int ni = dbl.length - 1;
            v_total += (double)ni * var_group / (double)(n - k);
            sum_recip += 1.0 / (double)ni;
            sum_n_vlog += (double)ni * Math.log(var_group);
        }
        double stat = ((double)(n - k) * Math.log(v_total) - sum_n_vlog) / (1.0 + (sum_recip - 1.0 / (double)(n - k)) / (double)(3 * (k - 1)));
        double p = ChiSquare.cumulative(stat, k - 1, false, false);
        return new double[]{stat, p};
    }

    public static final double[] fligner_test(double[] x, int[] group) {
        int i;
        int n = x.length;
        if (n != group.length) {
            throw new RuntimeException();
        }
        HashMap<Integer, ArrayList<Double>> map = new HashMap<Integer, ArrayList<Double>>();
        for (int i2 = 0; i2 < n; ++i2) {
            ArrayList<Double> ll = (ArrayList<Double>)map.get(group[i2]);
            if (ll == null) {
                ll = new ArrayList<Double>();
                map.put(group[i2], ll);
            }
            ll.add(x[i2]);
        }
        int[] unique_group = Utilities.to_int_array(map.keySet());
        int k = unique_group.length;
        int[] cumsum_n_group = new int[k];
        int[] n_group = new int[k];
        double[] new_x = new double[n];
        for (i = 0; i < k; ++i) {
            double[] dbl = Utilities.to_double_array((Collection)map.get(unique_group[i]));
            int ni = dbl.length;
            cumsum_n_group[i] = ni + (i > 0 ? cumsum_n_group[i - 1] : 0);
            n_group[i] = ni;
            double med_group = VectorMath.median(dbl);
            int j = 0;
            while (j < ni) {
                int n2 = j++;
                dbl[n2] = dbl[n2] - med_group;
            }
            System.arraycopy(dbl, 0, new_x, i == 0 ? 0 : cumsum_n_group[i - 1], ni);
        }
        new_x = Utilities.rank(VectorMath.vabs(new_x));
        for (i = 0; i < new_x.length; ++i) {
            new_x[i] = Normal.quantile((1.0 + new_x[i] / (double)(n + 1)) / 2.0, 0.0, 1.0, true, false);
        }
        double stat = 0.0;
        for (int i3 = 0; i3 < k; ++i3) {
            int from = i3 == 0 ? 0 : cumsum_n_group[i3 - 1];
            int ni = n_group[i3];
            int to = from + ni;
            double sum = 0.0;
            for (int j = from; j < to; ++j) {
                sum += new_x[j];
            }
            stat += sum * sum / (double)ni;
        }
        double ma = VectorMath.mean(new_x);
        stat = (stat - (double)n * ma * ma) / VectorMath.var(new_x);
        double p = ChiSquare.cumulative(stat, k - 1, false, false);
        return new double[]{stat, p};
    }

    public static final double[] kruskal_wallis_test(double[] x, int[] group) {
        int n = x.length;
        if (n != group.length) {
            throw new RuntimeException();
        }
        HashMap<Integer, ArrayList<Double>> map = new HashMap<Integer, ArrayList<Double>>();
        for (int i = 0; i < n; ++i) {
            ArrayList<Double> ll = (ArrayList<Double>)map.get(group[i]);
            if (ll == null) {
                ll = new ArrayList<Double>();
                map.put(group[i], ll);
            }
            ll.add(x[i]);
        }
        int[] unique_group = Utilities.to_int_array(map.keySet());
        int k = unique_group.length;
        int[] cumsum_n_group = new int[k];
        int[] n_group = new int[k];
        double[] new_x = new double[n];
        for (int i = 0; i < k; ++i) {
            double[] dbl = Utilities.to_double_array((Collection)map.get(unique_group[i]));
            int ni = dbl.length;
            cumsum_n_group[i] = ni + (i > 0 ? cumsum_n_group[i - 1] : 0);
            n_group[i] = ni;
            System.arraycopy(dbl, 0, new_x, i == 0 ? 0 : cumsum_n_group[i - 1], ni);
        }
        double[] r = Utilities.rank(new_x);
        double stat = 0.0;
        for (int i = 0; i < k; ++i) {
            int from = i == 0 ? 0 : cumsum_n_group[i - 1];
            int ni = n_group[i];
            int to = from + ni;
            double sum = 0.0;
            for (int j = from; j < to; ++j) {
                sum += r[j];
            }
            stat += sum * sum / (double)ni;
        }
        double sigma = 0.0;
        for (int nties : VectorMath.table(r).values()) {
            sigma += (double)(nties * nties * nties - nties);
        }
        stat = (12.0 * stat / (double)(n * (n + 1)) - (double)(3 * (n + 1))) / (1.0 - sigma / (double)(n * n * n - n));
        double p = ChiSquare.cumulative(stat, k - 1, false, false);
        return new double[]{stat, p};
    }

    public static final double[] poisson_test(int num_events, double time, double rate, TestKind kind) {
        if (time < 0.0 || rate < 0.0 || num_events < 0) {
            throw new RuntimeException();
        }
        double m = rate * time;
        double p = Double.NaN;
        switch (kind) {
            case TWO_SIDED: {
                if (m == 0.0) {
                    p = num_events == 0 ? 1.0 : 0.0;
                    break;
                }
                if ((double)num_events == m) {
                    p = 1.0;
                    break;
                }
                double d = Poisson.density(num_events, m, false);
                double fuzz = 1.0000001 * d;
                double y = 0.0;
                if ((double)num_events < m) {
                    double N = (int)Math.ceil(2.0 * m - (double)num_events);
                    while (Poisson.density(N, m, false) > d) {
                        N *= 2.0;
                    }
                    int i = (int)Math.ceil(m);
                    while ((double)i <= N) {
                        if (Poisson.density(i, m, false) <= fuzz) {
                            y += 1.0;
                        }
                        ++i;
                    }
                    p = Poisson.cumulative(num_events, m, true, false) + Poisson.cumulative(N - y, m, false, false);
                    break;
                }
                double N = (int)Math.floor(m);
                int i = 0;
                while ((double)i < N) {
                    if (Poisson.density(i, m, false) <= fuzz) {
                        y += 1.0;
                    }
                    ++i;
                }
                p = Poisson.cumulative(y - 1.0, m, true, false) + Poisson.cumulative(num_events - 1, m, false, false);
                break;
            }
            case GREATER: {
                p = Poisson.cumulative(num_events - 1, m, false, false);
                break;
            }
            case LOWER: {
                p = Poisson.cumulative(num_events, m, true, false);
            }
        }
        return new double[]{num_events, p};
    }

    public static final double[] poisson_test(int num_events1, int num_events2, double time1, double time2, double r, TestKind kind) {
        if (time1 < 0.0 || time2 < 0.0 || r < 0.0 || num_events1 < 0 || num_events2 < 0) {
            throw new RuntimeException();
        }
        return DistributionTest.binomial_test(num_events1, num_events1 + num_events2, r * time1 / (r * time1 + time2), kind);
    }

    private static final double cramer_vonmises_statistic(double[] X, double[] Y) {
        double val;
        int i;
        int nX = X.length;
        int nY = Y.length;
        int nXY = nX * nY;
        int nXPY = nX + nY;
        double[] rank = Utilities.rank(Utilities.c(new double[][]{X, Y}));
        double[] rankX = Utilities.rank(X);
        double[] rankY = Utilities.rank(Y);
        double sumX = 0.0;
        double sumY = 0.0;
        for (i = 0; i < nX; ++i) {
            val = rank[i] - rankX[i];
            sumX += val * val;
        }
        for (i = nX; i < nXPY; ++i) {
            val = rank[i] - rankY[i - nX];
            sumY += val * val;
        }
        val = ((double)nX * sumX + (double)nY * sumY) / (double)(nXY * nXPY) - (double)((4 * nXY - 1) / (6 * nXPY));
        return val;
    }

    public static final void main(String[] args) {
        double[] x = new double[]{-1.2315764307891697, 0.10766660489198622, -0.25076771026116995, 0.1865730243313593, 0.7674721840239808, -0.18746405292415022, 0.13769759969213102, 0.37226584315573147, 1.8257862598243677, -1.4691239378183403};
        double[] y = new double[]{2.633833206002906, -1.0413375749105698, -1.0811218382230727, 2.702460192243479, 1.6265489662012782, 1.3366425380960192, 1.0751450212932796, 1.5430569496700024, -0.08503998732825324, 1.3579302158870394};
        System.out.println(DistributionTest.cramer_vonmises_statistic(x, y));
    }
}

