/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.Exponential;
import jdistlib.rng.QRandomEngine;

public class GeneralizedPareto {
    public static final double density(double x, double loc, double scale, double shape, boolean log) {
        if (scale <= 0.0) {
            return Double.NaN;
        }
        if (1.0 + shape * (x = (x - loc) / scale) <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        x = shape == 0.0 ? -Math.log(scale) - x : -Math.log(scale) - (1.0 / shape + 1.0) * Math.log(1.0 + shape * x);
        return !log ? Math.exp(x) : x;
    }

    public static final double cumulative(double q, double loc, double scale, double shape, boolean lower_tail) {
        if (scale <= 0.0) {
            return Double.NaN;
        }
        q = Math.max(q - loc, 0.0) / scale;
        q = shape == 0.0 ? 1.0 - Math.exp(-q) : 1.0 - Math.pow(Math.max(1.0 + shape * q, 0.0), -1.0 / shape);
        return !lower_tail ? 1.0 - q : q;
    }

    public static final double quantile(double p, double loc, double scale, double shape, boolean lower_tail) {
        if (p <= 0.0 || p >= 1.0 || scale < 0.0) {
            return Double.NaN;
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        p = shape == 0.0 ? 1.0 - Math.exp(-p) : 1.0 - Math.pow(Math.max(1.0 + shape * p, 0.0), -1.0 / shape);
        return shape == 0.0 ? loc - scale * Math.log(p) : loc + scale * (Math.pow(p, -shape) - 1.0) / shape;
    }

    public static final double random(double loc, double scale, double shape, QRandomEngine random) {
        if (scale < 0.0) {
            return Double.NaN;
        }
        return shape == 0.0 ? loc + scale * Math.log(Exponential.random_standard(random)) : loc + scale * ((Math.pow(random.nextDouble(), -shape) - 1.0) / shape);
    }
}

