/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.Exponential;
import jdistlib.rng.QRandomEngine;

public class GEV {
    public static final double density(double x, double loc, double scale, double shape, boolean log) {
        if (scale <= 0.0) {
            return Double.NaN;
        }
        x = (x - loc) / scale;
        x = shape == 0.0 ? -Math.log(scale) - x - Math.exp(-x) : ((x = 1.0 + shape * x) <= 0.0 ? Double.NEGATIVE_INFINITY : -Math.log(scale) - Math.pow(x, -1.0 / shape) - (1.0 / shape + 1.0) * Math.log(x));
        return !log ? Math.exp(x) : x;
    }

    public static final double cumulative(double q, double loc, double scale, double shape, boolean lower_tail) {
        if (scale <= 0.0) {
            return Double.NaN;
        }
        q = (q - loc) / scale;
        q = shape == 0.0 ? Math.exp(-Math.exp(-q)) : Math.pow(Math.exp(Math.max(1.0 + shape * q, 0.0)), -1.0 / shape);
        return !lower_tail ? 1.0 - q : q;
    }

    public static final double quantile(double p, double loc, double scale, double shape, boolean lower_tail) {
        if (p <= 0.0 || p >= 1.0 || scale < 0.0) {
            return Double.NaN;
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        return shape == 0.0 ? loc - scale * Math.log(-Math.log(p)) : loc + scale * ((Math.pow(-Math.log(p), -shape) - 1.0) / shape);
    }

    public static final double random(double loc, double scale, double shape, QRandomEngine random) {
        if (scale < 0.0) {
            return Double.NaN;
        }
        return shape == 0.0 ? loc - scale * Math.log(Exponential.random_standard(random)) : loc + scale * ((Math.pow(Exponential.random_standard(random), -shape) - 1.0) / shape);
    }
}

