/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.MathFunctions;
import jdistlib.Normal;
import jdistlib.rng.QRandomEngine;

public class Tukey {
    static final double wprob(double w, double rr, double cc) {
        int nleg = 12;
        int ihalf = 6;
        double C1 = -30.0;
        double C2 = -50.0;
        double C3 = 60.0;
        double bb = 8.0;
        double wlar = 3.0;
        double wincr1 = 2.0;
        double wincr2 = 3.0;
        double[] xleg = new double[]{0.9815606342467192, 0.9041172563704749, 0.7699026741943047, 0.5873179542866175, 0.3678314989981802, 0.1252334085114689};
        double[] aleg = new double[]{0.04717533638651183, 0.10693932599531843, 0.16007832854334622, 0.20316742672306592, 0.2334925365383548, 0.24914704581340277};
        double qsqz = w * 0.5;
        if (qsqz >= 8.0) {
            return 1.0;
        }
        double pr_w = 2.0 * Normal.cumulative(qsqz, 0.0, 1.0, true, false) - 1.0;
        pr_w = pr_w >= Math.exp(-50.0 / cc) ? Math.pow(pr_w, cc) : 0.0;
        double wincr = w > 3.0 ? 2.0 : 3.0;
        double blb = qsqz;
        double binc = (8.0 - qsqz) / wincr;
        double bub = blb + binc;
        double einsum = 0.0;
        double cc1 = cc - 1.0;
        for (double wi = 1.0; wi <= wincr; wi += 1.0) {
            double elsum = 0.0;
            double a = 0.5 * (bub + blb);
            double b = 0.5 * (bub - blb);
            for (int jj = 1; jj <= 12; ++jj) {
                double pminus;
                double xx;
                int j;
                if (6 < jj) {
                    j = 12 - jj + 1;
                    xx = xleg[j - 1];
                } else {
                    j = jj;
                    xx = -xleg[j - 1];
                }
                double c = b * xx;
                double ac = a + c;
                double qexpo = ac * ac;
                if (qexpo > 60.0) break;
                double pplus = 2.0 * Normal.cumulative(ac, 0.0, 1.0, true, false);
                double rinsum = pplus * 0.5 - (pminus = 2.0 * Normal.cumulative(ac, w, 1.0, true, false)) * 0.5;
                if (!(rinsum >= Math.exp(-30.0 / cc1))) continue;
                rinsum = aleg[j - 1] * Math.exp(-(0.5 * qexpo)) * Math.pow(rinsum, cc1);
                elsum += rinsum;
            }
            einsum += (elsum *= 2.0 * b * cc * 0.3989422804014327);
            blb = bub;
            bub += binc;
        }
        if ((pr_w = einsum + pr_w) <= Math.exp(-30.0 / rr)) {
            return 0.0;
        }
        if ((pr_w = Math.pow(pr_w, rr)) >= 1.0) {
            return 1.0;
        }
        return pr_w;
    }

    public static final double cumulative(double q, double rr, double cc, double df, boolean lower_tail, boolean log_p) {
        int nlegq = 16;
        int ihalfq = 8;
        double eps1 = -30.0;
        double eps2 = 1.0E-14;
        double dhaf = 100.0;
        double dquar = 800.0;
        double deigh = 5000.0;
        double dlarg = 25000.0;
        double ulen1 = 1.0;
        double ulen2 = 0.5;
        double ulen3 = 0.25;
        double ulen4 = 0.125;
        double[] xlegq = new double[]{0.9894009349916499, 0.9445750230732326, 0.8656312023878318, 0.755404408355003, 0.6178762444026438, 0.45801677765722737, 0.2816035507792589, 0.09501250983763744};
        double[] alegq = new double[]{0.027152459411754096, 0.062253523938647894, 0.09515851168249279, 0.12462897125553388, 0.14959598881657674, 0.16915651939500254, 0.18260341504492358, 0.1894506104550685};
        double otsum = 0.0;
        if (Double.isInfinite(q) || Double.isInfinite(rr) || Double.isInfinite(cc) || Double.isInfinite(df)) {
            return Double.NaN;
        }
        if (q <= 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (df < 2.0 || rr < 1.0 || cc < 2.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(q)) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (df > 25000.0) {
            double x = Tukey.wprob(q, rr, cc);
            return lower_tail ? (log_p ? Math.log(x) : x) : (log_p ? Math.log1p(-x) : 0.5 - x + 0.5);
        }
        double f2 = df * 0.5;
        double f2lf = f2 * Math.log(df) - df * 0.6931471805599453 - MathFunctions.lgammafn(f2);
        double f21 = f2 - 1.0;
        double ff4 = df * 0.25;
        double ulen = df <= 100.0 ? 1.0 : (df <= 800.0 ? 0.5 : (df <= 5000.0 ? 0.25 : 0.125));
        f2lf += Math.log(ulen);
        double ans = 0.0;
        for (int i = 1; i <= 50; ++i) {
            otsum = 0.0;
            double twa1 = (double)(2 * i - 1) * ulen;
            for (int jj = 1; jj <= 16; ++jj) {
                double t1;
                int j;
                if (8 < jj) {
                    j = jj - 8 - 1;
                    t1 = f2lf + f21 * Math.log(twa1 + xlegq[j] * ulen) - (xlegq[j] * ulen + twa1) * ff4;
                } else {
                    j = jj - 1;
                    t1 = f2lf + f21 * Math.log(twa1 - xlegq[j] * ulen) + (xlegq[j] * ulen - twa1) * ff4;
                }
                if (!(t1 >= -30.0)) continue;
                double qsqz = 8 < jj ? q * Math.sqrt((xlegq[j] * ulen + twa1) * 0.5) : q * Math.sqrt((-(xlegq[j] * ulen) + twa1) * 0.5);
                double wprb = Tukey.wprob(qsqz, rr, cc);
                double rotsum = wprb * alegq[j] * Math.exp(t1);
                otsum += rotsum;
            }
            if ((double)i * ulen >= 1.0 && otsum <= 1.0E-14) break;
            ans += otsum;
        }
        if (otsum > 1.0E-14) {
            System.err.println("Precision error at Tukey.cumulative");
        }
        if (ans > 1.0) {
            ans = 1.0;
        }
        return lower_tail ? (log_p ? Math.log(ans) : ans) : (log_p ? Math.log1p(-ans) : 0.5 - ans + 0.5);
    }

    static double qinv(double p, double c, double v) {
        double p0 = 0.322232421088;
        double q0 = 0.099348462606;
        double p1 = -1.0;
        double q1 = 0.588581570495;
        double p2 = -0.342242088547;
        double q2 = 0.531103462366;
        double p3 = -0.204231210125;
        double q3 = 0.10353775285;
        double p4 = -4.53642210148E-5;
        double q4 = 0.0038560700634;
        double c1 = 0.8832;
        double c2 = 0.2368;
        double c3 = 1.214;
        double c4 = 1.208;
        double c5 = 1.4142;
        double vmax = 120.0;
        double ps = 0.5 - 0.5 * p;
        double yi = Math.sqrt(Math.log(1.0 / (ps * ps)));
        double t = yi + ((((yi * -4.53642210148E-5 + -0.204231210125) * yi + -0.342242088547) * yi + -1.0) * yi + 0.322232421088) / ((((yi * 0.0038560700634 + 0.10353775285) * yi + 0.531103462366) * yi + 0.588581570495) * yi + 0.099348462606);
        if (v < 120.0) {
            t += (t * t * t + t) / v / 4.0;
        }
        double q = 0.8832 - 0.2368 * t;
        if (v < 120.0) {
            q += -1.214 / v + 1.208 * t / v;
        }
        return t * (q * Math.log(c - 1.0) + 1.4142);
    }

    public static final double quantile(double p, double rr, double cc, double df, boolean lower_tail, boolean log_p) {
        double eps = 1.0E-4;
        int maxiter = 50;
        double ans = 0.0;
        if (Double.isNaN(p) || Double.isNaN(rr) || Double.isNaN(cc) || Double.isNaN(df)) {
            return p + rr + cc + df;
        }
        if (df < 2.0 || rr < 1.0 || cc < 2.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        p = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (lower_tail ? p : 0.5 - p + 0.5);
        double x0 = Tukey.qinv(p, cc, df);
        double valx0 = Tukey.cumulative(x0, rr, cc, df, true, false) - p;
        double x1 = valx0 > 0.0 ? Math.max(0.0, x0 - 1.0) : x0 + 1.0;
        double valx1 = Tukey.cumulative(x1, rr, cc, df, true, false) - p;
        for (int iter = 1; iter < 50; ++iter) {
            ans = x1 - valx1 * (x1 - x0) / (valx1 - valx0);
            valx0 = valx1;
            x0 = x1;
            if (ans < 0.0) {
                ans = 0.0;
                valx1 = -p;
            }
            valx1 = Tukey.cumulative(ans, rr, cc, df, true, false) - p;
            x1 = ans;
            double xabs = Math.abs(x1 - x0);
            if (!(xabs < 1.0E-4)) continue;
            return ans;
        }
        System.err.println("Non-convergence error in Tukey.quantile");
        return ans;
    }

    public static final double random(double rr, double cc, double df, QRandomEngine random) {
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Tukey.quantile(u1 / 1.34217728E8, rr, cc, df, true, false);
        return u1;
    }
}

