/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Beta;
import jdistlib.ChiSquare;
import jdistlib.MathFunctions;
import jdistlib.Normal;
import jdistlib.T;
import jdistlib.rng.QRandomEngine;

public class NonCentralT {
    public static final double density(double x, double df, double ncp, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(df)) {
            return x + df;
        }
        if (df <= 0.0) {
            return Double.NaN;
        }
        if (ncp == 0.0) {
            return T.density(x, df, give_log);
        }
        if (Double.isInfinite(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (Double.isInfinite(df) || df > 1.0E8) {
            return Normal.density(x, ncp, 1.0, give_log);
        }
        double u = Math.abs(x) > Math.sqrt(df * 2.220446049250313E-16) ? Math.log(df) - Math.log(Math.abs(x)) + Math.log(Math.abs(NonCentralT.cumulative(x * Math.sqrt((df + 2.0) / df), df + 2.0, ncp, true, false) - NonCentralT.cumulative(x, df, ncp, true, false))) : MathFunctions.lgammafn((df + 1.0) / 2.0) - MathFunctions.lgammafn(df / 2.0) - 0.5 * (Math.log(Math.PI) + Math.log(df) + ncp * ncp);
        return give_log ? u : Math.exp(u);
    }

    public static final double cumulative(double t, double df, double ncp, boolean lower_tail, boolean log_p) {
        double tnc;
        double del;
        double tt;
        boolean negdel;
        int itrmax = 1000;
        double errmax = 1.0E-12;
        if (df <= 0.0) {
            return Double.NaN;
        }
        if (ncp == 0.0) {
            return T.cumulative(t, df, lower_tail, log_p);
        }
        if (Double.isInfinite(t)) {
            return t < 0.0 ? (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0)) : (lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0));
        }
        if (t >= 0.0) {
            negdel = false;
            tt = t;
            del = ncp;
        } else {
            if (!(!(ncp > 40.0) || log_p && lower_tail)) {
                return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
            }
            negdel = true;
            tt = -t;
            del = -ncp;
        }
        if (df > 400000.0 || del * del > 1415.4065427034084) {
            double s = 1.0 / (4.0 * df);
            return Normal.cumulative(tt * (1.0 - s), del, Math.sqrt(1.0 + tt * tt * 2.0 * s), lower_tail != negdel, log_p);
        }
        double x = t * t;
        double rxb = df / (x + df);
        if ((x /= x + df) > 0.0) {
            double lambda = del * del;
            double p = 0.5 * Math.exp(-0.5 * lambda);
            if (p == 0.0) {
                System.err.println("Underflow error in NonCentralT.cumulative");
                return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
            }
            double q = 0.7978845608028654 * p * del;
            double s = 0.5 - p;
            if (s < 1.0E-7) {
                s = -0.5 * Math.expm1(-0.5 * lambda);
            }
            double a = 0.5;
            double b = 0.5 * df;
            rxb = Math.pow(rxb, b);
            double albeta = 0.5723649429247001 + MathFunctions.lgammafn(b) - MathFunctions.lgammafn(0.5 + b);
            double xodd = Beta.cumulative(x, a, b, true, false);
            double godd = 2.0 * rxb * Math.exp(a * Math.log(x) - albeta);
            tnc = b * x;
            double xeven = tnc < 2.220446049250313E-16 ? tnc : 1.0 - rxb;
            double geven = tnc * rxb;
            tnc = p * xodd + q * xeven;
            for (int it = 1; it <= 1000; ++it) {
                double errbd;
                tnc += (p *= lambda / (double)(2 * it)) * (xodd -= (godd *= x * ((a += 1.0) + b - 1.0) / a)) + (q *= lambda / (double)(2 * it + 1)) * (xeven -= (geven *= x * (a + b - 0.5) / (a + 0.5)));
                if ((s -= p) < -1.0E-10) {
                    System.err.println("Precision error in NonCentralT.cumulative");
                    break;
                }
                if (s <= 0.0 && it > 1 || Math.abs(errbd = 2.0 * s * (xodd - godd)) < 1.0E-12) break;
            }
            System.err.println("Non-convergence error in NonCentralT.cumulative");
        } else {
            tnc = 0.0;
        }
        tnc += Normal.cumulative(-del, 0.0, 1.0, true, false);
        boolean bl = lower_tail = lower_tail != negdel;
        if (tnc > 0.9999999999 && lower_tail) {
            System.err.println("Precision error in final section of NonCentralT.cumulative");
        }
        tnc = Math.min(tnc, 1.0);
        return lower_tail ? (log_p ? Math.log(tnc) : tnc) : (log_p ? Math.log1p(-tnc) : 0.5 - tnc + 0.5);
    }

    public static final double quantile(double p, double df, double ncp, boolean lower_tail, boolean log_p) {
        double nx;
        double lx;
        double ux;
        double accu = 1.0E-13;
        double Eps = 1.0E-11;
        if (Double.isNaN(p) || Double.isNaN(df) || Double.isNaN(ncp)) {
            return p + df + ncp;
        }
        if (Double.isInfinite(df)) {
            return Double.NaN;
        }
        if (df <= 0.0) {
            return Double.NaN;
        }
        if (ncp == 0.0 && df >= 1.0) {
            return T.quantile(p, df, lower_tail, log_p);
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
        }
        double d = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (p = lower_tail ? p : 0.5 - p + 0.5);
        if (p > 0.9999999999999998) {
            return Double.POSITIVE_INFINITY;
        }
        double pp = Math.min(0.9999999999999998, p * 1.00000000001);
        for (ux = Math.max(1.0, ncp); ux < Double.MAX_VALUE && NonCentralT.cumulative(ux, df, ncp, true, false) < pp; ux *= 2.0) {
        }
        pp = p * 0.99999999999;
        for (lx = Math.min(-1.0, -ncp); lx > -1.7976931348623157E308 && NonCentralT.cumulative(lx, df, ncp, true, false) > pp; lx *= 2.0) {
        }
        do {
            if (NonCentralT.cumulative(nx = 0.5 * (lx + ux), df, ncp, true, false) > p) {
                ux = nx;
                continue;
            }
            lx = nx;
        } while ((ux - lx) / Math.abs(nx) > 1.0E-13);
        return 0.5 * (lx + ux);
    }

    public static final double random(double df, double ncp, QRandomEngine random) {
        if (ncp == 0.0) {
            return T.random(df, random);
        }
        return Normal.random(ncp, 1.0, random) / Math.sqrt(ChiSquare.random(df, random) / df);
    }
}

