/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.ChiSquare;
import jdistlib.Gamma;
import jdistlib.MathFunctions;
import jdistlib.Poisson;
import jdistlib.rng.QRandomEngine;

public class NonCentralChiSquare {
    public static final double density(double x, double df, double ncp, boolean give_log) {
        double q;
        double mid;
        double eps = 5.0E-15;
        double dfmid = 0.0;
        if (Double.isNaN(x) || Double.isNaN(df) || Double.isNaN(ncp)) {
            return x + df + ncp;
        }
        if (ncp < 0.0 || df <= 0.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(df) || Double.isInfinite(ncp)) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x == 0.0 && df < 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (ncp == 0.0) {
            return ChiSquare.density(x, df, give_log);
        }
        if (x == Double.POSITIVE_INFINITY) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        double ncp2 = 0.5 * ncp;
        double imax = Math.ceil((-(2.0 + df) + Math.sqrt((2.0 - df) * (2.0 - df) + 4.0 * ncp * x)) / 4.0);
        if (imax < 0.0) {
            imax = 0.0;
        }
        if (!Double.isInfinite(imax)) {
            dfmid = df + 2.0 * imax;
            mid = Poisson.density_raw(imax, ncp2, false) * ChiSquare.density(x, dfmid, false);
        } else {
            mid = 0.0;
        }
        if (mid == 0.0) {
            if (give_log || ncp > 1000.0) {
                double nl = df + ncp;
                double ic = nl / (nl + ncp);
                return ChiSquare.density(x * ic, nl * ic, give_log);
            }
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        double sum = mid;
        double term = mid;
        df = dfmid;
        double i = imax;
        double x2 = x * ncp2;
        do {
            q = x2 / (i += 1.0) / df;
            df += 2.0;
        } while (q >= 1.0 || term * q > (1.0 - q) * 5.0E-15 || term > 1.0E-10 * (sum += (term *= q)));
        term = mid;
        df = dfmid;
        i = imax;
        while (i != 0.0) {
            q = i * (df -= 2.0) / x2;
            i -= 1.0;
            sum += (term *= q);
            if (!(q < 1.0) || !(term * q <= (1.0 - q) * 5.0E-15)) continue;
        }
        return give_log ? Math.log(sum) : sum;
    }

    /*
     * Unable to fully structure code
     */
    public static final double cumulative_raw(double x, double f, double theta, double errmax, double reltol, int itrmax, boolean lower_tail) {
        l_lam = -1.0;
        l_x = -1.0;
        lu = -1.0;
        _dbl_min_exp = -707.7032713517042;
        if (x <= 0.0) {
            if (x == 0.0 && f == 0.0) {
                return lower_tail != false ? Math.exp(-0.5 * theta) : -Math.expm1(-0.5 * theta);
            }
            return lower_tail != false ? 0.0 : 1.0;
        }
        if (Double.isInfinite(x)) {
            return lower_tail != false ? 1.0 : 0.0;
        }
        if (theta < 80.0) {
            sum = 0.0;
            sum2 = 0.0;
            lambda = 0.5 * theta;
            pr = Math.exp(-lambda);
            i = 0;
            while (i < 110) {
                sum += pr * ChiSquare.cumulative(x, f + (double)(2 * i), lower_tail, false);
                if ((sum2 += pr) >= 0.999999999999999) break;
                pr *= lambda / (double)(++i);
            }
            ans = sum / sum2;
            return ans;
        }
        lam = 0.5 * theta;
        v0 = lamSml = -lam < -707.7032713517042;
        if (lamSml) {
            u = 0.0;
            lu = -lam;
            l_lam = Math.log(lam);
        } else {
            u = Math.exp(-lam);
        }
        v = u;
        x2 = 0.5 * x;
        f2 = 0.5 * f;
        f_x_2n = f - x;
        if (!(f2 * 2.220446049250313E-16 > 0.125)) ** GOTO lbl-1000
        t = x2 - f2;
        if (Math.abs(v1) < Math.sqrt(2.220446049250313E-16) * f2) {
            lt = (1.0 - t) * (2.0 - t / (f2 + 1.0)) - 0.5 * Math.log(6.283185307179586 * (f2 + 1.0));
        } else lbl-1000:
        // 2 sources

        {
            lt = f2 * Math.log(x2) - x2 - MathFunctions.lgammafn(f2 + 1.0);
        }
        v2 = tSml = lt < -707.7032713517042;
        if (tSml) {
            if (x > f + theta + 5.0 * Math.sqrt(2.0 * (f + 2.0 * theta))) {
                return lower_tail != false ? 1.0 : 0.0;
            }
            l_x = Math.log(x);
            t = 0.0;
            term = 0.0;
            ans = 0.0;
        } else {
            t = Math.exp(lt);
            ans = term = v * t;
        }
        n = 1;
        f_2n = f + 2.0;
        f_x_2n += 2.0;
        while (true) {
            if (f_x_2n > 0.0) {
                bound = t * x / f_x_2n;
                is_it = false;
                is_r = false;
                is_b = bound <= errmax;
                if (is_b && (is_r = term <= reltol * ans) || (is_it = n > itrmax)) break;
            }
            if (lamSml) {
                if ((lu += l_lam - Math.log(n)) >= -707.7032713517042) {
                    v = u = Math.exp(lu);
                    lamSml = false;
                }
            } else {
                v += (u *= lam / (double)n);
            }
            if (tSml) {
                if ((lt += l_x - Math.log(f_2n)) >= -707.7032713517042) {
                    t = Math.exp(lt);
                    tSml = false;
                }
            } else {
                t *= x / f_2n;
            }
            if (!lamSml && !tSml) {
                term = v * t;
                ans += term;
            }
            ++n;
            f_2n += 2.0;
            f_x_2n += 2.0;
        }
        if (is_it) {
            System.err.println("NonCentralChiSquare.density non-convergence error");
        }
        return lower_tail != false ? ans : 1.0 - ans;
    }

    public static final double cumulative(double x, double df, double ncp, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(df) || Double.isNaN(ncp)) {
            return x + df + ncp;
        }
        if (Double.isInfinite(df) || Double.isInfinite(ncp)) {
            return Double.NaN;
        }
        if (df < 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        double ans = NonCentralChiSquare.cumulative_raw(x, df, ncp, 1.0E-12, 1.7763568394002505E-15, 1000000, lower_tail);
        if (ncp >= 80.0) {
            if (lower_tail) {
                ans = Math.min(ans, 1.0);
            } else {
                if (ans < 1.0E-10) {
                    System.err.println("Precision error NonCentralChiSquare.cumulative");
                }
                ans = Math.max(ans, 0.0);
            }
        }
        if (!log_p) {
            return ans;
        }
        if (ncp >= 80.0 || ans < 0.99999999) {
            return Math.log(ans);
        }
        ans = NonCentralChiSquare.cumulative_raw(x, df, ncp, 1.0E-12, 1.7763568394002505E-15, 1000000, !lower_tail);
        return Math.log1p(-ans);
    }

    public static final double quantile(double p, double df, double ncp, boolean lower_tail, boolean log_p) {
        double lx;
        double pp;
        double ff;
        double c;
        double b;
        double ux;
        double accu = 1.0E-13;
        double racc = 8.881784197001252E-16;
        double Eps = 1.0E-11;
        double rEps = 1.0E-10;
        if (Double.isNaN(p) || Double.isNaN(df) || Double.isNaN(ncp)) {
            return p + df + ncp;
        }
        if (Double.isInfinite(df)) {
            return Double.NaN;
        }
        if (df < 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        if ((ux = (b = ncp * ncp / (df + 3.0 * ncp)) + (c = (df + 3.0 * ncp) / (df + 2.0 * ncp)) * ChiSquare.quantile(p, ff = (df + 2.0 * ncp) / (c * c), lower_tail, log_p)) < 0.0) {
            ux = 1.0;
        }
        double ux0 = ux;
        double d = p = log_p ? Math.exp(p) : p;
        if (!lower_tail && ncp >= 80.0) {
            if (p < 1.0E-10) {
                System.err.println("Precision error NonCentralChiSquare.quantile");
            }
            p = 1.0 - p;
            lower_tail = true;
        }
        if (lower_tail) {
            if (p > 0.9999999999999998) {
                return Double.POSITIVE_INFINITY;
            }
            pp = Math.min(0.9999999999999998, p * 1.00000000001);
            while (ux < Double.MAX_VALUE && NonCentralChiSquare.cumulative_raw(ux, df, ncp, 1.0E-11, 1.0E-10, 10000, true) < pp) {
                ux *= 2.0;
            }
            pp = p * 0.99999999999;
            for (lx = Math.min(ux0, Double.MAX_VALUE); lx > Double.MIN_VALUE && NonCentralChiSquare.cumulative_raw(lx, df, ncp, 1.0E-11, 1.0E-10, 10000, true) > pp; lx *= 0.5) {
            }
        } else {
            if (p > 0.9999999999999998) {
                return 0.0;
            }
            pp = Math.min(0.9999999999999998, p * 1.00000000001);
            while (ux < Double.MAX_VALUE && NonCentralChiSquare.cumulative_raw(ux, df, ncp, 1.0E-11, 1.0E-10, 10000, false) > pp) {
                ux *= 2.0;
            }
            pp = p * 0.99999999999;
            for (lx = Math.min(ux0, Double.MAX_VALUE); lx > Double.MIN_VALUE && NonCentralChiSquare.cumulative_raw(lx, df, ncp, 1.0E-11, 1.0E-10, 10000, false) < pp; lx *= 0.5) {
            }
        }
        if (lower_tail) {
            double nx;
            do {
                if (NonCentralChiSquare.cumulative_raw(nx = 0.5 * (lx + ux), df, ncp, 1.0E-13, 8.881784197001252E-16, 100000, true) > p) {
                    ux = nx;
                    continue;
                }
                lx = nx;
            } while ((ux - lx) / nx > 1.0E-13);
        } else {
            double nx;
            do {
                if (NonCentralChiSquare.cumulative_raw(nx = 0.5 * (lx + ux), df, ncp, 1.0E-13, 8.881784197001252E-16, 100000, false) < p) {
                    ux = nx;
                    continue;
                }
                lx = nx;
            } while ((ux - lx) / nx > 1.0E-13);
        }
        return 0.5 * (ux + lx);
    }

    public static final double random(double df, double lambda, QRandomEngine random) {
        if (Double.isInfinite(df) || Double.isInfinite(lambda) || df < 0.0 || lambda < 0.0) {
            return Double.NaN;
        }
        if (lambda == 0.0) {
            if (df == 0.0) {
                return Double.NaN;
            }
            return Gamma.random(df / 2.0, 2.0, random);
        }
        double r = Poisson.random(lambda / 2.0, random);
        if (r > 0.0) {
            r = ChiSquare.random(2.0 * r, random);
        }
        if (df > 0.0) {
            r += Gamma.random(df / 2.0, 2.0, random);
        }
        return r;
    }
}

