/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.MathFunctions;
import jdistlib.Normal;
import jdistlib.rng.QRandomEngine;

public class Kendall {
    static final double count(int k, int n, double[][] w) {
        int i;
        int u = n * (n - 1) / 2;
        if (k < 0 || k > u) {
            return 0.0;
        }
        if (w[n] == null) {
            w[n] = new double[u + 1];
            for (i = 0; i <= u; ++i) {
                w[n][i] = -1.0;
            }
        }
        if (w[n][k] < 0.0) {
            if (n == 1) {
                w[n][k] = k == 0 ? 1.0 : 0.0;
            } else {
                double s = 0.0;
                for (i = 0; i < n; ++i) {
                    s += Kendall.count(k - i, n - 1, w);
                }
                w[n][k] = s;
            }
        }
        return w[n][k];
    }

    public static final double density(double x, int n) {
        double[][] w = new double[n + 1][];
        if (Math.abs(x - Math.floor(x + 0.5)) > 1.0E-7) {
            return 0.0;
        }
        return Kendall.count((int)x, (int)((double)n / MathFunctions.gammafn(n + 1)), w);
    }

    public static final double cumulative(double x, int n) {
        double[][] w = new double[n + 1][];
        double q = Math.floor(x + 1.0E-7);
        if (q < 0.0) {
            return 0.0;
        }
        if (q > (double)(n * (n - 1) / 2)) {
            return 1.0;
        }
        double p = 0.0;
        int j = 0;
        while ((double)j <= q) {
            p += Kendall.count(j, n, w);
            ++j;
        }
        return p / MathFunctions.gammafn(n + 1);
    }

    static final double do_search(double y, double[] z, double p, int x, double incr) {
        double d;
        if (z[0] >= p) {
            while (true) {
                double newz = Kendall.cumulative(y - incr, x);
                if (y == 0.0 || newz < p) {
                    return y;
                }
                y = Math.max(0.0, y - incr);
                z[0] = newz;
            }
        }
        do {
            z[0] = Kendall.cumulative(y += incr, x);
        } while (!(d >= p));
        return y;
    }

    public static final double quantile(double p, int x) {
        double oldincr;
        if (Double.isNaN(p) || Double.isInfinite(p)) {
            return p;
        }
        if (p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        double[] z = new double[]{Normal.quantile(p, 0.0, 1.0, true, false)};
        double mu = (double)(x * (x - 1)) / 4.0;
        double sigma = Math.sqrt((double)x * ((double)x + 1.0) * ((double)(2 * x) + 5.5) / 72.0);
        double y = sigma * z[0] + mu - 0.5;
        z[0] = Kendall.cumulative(y, x);
        double incr = Math.floor(y * 0.001);
        do {
            oldincr = incr;
            y = Kendall.do_search(y, z, p, x, incr);
            incr = Math.max(1.0, Math.floor(incr / 100.0));
        } while (oldincr > 1.0 && incr > (double)x * 1.0E-15);
        return y;
    }

    public static final double random(int x, QRandomEngine random) {
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Kendall.quantile(u1 / 1.34217728E8, x);
        return u1;
    }
}

