/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Binomial;
import jdistlib.Exponential;
import jdistlib.Poisson;
import jdistlib.rng.QRandomEngine;

public class Geometric {
    public static final double density(double x, double p, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(p)) {
            return x + p;
        }
        if (p <= 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (Math.abs(x - Math.floor(x + 0.5)) > 1.0E-7) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x < 0.0 || Double.isInfinite(x) || p == 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        x = Math.floor(x + 0.5);
        double prob = Binomial.density_raw(0.0, x, p, 1.0 - p, give_log);
        return give_log ? Math.log(p) + prob : p * prob;
    }

    public static final double cumulative(double x, double p, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(p)) {
            return x + p;
        }
        if (p <= 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (Double.isInfinite(x)) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        x = Math.floor(x + 1.0E-7);
        if (p == 1.0) {
            x = lower_tail ? 1.0 : 0.0;
            return log_p ? Math.log(x) : x;
        }
        x = Math.log1p(-p) * (x + 1.0);
        if (log_p) {
            return lower_tail ? (log_p ? (x > -0.6931471805599453 ? Math.log(-Math.expm1(x)) : Math.log1p(-Math.exp(x))) : Math.log1p(-x)) : (log_p ? x : Math.log(x));
        }
        return lower_tail ? -Math.expm1(x) : Math.exp(x);
    }

    public static final double quantile(double p, double prob, boolean lower_tail, boolean log_p) {
        if (prob <= 0.0 || prob > 1.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        if (Double.isNaN(p) || Double.isNaN(prob)) {
            return p + prob;
        }
        if (prob == 1.0) {
            return 0.0;
        }
        p = lower_tail ? (log_p ? (p > -0.6931471805599453 ? Math.log(-Math.expm1(p)) : Math.log1p(-Math.exp(p))) : Math.log1p(-p)) : (log_p ? p : Math.log(p));
        return Math.max(0.0, Math.ceil(p / Math.log1p(-prob) - 1.0 - 1.0E-12));
    }

    public static final double random(double p, QRandomEngine random) {
        if (Double.isInfinite(p) || p <= 0.0 || p > 1.0) {
            return Double.NaN;
        }
        return Poisson.random(Exponential.random_standard(random) * ((1.0 - p) / p), random);
    }
}

