/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Beta;
import jdistlib.Binomial;
import jdistlib.ChiSquare;
import jdistlib.Gamma;
import jdistlib.rng.QRandomEngine;

public class F {
    public static final double density(double x, double m, double n, boolean give_log) {
        double dens;
        if (Double.isNaN(x) || Double.isNaN(m) || Double.isNaN(n)) {
            return x + m + n;
        }
        if (m <= 0.0 || n <= 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x == 0.0) {
            return m > 2.0 ? (give_log ? Double.NEGATIVE_INFINITY : 0.0) : (m == 2.0 ? (give_log ? 0.0 : 1.0) : Double.POSITIVE_INFINITY);
        }
        if (Double.isInfinite(m) && Double.isInfinite(n)) {
            if (x == 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (Double.isInfinite(n)) {
            return Gamma.density(x, m / 2.0, 2.0 / m, give_log);
        }
        if (m > 1.0E14) {
            double dens2 = Gamma.density(1.0 / x, n / 2.0, 2.0 / n, give_log);
            return give_log ? dens2 - 2.0 * Math.log(x) : dens2 / (x * x);
        }
        double f = 1.0 / (n + x * m);
        double q = n * f;
        double p = x * m * f;
        if (m >= 2.0) {
            f = m * q / 2.0;
            dens = Binomial.density_raw((m - 2.0) / 2.0, (m + n - 2.0) / 2.0, p, q, give_log);
        } else {
            f = m * m * q / (2.0 * p * (m + n));
            dens = Binomial.density_raw(m / 2.0, (m + n) / 2.0, p, q, give_log);
        }
        return give_log ? Math.log(f) + dens : f * dens;
    }

    public static final double cumulative(double x, double df1, double df2, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(df1) || Double.isNaN(df2)) {
            return x + df2 + df1;
        }
        if (df1 <= 0.0 || df2 <= 0.0) {
            return Double.NaN;
        }
        if (x <= 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (df2 == Double.POSITIVE_INFINITY) {
            if (df1 == Double.POSITIVE_INFINITY) {
                if (x < 1.0) {
                    return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
                }
                if (x == 1.0) {
                    return log_p ? -0.6931471805599453 : 0.5;
                }
                if (x > 1.0) {
                    return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
                }
            }
            return ChiSquare.cumulative(x * df1, df1, lower_tail, log_p);
        }
        if (df1 == Double.POSITIVE_INFINITY) {
            return ChiSquare.cumulative(df2 / x, df2, !lower_tail, log_p);
        }
        x = df1 * x > df2 ? Beta.cumulative(df2 / (df2 + df1 * x), df2 / 2.0, df1 / 2.0, !lower_tail, log_p) : Beta.cumulative(df1 * x / (df2 + df1 * x), df1 / 2.0, df2 / 2.0, lower_tail, log_p);
        return x;
    }

    public static final double quantile(double p, double df1, double df2, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(df1) || Double.isNaN(df2)) {
            return p + df2 + df1;
        }
        if (df1 <= 0.0 || df2 <= 0.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : 0.0;
            }
        }
        if (df1 <= df2 && df2 > 400000.0) {
            if (Double.isInfinite(df1)) {
                return 1.0;
            }
            return ChiSquare.quantile(p, df1, lower_tail, log_p) / df1;
        }
        if (df1 > 400000.0) {
            return df2 / ChiSquare.quantile(p, df2, !lower_tail, log_p);
        }
        p = (1.0 / Beta.quantile(p, df2 / 2.0, df1 / 2.0, !lower_tail, log_p) - 1.0) * (df2 / df1);
        return p;
    }

    public static final double random(double n1, double n2, QRandomEngine random) {
        if (Double.isNaN(n1) || Double.isNaN(n2) || n1 <= 0.0 || n2 <= 0.0) {
            return Double.NaN;
        }
        double v1 = !Double.isInfinite(n1) ? ChiSquare.random(n1, random) / n1 : 1.0;
        double v2 = !Double.isInfinite(n2) ? ChiSquare.random(n2, random) / n2 : 1.0;
        return v1 / v2;
    }
}

