/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.rng.QRandomEngine;

public class Cauchy {
    public static final double density(double x, double location, double scale, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x + location + scale;
        }
        if (scale <= 0.0) {
            return Double.NaN;
        }
        double y = (x - location) / scale;
        return give_log ? -Math.log(Math.PI * scale * (1.0 + y * y)) : 1.0 / (Math.PI * scale * (1.0 + y * y));
    }

    public static final double cumulative(double x, double location, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x + location + scale;
        }
        if (scale <= 0.0) {
            return Double.NaN;
        }
        if (Double.isNaN(x = (x - location) / scale)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            if (x < 0.0) {
                return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
            }
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (!lower_tail) {
            x = -x;
        }
        if (Math.abs(x) > 1.0) {
            double y = Math.atan(1.0 / x) / Math.PI;
            return x > 0.0 ? (log_p ? Math.log1p(-y) : 0.5 - y + 0.5) : (log_p ? Math.log(-y) : -y);
        }
        x = 0.5 + Math.atan(x) / Math.PI;
        return log_p ? Math.log(x) : x;
    }

    public static final double quantile(double p, double location, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(location) || Double.isNaN(scale)) {
            return p + location + scale;
        }
        if (log_p && p > 0.0 || !log_p && (p < 0.0 || p > 1.0)) {
            return Double.NaN;
        }
        if (scale <= 0.0 || Double.isInfinite(scale)) {
            if (scale == 0.0) {
                return location;
            }
            return Double.NaN;
        }
        if (log_p) {
            if (p > -1.0) {
                if (p == 0.0) {
                    return location + (lower_tail ? scale : -scale) * Double.POSITIVE_INFINITY;
                }
                lower_tail = !lower_tail;
                p = -Math.expm1(p);
            } else {
                p = Math.exp(p);
            }
        } else if (p == 1.0) {
            return location + (lower_tail ? scale : -scale) * Double.POSITIVE_INFINITY;
        }
        return location + (lower_tail ? -scale : scale) / Math.tan(Math.PI * p);
    }

    public static final double random(double location, double scale, QRandomEngine random) {
        if (Double.isNaN(location) || Double.isInfinite(scale) || scale < 0.0) {
            return Double.NaN;
        }
        if (scale == 0.0 || Double.isInfinite(location)) {
            return location;
        }
        return location + scale * Math.tan(Math.PI * random.nextDouble());
    }
}

