/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Binomial;
import jdistlib.MathFunctions;
import jdistlib.rng.QRandomEngine;

public class Beta {
    public static final double density(double x, double a, double b, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return x + a + b;
        }
        if (a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (x < 0.0 || x > 1.0) {
            return log_p ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x == 0.0) {
            if (a > 1.0) {
                return log_p ? Double.NEGATIVE_INFINITY : 0.0;
            }
            if (a < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return log_p ? Math.log(b) : b;
        }
        if (x == 1.0) {
            if (b > 1.0) {
                return log_p ? Double.NEGATIVE_INFINITY : 0.0;
            }
            if (b < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return log_p ? Math.log(a) : a;
        }
        double lval = a <= 2.0 || b <= 2.0 ? (a - 1.0) * Math.log(x) + (b - 1.0) * Math.log1p(-x) - MathFunctions.lbeta(a, b) : Math.log(a + b - 1.0) + Binomial.density_raw(a - 1.0, a + b - 2.0, x, 1.0 - x, true);
        return log_p ? lval : Math.exp(lval);
    }

    public static final double cumulative_raw(double x, double pin, double qin, boolean lower_tail, boolean log_p) {
        double x1 = 0.5 - x + 0.5;
        double[] temp = MathFunctions.bratio(pin, qin, x, x1, log_p);
        double w = temp[0];
        double wc = temp[1];
        int ierr = (int)temp[2];
        if (ierr > 0 && (ierr != 8 || log_p)) {
            return Double.NaN;
        }
        return lower_tail ? w : wc;
    }

    public static final double cumulative(double x, double pin, double qin, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(pin) || Double.isNaN(qin)) {
            return x + pin + qin;
        }
        if (pin <= 0.0 || qin <= 0.0) {
            return Double.NaN;
        }
        if (x <= 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (x >= 1.0) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        return Beta.cumulative_raw(x, pin, qin, lower_tail, log_p);
    }

    public static final double quantile(double alpha, double p, double q, boolean lower_tail, boolean log_p) {
        double xinbta;
        double t;
        boolean swap_tail;
        double qq;
        double pp;
        double a;
        double p_;
        double fpu = 3.0E-308;
        double acu_min = 1.0E-300;
        double lower = 3.0E-308;
        double upper = 0.9999999999999998;
        double const1 = 2.30753;
        double const2 = 0.27061;
        double const3 = 0.99229;
        double const4 = 0.04481;
        if (Double.isNaN(p) || Double.isNaN(q) || Double.isNaN(alpha)) {
            return p + q + alpha;
        }
        if (p < 0.0 || q < 0.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (alpha > 0.0) {
                return Double.NaN;
            }
            if (alpha == 0.0) {
                return lower_tail ? 1.0 : 0.0;
            }
            if (alpha == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : 1.0;
            }
        } else {
            if (alpha < 0.0 || alpha > 1.0) {
                return Double.NaN;
            }
            if (alpha == 0.0) {
                return lower_tail ? 0.0 : 1.0;
            }
            if (alpha == 1.0) {
                return lower_tail ? 1.0 : 0.0;
            }
        }
        double d = log_p ? (lower_tail ? Math.exp(alpha) : -Math.expm1(alpha)) : (p_ = lower_tail ? alpha : 0.5 - alpha + 0.5);
        if (log_p && (p_ == 0.0 || p_ == 1.0)) {
            return p_;
        }
        double logbeta = MathFunctions.lbeta(p, q);
        if (p_ <= 0.5) {
            a = p_;
            pp = p;
            qq = q;
            swap_tail = false;
        } else {
            a = !lower_tail && !log_p ? alpha : 1.0 - p_;
            pp = q;
            qq = p;
            swap_tail = true;
        }
        double r = Math.sqrt(-2.0 * Math.log(a));
        double y = r - (2.30753 + 0.27061 * r) / (1.0 + (0.99229 + 0.04481 * r) * r);
        if (pp > 1.0 && qq > 1.0) {
            r = (y * y - 3.0) / 6.0;
            double s = 1.0 / (pp + pp - 1.0);
            t = 1.0 / (qq + qq - 1.0);
            double h = 2.0 / (s + t);
            double w = y * Math.sqrt(h + r) / h - (t - s) * (r + 0.8333333333333334 - 2.0 / (3.0 * h));
            xinbta = pp / (pp + qq * Math.exp(w + w));
        } else {
            r = qq + qq;
            t = 1.0 / (9.0 * qq);
            xinbta = (t = r * Math.pow(1.0 - t + y * Math.sqrt(t), 3.0)) <= 0.0 ? 1.0 - Math.exp((Math.log1p(-a) + Math.log(qq) + logbeta) / qq) : ((t = (4.0 * pp + r - 2.0) / t) <= 1.0 ? Math.exp((Math.log(a * pp) + logbeta) / pp) : 1.0 - 2.0 / (t + 1.0));
        }
        r = 1.0 - pp;
        t = 1.0 - qq;
        double yprev = 0.0;
        double adj = 1.0;
        if (xinbta < 3.0E-308) {
            xinbta = 0.5;
        } else if (xinbta > 0.9999999999999998) {
            xinbta = 0.5;
        }
        double acu = Math.max(1.0E-300, Math.pow(10.0, -13.0 - 2.5 / (pp * pp) - 0.5 / (a * a)));
        double prev = 0.0;
        double tx = 0.0;
        for (int i_pb = 0; i_pb < 1000; ++i_pb) {
            y = Beta.cumulative_raw(xinbta, pp, qq, true, false);
            if (Double.isInfinite(y)) {
                return Double.NaN;
            }
            if ((y = (y - a) * Math.exp(logbeta + r * Math.log(xinbta) + t * Math.log1p(-xinbta))) * yprev <= 0.0) {
                prev = Math.max(Math.abs(adj), 3.0E-308);
            }
            double g = 1.0;
            for (int i_inn = 0; i_inn < 1000; ++i_inn) {
                adj = g * y;
                if (Math.abs(adj) < prev && (tx = xinbta - adj) >= 0.0 && tx <= 1.0) {
                    if (prev <= acu || Math.abs(y) <= acu) {
                        return swap_tail ? 1.0 - xinbta : xinbta;
                    }
                    if (tx != 0.0 && tx != 1.0) break;
                }
                g /= 3.0;
            }
            if (Math.abs(tx - xinbta) < 1.0E-15 * xinbta) {
                return swap_tail ? 1.0 - xinbta : xinbta;
            }
            xinbta = tx;
            yprev = y;
        }
        return Double.NaN;
    }

    public static final double random(double aa, double bb, QRandomEngine random) {
        double t;
        double u2;
        double u1;
        double z;
        double w;
        double v;
        double r;
        double s;
        double expmax = 709.782712893384;
        if (aa <= 0.0 || bb <= 0.0 || Double.isInfinite(aa) && Double.isInfinite(bb)) {
            return Double.NaN;
        }
        if (Double.isInfinite(aa)) {
            return 1.0;
        }
        if (Double.isInfinite(bb)) {
            return 0.0;
        }
        double a = Math.min(aa, bb);
        double b = Math.max(aa, bb);
        double alpha = a + b;
        if (a <= 1.0) {
            double w2;
            double beta = 1.0 / a;
            double delta = 1.0 + b - a;
            double k1 = delta * (0.0138889 + 0.0416667 * a) / (b * beta - 0.777778);
            double k2 = 0.25 + (0.5 + 0.25 / delta) * a;
            while (true) {
                double v2;
                double z2;
                double u12 = random.nextDouble();
                double u22 = random.nextDouble();
                if (u12 < 0.5) {
                    double y = u12 * u22;
                    z2 = u12 * y;
                    if (0.25 * u22 + z2 - y >= k1) {
                        continue;
                    }
                } else {
                    z2 = u12 * u12 * u22;
                    if (z2 <= 0.25) {
                        v2 = beta * Math.log(u12 / (1.0 - u12));
                        if (v2 <= 709.782712893384) {
                            w2 = b * Math.exp(v2);
                            if (!Double.isInfinite(w2)) break;
                            w2 = Double.MAX_VALUE;
                            break;
                        }
                        w2 = Double.MAX_VALUE;
                        break;
                    }
                    if (z2 >= k2) continue;
                }
                if ((v2 = beta * Math.log(u12 / (1.0 - u12))) <= 709.782712893384) {
                    w2 = b * Math.exp(v2);
                    if (Double.isInfinite(w2)) {
                        w2 = Double.MAX_VALUE;
                    }
                } else {
                    w2 = Double.MAX_VALUE;
                }
                if (alpha * (Math.log(alpha / (a + w2)) + v2) - 1.3862944 >= Math.log(z2)) break;
            }
            return aa == a ? a / (a + w2) : w2 / (a + w2);
        }
        double beta = Math.sqrt((alpha - 2.0) / (2.0 * a * b - alpha));
        double gamma = a + 1.0 / beta;
        do {
            u1 = random.nextDouble();
            u2 = random.nextDouble();
            v = beta * Math.log(u1 / (1.0 - u1));
            if (v <= 709.782712893384) {
                w = a * Math.exp(v);
                if (!Double.isInfinite(w)) continue;
                w = Double.MAX_VALUE;
                continue;
            }
            w = Double.MAX_VALUE;
        } while (!((s = a + (r = gamma * v - 1.3862944) - w) + 2.609438 >= 5.0 * (z = u1 * u1 * u2)) && !(s > (t = Math.log(z))) && r + alpha * Math.log(alpha / (b + w)) < t);
        return aa != a ? b / (b + w) : w / (b + w);
    }
}

