/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring.util;

import edu.uci.ics.jung.algorithms.scoring.HITS;
import java.util.Collection;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoringUtils {
    public static <V> Transformer<V, Double> getUniformRootPrior(Collection<V> roots) {
        final Collection<V> inner_roots = roots;
        Transformer distribution = new Transformer<V, Double>(){

            public Double transform(V input) {
                if (inner_roots.contains(input)) {
                    return new Double(1.0 / (double)inner_roots.size());
                }
                return 0.0;
            }
        };
        return distribution;
    }

    public static <V> Transformer<V, HITS.Scores> getHITSUniformRootPrior(Collection<V> roots) {
        final Collection<V> inner_roots = roots;
        Transformer distribution = new Transformer<V, HITS.Scores>(){

            public HITS.Scores transform(V input) {
                if (inner_roots.contains(input)) {
                    return new HITS.Scores(1.0 / (double)inner_roots.size(), 1.0 / (double)inner_roots.size());
                }
                return new HITS.Scores(0.0, 0.0);
            }
        };
        return distribution;
    }
}

