/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.spring.web.servlet.view;

import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.filters.OrPropertyFilter;
import net.sf.json.util.PropertyFilter;
import org.springframework.web.servlet.view.AbstractView;

public class JsonView
extends AbstractView {
    private static final String DEFAULT_JSON_CONTENT_TYPE = "application/json";
    private boolean forceTopLevelArray = false;
    private boolean skipBindingResult = true;
    private JsonConfig jsonConfig = new JsonConfig();

    public JsonView() {
        this.setContentType(DEFAULT_JSON_CONTENT_TYPE);
    }

    public JsonConfig getJsonConfig() {
        return this.jsonConfig;
    }

    public boolean isForceTopLevelArray() {
        return this.forceTopLevelArray;
    }

    public boolean isIgnoreDefaultExcludes() {
        return this.jsonConfig.isIgnoreDefaultExcludes();
    }

    public boolean isSkipBindingResult() {
        return this.skipBindingResult;
    }

    public void setExcludedProperties(String[] excludedProperties) {
        this.jsonConfig.setExcludes(excludedProperties);
    }

    public void setForceTopLevelArray(boolean forceTopLevelArray) {
        this.forceTopLevelArray = forceTopLevelArray;
    }

    public void setIgnoreDefaultExcludes(boolean ignoreDefaultExcludes) {
        this.jsonConfig.setIgnoreDefaultExcludes(ignoreDefaultExcludes);
    }

    public void setJsonConfig(JsonConfig jsonConfig) {
        JsonConfig jsonConfig2 = this.jsonConfig = jsonConfig != null ? jsonConfig : new JsonConfig();
        if (this.skipBindingResult) {
            PropertyFilter jsonPropertyFilter = this.jsonConfig.getJsonPropertyFilter();
            if (jsonPropertyFilter == null) {
                this.jsonConfig.setJsonPropertyFilter((PropertyFilter)new BindingResultPropertyFilter());
            } else {
                this.jsonConfig.setJsonPropertyFilter((PropertyFilter)new OrPropertyFilter((PropertyFilter)new BindingResultPropertyFilter(), jsonPropertyFilter));
            }
        }
    }

    public void setSkipBindingResult(boolean skipBindingResult) {
        this.skipBindingResult = skipBindingResult;
    }

    protected JSON createJSON(Map model, HttpServletRequest request, HttpServletResponse response) {
        return this.defaultCreateJSON(model);
    }

    protected final JSON defaultCreateJSON(Map model) {
        if (this.skipBindingResult && this.jsonConfig.getJsonPropertyFilter() == null) {
            this.jsonConfig.setJsonPropertyFilter((PropertyFilter)new BindingResultPropertyFilter());
        }
        return JSONSerializer.toJSON((Object)model, (JsonConfig)this.jsonConfig);
    }

    protected String[] getExcludedProperties() {
        return this.jsonConfig.getExcludes();
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.getContentType());
        this.writeJSON(model, request, response);
    }

    protected void writeJSON(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSON json = this.createJSON(model, request, response);
        if (this.forceTopLevelArray) {
            json = new JSONArray().element((Object)json);
        }
        json.write((Writer)response.getWriter());
    }

    private static class BindingResultPropertyFilter
    implements PropertyFilter {
        private BindingResultPropertyFilter() {
        }

        public boolean apply(Object source, String name, Object value) {
            return name.startsWith("org.springframework.validation.BindingResult.");
        }
    }
}

