/*
 * Copyright 2008 Robert Hanson <iamroberthanson AT gmail.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gwtwidgets.client.ui.canvas.impl;

import com.google.gwt.core.client.JavaScriptObject;

/**
 * Concatenates values and returns a comma separated list. This implementations exploits the
 * fact that currently (FF2, IE7) operating on javascript arrays is faster than appending to a string.
 * @author George Georgovassilis g.georgovassilis[at]gmail.com
 *
 */

public class StringArray {

	private JavaScriptObject buffer;
	
	
	private native JavaScriptObject createArray()/*-{
		return new Array();
	}-*/;
	
	public native StringArray append(String s)/*-{
		this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.push(s);
		return this;
	}-*/;

	public native StringArray append(double d)/*-{
	this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.push(d);
	return this;
	}-*/;

	public native StringArray append(int i)/*-{
	this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.push(i);
	return this;
	}-*/;
	
	public native String toString()/*-{
	return this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.join(",");
	}-*/;

	public native String toString(String delimiter)/*-{
	return this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.join(delimiter);
	}-*/;

	public native void clear()/*-{
	this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.splice(0,this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.length);
	}-*/;

	// special implementations of append for performance

	public native void appendElement(String sElem, double left, double top, double width, double height)/*-{
	this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.push(
	"<",sElem," style='left:",left,"px;top:",top,"px;width:",width,"px;height:",height,"px;position:absolute;' "
	);
	}-*/;

	public native void appendImageData(String src, double relativeOffsetLeft, double relativeOffsetRight, double relativeOffsetTop, double relativeOffsetBottom)/*-{
	this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.push(
	"<v:imagedata src='", src,
	"' CropLeft='", relativeOffsetLeft,
	"' CropRight='", relativeOffsetRight, 
	"' CropTop='", relativeOffsetTop, 
	"' CropBottom='", relativeOffsetBottom,
	"'/>" 
	);
	}-*/;
	
	public native void appendCoordinates(double x, double y)/*-{
	this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.push(x,y);
	}-*/;

	public native StringArray appendAttribute(String name, String value)/*-{
	this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.push(name,"='",value,"' ");
	return this;
	}-*/;
	
	public native void closeElement(String elementName)/*-{
	this.@org.gwtwidgets.client.ui.canvas.impl.StringArray::buffer.push("</",elementName,">");
	}-*/;
	
	public StringArray(){
		this.buffer = createArray();
	}
}
