/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring;

import com.google.gwt.user.client.rpc.RemoteService;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static Class<RemoteService>[] getExposedInterfaces(Class<?> clazz) {
        Set<Class<?>> interfaces = ReflectionUtils.getInterfaces(clazz);
        Iterator<Class<?>> ite = interfaces.iterator();
        while (ite.hasNext()) {
            Class<?> c = ite.next();
            if (ReflectionUtils.isExposed(c)) continue;
            ite.remove();
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static void addAll(Set<Class<?>> set, Class<?>[] elements) {
        for (Class<?> element : elements) {
            set.add(element);
        }
    }

    public static Set<Class<?>> getInterfaces(Class<?> c) {
        Class<?>[] interfaces = c.getInterfaces();
        HashSet classes = new HashSet();
        if (interfaces == null) {
            return classes;
        }
        ReflectionUtils.addAll(classes, interfaces);
        for (Class<?> cl : interfaces) {
            classes.addAll(ReflectionUtils.getInterfaces(cl));
        }
        return classes;
    }

    private static boolean isExposed(Class c) {
        return RemoteService.class.isAssignableFrom(c);
    }

    public static Method getRPCMethod(Object target, Class[] serviceInterfaces, Method method) throws NoSuchMethodException {
        if (serviceInterfaces.length == 0) {
            return target.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        for (Class serviceInterface : serviceInterfaces) {
            try {
                Method template = serviceInterface.getMethod(method.getName(), method.getParameterTypes());
                return target.getClass().getMethod(template.getName(), template.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
            }
        }
        throw new NoSuchMethodException(method.toString());
    }
}

