/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwtwidgets.server.spring.RPCServiceExporter;
import org.gwtwidgets.server.spring.ReflectionUtils;
import org.gwtwidgets.server.spring.ServletUtils;
import org.gwtwidgets.server.spring.util.ImmutableCopyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWTRPCServiceExporter
extends RemoteServiceServlet
implements RPCServiceExporter {
    public static final int COMPRESSION_DISABLED = 0;
    public static final int COMPRESSION_AUTO = 1;
    public static final int COMPRESSION_ENABLED = 2;
    protected Log logger = LogFactory.getLog(this.getClass());
    protected Class<?>[] serviceInterfaces;
    protected Object service = this;
    protected ServletContext servletContext;
    protected int compressResponse = 1;
    protected boolean disableResponseCaching = false;
    protected Map<Method, Method> methodCache = new ImmutableCopyMap<Method, Method>();

    protected void preprocessHTTP(HttpServletRequest request, HttpServletResponse response) {
        if (this.disableResponseCaching) {
            ServletUtils.disableResponseCaching(response);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Serialised RPC response: [" + serializedResponse + "]"));
        }
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Serialised RPC request: [" + serializedRequest + "]"));
        }
    }

    protected String invokeMethodOnService(Object service, Method targetMethod, Object[] targetParameters, RPCRequest rpcRequest) throws Exception {
        Object result = targetMethod.invoke(service, targetParameters);
        String encodedResult = RPC.encodeResponseForSuccess((Method)rpcRequest.getMethod(), (Object)result, (SerializationPolicy)rpcRequest.getSerializationPolicy());
        return encodedResult;
    }

    protected String handleIllegalArgumentException(IllegalArgumentException e, Object service, Method targetMethod, RPCRequest rpcRequest) {
        SecurityException securityException = new SecurityException("Blocked attempt to invoke method " + targetMethod);
        securityException.initCause(e);
        throw securityException;
    }

    protected String handleIllegalAccessException(IllegalAccessException e, Object service, Method targetMethod, RPCRequest rpcRequest) {
        SecurityException securityException = new SecurityException("Blocked attempt to access inaccessible method " + targetMethod + (service != null ? " on service " + service : ""));
        securityException.initCause(e);
        throw securityException;
    }

    protected String handleInvocationTargetException(InvocationTargetException e, Object service, Method targetMethod, RPCRequest rpcRequest) throws Exception {
        Throwable cause = e.getCause();
        if (!(cause instanceof RuntimeException)) {
            this.logger.warn((Object)cause);
        }
        String failurePayload = RPC.encodeResponseForFailure((Method)rpcRequest.getMethod(), (Throwable)cause, (SerializationPolicy)rpcRequest.getSerializationPolicy());
        return failurePayload;
    }

    protected String handleServiceException(Exception e, Object service, Method targetMethod, RPCRequest rpcRequest) throws Exception {
        throw e;
    }

    protected String handleUndeclaredThrowableException(Exception e, Object service, Method targetMethod, RPCRequest rpcRequest) throws Exception {
        throw e;
    }

    protected Method getMethodToInvoke(Method decodedMethod) throws NoSuchMethodException {
        Method method = this.methodCache.get(decodedMethod);
        if (method != null) {
            return method;
        }
        method = ReflectionUtils.getRPCMethod(this.service, this.serviceInterfaces, decodedMethod);
        return this.methodCache.put(decodedMethod, method);
    }

    public String processCall(String payload) throws SerializationException {
        try {
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, null, (SerializationPolicyProvider)this);
            Method targetMethod = this.getMethodToInvoke(rpcRequest.getMethod());
            Object[] targetParameters = rpcRequest.getParameters();
            try {
                return this.invokeMethodOnService(this.service, targetMethod, targetParameters, rpcRequest);
            }
            catch (IllegalArgumentException e) {
                return this.handleIllegalArgumentException(e, this.service, targetMethod, rpcRequest);
            }
            catch (IllegalAccessException e) {
                return this.handleIllegalAccessException(e, this.service, targetMethod, rpcRequest);
            }
            catch (InvocationTargetException e) {
                return this.handleInvocationTargetException(e, this.service, targetMethod, rpcRequest);
            }
            catch (UndeclaredThrowableException e) {
                return this.handleUndeclaredThrowableException(e, this.service, targetMethod, rpcRequest);
            }
            catch (Exception e) {
                return this.handleServiceException(e, this.service, targetMethod, rpcRequest);
            }
        }
        catch (IncompatibleRemoteServiceException e) {
            return this.handleIncompatibleRemoteServiceException(e);
        }
        catch (Exception e) {
            return this.handleExporterProcessingException(e);
        }
    }

    protected String handleIncompatibleRemoteServiceException(IncompatibleRemoteServiceException e) throws SerializationException {
        this.logger.warn((Object)e.getMessage());
        return RPC.encodeResponseForFailure(null, (Throwable)e);
    }

    protected String handleExporterProcessingException(Exception e) {
        throw new RuntimeException(e);
    }

    @Override
    public void setService(Object service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.preprocessHTTP(request, response);
            ServletUtils.setRequest(request);
            ServletUtils.setResponse(response);
            this.doPost(request, response);
        }
        finally {
            ServletUtils.setRequest(null);
            ServletUtils.setResponse(null);
        }
    }

    @Override
    public void setServiceInterfaces(Class<RemoteService>[] serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.service == null) {
            throw new Exception("You must specify a service object.");
        }
        if (this.serviceInterfaces == null) {
            this.logger.debug((Object)"Discovering service interfaces");
            this.serviceInterfaces = ReflectionUtils.getExposedInterfaces(this.service.getClass());
            if (this.serviceInterfaces.length == 0) {
                this.logger.warn((Object)"The specified service does neither implement RemoteService nor were any service interfaces specified. RPC access to *all* object methods is allowed.");
            }
        }
    }

    public Object getService() {
        return this.service;
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        switch (this.compressResponse) {
            case 0: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return super.shouldCompressResponse(request, response, responsePayload);
    }

    protected void setCompressResponse(int compressResponse) {
        if (compressResponse != 2 && compressResponse != 0 && compressResponse != 1) {
            throw new IllegalArgumentException("Invalid compressResponse argumnet " + compressResponse);
        }
        this.compressResponse = compressResponse;
    }

    @Override
    public void setResponseCachingDisabled(boolean disableResponseCaching) {
        this.disableResponseCaching = disableResponseCaching;
    }
}

