/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import net.sf.ehcache.transaction.xa.EhcacheXAException;
import net.sf.ehcache.transaction.xa.EhcacheXAResourceImpl;
import net.sf.ehcache.transaction.xa.XARequest;
import net.sf.ehcache.transaction.xa.XARequestProcessor;

public class TransactionXARequestProcessor
implements XARequestProcessor {
    private final ConcurrentMap<Xid, ExecutorService> executorMap = new ConcurrentHashMap<Xid, ExecutorService>();
    private EhcacheXAResourceImpl resourceImpl;

    public TransactionXARequestProcessor(EhcacheXAResourceImpl resourceImpl) {
        this.resourceImpl = resourceImpl;
    }

    public int process(XARequest request) throws XAException {
        int returnFlags = 0;
        ExecutorService service = this.getOrCreateExecutorService(request.getXid());
        Future<XAResponse> future = service.submit(new XARequestCallable(this.resourceImpl, request));
        XAResponse xaResponse = null;
        try {
            xaResponse = future.get();
        }
        catch (InterruptedException e) {
            this.cleanupExecutorService(request.getXid());
            throw new EhcacheXAException(e.getMessage(), -3, e);
        }
        catch (ExecutionException e) {
            this.cleanupExecutorService(request.getXid());
            throw new EhcacheXAException(e.getMessage(), -3, e);
        }
        if (xaResponse.getXaException() != null) {
            this.cleanupExecutorService(request.getXid());
            throw new EhcacheXAException("XA request on [" + request.getXid() + "] failed", xaResponse.getXaException().errorCode, xaResponse.getXaException());
        }
        if (request.getRequestType().equals((Object)XARequest.RequestType.COMMIT) || request.getRequestType().equals((Object)XARequest.RequestType.ROLLBACK) || request.getRequestType().equals((Object)XARequest.RequestType.FORGET)) {
            this.cleanupExecutorService(request.getXid());
        }
        return returnFlags;
    }

    private ExecutorService getOrCreateExecutorService(Xid xid) {
        ExecutorService service = (ExecutorService)this.executorMap.get(xid);
        if (service == null) {
            service = Executors.newSingleThreadExecutor(new XARequestProcessThreadFactory(xid));
            this.executorMap.put(xid, service);
        }
        return service;
    }

    private void cleanupExecutorService(Xid xid) {
        ExecutorService service = (ExecutorService)this.executorMap.remove(xid);
        service.shutdown();
    }

    private static class XAResponse {
        private final int flags;
        private final XAException xaException;

        public XAResponse(int flags, XAException xaException) {
            this.flags = flags;
            this.xaException = xaException;
        }

        public int getFlags() {
            return this.flags;
        }

        public XAException getXaException() {
            return this.xaException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XARequestCallable
    implements Callable<XAResponse> {
        private final EhcacheXAResourceImpl resourceImpl;
        private final XARequest request;

        public XARequestCallable(EhcacheXAResourceImpl resourceImpl, XARequest request) {
            this.resourceImpl = resourceImpl;
            this.request = request;
        }

        @Override
        public XAResponse call() throws Exception {
            int returnFlag = 0;
            XAException xaException = null;
            try {
                switch (this.request.getRequestType()) {
                    case FORGET: {
                        this.resourceImpl.forgetInternal(this.request.getXid());
                        break;
                    }
                    case PREPARE: {
                        returnFlag = this.resourceImpl.prepareInternal(this.request.getXid());
                        break;
                    }
                    case ROLLBACK: {
                        this.resourceImpl.rollbackInternal(this.request.getXid());
                        break;
                    }
                    case COMMIT: {
                        this.resourceImpl.commitInternal(this.request.getXid(), this.request.isOnePhase());
                        break;
                    }
                    default: {
                        throw new XAException("Unknown enum type: " + (Object)((Object)this.request.getRequestType()));
                    }
                }
            }
            catch (XAException xaE) {
                xaException = xaE;
            }
            return new XAResponse(returnFlag, xaException);
        }
    }

    private static class XARequestProcessThreadFactory
    implements ThreadFactory {
        private final Xid xid;
        private Thread thread;

        public XARequestProcessThreadFactory(Xid xid) {
            this.xid = xid;
        }

        public synchronized Thread newThread(Runnable runnable) {
            if (this.thread != null) {
                throw new RuntimeException("more than 1 thread requested to work on XID [" + this.xid + "]");
            }
            this.thread = new Thread(runnable, "XA-Request processor Thread Xid [ " + this.xid + " ]");
            return this.thread;
        }
    }
}

