/*
 * Decompiled with CFR 0.152.
 */
package net.objecthunter.exp4j.function;

public abstract class Function {
    protected final String name;
    protected final int numArguments;

    public Function(String name, int numArguments) {
        this.name = name;
        if (numArguments < 1) {
            throw new IllegalArgumentException("The number of function arguments can not be less than 1 for '" + name + "'");
        }
        this.numArguments = numArguments;
    }

    public Function(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Function name can not be empty");
        }
        if (!Character.isAlphabetic(name.charAt(0)) && name.charAt(0) != '_') {
            throw new IllegalArgumentException("Function name is invalid. Name has to start with a letter or an underscore");
        }
        this.name = name;
        this.numArguments = 1;
    }

    public String getName() {
        return this.name;
    }

    public int getNumArguments() {
        return this.numArguments;
    }

    public abstract double apply(double ... var1);

    public static char[] getAllowedFunctionCharacters() {
        int i;
        char[] chars = new char[53];
        int count = 0;
        for (i = 65; i < 91; ++i) {
            chars[count++] = (char)i;
        }
        for (i = 97; i < 123; ++i) {
            chars[count++] = (char)i;
        }
        chars[count] = 95;
        return chars;
    }
}

